//** LOADER ->	DIGPAK and MIDPAK dynamic loader.
//**						Include this header file to support dynamic loading of
//**						the real-mode DIGPAK and MIDPAK drivers.	If you only
//**						want DIGPAK suppor then set MIDPAK_LOADER to false, if
//**						you just want MIDPAK support then set DIGPAK_LOADER to false.
//**						Requires: SUPPORT.C SUPPORT.H  basic file i/o memory managment.
//**											VECTOR.ASM VECTOR.H  Hook and unhook the realmode
//**											VECTOR.COM					 vector manager, VECTOR.COM.
//**											DOSCALLS.ASM DOSCALLS.H, real-mode 1mb memory
//**																					 allocation and management.
//**											DIGPLAY.ASM DIGPLAY.H DigPak API link layer.
//**											MIDPAK.ASM MIDPAK.H  MidPak API link layer.
//**											STDIO.H STDLIB.H	C standard file support functions.
/*																																					 */
/*		Written by John W. Ratcliff (c) 1994																	 */
/*			 Compuserve: 70253,3237 																						 */
/*			 Genie: J.RATCLIFF3 																								 */
/*			 BBS: 1-314-939-0200																								 */
/*			 Addresss:																													 */
/*					 747 Napa Lane																									 */
/*					 St. Charles, MO 63304																					 */
/*																																					 */

#define DIGPAK_LOADER 1 // True if enabling DIGPAK loading.
#define MIDPAK_LOADER 1 // True if enabling MIDPAK loading.

// ** C prototype header to MIDPAK and DIGPAK loader functions.
#if DIGPAK_LOADER
int LoadDigPak(char *fname); // Load digpak driver, returns' true if loaded.
int InitDigPak(void); // Initialize Digpak true, if successfull.
int DeInitDigPak(void); // Uninitialize DigPak.
int UnLoadDigPak(void); // unload digpak driver from memory.
#endif

#if MIDPAK_LOADER
int LoadMidPak(char *fname,char *adv,char *ad); // Load MidPak driver, returns' true if loaded.
int InitMidPak(void); // Initialize MidPak true, if successfull.
int DeInitMidPak(void); // Uninitialize MidPak.
int UnLoadMidPak(void); // unload MidPak driver from memory.
#endif

void RemoveVectorLoader(void); // Remove vector loader.

