;;*** T16.ASM	Converts an 8 bit mono sound sample into various formats
;;***		for testing purposes.
;;***
;;*** Written by John W. Ratcliff (c) 1994
;;***		 Compuserve: 70253,3237
;;***		 Genie: J.RATCLIFF3
;;***		 BBS: 1-314-939-0200
;;***		 Addresss:
;;***			   747 Napa Lane
;;***			   St. Charles, MO 63304
;;***


	IDEAL
	P386
	JUMPS
	MODEL FLAT,C

	public	Left8
	public	Right8
	public	Mono16
	public	Left16
	public	Right16


	CODESEG

Proc	C Left8 near
	ARG	SOURCE:DWORD,DEST:DWORD,SLEN:DWORD
	uses	ecx,esi,edi

	mov	esi,[SOURCE]
	mov	edi,[DEST]
	mov	ecx,[SLEN]
	xor	ax,ax
@@GO:	movsb
	stosb
	loop	@@GO

	ret
	endp

PROC	C Right8 near
	ARG	SOURCE:DWORD,DEST:DWORD,SLEN:DWORD
	uses	ecx,esi,edi

	mov	esi,[SOURCE]
	mov	edi,[DEST]
	mov	ecx,[SLEN]
	xor	eax,eax
@@GO:	stosb
	movsb
	loop	@@GO

	ret
	endp

PROC	C Mono16 near
	ARG	SOURCE:DWORD,DEST:DWORD,SLEN:DWORD
	uses ecx,esi,edi

	mov	esi,[SOURCE]
	mov	edi,[DEST]
	mov	ecx,[SLEN]
@@GO:	lodsb
	mov	ah,al
	xor	al,al
	sub	ax,32767
	stosw
	loop	@@GO

	ret
	endp

PROC	C Left16 near
	ARG	SOURCE:DWORD,DEST:DWORD,SLEN:DWORD
	uses ecx,esi,edi

	mov	esi,[SOURCE]
	mov	edi,[DEST]
	mov	ecx,[SLEN]

@@GO:	lodsb
	mov	ah,al
	xor	al,al
	sub	ax,32767
	stosw
	mov	ax,8000h
	stosw
	loop	@@GO

	ret
	endp

PROC	C Right16 near
	ARG	SOURCE:DWORD,DEST:DWORD,SLEN:DWORD
	uses ecx,esi,edi

	mov	esi,[SOURCE]
	mov	edi,[DEST]
	mov	ecx,[SLEN]

@@GO:	mov	ax,8000h
	stosw
	lodsb
	mov	ah,al
	xor	al,al
	sub	ax,32767
	stosw
	loop	@@GO

	ret
	endp

	ends
	end
