
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "..\sb.h"

unsigned char ca;
unsigned short ra;
unsigned long la;
FILE *fp;
unsigned char gstring[80];

// for .WAV stuff
unsigned long rID;
unsigned long rLen;
unsigned long wID;
unsigned long fID;
unsigned long fLen;
unsigned long fNext;
unsigned short wFormatTag;
unsigned short nChannels;
unsigned short nSamplesPerSec;
unsigned short nAvgBytesPerSec;
unsigned long dID;
unsigned long dLen;

void main ( int argc, char *argv[] )
{

    if(argc==1)
    {
        printf(".WAV file and sample rate not specified\n");
        exit(1);
    }
    if(argc==2)
    {
        nSamplesPerSec=12000;
        printf("Default sample rate of %u Hz will be used\n",nSamplesPerSec);
    }
    if(argc>=3)
    {
        nSamplesPerSec=atoi(argv[2]);
        printf("Samples Per Second %u\n",nSamplesPerSec);
    }

    strcpy(gstring,argv[1]);
    strcat(gstring,".WAV");
    if((fp=fopen(gstring,"wb"))==0)
    {
        strcpy(gstring,argv[1]);
        if((fp=fopen(gstring,"wb"))==0)
        {
            printf("Error opening .WAV file [%s]\n",argv[1]);
            exit(1);
        }
    }
    printf("FILE: [%s]\n",gstring);
    sbsetup();

    fLen=16;
    wFormatTag=1;
    nChannels=1;
    nAvgBytesPerSec=0;
    dLen=65000;
    rLen=20+fLen+dLen;

    rID=0x46464952;
    fwrite(&rID,1,4,fp);
    fwrite(&rLen,1,4,fp);
    wID=0x45564157;
    fwrite(&wID,1,4,fp);
    fID=0x20746D66;
    fwrite(&fID,1,4,fp);
    fwrite(&fLen,1,4,fp);
    fwrite(&wFormatTag,1,2,fp);
    fwrite(&nChannels,1,2,fp);
    fwrite(&nSamplesPerSec,1,2,fp);
    fwrite(&nAvgBytesPerSec,1,2,fp);
    fwrite(&nSamplesPerSec,1,2,fp);
    ra=0; fwrite(&ra,1,2,fp);
    ra=1; fwrite(&ra,1,2,fp);
    ra=8; fwrite(&ra,1,2,fp);
    dID=0x61746164;
    fwrite(&dID,1,4,fp);
    fwrite(&dLen,1,4,fp);

    ca=256UL-(1000000UL/nSamplesPerSec);
    printf("Time Constant %u\n",ca);
    sbsettc(ca);
    sbrec(dLen);
    printf("Recording %lu samples\n",dLen);
    while(1) if(dmacount()==0xFFFF) break;
    fwrite(aligned,1,dLen,fp);
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------

