














			     GetBack User's Manual

				  Revision A
				 May 22, 1992
			Copyright (C) 1992 MICROTOOLS
1	  GetBack Introduction

       Welcome to GetBack.  GetBack is a powerful, safe  yet simple
       means of backing up your vital data.  For most of us,
       backing up our data is a nuisance that we all too often
       avoid.  GetBack makes backing up fun.  You can set up your
       backups once with our intuitive users interface and then run
       them from a regular batch file.

       But, before we get into how to perform a backup, we need to
       talk strategy.  Without a well thought out strategy, you may
       find yourself either wasting time by backing up too much or
       (heaven forbid), not be backing up enough data.	It doesn't
       do any good to begin backing up the wrong data or backing up
       more data than it is worth to backup.  That's why we must
       begin with a good backup strategy.  Once that is established
       we'll work on how to implement that strategy with GetBack.

   1.1	  Fundamentals of a Backup Strategy

	  First and foremost to all backup strategies is taken from
	  the famous shoe ad:

		    Just Do It!

	  Many of us get lazy and neglect some important tasks
	  every day.  Many of us have neglected to perform the
	  backups necessary to protect our valuable data on a
	  timely basis.  Let's decide today that we will follow the
	  first and primary fundamental of backup strategy and that
	  is to DO IT!

	  Once we got that down (or at least decided), the next
	  important piece of our strategic plan is to determine:

	     What Data is important to backup?

		      and

	     How often should that be backed up.

	  Perhaps the simplest answer to both of these is: all the
	  data every day.  But that often is not a reasonable
	  answer to either question.  Generally speaking, all data
	  is important to be backed up, but not every day.  Much
	  data on your hard drive is already backed up.  Sometimes,
	  every day is not frequent enough for some data.
	  Sometimes it is overkill.

   1.2	  What Data is important to backup

	  Again, it is dangerous to deal in generalities, but most
	  data falls under three categories:

		 1.	   Data files that I have bought and thus
			   have the original files on their
			   installation disks.	These are the disks
			   that came when you purchased the software.
			    If this data is lost, it could be
			   reconstructed by reloading the software.
			   Not too painful.

		 2.	   Data files that my programs have created
			   that can be re-created from other files.
			   Lotus ".PIC" are such files as are dBase
			   ".NDX" files.  Lotus ".PIC" files are
			   graph files that are created from your
			   spreadsheet files.	These files usually
			   can be easily recreated if you have the
			   source files (Lotus ".WK1" files and dBase
			   ".DBF" files).  This data never needs to
			   be backed up.

		 3.	   Data files that I have created through the
			   keyboard or mouse.  These files are like
			   the outputs of word processing programs
			   (like .DOC files from Word), spreadsheets
			   (like .WK1 files from Lotus 1-2-3),
			   databases (like .DBF files from dBase), or
			   accounting programs (like MoneyCounts .DAT
			   files).  These files represent your hard
			   earned work and are very important to you.
			   They also might include configuration
			   files (like Window's configuration files
			   or your DOS CONFIG.SYS and AUTOEXEC.BAT).

   1.3	  How often to Backup Data

	  Ideally, data should be backed up as soon as practical
	  after it has been created.  If you are entering
	  significant data that is creative of nature you may want
	  to back it up right after you create it.  (Some of us
	  forget our brainstorms as quickly as we get them).
	  Generally, you want to regularly backup only the files
	  that you create and/or change.  These are files like
	  letters, reports, databases, documents and spreadsheets.
	  Generally you don't want to backup files that you don't
	  change. Every user has different needs.  Not everyone's
	  data is of equal value.  How often you backup depends on
	  both your needs, your habits, and your comfort level with
	  the thought of losing some data.  A good rule of thumb
	  that works for most people is to back up at the end of
	  every day.  This means that in a very worst case scenario
	  (you have lost every thing), on the average, you will
	  only lose about 4 hours of work.

   1.4	  Setting a Backup Strategy

	  So, how do you go about setting a backup strategy?  Here
	  are a few simple guidelines.	(Note: Running ALLFILES
	  will create a text file, ALLFILES.TXT, of all files on
	  your current hard drive.  Print this file out and use
	  three highlighters to identify each file)

	     Step 1	   Identify those category one files that are
			   part of programs for which you already
			   have a backup.  You are probably wise to
			   back up all of these up in one backup set
			   (a set of floppy disks containing a
			   backup) once.  We will label this backup
			   set PROGRAMS. Although this is not
			   essential (remember, you already have
			   these backed up on your original floppies)
			   it will make it much easier to recreate
			   your system.  If you are willing to take
			   the time of reconstructing these from all
			   the programs that you own or if you don't
			   own that many complex programs, this step
			   may be skipped.   We will explain how to
			   do this later.  File these away in a very
			   safe place.	Write protect the disks.  You
			   need not make another copy of this backup
			   until you add another set of program data
			   files (say you add a new Backup program
			   like GetBack).  At that point, you are
			   probably wise to make a fresh backup of
			   all your programs (because you may have
			   forgotten to backup your last update to
			   your spreadsheet program).


	  Step 2	   Identify those category two files that are
			   automatically generated.  Many users do
			   not have any of these files.  If you are
			   not sure about a file, consider it a
			   category 3 file.

	  Step 3	   Identify those category three files that
			   are your hard earned data files.  If there
			   are files from long dead projects or
			   correspondence that you are fairly sure
			   you will never touch again, back them up
			   in a backup set and call it ARCHIVE01.
			   Then delete them from your disk.

       Now, are there any files that don't fall under these three
       categories.  If you can't find out what they are, it is best
       to put them under category three.

       All files that are category 3 files need not be updated
       every day.  Some files are from projects long since
       completed.  Some files were created once and have no
       business being on your hard drive.  After we have backed
       them up, it may be wise to delete them from your hard drive.
       Many of us only work on a few files a day.  If our backup is
       taking 20 minutes each day to backup 30 meg of data, we are
       probably backing up a lot more than we need to.	Ideally we
       should only backup those files that we need to backup.

       How you have organized your hard disk also affects your
       backup strategy.  In order to facilitate backups, it is very
       useful and safe to put all of your files of the same
       category in multiple directories under one directory tree.
       This way, to backup all category three data files you could
       just specify to include all the files in that directory and
       all its subdirectory.  You never have to remember to update
       your backup configuration files when you add new projects
       and new directories.  For example, all category three data
       files could be put under the C:\DATA directory.	It is very
       important that macros generated with spreadsheet programs
       and word processing programs be put under these directories.
       Your MoneyCounts data files should also be put in a
       subdirectory under this directory.

       It also is useful to place all category one data files under
       a directory tree like C:\PROGRAM.  Thus you would have a set
       of directories that might look like:

	     C:\PROGRAM
	     C:\PROGRAM\MC
	     C:\PROGRAM\123
		 etc

       Although GetBack will allow you to specify data directories
       all over your hard disk, it becomes another thing to
       remember whenever you add new directories.  For example,
       let's imagine that you keep your word processing files in
       C:\LETTERS and your spreadsheets in C:\WORKSHTS.  When you
       add WordPerfect to your system, you add a directory
       C:\WP51\LETTERS.  This is category three data that must be
       added to your backup specification.  If instead you had a
       directory structure that looked like this:

	     C:\DATA
	     C:\DATA\LETTERS
	     C:\DATA\WORKSHTS


       you could tell the backup program to backup up everything in
       C:\DATA and all the files in DATA's subdirectories and never
       have to worry about it.

   1.5	  Some Typical Backup Strategies

       Let's list a few backup strategies and then analyze them for
       the applicability.  We will show you how to perform these
       strategies later.

       Data Backup Strategy #1 - (Weekly Full data/Daily
	  Incremental data)

	  Step 1	   On Friday afternoon of every week, perform
			   a FULL backup of your category three data
			   files.  Let's call this backup set FULL
			   DATA WEEK 1.  Mark all floppies in
			   numerical order with this label and with
			   their number.
	  Step 2	   On Monday afternoon, perform a backup of
			   all category three files that have changed
			   since Friday.  This is called an
			   INCREMENTAL backup.	Mark all the floppies
			   with the label INCREMENTAL DATA WEEK 1 DAY
			   1.	Use either a new disk or append the
			   backup set to your last disk. (Appending
			   does not delete the existing files).
	  Step 3	   On Tuesday afternoon, repeat step 2 naming
			   the backup set INCREMENTAL DATA WEEK 1 DAY
			   2.
	  Step 4	   On Wednesday afternoon, repeat step 2
			   naming the backup set INCREMENTAL DATA
			   WEEK 1 DAY 3.
	  Step 5	   On Thursday afternoon, repeat step 2
			   naming the backup set INCREMENTAL DATA
			   WEEK 1 DAY 4.
	  Step 6	   On Friday afternoon, repeat step one,
			   naming the backup set FULL DATA WEEK 2.
			   Start with a new disk.

	  Repeat this for four weeks.  At this point, start re-
	     using your disks.

	  Analysis of Strategy #1
	      Advantages - This strategy is pretty thorough.  In
		 general, the incremental backups performed on
		 Monday - Thursday will be fairly quick.  Friday's
		 backup may take too long however depending on how
		 much data you keep on your hard drive.  Depending
		 on how many disks you are using, you may desire to
		 wait 8-16 weeks before recycling your disks.  It is
		 also useful to save a backup set every 3-4 months
		 and file it away in a safe place.  Never recycle
		 these disks.  You never know when you may find that
		 you accidentally deleted a file two months ago
		 which has fallen off the backup list.
	      Disadvantages - INCREMENTAL backups are quick but make
		 restoration a little more difficult.  If you need
		 to restore one file, you may need to go through
		 several backup sets before you find it.  In general
		 this is not to bad a limitation because we don't
		 lose data that often.	There is a disadvantage to
		 this strategy if you have not carefully identified
		 all of your critical category three data.  For
		 example, if you just recently started creating .WP
		 files and had not identified these as category
		 three files, you will never back them up unless you
		 have structured your directories properly (as we
		 talked about earlier).  This strategy also tends to
		 use a fair number of disks.

       Data Backup Strategy #2 (Full Disk/Differentials until
	  unwieldy)

	  Step 1	   Perform a FULL backup of your entire hard
			   disk (all categories)

	  Step 2	   Every day (or after a significant period
			   of data entry), perform a DIFFERENTIAL
			   backup of your entire hard disk.  This
			   will back up only those files that have
			   changed since the last full backup.
			   Recycle disks every other time.

	  Step 3	   Perform Step 2 until this procedure
			   becomes unwieldy (takes too long or uses
			   too many disks).

	  Step 4	   Repeat from step 1, using a new set of
			   disks.

	  Analysis of Strategy #2
	      Advantages - This strategy works well if you do not
		 create a lot of files.  It is easy to restore a
		 file, since all files that have changed since the
		 full backup can easily be restored.  It doesn't use
		 a lot of floppy disks.  It is extremely thorough
		 and is not very prone to error.
	      Disadvantages - If you create a lot of category three
		 data, this strategy becomes unwieldy very soon.

       Data Backup Strategy #3 (Full Disk/Incrementals)

	  Step 1	   Perform a FULL backup of your entire hard
			   disk (all categories)

	  Step 2	   Every day (or after a significant period
			   of data entry), perform an INCREMENTAL
			   backup of your entire hard disk.  This
			   will back up only those files that have
			   changed since the last backup.  Either
			   append the files to your existing backup
			   set or carefully label each floppy.

	  Step 3	   Perform Step 2 for a month or so
			   (approximately 20 incremental backups).

	  Step 4	   Repeat from step 1, using a new set of
			   disks for the full backup and recycle the
			   Incrementals.

	  Analysis of Strategy #3
	      Advantages - This strategy works well if you do not
		 need to restore files very often.  It minimizes the
		 number of disks needed. It is not very prone to
		 error.
	      Disadvantages - Restoring of a file could mean going
		 through 10-20 backup sets.  However, if this
		 doesn't occur very often, it is a very fast,
		 thorough and efficient backup strategy.

   1.6	  General Backup Guidelines


	  Finally, once you have a backup strategy that works.
	  Stick to it.	Deviations can spell disaster.

	  It is always good policy to:

	  1.  Have a well thought-out backup strategy and keep it.
	  2.  Keep backups in a safe, fireproof, preferably off-site
	      location.
	  3.  Archive a full backup every 1-3 months that never gets
	      re-cycled
	  4.  Backup your data at the end of a day rather than the
	      beginning.  (Computers have a higher probability of
	      failing when they are turned on rather than failing
	      while they are running).
	  5.  Test you backup strategy with a mini-fire drill to
	      make sure you know how to restore your files.
	  6.  Maintain at least two backups if you are going to
	      replace or re-format your hard disk.
	  7.  Have a well thought-out backup strategy and keep it.
	      (This bears repeating)
	  8.  Turn on Verification ALWAYS!
	  9.  Have plenty of disks available.  They are cheaper than
	      your lost time.



2      Invoking GetBack

   GetBack consists of three programs.	GETBACK is the user
   friendly interface that lets you define your backup and restore
   options.  It invokes MAKEBAK to actually make a backup and
   GETBAK to actually perform a restore.  The backup "engines" may
   be run separately from the command line (or Batch file).
   GETBACK can be started at the DOS command line as follows:

       C:> GETBACK [switches] [configuration file]

	      where the optional switches are:
		 /T   for Text Mode
		 /G   for Graphics Mode
	      GetBack automatically determines an optimal setting
		 based on your hardware and graphics capability.
		 These switches allow you to override the default
		 settings.

	      and the optional configuration file is used to set up
		 your backup configuration upon startup.  If no file
		 is specified, GetBack uses the file "LAST.GBK"
		 stored in GetBack's program directory.  All GetBack
		 configuration files have the .GBK extension.
		 GetBack first looks in the current directory and
		 then (for DOS 3.0 or greater) in the same directory
		 that GetBack.EXE is store in.

   If you desire to perform backups with no user interaction (like
       from a batch file), you may run the GetBack backup engine
       with the command:

	  C:> MAKEBAK configuration_file

       Here the configuration file and the extension are not
       optional.

   If you desire to perform a restore with no user
       interaction, you may run the GetBack restore engine:

	  C:> GETBAK configuration_file

3  Navigating in GetBack

   GetBack is designed with an intuitive interface that needs no
   introduction.  Many programs have paved the way and set the
   standard for navigating on a screen like GetBack's that should
   make learning to use it a snap.  For those not familiar with
   these navigation standards, we'll give you a summary.

   3.1	  Some Definitions of Terms we will be using throughout
	  this manual

	  Menu	 - This is a list options for you to choose.  There
	  are many such menus in GetBack.  An example is the Main
	  Menu where you are give the option to:

				  Start Backup
				  Preview Backup
				  Start Restore
				  Preview Restore
				  Display Backup Set
				  Setup Backup Options
				  Edit Include/Excludes
				  Load Configuration
				  Save Configuration

	     Each of these items in the list are a Menu Item.

	  Button Item - A button is a rectangularly shaped box on
	  the screen used to select an option.	The Exit button on
	  the Main Screen is such an object.

	  Highlighted Item - This is when a menu item (or button)
	  is highlighted with either a different color or a
	  different intensity.	This item is available for
	  Selection.

	  Select Item - This is when a highlighted item is selected
	  to perform the function it describes.  For example, when
	  the Preview Backup Menu Item is Highlighted and then
	  Selected, GetBack begins to preview the currently defined
	  backup.  When the Exit Button Item is selected, GetBack
	  exits.

	  Toggle Item - Certain discrete items can be toggled to
	  select alternate options.  For example, the Verification
	  Status item can be toggled from On to Off and vice versa.

	  Edit Item - Certain items are fields that can be edited.
	  For example, when loading new configuration, you can
	  enter the file specification for the configuration file
	  that you wish to load.

	  Window Item - On most screens there are multiple window
	  items.  For example on the Main Screen there are seven
	  separate window items:

		 The Main Menu
		 The Status Window
		 The Hardware Status Window
		 The Advanced Status Window
		 The Current Configuration file
		 The Exit Button
		 The Include/Exclude Matrix

	  Context Sensitive Help - GetBack provides context
	  sensitive help to help you find your way around its
	  screen.  Whatever item is highlighted has a unique help
	  message to help you remember what it does.  For example,
	  if the View Backup Set item is highlighted in the Main
	  Menu, selecting Help will provide a detailed description
	  of what selecting this item will do.

	  Status Window - GetBack has three status windows; one for
	  the normal setup options, one for the hardware options,
	  and one for advanced options that need not be changed
	  under normal circumstances.  Each status window is actual
	  a menu consisting of two more menu items itself.  There
	  are no hot keys associated with these menu items.

	  Hot Keys - GetBack provides a way to select a menu item
	  or a button item with a hot key.  A hot key is indicated
	  by an underline in Graphics mode and a bold character in
	  Text mode.  Hot keys may be activated from anywhere on
	  the screen with an <ALT>-<Hotkey>.

   3.2	  How to Navigate

	  Navigating through GetBack menu's is performed using any
	  combination of the following techniques:

	  Keyboard Navigating

	      Cursor Control Keys - use the <UP_ARROW> or
		 <DOWN_ARROW> to position the cursor or Highlighted
		 item.	Once you have Highlighted the item you
		 desire, hit the <ENTER> key to Select it.  Use the
		 <LEFT_ARROW> or <RIGHT_ARROW> keys to move
		 horizontally across items.

	      Exit Window - The <Esc> key can be used to exit any
		 window

	      Hot Key Character - in every menu, items may be
		 selected by hitting the key corresponding to the
		 item.	This key is identified in bold for Text mode
		 applications and with an underline for Graphics
		 mode applications.

	      <Tab> Key - This key may be used to move from window
		 item to window item on the screen.  <Shift-Tab>
		 moves from window item to window item in the
		 reverse direction.

	      <Space Bar> - This key is used to toggle items

	      <Enter> - This key is used to select an item, toggle
		 an item, or complete the editing of an item.

	      <PgUp> and <PgDn> - These keys are used in menus to go
		 to the top or the bottom of the menu.	When viewing
		 help screens or Include/Exclude lists, these keys
		 move the highlight bar one page up or down.


	  Mouse Navigating

	     The mouse may be used to select or toggle an item by
	     the simple Point and Click method.  Point the mouse
	     cursor at the item and click the left mouse button.
	     If the item is to be selected, it will be selected
	     (for example, GetBack will Start a Backup).  If the
	     item is an item to be toggled, the item will be
	     toggled.

	  Scroll Bar

	     When viewing large amounts of data (in a Help Screen
	     or in the Include/Exclude list), a scroll bar is
	     provided for navigation.  You may either click on the
	     scroll button and drag the button down to position the
	     text or you may click on the UP and DOWN arrows to
	     move one line at a time.

4  Setting Up GetBack

   GetBack allows you to set up several options in order to
   configure your backup.  Although GetBack provides a set of
   defaults, you need to carefully chose your options to fit your
   hardware and your backup strategy.

   GetBack provides two ways for you to set up its options - the
   fast method and the verbose method.	We recommend that you
   utilize the verbose method at first since it will walk you
   through each of the options.  At any time you may click on the
   Help Button or hit <F3> to call up the context sensitive help.

   The Main Screen provides a complete status of all of the
   options selected for GetBack.  This allows you to see all the
   options you have selected all at once.

   We will describe how to select an option using each of the two
   methods using the Drive type as an example.	All other options
   are set the same.

   The following options are available:

       Hardware Configuration
	  Type of Backup Media (360k, 720k, 1.2m, 1.44m floppy, or
	     DOS drive)
	  Drive (and for DOS drives the directory)
	  Colors on your Display
	  Text or Graphics mode
       Setup options for Backup/Restore
	  Type (full, differential, incremental)
	  Files (only defined files, all except defined files)
	  Archive Bit (set or cleared after backup)
	  Compression option (Compression On or Compression Off)
	  Verify (Check that the backup worked as you go)
	  Restore Overwrite Warnings (Tell you that you are
	     overwriting)
       Advanced options
	  Formatting of Target Drive
	  Keeping of Log Files on Hard Disk
	  Deleting of Files on Target Drive
	  Backing up System/Hidden Files

   4.1	  Hardware Configuration

	  GetBack requires that you define where the backup files
	  are to go and where the restored files are coming from.
	  GetBack needs to know what drive they are on and what
	  type of drive it is.	In addition, GetBack allows you to
	  specify the colors for your screen (if you have a color
	  monitor) and whether or not you are in text mode or
	  graphics mode.  All four of these options may be set
	  through the pop up menus by selecting first the SETUP
	  BACKUP/RESTORE and then SETUP HARDWARE OPTIONS.  Where
	  the files are coming from and going to and the backup
	  media type may also be set directly from the Main Menu by
	  using either the <Tab>, <Arrow>, and <Enter> keys or the
	  Mouse to toggle these options.

       4.1.1  Drive Type

	     You must select the type of media you are going to
	     back up to.  The options for this are:

		 360k 5 Floppy
		 720k 3 Floppy
		 1.2m 5 Floppy
		 1.44m 3 Floppy
		     DOS media - This can be network, a tape drive,
			   or an unsupported floppy.  You can also do
			   cumulative backups to DOS media.  This
			   allows you to have multiple backups on one
			   media.  This is also called append.	In
			   general this mode is considerably slower
			   than defining the media type.

	      If you do not know what type of drive you have, select
		 the DOS media.

	  4.1.1.1   Selecting the Drive Type (Fast Method)

		    From the main screen, the Drive type is listed
		    in the Hardware Status window.  By depressing
		    the <TAB> key, you will move the highlight bar
		    to the Drive Type.	Hitting the <Enter> key will
		    toggle this through each of the options.	      For
		    mouse users, place the mouse cursor on the Drive
		    Type and depress the Left Mouse button once to
		    toggle the option.

	  4.1.1.2   Selecting the Drive Type (Verbose Method)

		    Alternately, for beginners, the drive type may
		    be set via the menu selections.  First, select
		    the SET BACKUP/RESTORE from the main menu (using
		    the <Down Arrow> key and the <Enter> key or the
		    Mouse).  This will take you to the Setup Menu.
		    Select the first item, (SET HARDWARE OPTIONS) by
		    hitting the <ENTER> key or clicking it with the
		    Left mouse button.	Then select the SET MEDIA
		    TYPE.  This will bring you to a menu of media
		    type options.  Select the option desired by
		    either hitting <ENTER> or clicking on it with
		    the mouse.	You may return to the main menu by
		    selecting the RETURN option in each of the
		    menus.

       4.1.2  Target/Source Drive for Backup/Restore

	     You must specify the target drive for backups and the
	     source drive for restore.	 Generally only a letter is
	     required.	However, for DOS drives, you may also
	     specify a directory.  If you specify a directory, you
	     will not be able to toggle this from the status
	     window.

       4.1.3  Color Options

	     GetBack allows you to specify the Color of various
	     items on your screen. Colors may only be set with the
	     verbose method.  It is possible to set the foreground
	     and background colors of the following:

		Borders around windows
		Windows
		Window objects
		Titles
		Menu items (both selected and non selected)
		Hot Key items (character color only)
		Buttons (like the HELP, GENERAL HELP)

	     Foreground color is defined as the color of the
	     characters or lines.  Background color is defined as
	     the color of the paper the characters are written on.

	     It is also possible to reset the color to their
	     original settings.  These settings are stored in a
	     file called BBCOLOR.DAT and is located in the same
	     directory that the GetBack.EXE is kept.  If you desire
	     to save different color configuration, this file can
	     be renamed to reflect any number of color
	     configurations.

       4.1.4  Text and Graphics Mode

	     GetBack runs in two modes:

		Graphics Mode
		Text Mode

	     On startup, if no mode is specified, GetBack
	     determines the mode based		 on the hardware
	     available, and the speed of your machine.	For 808X
	     machines (like PC's and XT's),  GetBack defaults to
	     text mode.    You may override this by specifying a "/T"
	     or a "/G" switch at startup.

	      Also, you can switch screen modes from a Hardware Menu
		 option.

   4.2	  Setup Options

	  GetBack allows you to configure your Backups and Restores
	  with the following options:
	      Type: GetBack allows you to specify three types of
		 backups:

		 Full - 	  This option backs up all files that
				  are specified.
		 Incremental -	  This option backs up only files that
				  have changed or have been created
				  since the last FULL or INCREMENTAL
				  backup.
		 Differential -    This option backs up only those
				   files that have changed     or are
				   new since the last FULL backup.

	      Files: GetBack allows you to specify which files to
		 backup:
		Include 	  This option will allow you to specify
				  a list of directories and files to
				  include in Backup/Restore.  The
				  inclusion of these files may be
				  superseded by an Exclude
				  specification.
		All Include	  This option will allow you to specify
				  a list of directories and files to
				  include in the Backup/Restore that
				  can not be superseded by an Exclude
				  specification
		Exclude 	  This option will allow you to specify
				  a list of directories and files to be
				  excluded in the Backup/Restore.

		 In the restore mode, you may also specify a
		 different target directory.

	      Archive Bit: GetBack allows you to select what happens
		 to the Archive Bit of files that are backed up.
		 Under most circumstances you will not want to
		 change this option.  Setting this will override the
		 effect of the backup type.  For example, generally,
		 a full backup always clears the archive bit.
		 Setting this to UNCHANGED, will cause the archive
		 bit to not get cleared. Setting the bit to
		 UNCHANGED means that the archive bit will not be
		 changed at all.

	      Compression:  GetBack allows you to disable its normal
		 compression techniques.  This option will cause the
		 backup to use more disk space and generally will
		 cause the backup to take longer.  Under certain
		 circumstances (a very fast backup media and/or a
		 very slow PC), disabling compression might speed up
		 the backup process.

	      Verify:  GetBack normally verifies all data it writes
		 to the backup media. THIS IS VERY IMPORTANT TO THE
		 INTEGRITY OF YOUR BACKUP! In some circumstances, it
		 may be desirable to turn this feature off.  PLEASE
		 BE AWARE WHEN YOU DO THIS.

	      Backup/Restore Overwrite Warnings : This option is
		 used during restore to warn you that a file already
		 exists on your hard disk which you are about to
		 overwrite with the backup version.  During Backup,
		 this option will enable you to be warned if files
		 on a disk are being overwritten.

	     All of these options may be set via the menu system by
	     selecting the SETUP BACKUP/RESTORE option and then the
	     SET BACKUP/RESTORE.  These also may be set directly
	     from the Main Menu by using either the <Tab>, <Arrow>
	     and <Enter> keys or the Mouse to toggle these options.

       4.2.1  Type

	     There are three types of Backups that can be performed
	     with GetBack:

		 Full
		 Incremental
		 Differential

	     Full Backup is used when you want to backup all files
	     specified in your INCLUDE/EXCLUDE specification
	     independent of the status of the archive bit. Full
	     backups generally clear the archive bit (unless
	     overridden by the ARCHIVE BIT UNCHANGED option) of all
	     files that it backs up.  Selecting a Full Backup
	     automatically sets the Archive bit option to CLEARED.

	     Incremental Backup is used when you want to backup any
	     files that have changed or are new since the last
	     backup.  Incremental backups are made based on the
	     status of the archive bit.  The incremental backup
	     clears the archive bit of each file it backs up
	     (unless overridden by the ARCHIVE BIT UNCHANGED
	     option). This means that the next incremental backup
	     will not back that file up again unless it has been
	     changed.	Selecting an Incremental backup,
	     automatically sets the Archive bit option to CLEARED.

	     Differential Backup is used when you want to backup
	     all files that have changed since the last full
	     backup.  Differential backups are made based on the
	     status of the archive bit.  The differential backup
	     does not clear the archive bit as it backs up.  This
	     allows you to run consecutive backups after a full
	     backup. Selecting a Differential backup, automatically
	     sets the Archive bit option to UNCHANGED.

       4.2.2  Include/Exclude Specifications

	     You may specify the files that you want to INCLUDE or
	     EXCLUDE in a definition file.  You have five options
	     to create/define this file:

		   You mayfile that already exists from a previous
		    backup or	     you created offline with your
		    word processor or editor
		   You may create a new file with all of your
		    directories listed to allow you to edit from
		    this baseline
		   You may create a new empty file and build the
		    definition from scratch
		   You may edit your current configuration
		   You may select the files from a directory tree

	     In some cases you do not want to back up all of your
	     files and all of your directories.  With GetBack you
	     can select only certain files, certain extensions and
	     / or certain directories to back up.  This is done
	     with the INCLUDE/EXCLUDE/INC ALL option.  Only those
	     directories and files that you specify will be backed
	     up.  This selection is performed by defining the
	     directories and files in a backup configuration file.
	     The file consists of a list of directories and files.
	     Filenames may be specified using DOS wildcard
	     characters (* and ?).  Backup will only backup files
	     that you specify in this file.

		 INCLUDE means to backup these files unless
		 overridden by EXCLUDE.
		 EXCLUDE means to not backup these files unless
		    overridden by INC ALL.
		 INC ALL means to always backup these files.

	     Be careful not to have overlapping INCLUDE and/or INC
	     ALL specification or GetBack will backup the files
	     twice.

	     EXAMPLE:  To Backup only ".DOC" files in all
	     directories, you would create a list with the
	     following contents:

   INCLUDE/		   File Specification		With
   EXCLUDE						Subdirs

   INCLUDE		   c:\*.DOC			SUBDIRS

	     In some cases, you want to back up all of your files
	     except certain exceptions. This may be done with the
	     EXCLUDE option.  As with the INCLUDE option, you
	     create a file with a list of files that you want to be
	     excluded from backup. GetBack will backup all files
	     except for those you specified.

	     EXAMPLE:  To Backup all files except those files in
	     the "user\tmp" directory, you would create a file with
	     the following contents:

       INCLUDE/ 	   File Specification		With
       EXCLUDE						Subdirs

       INCLUDE		   c:\*.*			SUBDIRS
       EXCLUDE		   c:\user\tmp\*.*		NO SUBD


	     When specifying INCLUDE, INC ALL and EXCLUDE three
	     rules that GetBack follows are very important.

	     RULE #1:  EXCLUDE takes precedence over INCLUDE.  This
	     means that in the above example the INCLUDE
	     specification (C:\*.*) defines all files except as
	     exempted by the EXCLUDE.  This rule always applies
	     unless overridden by rule #2.

	     RULE #2:  INCLUDE specifications that do not include
	     DOS wildcard specifications can never be excluded.

	     RULE #3:  INC ALL specification can never be excluded.

	     For example:

   INCLUDE/		   File Specification		       With
   EXCLUDE						       Subdirs

   INCLUDE   c:\*.*					       SUBDIRS
   EXCLUDE   c:\*.TMP					       SUBDIRS
   INCLUDE   c:\IMPORTNT.TMP				       NO SUBD
   INC ALL   c:\SPECIAL\*.TMP				       NO SUBD

	     In this example, all files will be backed up unless
	     they have a TMP extension. No .TMP files will be
	     backed up except IMPORTNT.TMP and those in the special
	     directory.

	  4.2.2.1   Editing Include/Exclude Lists

	  It is possible to Edit the Include/Exclude list from
	  several places in GetBack.  From the Main Screen, you can
	  completely edit the list but you cannot add additional
	  items to the list once it is filled.	From the other
	  screens, you are allowed to add and delete lines to the
	  list as well as seed it with you directory structure.

	  When backing up, enter all of the file specifications you
	  desire and indicate whether or not you desire to INCLUDE
	  or EXCLUDE these files from the backup.  If you desire
	  the file specification to be inclusive of all subsequent
	  subdirectories, select SUBDIR in the subdirectory button.

	  When restoring files, each line of the file specification
	  can actually contain two file specifications separated by
	  a space.  The second file specification is the
	  destination of where you want the restored files to go.

	  For example, to restore all *.DOC files in the
	  C:\WORD\DOC directory to the C:\WORD\TMP directory, you
	  would select INCLUDE and:
	     C:\WORD\DOC\*.DOC C:\WORD\TMP

	  To insert lines into this list, place the cursor where
	  you want to insert and select the insert button (Placing
	  the mouse cursor and clicking the left button or Hot Key
	  <ALT-I>).

	  To delete lines in this list, place the cursor on the
	  line where you want to delete and select the delete
	  button (Placing the mouse cursor and clicking the left
	  button or Hot Key <ALT-D>).

	  When you have made all your changes, select the OK button
	  to exit.  If you wish to cancel your changes, select the
	  CANCEL button.

	  Editing and cursor movements while in this list are as
	  follows:

	     Cursor Movement:
	     <Down/Up/Right/Left>	     Move cursor one character
					     down/up/right/left
	     <PgDn> <PgUp>		     Move the cursor down/up one
					     page
	     <Home> <End>		     Move the cursor to the
					     beginning/end of line
	     <Ctrl Right/Left>		     Move cursor one word to the
					     right/left
	     <Ctrl Home> <Ctrl End>	     Move cursor to the
					     beginning/end of the file
	     {Left Mouse Click} 	     Move cursor to the Mouse
					     cursor

	     Delete Text:
	     <Del>			     Delete the character at the
					     cursor
	     <Ctrl Del> 		     Delete the word at the
					     cursor
	     <BkSp>			     Delete the character before
					     the cursor
	     <Ctrl BkSp>		     Delete from the cursor to
					     the end of line
	     <F8>			     Delete from the cursor to
					     the end of line

	     Mark Text:
	     <Ctrl F5>			     Marks text for copy or cut
	     <ENTER>			     Following a mark, copies
					     text to paste buffer
	     <Del>			     Following a mark, deletes
					     text to paste buffer
	     <Ctrl F6>			     Cut marked Text
	     <Ctrl F8>			     Copies from paste buffer to
					     cursor

	  4.2.2.2   Seeding the Include/Exclude List with a
		    Directory Tree

		    GetBack allows you to start your list of
		    Include/Exclude files with a directory tree.
		    For example, if you wanted to start with all
		    directories of the C: drive you would enter:

		       C:\

		    GetBack will then display all of the directories
		    on your C drive.

		    If you want to start your list with the list of
		    all directories under the \USER\ directory, you
		    would enter:

		       C:\USER\

		    This starting point will allow you to easily
		    specify the files that you want to
		    include/exclude.

       4.2.3  Archive Bit

	     Whenever a file is created or modified, a bit is set
	     in the file to indicate that this file should be
	     archived.	This bit is called the archive bit.  The
	     archive bit is used by backup utilities (and XCOPY) to
	     indicate that a file has been created or modified
	     since the last backup.  Generally you want the archive
	     bit cleared when the file has been backed up.
	     Generally, all FULL and INCREMENTAL backups will clear
	     the archive bit of each file that is backed up.

	     For example, lets imagine that you just backed up your
	     entire disk.  All files will have their archive bit
	     cleared indicating that they do not need to be backed
	     up again.	After one day of creating and modifying
	     files, you run an INCREMENTAL backup.  This backup
	     will only backup those files that have the archive bit
	     set.  It will generally clear the archive bit of those
	     files.  But, if you wanted to run two identical
	     INCREMENTAL backups you could not do it if the archive
	     bit gets cleared.	If you desire to run two identical
	     INCREMENTAL backups, you must run the first with this
	     option set to ARCHIVE BIT UNCHANGED. The second will
	     be run with the ARCHIVE BIT CLEARED.

	     You may also want to not clear the archive bit after
	     any INCREMENTAL backup. In this case, each INCREMENTAL
	     backup would include all files that have changed since
	     the last full backup.  This would (in effect) be a
	     DIFFERENTIAL backup. The archive bit will always be
	     UNCHANGED during differential backups.


       4.2.4  Compression

	     With the Compress option on, GetBack will compress
	     your files on the backup media while backing up your
	     files.  This causes them to take less space on your
	     backup media than they took on your hard disk.
	     Normally, GetBack will also run faster with
	     compression turned on.  Compression takes processing
	     time to compress your data.  But since disk I/O is
	     generally the slowest part of any computer program,
	     compression generally saves more time than it takes.
	     However, with a very slow PC and/or a very fast disk
	     or tape, GetBack may run faster with compression
	     turned off.

	     You also may choose to turn compression off if you are
	     only backing up files that are already compressed
	     (.ZIP or .ARC) files.

	     The compression option has no effect during Restore.

       4.2.5  Verify

	     There are two ways to verify your data as you write
	     it.

		 Verify every byte that it writes
		 Use the DOS verify which merely checks the
		    integrity of the data

	     Many backup programs only perform the DOS verify.
	     Because the DOS verify provides a false sense of
	     security, GetBack does not even provide it as an
	     option.  GetBack defaults to checking every byte that
	     it writes to your backup media. This adds a
	     significant amount of time to your backup process.
	     However, floppy disks are notorious in dropping data.
	     If VERIFY is turned off, the backup program cannot
	     attest to the integrity of the backup.  We would
	     strongly recommend that you leave VERIFY on.

	     Again, depending on the speed of your machine, this
	     could add between 20% (for a slow machine) to 50% on a
	     fast machine.

       4.2.6  Backup/Restore Overwrite Warnings

	     GetBack Restore allows you to choose whether or not
	     you want to be warned during a restore if it is going
	     to overwrite a file.  Having this option on will cause
	     an overwrite warning and a prompt to ask you to
	     proceed.

	     During backups, the overwrite option, when enabled,
	     causes GETBACK to warn you whenever you are going to
	     overwrite files on the target media.

   4.3	  Advanced Setup Options

	  GetBack allows the user to set certain advanced options
	  for backup.  The default operation for these options will
	  meet the needs of most users.  For certain users,
	  changing the defaults on these options will allow
	  additional flexibility in backup.	    These options
	  include:

	    Allow the user to not keep the log files on their hard
	     drive.  GetBack defaults to keeping the last five log
	     files on the hard drive.

	    Allow the user to not automatically format the target
	     drive if it is not formatted.  GetBack defaults to
	     automatically formatting the target drive if required.

	    Allow the user to not automatically delete the files
	     on the target drive. GetBack defaults to automatically
	     deleting all files on the target drive.

	    Allow the user to not backup Hidden and System files.
	     GetBack defaults to backing up all files.

	  There are two methods of setting these options; using
	  either the menu system or the Status windows.

       4.3.1  Log Backup Sets on Hard Drive

	     Every time a backup is performed, a log file
	     containing the list of files that were backed up and
	     what disk they are on is stored on the last floppy in
	     the backup set.  In addition, the last five log files
	     are automatically kept on the hard drive in GetBack's
	     special hidden directory }H_DD_N{.  (or optionally in
	     the directory specified by the environment variable
	     GBK_LOG).	If you want these kept in a different
	     directory, put the following in your autoexec.bat
	     file:

		 SET GBK_LOG=C:MY_DIRECTORY


	     These log files are named as follows:

		 YYMMDDL#.BK1

	     Where YY is the year, MM is the month, DD is the day,
	     L is the first drive in this backup set, # is the
	     letter (A-Z) representing the number of backups
	     performed on that date.

	     When you want to backup just a few files from a backup
	     set, many backup programs force you to go through all
	     of the floppies to find the file.		GetBack uses the
	     log file to tell you which floppy to insert to restore
	     the files. Having these log files on your hard disk,
	     allows you restore files without having to insert the
	     last floppy in the drive.

	     This option allows you to not keep any log files on
	     your hard disk.

	     This option has no effect during a restore.

       4.3.2  Backup Media Format Option

	     GetBack always checks to see if a floppy requires
	     formatting before backing up to it.	Sometimes, it may
	     be important to stop the backup if the floppy isn't
	     formatted (or is the wrong density).  This options (if
	     selected) causes GetBack to display a warning message
	     if a wrong density or unformatted floppy is used
	     during backup.

	     GetBack uses a DOS compliant formatted floppy.
	     Although this is not as fast as some proprietary
	     formats, it allows you to mix and match your floppies
	     between backups and normal usage.

	     This option has no effect during a restore.

       4.3.3  Delete Target Files Option

	     GetBack always deletes all files on a floppy unless
	     this options is selected. There are situations
	     (networks in particular) where you would want to have
	     multiple backup sets on one floppy.

	     Select this option if you do not want to delete files
	     on the target drive when a backup is performed.

	     This option is only available for DOS media type.

	     This option has no effect during a restore.

       4.3.4  Hidden /System Files Option

	     Certain files on your hard disk are not visible to you
	     the user with normal DOS operation.  These files are
	     categorized as either System or Hidden files.  By
	     default, GetBack backs up both System and Hidden
	     files.

	     Under certain circumstances (older methods of copy
	     protection for instance), you may not want these files
	     backed up.

	     Select this option if you do not want to backup up
	     System files

	     This option has no effect during a restore.

5  Configuration Files

   There are three types of files that are used with Getback:
       Configuration Files - These files specify the Backup/Restore
	  specific information needed to perform a specific Backup
	  or Restore.  We would recommend that they be named to
	  reflect their purpose (like ALLFULL and DATAFULL for a
	  full backup of the entire disk and a backup of all data
	  files).
       Color Configuration Files - This file sets the colors for
	  all of GetBacks programs.
       Backup Set Files - These files contain a log of all of the
	  files backed up during a particular Backup Set.  They are
	  kept on the backup media (floppy or network) and the last
	  five are kept in GetBack's hidden directory.

   5.1	  Backup/Restore Configuration Files

	  Configuration files are used to store the option
	  information for GetBack.  These files are ASCII files
	  that can be created with any word processor or editor
	  capable of producing pure ASCII files (in Word Perfect
	  these are called DOS text files).  These files consist of
	  a first line containing the options and subsequent lines
	  containing the include/exclude specification.  These
	  files are generally kept in GetBacks home directory but
	  you can store them in your current directory.

	  A configuration file is saved any time you exit GETBACK
	  with the name LAST.GBK.  This file is also loaded into
	  memory on startup if no other configuration file is
	  specified.

	  The same file can be used for backup and for restore.
	  Certain options are not applicable to each and are
	  ignored.

       5.1.1  Saving the Backup / Restore Configuration File

	     You can specify a file where you want to save the
	     configuration.  This can be done from the Main menu by
	     selecting Save Configuration.

	     You may specify the full drive, path, and filename
	     (without extension) of where you want the
	     configuration file to be stored.  This configuration
	     file will contain all of the setup information
	     required.	This file always has the .GBK extension to
	     allow you to easily find them on your hard disk.  If
	     no directory is specified,  GetBack saves the file in
	     the directory where GetBack is stored (\GETBAK by
	     default).

	     The configuration includes:

		 Drive to be backed up to/restore data from
		 Media type
		 Backup Type
		 Archive Bit Option
		 Compression Option
		 Verify Option
		 Backup/Restore Warning Option
		 Hard Drive Log File Option
		 Hard Drive Format Option
		 Delete Target Drive Overwrite warnings
		 Include/Exclude File list
		 Status of Hidden /System files

	     The same file may be used for either backup or
	     restore.  Certain options, however may not be selected
	     and/or appropriate for both.


       5.1.2  Loading the Backup / Restore Configuration File

	     Every time GetBack powers up it takes either the last
	     configuration file you used or one that you specified
	     from the command line.  You may also load another
	     configuration file using the Load Configuration
	     selection from the Main Menu.  Once selected, you are
	     offered an option of selections to choose from or you
	     may enter your own selection.  Files are selected from
	     the pick list with either the mouse or the <Tab>,
	     <Cursor Ctrl> keys, and the <Enter>.  Files offered
	     from the pick list are either from your current
	     directory (those marked with a # sign) or from the
	     directory where the GETBACK.EXE file is stored.  You
	     may specify a load file from any directory.

   5.2	  Color Configuration File

	  GetBack stores the color information in a file called
	  BBCOLOR.DAT.	This file is automatically retrieved from
	  the directory that GetBack.exe is stored in and loaded
	  into memory.	This setup can be stored in your current
	  directory to allow different color configurations for
	  different users and or uses.

   5.3	  Backup Set Files

	  Every time a backup is run, a backup set file is
	  optionally stored on you hard disk as well as on the last
	  media disk where the backup is performed.  This backup
	  set contains the complete history of the backup,
	  including file names, date, time, size of the file, and
	  which disk the file was stored on.  These files are used
	  to pinpoint where in the backup set each file is that the
	  user wants to restore.  This enables the program to tell
	  the user which disk to insert during a restore.  For DOS
	  type media, multiple backup sets are allowed on each
	  media. This allows the user to append a series of back
	  ups to one media.

	  GetBack also (optionally) stores the last 5 backup sets
	  in its C:\}H_DD_N{ directory (or optionally in the
	  directory specified by the environment variable GBK_LOG.
	  If you want these kept in a different directory, put the
	  following in your autoexec.bat file:

		 SET GBK_LOG=C:\MY_DIRECTORY

		    where MY_DIRECTORY is the full DOS directory
		    specification.

6  Backing Up

   Before starting your backup, make sure that the following items
   are correct in GetBack's status windows:

       The Type of Backup - Full, Incremental, or Differential
       To Compress or not to compress (should be ON)
       To Verify or not to verify (should be ON)
       The Include / Exclude specification
       The archive status (should be CLEARED unless you are doing a
	  special backup or a Differential backup)
       The Drive letter
       The Media type

   Once your program is completely configured, you may start
   backing up your valuable data by selecting the Start Backup
   option from the Main Menu.  To verify everything is set up you
   may desire to preview the backup by selecting the Preview
   Backup option.  At this point the backup engine takes control.


   Once started, GetBack provides an estimate of the number of
   disks used and the amount of data that will be backed up.   It
   also provides you the ability to see how far the backup is
   along on the entire backup as well as on the individual disk.
   This gives the ability to know if you can leave your machine
   for a minute or two without dropping a second.  GetBack will
   not embarrass you by telling you how much time it takes to load
   the floppies.  Some of us fumble fingers would rather not know.

   Should there be any errors during the backup, GetBack will
   provide a comprehensive description of the error and a possible
   remedy for the problem.

7  Restoring Data

   In the unfortunate event that you need to restore some data
   from a backup set, step one is to set up GetBack with all the
   appropriate option.	Before starting the restore (with the
   Start Restore selection, make sure that the following options
   are set correctly:

       The Include / Exclude specification
       The Drive letter
       The Restore Overwrite warning option

   Before starting you may also desire to do a preview of the
   restore to see that every option is correctly stated.  This can
   be started from the Main Menu by selecting Preview Restore.

   Both Start Restore and Preview Restore may offer you an
   optional pick list of backup sets on a DOS media that allows
   multiple backup sets.  Selecting this backup set is performed
   in the exact same way selecting a configuration file for
   loading is performed.

   Sometime it becomes necessary to view the files in a backup set
   to see if they are the correct files.  A preview will tell you
   what files you are restoring but not any other details about
   the files.  View Backup Set provides the ability to obtain the
   following about the files in a backup set:

       Name
       Extension
       Path
       Date Created
       Time Created
       Size of the File


