/*
    File BGIALLOC.C     TAB 4

    (C)opyright
           Raimund Nisius
           Goethepark  13
           W-1000 Berlin 12
       April 1992
    Als rechtmiger Besitzer eines BGI-Treibers drfen sie
    diesen Quellcode benutzen und nach Ihrem Bedarf verndern.

	Dieses Modul ist fr HPGL.BGI, LASER.BGI und NADEL.BGI DESKJETC.BGI
	PJXL.BGI DXF.BGI nutzbar.
    ------------------------------------------------------------------
    Wenn Sie einen dieser Treiber nicht benutzen, dann knnen sie
    die entsprechende Zeile
    ##define ...
    in der Datei  "inventar.h" streichen.
    */

#include "inventar.h"

/*      Entfernen Sie diesen Kommentar , wenn
        Sie die Treiber einbinden wollen
#define PLOTTER_EINBINDEN
#define LASER_EINBINDEN
#define NADEL_EINBINDEN
#define DESKJET_EINBINDEN
#define PAINTJET_EINBINDEN

*/

/*
Diese Datei stellt dem Hauptprogramm die Variablen
                monitortreiber  , monitormode
                plottertreiber  , plottermode
                lasertreiber    , lasermode
                nadeltreiber    , nadelmode
				deskjettreiber  , deskjetmode
				paintjettreiber  , paintjetmode
			 zur Verfgung und intialisiert sie. Auer beim Monitor
             bedeutet "...mode" die Schnittstelle, an der das Gert
             angeschlossen ist. Wenn Sie im Hauptprgramm mit z.B.
             initgraph( plottertreiber, plottermode, '');
             auskommen, dann brauchen Sie nicht mehr weiterzulesen.


Diese Datei
            stellt den Treibern "HPGL.BGI","LASER.BGI","NADEL.BGI",
			"DESKJETC.BGI" einen Interruptvektor zur Verfgung.
            Dieser Vektor zeigt auf eine Datenstruktur vom Typ
            BGI_struct mit den Konfigurationen der einzelnen Treiber.
            Der Initialisierungsteil des Moduls installiert den Interrupt
            und sorgt dafr da er zum Programmschlu wieder entfernt
            wird.

            Welcher Interruptvektor das ist, wird zur Laufzeit bestimmt.
            Wenn das Strukturelement "reconfig" gleich Null ist, setzt
            der Treiber seine eigenen Defaultwerte ein.
            Die Bedeutung der Strukturelemente entnehmen Sie bitte der
            Datei "BGIALLOC.H".



Diese Datei
            stellt den Druckertreibern eine Funktion zur Speicher-
            allocation zur Verfgung.
            Der Speicher wird whrend der Ausfhrung von CloseGraph
            bzw. RestoreCrtMode von myalloc angefordert und mit
            myfree wieder freigegeben.


Diese Datei
	stellt den Druckertreibern eine Funktion zur Kontrolle
	der Datenausgabe zur Verfgung (BGIControl)
	Diese Funktion wird whrend der Datenbertragung oft mit einem
	Argument >= 0 aufgerufen. Bei Fehlern wird sie mit einem
	Argument  < 0 aufgerufen.
	Das Funktionsergebnis befiehlt dem Treiber, wie er arbeiten soll.
	Argument :
		  >= 0 : Nummer der Zeile die bertragen werden soll
		  -1   : Fehler beim Erffnen
		  -2   : Fehler beim bertragen (Busy oder Strung)
		  -3   : Anfrage ob die Bilderzeugung stattfinden soll
				   (Antwort 1 = Abbruch. Sonst gehts los)
	Rckgabe :
		  0 : Fortsetzung der bertragung (noch mal versuchen)
		  1 : Abrruch der bertragung
		  2 : Neustart der bertragung (nur wenn Status < 0)
	Wenn die Adresse dieser Funktion dem Treiber nicht bergeben
	wurde, bricht er bei Erffnungsfehler ab, sonst arbeitet er
	weiter.


	Hinweis
	falls Sie eine komplizierte dynamische Datenstruktur haben :
    AllocInit() mu den Druckertreibern zwei Funktionen und deren
    Datensegment bekanntmachen.
    Die erste Funktion mu wie myalloc deklariert sein. Sie mu ver-
    fgbaren, zusammenhngenden Speicherplatz (mglichst viel) schaf-
    fen und dem Treiber mitteilen. Die Anzahl der vollstndigen Para-
    graphen (16Byte) ist der Rckgabewert dieser Funktion. Die als
    Referenz bergebene Variable wird mit der Nummer des 1. voll-
    stndigen Paragraphen belegt.
    Die zweite Funktion mu wie myfree deklariert sein. Sie gibt den
    Speicher wieder frei.
    Sie knnen z.B. mit myalloc Ihren gesamten Heap auf Festplatte
    retten. Mit myfree restaurieren sie den Heap wieder. myalloc
    braucht dann nur die Lnge und Position des geretteten Heap anzu-
	geben. Vorteil : Sie mssen den genauen Aufbau ihrer dynamischen
    Daten zum Zeitpunkt von closegraph nicht kennen.
*/

#ifdef  __TINY__
#error bersetzen Mit Speichermodell {Compact,Large, Huge}!
#endif
#ifdef  __SMALL__
#error bersetzen Mit Speichermodell {Compact,Large, Huge}!
#endif
#ifdef  __MEDIUM__
#error bersetzen Mit Speichermodell {Compact,Large, Huge}!
#endif

#include <graphics.h>
#include <alloc.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#define  BGIALLOC_FILE      /* fuer BGIALLOC.H */
#include "BGIALLOC.H"

void AllocInit(void);   /* wird automatisch bei Programmstart aufgerufen */
void get_schnittstelle(int *mode, char *geraet, char *defaultdatei);
                        /* wird von AllocInit benutzt (erfragt interaktiv) */
                        /* die Schnittstelle des Gertes ab. */
void allocexit(void);   /* wird zum Programmschlu automatisch aufgerufen */

typedef unsigned int  word;

#ifdef ANY_DRUCKER
    void far *memptr;           /* Zeiger auf den allozierten Bereich */
#endif
int benutzte_Vektornummer;      /* Interruptvektor vor initialisierung */
void interrupt(*AltIntVektor)();            /* des Moduls */


/* deklarieren der Treiber zum Linken */
/* mu nicht sein */
#ifdef HPGLPLOTTER
   #ifdef PLOTTER_EINBINDEN
    void           _Cdecl HPGL_driver(void);
    extern int far _Cdecl HPGL_driver_far[];
   #endif
#endif

#ifdef LASERDRUCKER
   #ifdef LASER_EINBINDEN
    void           _Cdecl LASER_driver(void);
    extern int far _Cdecl LASER_driver_far[];
   #endif
#endif

#ifdef NADELDRUCKER
    #ifdef NADEL_EINBINDEN
    void           _Cdecl NADEL_driver(void);
    extern int far _Cdecl NADEL_driver_far[];
    #endif
#endif

#ifdef DESKJETDRUCKER
	#ifdef DESKJET_EINBINDEN
	void           _Cdecl DESKJETC_driver(void);
	extern int far _Cdecl DESKJETC_driver_far[];
	#endif
#endif

#ifdef PAINTJETDRUCKER
	#ifdef PAINTJET_EINBINDEN
	void           _Cdecl PAINTJET_driver(void);
	extern int far _Cdecl PAINTJET_driver_far[];
	#endif
#endif

#ifdef DXFPLOTTER
   #ifdef PLOTTER_EINBINDEN
    void           _Cdecl HPGL_driver(void);
    extern int far _Cdecl HPGL_driver_far[];
   #endif
#endif
#ifdef ANY_DRUCKER

unsigned int far pascal myalloc(word far *start)
                                    /* Rckgabe : Gre in Paragraphen */
                                    /* (soviel, wie mglich)           */
                                    /* start ist der 1. Paragraph      */
{
unsigned long   laenge,         /* gewnschte Blocklnge beim ausprobieren*/
                mindestens = 0L,/* Untergrenze der Blocklnge im Heap */
                hoechstens = farcoreleft(); /* Obergrenze der Blocklnge*/
/* Groesse des grten freien Blocks Heap wird mit Mittelpunktverfahren */
/* ermittelt */
laenge = hoechstens;                /* vieleicht klappts ja sofort. */
while ( (hoechstens - mindestens) > 63)
    {
    memptr = farmalloc(laenge);
    if (memptr == NULL)         /* Block dieser Laenge nicht vorhanden */
        hoechstens = laenge;    /* Obergrenze setzen */
    else
        {                       /* Block dieser Laenge vorhanden */
        mindestens = laenge;    /* Untergrenze setzen */
        farfree(memptr);        /* und wieder freigeben zum Weitersuchen. */
        }
    laenge = (mindestens + hoechstens) / 2L;    /* Neue Mitte zwischen den*/
    }                                           /* Grenzen berechnen. */
memptr = farmalloc(mindestens);     /* Speicher endgueltig reservieren */
*start  = FP_SEG(memptr);           /* Startparagraph fuer den Treiber */
*start += (FP_OFF(memptr)+15)/16;   /* Normieren und evtentuell runden */
return (word) (mindestens / 16)-2;  /* Groesse in Paragraphen (der 1.  */
                                    /* und der letzte Paragraph knnten*/
                                    /* unvollstndig sein)             */
}

void far pascal myfree()    /* gibt den Speicher wieder frei */
                            /* mu auch aufgerufen werden koennen, wenn */
                            /* myalloc nicht erfolgreich war ! */
{
if (memptr != NULL)
	farfree(memptr);        /* Speicher wieder freigegeben   */
}


unsigned int far pascal BGIControl(int Status)
/* wird vom LASER.BGI-Treiber whrend der Ausgabe oft aufgerufen */
/* Argument   : Status */
	  /* >= 0 : Nummer der Zeile die bertragen werden soll */
	  /* -1   : Fehler beim Erffnen */
	  /* -2   : Fehler beim bertragen (Busy oder Strung) */
	  /* -3   : Anfrage ob die Bilderzeugung stattfinden soll */
	  /* 		   (Antwort 1 = Abbruch. Sonst gehts los)
/* Rckgabe : */
	  /* 0 : Fortsetzung der bertragung */
	  /* 1 : Abrruch der bertragung */
	  /* 2 : Neustart der bertragung (nur wenn Status < 0) */
{
char c;

if (Status >= 0)                /* kein Fehler : Status = Zeilennummer */
   {
   printf("\r%4d",Status);      /* den Anwender unterhalten */
   if (kbhit())                 /* und beachten */
	  {
	  printf("Ausgabe in vollem Gange\n\r");
	  printf("Was ist zu tun ?\n\r");
	  printf(" 0 : Weitermachen\n\r");
	  printf(" 1 : Aufhren\n\r");
	  while (kbhit())
		c = getch();                        /* Puffer leeren */
	  do
		c = getch();                        /* Entscheidung abholen */
	  while ((c != '0') && (c != '1')) ;
	  return (unsigned) c - '0';            /* Entscheidung auswerten */
	  }
   else                                     /* keine Intervention : */
	  return 0;                             /* weitermachen */
   }
if (Status == -1)                           /* Fehler beim ffnen */
   {
   printf("Ausgabe nicht bereit (Disk voll, Printer Offline, ...) !\n\r");
   printf("Was ist zu tun ?\n\r");
   printf(" 0 : Drucker ist eingeschaltet, nochmal versuchen \n\r");
   printf(" 1 : Aufhren\n\r");
   while (kbhit())
	 c = getch();                       /* Puffer leeren */
   do
	 c = getch();                       /* Entscheidung abholen */
   while ((c != '0') && (c != '1')) ;
	return (unsigned) c - '0';          /* Entscheidung auswerten */
   }
if (Status == -3)                       /* Soll Graphik erzeugt werden */
   {
	return 0;          					/* ja !   */
/* 	return 1;          					/* nein   */
   }
										/* Rest : Status < -1 */
gotoxy(6,wherey());
printf("Printer BUSY");                 /* melden */
printf("Ausgabe gestrt oder Drucker beschftigt !\n\r");
printf("Was ist zu tun ?\n\r");
printf(" 0 : Drucker ist beschftigt, weiter versuchen\n\r");
printf(" 1 : Aufhren\n\r");
printf(" 2 : Daten noch mal von vorn bertragen\n\r");
while (kbhit())
  c = getch();                      /* Puffer leeren */
do
  c = getch();                      /* Entscheidung abholen */
while ((c < '0') && (c > '2')) ;
return c - '0';                     /* Entscheidung auswerten */
}

#endif /* ANY_DRUCKER */

const
#ifdef HPGLPLOTTER
	hpgl_struct HP7475_A3 = {
		1,          /* reconfig1: Treiber benutzt diese Werte   */
		7,          /* Stifte im Karussel +  "kein stift" */
		381,        /* Defaultspeed [mm/s] */
		{   {
			100,100,100,100,100,100,100,100, /* speed der Farbstifte */
			100,100,100,100,100,100,100,100, /* in % */
			100,100,100,100,100,100,100,100, /*  100 = default */
			100,100,100,100,100,100,100,100
			}
		},
				/* dicke der Stifte [Plottereinheiten],  12 = 0.3mm  */
		{   {
			12,12,12,12,12,12,12,12,
			12,12,12,12,12,12,12,12,
			12,12,12,12,12,12,12,12,
			12,12,12,12,12,12,12,12
			}
		},
		3,          /* strichweite der gestrichelten Linien */
					/* pro Pattern-Bit in Stiftdicken */
		{16158, /* Ausdehnung in Pixeln                 */
		11040},
		0,      /* filehandle wird vom Treiber gesetzt. */
				/* Fr Plotterbefehle mittels INT $40} */
		0,      /* kein rotate : Landscape          */
		0,      /* Plotter kann und soll Papier auswerfen  : nein */
		0,      /* lastschnitt fr Schnittstellle = 9   */
		'\x0f', /* Stringlnge im Pascalstil */
		"\x1b(;IN;SC;PU0,0;", /* initstr : Plotter Reset, kein Stift */
		0,      /* exitlength  */
		""      /*Exitstring : leer */
	   };

	hpgl_struct HP7475_A4 = {
		1,          /* reconfig1: Treiber benutzt diese Werte   */
		7,          /* Stifte im Karussel +  "kein stift" */
		381,        /* Defaultspeed [mm/s] */
		{   {
			100,100,100,100,100,100,100,100, /* speed der Farbstifte */
			100,100,100,100,100,100,100,100, /* in % */
			100,100,100,100,100,100,100,100, /*  100 = default */
			100,100,100,100,100,100,100,100
			}
		},
				/* dicke der Stifte [Plottereinheiten],  12 = 0.3mm  */
		{   {
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12
            }
        },
        3,          /* strichweite der gestrichelten Linien */
                    /* pro Pattern-Bit in Stiftdicken */
        {11040, /* Ausdehnung in Pixeln                 */
        7721},
        0,      /* filehandle wird vom Treiber gesetzt. */
                /* Fr Plotterbefehle mittels INT $40} */
        0,      /* kein rotate : Landscape          */
        0,      /* Plotter kann und soll Papier auswerfen  : nein */
        0,      /* lastschnitt fr Schnittstellle = 9   */
        '\x0f', /* Stringlnge im Pascalstil */
        "\x1b(;IN;SC;PU0,0;", /* initstr : Plotter Reset, kein Stift */
        0,      /* exitlength  */
        ""      /*Exitstring : leer */
       };

	hpgl_struct HPLaserjet_A4 = {
        1,          /* reconfig1: Treiber benutzt diese Werte   */
        7,          /* Stifte im Karussel +  "kein stift" */
        381,        /* Defaultspeed [mm/s] */
        {   {
            100,100,100,100,100,100,100,100, /* speed der Farbstifte */
            100,100,100,100,100,100,100,100, /* in % */
            100,100,100,100,100,100,100,100, /*  100 = default */
            100,100,100,100,100,100,100,100
            }
        },
                /* dicke der Stifte [Plottereinheiten],  12 = 0.3mm  */
        {   {
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12
            }
        },
        3,          /* strichweite der gestrichelten Linien */
                    /* pro Pattern-Bit in Stiftdicken */
        {7721,  /* Ausdehnung in Pixeln                 */
        11040},
        0,      /* filehandle wird vom Treiber gesetzt. */
                /* Fr Plotterbefehle mittels INT $40} */
        0,      /* kein rotate : Landscape          */
        0,      /* Plotter kann und soll Papier auswerfen  : nein */
        0,      /* lastschnitt fr Schnittstellle = 9   */
        19, /* Stringlnge im Pascalstil */
        "\x1b%0B\x1b(;IN;SC;PU0,0;", /* initstr : Plotter Reset, kein Stift */
        5,      /* exitlength  */
        "\x1b%0A\f" /*Exitstring : PCL Modus wieder an, Formfeed */
       };

	hpgl_struct HP7550_A3 = {
        1,          /* reconfig1: Treiber benutzt diese Werte   */
        9,          /* Stifte im Karussel +  "kein stift" */
        381,        /* Defaultspeed [mm/s] */
        {   {
            100,100,100,100,100,100,100,100, /* speed der Farbstifte */
            100,100,100,100,100,100,100,100, /* in % */
            100,100,100,100,100,100,100,100, /*  100 = default */
            100,100,100,100,100,100,100,100
            }
        },
                /* dicke der Stifte [Plottereinheiten],  12 = 0.3mm  */
        {   {
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12
            }
        },
        3,          /* strichweite der gestrichelten Linien */
                    /* pro Pattern-Bit in Stiftdicken */
        {15970, /* Ausdehnung in Pixeln                 */
        10870},
        0,      /* filehandle wird vom Treiber gesetzt. */
                /* Fr Plotterbefehle mittels INT $40} */
        0,      /* kein rotate : Landscape          */
        1,      /* Plotter kann und soll Papier auswerfen  : ja */
        0,      /* lastschnitt fr Schnittstellle = 9   */
        '\x0f', /* Stringlnge im Pascalstil */
        "\x1b(;IN;SC;PU0,0;", /* initstr : Plotter Reset, kein Stift */
        0,      /* exitlength  */
        "" /*Exitstring : leer */
       };

	hpgl_struct HP7550_A4 = {
        1,          /* reconfig1: Treiber benutzt diese Werte   */
        9,          /* Stifte im Karussel +  "kein stift" */
        381,        /* Defaultspeed [mm/s] */
        {   {
            100,100,100,100,100,100,100,100, /* speed der Farbstifte */
            100,100,100,100,100,100,100,100, /* in % */
            100,100,100,100,100,100,100,100, /*  100 = default */
            100,100,100,100,100,100,100,100
            }
        },
                /* dicke der Stifte [Plottereinheiten],  12 = 0.3mm  */
        {   {
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12,
            12,12,12,12,12,12,12,12
            }
        },
        3,          /* strichweite der gestrichelten Linien */
                    /* pro Pattern-Bit in Stiftdicken */
        {10870, /* Ausdehnung in Pixeln                 */
        7600},
        0,      /* filehandle wird vom Treiber gesetzt. */
                /* Fr Plotterbefehle mittels INT $40} */
        0,      /* kein rotate : Landscape          */
        1,      /* Plotter kann und soll Papier auswerfen  : ja */
        0,      /* lastschnitt fr Schnittstellle = 9   */
        '\x0f', /* Stringlnge im Pascalstil */
        "\x1b(;IN;SC;PU0,0;", /* initstr : Plotter Reset, kein Stift */
        0,      /* exitlength  */
        ""      /*Exitstring : leer */
       };
#endif

#ifdef DXFPLOTTER
	DXF_struct DXFdefault = {
		1,          /* reconfig1: Treiber benutzt diese Werte   */
		7,          /* Stifte "kein stift" */
			{  /* Stiftdicke in units der resolution*/
				{
				3,3,3,3,3,3,3,3,
				3,3,3,3,3,3,3,3,
				3,3,3,3,3,3,3,3,
				3,3,3,3,3,3,3,3
				}
			},
		3,          /* strichweite der gestrichelten Linien */
					/* pro Pattern-Bit in Stiftdicken */
		{2100, /* Ausdehnung in Pixeln                 */
		2900},
		-1,			/* resolution der Koordinaten = 1/10 mm */
		90,			/* Winkel fr SetTextStyle( x,VertDir, y)  normal */
		3,			/* Pascal Stringlnge */
		"txt"		/* Standard text stil */
	   };

#endif

#ifdef LASERDRUCKER
#define AUFLOESUNG 1    /*Druckerpixel/logischem Punkt    Bereich: 1..4  */
laser_struct laserkonfig = {
			1,        /* reconfig1: Treiber liest Werte aus Struct     */
			2,        /* Stiftzahl des Druckers (0..n-1).     */
            {  /* Stiftdicke in Dots Druckereinheiten, 12 = 1mm bei 300 dpi */
                {
                3,3,3,3,3,3,3,3,
                3,3,3,3,3,3,3,3,
                3,3,3,3,3,3,3,3,
                3,3,3,3,3,3,3,3
                }
            },
            6,      /* strichweite der gestrichelten Linien pro Pattern-Bit                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             */
        {2335 / AUFLOESUNG,     /* Ausdehnung in Pixeln bei Portrait */
        3300  / AUFLOESUNG
        },
        0,      /* rotate : Portrait */
        1,      /* (J/N) Seite ausdrucken : ja */
        AUFLOESUNG, /* resolution 1,2,3 oder 4 Pixel / Punkt */
        0,          /* Komprimiermethode 2 ab Laserjet III */
		0,          /* lastschnitt fr Schnittstellle = 9   */
        0,          /* 1 : File wird nicht berschrieben */
        '\x0A',     /* Stringlnge im Pascalstil */
        "\x1b*p0X\x1b*p0Y"  /* initstr Cursor nach Links oben */
       };
#endif

#ifdef NADELDRUCKER
nadel_struct nadelkonfig = {
        1,        /* reconfig1: Treiber liest Werte aus Struct     */
        2,        /* Stiftzahl des Druckers (0..n-1).     */
        {  /* Stiftdicke in Dots Druckereinheiten, 12 = 1mm bei 300 dpi */
            {
			1,1,1,1,1,1,1,1,
			1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1
            }
        },
        6,      /* strichweite der gestrichelten Linien pro Pattern-Bit                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 */
        {0,0},      /* Ausdehnung in Pixeln bei Portrait */
                    /* Nadel nimmt eigene Werte */
        0,          /* rotate : Portrait */
        1,          /* (J/N) Seite ausdrucken : ja */
        EPS_60,     /* printermode EPS_240 .. EPS_360_360   */
        7,          /* defaultbackground wei (nur im Colormodus  0..8) */
        6,          /* 0: CR 1: LF 2: CR/LF  +4 fr Zeilenende immer */
        0,          /* lastschnitt fr Schnittstellle = 9   */
        0,          /* 1 : File wird nicht berschrieben */
        '\x0',      /* Stringlnge im Pascalstil */
        ""          /* keine initialisierung */
    };
#endif

#ifdef DESKJETDRUCKER
#define DJ_AUFLOESUNG 1 /*Druckerpixel/logischem Punkt    Bereich: 1..4  */
deskjet_struct deskjetkonfig = {
        1,        /* reconfig1: Treiber liest Werte aus Struct     */
		16,        /* Stiftzahl des Druckers (0..n-1).     */
        {  /* Stiftdicke in Dots Druckereinheiten, 12 = 1mm bei 300 dpi */
            {
            3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3
            }
        },
        6,      /* strichweite der gestrichelten Linien pro Pattern-Bit                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 */
        {2400 / DJ_AUFLOESUNG,      /* Ausdehnung in Pixeln bei Portrait */
        3100  / DJ_AUFLOESUNG       /* 3150 im Monomodus mglich */
		},
		0,      /* rotate : Portrait */
		1,      /* (J/N) Blatt auswerfen : ja */
		DJ_AUFLOESUNG,  /* resolution 1,2,3 oder 4 Pixel / Punkt */
		128,        /* printermode 0 : Monochrom, 128 : color */
		7,          /* defaultbackground wei (klappt nicht) */
		0,          /* lastschnitt fr Schnittstellle = 9   */
		0,          /* 1 : File wird nicht berschrieben */
		2,          /* quality 0: Keypad Einstellung 1: Draft 2: High */
		0,          /* Ausdnnung 0: keine 1: normal, 2 stark */
		4           /* Mehrphasendruck 0: nein 1: 2 Phasen 2: 4 Phasen */
                '\x0',      /* Stringlnge im Pascalstil */
                ""          /* keine initialisierung */
	   };
#endif


#ifdef PAINTJETDRUCKER
#define PJ_AUFLOESUNG 1 /*Druckerpixel/logischem Punkt    Bereich: 1..2  */
paintjet_struct paintjetkonfig = {
		1,        /* reconfig1: Treiber liest Werte aus Struct     */
		16,        /* Stiftzahl des Druckers (0..n-1).     */
		{  /* Stiftdicke in Dots Druckereinheiten, 12 = 1mm bei 300 dpi */
			{
			3,3,3,3,3,3,3,3,
			3,3,3,3,3,3,3,3,
			3,3,3,3,3,3,3,3,
			3,3,3,3,3,3,3,3
			}
		},
		6,      /* strichweite der gestrichelten Linien pro Pattern-Bit                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 */
		{1440 / PJ_AUFLOESUNG,      /* Ausdehnung in Pixeln bei Portrait */
		2055  / PJ_AUFLOESUNG       /* */
									/* Format        x     y    */
									/* US Letter/A   1472  1931 */
									/* US Ledger/B   1920  2990 */
									/* A4            1440  2055 */
									/* A3            1984  2906 */
		},
		0,      /* rotate : Portrait */
		1,      /* (J/N) Blatt auswerfen : ja */
		PJ_AUFLOESUNG,  /* resolution 1 oder 2 Pixel / Punkt */
		128,        /* printermode 0 : Monochrom, 128 : color */
		7,          /* defaultbackground wei (klappt nicht) */
		0,          /* lastschnitt fr Schnittstellle = 9   */
		0,          /* 1 : File wird nicht berschrieben */
		0           /* Mehrphasendruck 0: nein 1: ja */
	   };
#endif



void get_schnittstelle(int *mode, char *geraet, char *defaultdatei)
{
char c;

printf("Whlen Sie die Schnittstelle fr den %s : \n",geraet);
printf("  0  Standarddatei %s im Aktuellen Verzeichnis\n",defaultdatei);
printf("  1  COM1:\n");
printf("  2  COM2:\n");
printf("  3  COM3:\n");
printf("  4  COM4:\n");
printf("  5  LPT1:\n");
printf("  6  LPT2:\n");
printf("  7  LPT3:\n");
printf("  8  Datei mit frei whlbarem Namen\n\n");
printf("Drcken Sie eine Taste aus 0..8\n");
*mode = -1;
do
 {
 c = getch();
 if (c <= '8')
    *mode = (int) (c -'0');
 }while (*mode < 0);
printf("\n");
}





#ifndef __BORLANDC__
#error wenn Sie Turbo C 2.0 Benutzen, gilt :  #define graph_fehler 5
#error fr die C++ Compiler           gilt :  #define graph_fehler 0
#endif

#define graph_fehler 0


int myfill[16] = {
                                 0x8000,
                                 0x4000,
                                 0x2000,
                                 0x1000,
                                 0x0800,
                                 0x0400,
                                 0x0200,
								 0x0100,
                                 0x0080,
                                 0x0040,
                                 0x0080,
                                 0x0100,
                                 0x0200,
                                 0x0400,
                                 0x0800,
                                 0xF000
              };



void allocexit(void)
{
setvect(benutzte_Vektornummer,AltIntVektor);  /* alten Vektor restaurieren */
}





void AllocInit()
{
allgemein_struct *allgemein;


detectgraph((int far *)&monitortreiber,(int far *)&monitormode);

/* Freien Interruptvektor suchen  */
benutzte_Vektornummer  = 0x60;    /* Der erste mglicherweise freie Vektor*/
								/* das Prinzip arbeitet sogar mit INT21 */
AltIntVektor = getvect(benutzte_Vektornummer);

Umleitung.jumpbefehl[0] = 0xEA;		/* jump absolute */
memcpy(&Umleitung.jumpbefehl[1],&AltIntVektor, sizeof (void far *));
Umleitung.data = &Treiber_konfiguration;

setvect(benutzte_Vektornummer,
	(void interrupt (*)( ))&Umleitung);
								/* den eigenen Interrupt installieren */
								/* ist aber nur Datenstruktur */
								/* die aber aufgerufen werden darf */

atexit(allocexit);          /* sorgt fuer Restaurierung des */
						/* Interrupts zum Programmschlu */

#ifdef ANY_DRUCKER
allgemein = &(Treiber_konfiguration.umgebung);
/*
Wenn die Funktionen BGIControl, myalloc, und myfree
in einem anderen Modul definiert sind, dann
mssen Sie auch das jeweilige Datensegment von dort holen !
*/
	 allgemein->control       = BGIControl;
	 allgemein->control_ds    = _DS;
	 allgemein->alloc         = myalloc;
     allgemein->mfree         = myfree;
     allgemein->free_ds       = _DS;
/*
 ohne diese Zeile arbeitet setfillpattern normal
  Treiber_konfiguration.userfill      = (int far *)&myfill;
*/
#endif

#ifdef HPGLPLOTTER
 Treiber_konfiguration.plotter = &HP7475_A4;
 plottertreiber = graph_fehler + installuserdriver ("HPGL",NULL);
 #ifdef PLOTTER_EINBINDEN
	if (registerbgidriver(HPGL_driver) < 0)
		{
		printf("RegisterBGIDriver von HPGL ist fehlgeschlagen");
		exit(1);
		}
 #endif
 get_schnittstelle(&plottermode,"Plotter","HPGL.PLT");
#endif

#ifdef DXFPLOTTER
 Treiber_konfiguration.dxf = &DXFdefault;
 dxftreiber = graph_fehler + installuserdriver ("dxf",NULL);
 #ifdef dxf_EINBINDEN
	if (registerbgidriver(dxf_driver) < 0)
		{
		printf("RegisterBGIDriver von dxf ist fehlgeschlagen");
		exit(1);
		}
 #endif
 get_schnittstelle(&dxfmode,"dxf","BGI.DXF");
#endif

#ifdef LASERDRUCKER
 Treiber_konfiguration.laserjet     = &laserkonfig;
 lasertreiber = graph_fehler + installuserdriver ("LASER",NULL);
 #ifdef LASER_EINBINDEN
	if (registerbgidriver(LASER_driver) < 0 )
		{
		printf("RegisterBGIDriver von LASER ist fehlgeschlagen");
		exit(1);
		}
 #endif
 get_schnittstelle(&lasermode,"Laserdrucker","LASER.PRN");
#endif

#ifdef NADELDRUCKER
 Treiber_konfiguration.nadeldrucker = &nadelkonfig;
 nadeltreiber = graph_fehler + installuserdriver ("NADEL",NULL);
 #ifdef NADEL_EINBINDEN
	if (registerbgidriver(NADEL_driver) < 0)
		{
		printf("RegisterBGIDriver von NADEL ist fehlgeschlagen");
		exit(1);
		}
 #endif
 get_schnittstelle(&nadelmode,"Nadeldrucker","NADEL.PRN");
#endif

#ifdef DESKJETDRUCKER
 Treiber_konfiguration.deskjet_c     = &deskjetkonfig;
 deskjettreiber = graph_fehler + installuserdriver ("DESKJETC",NULL);
 #ifdef DESKJET_EINBINDEN
	if (registerbgidriver(DESKJETC_driver) < 0 )
		{
		printf("RegisterBGIDriver von DESKJET C ist fehlgeschlagen");
		exit(1);
		}
 #endif
 get_schnittstelle(&deskjetmode,"DeskJet 500 C","DESKJETC.PRN");
#endif

#ifdef PAINTJETDRUCKER
 Treiber_konfiguration.paintjet     = &paintjetkonfig;
 paintjettreiber = graph_fehler + installuserdriver ("PJXL",NULL);
 #ifdef PAINTJET_EINBINDEN
	if (registerbgidriver(PAINTJET_driver) < 0 )
		{
		printf("RegisterBGIDriver von PAINTJET XL ist fehlgeschlagen");
		exit(1);
		}
 #endif
 get_schnittstelle(&paintjetmode,"PaintJet XL","PAINTJET.PRN");
#endif

}

#pragma startup AllocInit
