/* File BGIALLOC.H     TAB 4 */
/* 1.*/
/* 2.*/
/* (C)opyright              */
/*      Raimund Nisius      */
/*      Goethepark  13      */
/*      W-1000 Berlin 12    */
/* Als rechtmiger Besitzer des LASER.BGI-Treibers drfen sie  */
/* diesen Quellcode benutzen und nach Ihrem Bedarf verndern.   */


/* Daten, die fr das Hauptprogramm bestimmt sind, werden beim bersetzen */
/* des Moduls BGIALLOC hier definiert, sonst als extern deklariert */

#ifdef BGIALLOC_FILE
  #define intex
#else
  #define intex extern
#endif

intex int monitortreiber,   /* Defaulttreiber wird nach installuserdriver */
          monitormode;      /* nicht mehr gefunden */

#ifdef HPGLPLOTTER
intex int plottermode,
          plottertreiber;   /* Treibernummer fr initgraph */
#endif

#ifdef LASERDRUCKER
intex int lasermode,
          lasertreiber;     /* Treibernummer fr initgraph */
#endif

#ifdef NADELDRUCKER
intex int nadelmode,
		  nadeltreiber;     /* Treibernummer fr initgraph */
#endif


#ifdef DESKJETDRUCKER
intex int deskjetmode,
		  deskjettreiber;       /* Treibernummer fr initgraph */
#endif

#ifdef PAINTJETDRUCKER
intex int paintjetmode,
		  paintjettreiber;       /* Treibernummer fr initgraph */
#endif

#ifdef DXFPLOTTER
intex int dxfmode,
		  dxftreiber;   /* Treibernummer fr initgraph */
#endif


typedef struct{   /* Max 32 Stifte / Karussel */
  int color[32];
  } stiftarr;

typedef unsigned int far pascal (*allocfunc)(unsigned far *);   /* pointertyp fuer allocmem */
typedef void far pascal (*freefunc)(void );                     /* pointertyp fuer freemem  */
typedef unsigned int far pascal (*contrfunc)(int);              /* pointertyp fuer Kontrollfunktion */
/* Argument : int Status */
					/* >= 0 : Nummer der Zeile, die bertragen werden soll */
					/* -1   : Fehler beim erffnen */
					/* -2   : Fehler beim bertragen (Busy oder Strung) */

/* Rckgabe : */
					/* 0 : Fortsetzung der bertragung */
					/* 1 : Abrruch der bertragung */
					/* 2 : Neustart der bertragung (nur wenn Status < 0) */

#define OEFFNEFEHLER    -1
#define SCHREIBFEHLER   -2
#define WEITER          0
#define ABBRUCH         1
#define VONVORN         2


typedef struct  {
  int  x ;
  int  y ;
}pointtype;



typedef struct { /* Anordnung ist resistent gegen Word-Alignment Option */
/* Folgende Elemente haben Bedeutung fr alle Treiber */
	char        errormessages;  /* (on/off)                         */
	char        warnings;       /* (on/off)                         */
	char        namelength;     /* Pascal String Start              */
	char        dateiname[79];  /* fr Mode 8                       */
/* Folgende Elemente haben Bedeutung fr die Druckertreiber */
	contrfunc   control;        /* Steuerung der Datenbertragung   */
	int         control_ds;     /* Datensegment von control         */
	allocfunc   alloc;          /* allocmem im Hauptprogramm        */
	freefunc    mfree;          /* freemem im Hauptprogramm         */
	int         free_ds;        /* Datensegment im Hauptprogramm    */
	int			SelectorInc;	/* von Segment zu Segment			*/
	char        tmplength;      /* Pascal String Start              */
	char        tmp_path[79];   /* kompletter Pfad fr temporre    */
								/* Datei: Laufwerk am Anfang und    */
								/* '\\' am Ende, oder "" z.B. "D:\" */
  } allgemein_struct;

typedef struct { /* Anordnung ist resistent gegen Word-Alignment Option    */
 int        reconfig;       /* 0: Treiber setzt hier Defaultwerte   */
							/* 1: Treiber liest Werte aus Struct    */
 int            stiftzahl;      /*  Stiftzahl im Karussel  (0..n-1).       */
 int            speedmax;       /* Defaultspeed [mm/s]                     */
 stiftarr   speed;          /* der Farbstifte  0 : default          */
 stiftarr   dicke;          /* in Dots                              */
 int            strichweite;    /* der gestrichelten Linien pro Pattern-Bit                                   */
 pointtype  size;           /* Ausdehnung in Pixeln                 */
 int         filehandle;        /* Zu int erweitern !       */
 char       rotate;         /* Landscape ?              */
 char       formfeed;       /* (J/N) Seite ausdrucken ? */
 char       lastschnitt;    /* fr Schnittstellle = 9   */
 char       initlength;     /* Pascal String Start      */
 char       initstr[50];    /* Spezielle Einstellungen  */
							/* des Benutzers (z.B. Emulation) */
 char       exitlength;     /* Pascal String Start      */
 char       exitstr[50];    /* Spezielle Einstellungen  */
							/* des Benutzers (z.B. Emulation aus) */
  } hpgl_struct;



typedef struct { /* Anordnung ist resistent gegen Word-Alignment Option */
 int            reconfig;       /* 0: Treiber setzt Defaults im Struct     */
                            /* 1: Treiber liest Werte aus Struct    */
 int            stiftzahl;      /*  Stiftzahl im Karussel  (0..n-1).       */


 stiftarr   dicke;          /* in Dots  */
 int            strichweite;    /* der gestrichelten Linien pro Pattern-Bit                                   */
 pointtype  size;           /* Ausdehnung in Pixeln                        */

 char       rotate;         /* Landscape ?              */
 char       formfeed;       /* (J/N) Seite ausdrucken ? */
 char       resolution;     /* 1,2,3 oder 4 Pixel / Punkt */
 char       compress;       /* 0 : aus,   != 0 :  an        */
 char       lastschnitt;    /* fr Schnittstellle = 9   */
 char       file_append;    /* != 0 : File wird nicht berschrieben */
 char       initlength;     /* Pascal String Start      */
 char       initstr[51];    /* Spezielle Einstellungen  */
  } laser_struct;               /* des Benutzers (z.B. Emulation) */

typedef struct { /* Anordnung ist resistent gegen Word-Alignment Option */
 int        reconfig;       /* 0: Treiber setzt Defaults im Struct  */
							/* 1: Treiber liest Werte aus Struct    */
 int            stiftzahl;      /*  Stiftzahl im Karussel  (0..n-1).       */


 stiftarr   dicke;          /* in Dots  */
 int            strichweite;    /* der gestrichelten Linien pro Pattern-Bit                                   */
 pointtype  size;           /* wird vom Treiber gesetzt */

 char       rotate;         /* Landscape ?              */
 char       formfeed;       /* (J/N) Seite ausdrucken ? */
 char       printermode;    /* EPS_240 .. NEC_360_360   */
 char       defaultbackground;  /* nur im Colormodus  0..8 */
 char       endezeichen;    /* 0: CR 1: LF 2: CR/LF  +4 fr zeilenende immer */
 char       lastschnitt;    /* fr Schnittstellle = 9   */
 char       file_append;    /* != 0 : File wird nicht berschrieben */
 char       initlength;     /* Pascal String Start      */
 char       initstr[51];    /* Spezielle Einstellungen  */
							/* des Benutzers (z.B. Emulation) */
  } nadel_struct;

typedef struct { /* Anordnung ist resistent gegen Word-Alignment Option */
 int        reconfig;       /* 0: Treiber setzt Defaults im Struct  */
							/* 1: Treiber liest Werte aus Struct    */
 int            stiftzahl;      /*  Stiftzahl im Karussel  (0..n-1).*/


 stiftarr   dicke;          /* in Dots */
 int            strichweite;    /* der gestrichelten Linien pro Pattern-Bit */
 pointtype  size;           /* */

 char       rotate;         /* Landscape ?              */
 char       formfeed;       /* (J/N) Seite ausdrucken ? */
 char       resolution;     /* 1,2,3 oder 4 Pixel / Punkt */
 char       printermode;    /* 0 fr Mono, 128 fr Color */
 char       defaultbackground;  /* nur im Colormodus  0..8 */
 char       lastschnitt;    /* fr Schnittstellle = 9   */
 char       file_append;    /* != 0 : File wird nicht berschrieben */
 char       quality;        /* 0: Keypad Einstellung 1: Draft 2: High */
 char       depletion;      /* Ausdnnung 0: keine 1: normal, 2 stark */
							/* spart Tinte, Papier wellt nicht so */
 char       shingling;      /* Mehrphasendruck 0: nein 1: 2 Phasen 2: 4 Phasen */
							/* Farbe verluft nicht  */
 char       initlength;     /* Pascal String Start      */
 char       initstr[51];    /* Spezielle Einstellungen  */
  } deskjet_struct;



typedef struct { /* Anordnung ist resistent gegen Word-Alignment Option */
 int        reconfig;       /* 0: Treiber setzt Defaults im Struct  */
							/* 1: Treiber liest Werte aus Struct    */
 int            stiftzahl;      /*  Stiftzahl im Karussel  (0..n-1). */


 stiftarr   dicke;          /* in Dots  */
 int        strichweite;    /* der gestrichelten Linien pro Pattern-Bit */
 pointtype  size;           /* */
								/* Format        x     y    */
								/* US Letter/A   1472  1931 */
								/* US Ledger/B   1920  2990 */
								/* A4            1440  2055 */
								/* A3            1984  2906 */

 char       rotate;         /* Landscape ?              */
 char       formfeed;       /* (J/N) Seite ausdrucken ? */
 char       resolution;     /* 1 oder 2 Pixel / Punkt */
 char       printermode;    /* 0 fr Mono, 128 fr Color */
 char       defaultbackground;  /* nur im Colormodus  0..8 */
 char       lastschnitt;    /* fr Schnittstellle = 9   */
 char       file_append;    /* != 0 : File wird nicht berschrieben */
 char       shingling;      /* Mehrphasendruck 0: nein 1: 2 Phasen 2: 4 Phasen */
							/* Farbe verluft nicht  */
 char       initlength;     /* Pascal String Start      */
 char       initstr[51];    /* Spezielle Einstellungen  */
  } paintjet_struct;





typedef struct { /* Anordnung ist resistent gegen Word-Alignment Option */
 int        reconfig;       /* 0: Treiber setzt Defaults im Struct  */
							/* 1: Treiber liest Werte aus Struct    */
 int        stiftzahl;      /* max 127 in autosketch */
 stiftarr   dicke;          /* in units der resolution */
 int		strichweite;    /* der gestrichelten Linien pro Pattern-Bit */
 pointtype	size;           /* Ausdehnung in mm * 10 hoch resolution */
 int 		resolution;     /* Zehnerpotenz der kordinaten 0 = mm; -3 = m */
 int		textwinkel;		/* Winkel bei nicht waagerecht */
 char       stylelength;	/* Pascal String Start      */
 char       textstyle[51];	/* Font Name default : txt */

  } DXF_struct;



typedef struct {		/* Anordnung ist resistent gegen Word-Alignment Option */
 allgemein_struct		umgebung;
 hpgl_struct		far	*plotter;
 laser_struct		far	*laserjet;
 nadel_struct		far	*nadeldrucker;
 deskjet_struct		far	*deskjet_c;
 paintjet_struct	far	*paintjet;
 DXF_struct			far	*dxf;
 void				far	*reserve1;
 void				far	*reserve2;
 void				far	*reserve3;
 int				far	*userfill;
  } BGI_struct;

typedef struct {    	/* Anordnung ist resistent gegen Word-Alignment Option */
			char jumpbefehl[6];		// OpCode "jmp" + sprungziel  + alignbyte
			char kennung[8];		// "NISIUS\xFF"
			BGI_struct far *data;	// Pointer auf Konfiguration
	} IntServicetyp;



intex BGI_struct Treiber_konfiguration
 #ifdef BGIALLOC_FILE
	=
	{
		{               /* umgebung */
		1,              /* errormessages : TRUE zum debuggen */
		1,              /* warnings      : TRUE zum debuggen */
		'\7',           /* namelength */
		"BGI.DAT",      /* Dateiname fr Mode 8  */
						/* Rest wird von diesem Modul initialisiert */
		0,              /* control */
		0,              /* control_ds */
		0,              /* myalloc */
		0,              /* mfree /*
		0,              /* free_ds */
		4096,			/* selectorInc (im real mode Paragraphen / segment) */
		0,              /* tmplength */
		'\0'            /*tmp_path */
		},
	0,  /*  plotter     */
	0,  /*  laserjet    */
	0,  /*  nadeldrucker*/
	0,  /*  deskjet_c   */
	0,  /*  paintjet    */
	0,  /*  reserve1    */
	0,  /*  reserve2    */
	0,  /*  reserve3    */
	0,  /*  reserve4    */
	0,  /*  userfill  : 0 -> normale Ausfhrung des Befehls setfillpattern */
		/*              sonst Zeiger auf 16 Worte, die das Bitmuster */
		/*              fr USER_FILL Zeilenweise mit 16 Bit definieren */
	}
 #endif
 ;

intex IntServicetyp Umleitung
 #ifdef BGIALLOC_FILE
	=
	{
	{0},					/* jump Befehl wird zur Laufzeit bestimmt */
	"Nisius\xff",   		/* kennung,  Mu bleiben */
	{0}						/* wird zur Laufzeit bestimmt */
	}
 #endif
 ;


#ifdef NADELDRUCKER
				/* Werte fr Treiber_konfiguration->nadeldrucker.printermode */
#define EPS_240     0   /* 8 Nadelmodi, vertikale Auflsung immer 72 DPI */
#define EPS_120Y    1   /* so gut wie alle Nadeldrucker */
#define EPS_120L    2
#define EPS_60      3
#define EPS_240_216 4
#define EPS_80      5
#define EPS_72      6
#define EPS_90      7
#define EPS_144     8

#define EPS_60_180   9   /* 24 Nadelmodi */
#define EPS_120_180 10   /* so gut wie alle Nadeldrucker */
#define EPS_90_180  11
#define EPS_180_180 12
#define EPS_360_180 13
#define NEC_360_360 14   /* nur NEC P6/7 */
#define EPS_360_360 15   /* Epson */

#endif

#ifdef BGIALLOC_FILE
  #undef BGIALLOC_FILE
  #define intex
#endif
