unit alloc;
{
(C)opyright
       Raimund Nisius
       Goethepark  13
       10627  Berlin
       April 1992
Als rechtmiger Besitzer eines BGI-Treibers drfen sie
diesen Quellcode benutzen und nach Ihrem Bedarf verndern.

Diese Unit ist fr HPGL.BGI, LASER.BGI und NADEL.BGI DESKJETC.BGI
PAINTJET.BGI und DXF.BGI nutzbar.
------------------------------------------------------------------
Wenn Sie einen dieser Treiber nicht benutzen, dann knnen sie
die entsprechende Zeile
$DEFINE ...
in der Datei  "inventar.inc" streichen.
}

{$I inventar.inc}

{ $ DEFINE PLOTTER_EINBINDEN}  { Leerzeichen um $ entfernen, }
{ $ DEFINE LASER_EINBINDEN}    { falls Treiber eingebunden }
{ $ DEFINE NADEL_EINBINDEN}    { werden sollen }
{ $ DEFINE DESKJET_EINBINDEN}
{ $ DEFINE PAINTJET_EINBINDEN}
{ $ DEFINE DXF_EINBINDEN}

{
unit alloc   stellt dem Hauptprogramm die Variablen
                monitortreiber  , monitormode
                plottertreiber  , plottermode
                lasertreiber    , lasermode
                nadeltreiber    , nadelmode
                deskjettreiber  , deskjetmode
                PAINTJETtreiber  , PAINTJETmode
                DXFtreiber       , DXFmode
         zur Verfgung und initialisiert sie. Auer beim Monitor
             bedeutet "...mode" die Schnittstelle, an der das Gert
             angeschlossen ist. Wenn Sie im Hauptprgramm mit z.B.
             initgraph( plottertreiber, plottermode, '');
             auskommen, dann brauchen Sie nicht mehr weiterzulesen.

unit alloc   stellt den Treibern "HPGL.BGI","LASER.BGI","NADEL.BGI",
             "DESKJETC.BGI" einen Interruptvektor zur Verfgung. Dieser
             Vektor zeigt auf eine Datenstruktur vom Typ BGI_Konfigura-
             tion mit den Konfigurationen der einzelnen Treiber.
             Der Initialisierungsteil der Unit installiert den Interrupt
             und sorgt dafr da er zum Programmschlu wieder entfernt
             wird.

             Welcher Interruptvektor das ist, wird zur Laufzeit bestimmt.
             Wenn das Recordelement "reconfig" gleich Null ist, setzt
             der Treiber seine eigenen Defaultwerte ein.
             Die Bedeutung der Recordelemente entnehmen Sie bitte der
             Datei "PARAMS.PAS".

unit alloc   stellt den Druckertreibern eine Funktion zur Speicher-
             allocation zur Verfuegung
             Der Speicher wird whrend der Ausfhrung von CloseGraph
             bzw. RestoreCrtMode von der Funtion "bgi_alloc" angefordert
             und durch "myfree" wieder freigegeben.

unit alloc   stellt den Druckertreibern eine Funktion zur Kontrolle
			 der Datenausgabe zur Verfgung (BGIControl)
			 Diese Funktion wird whrend der Datenbertragung oft mit einem
			 Argument >= 0 aufgerufen. Bei Fehlern wird sie mit einem
			 Argument  < 0 aufgerufen.
			 Das Funktionsergebnis befiehlt dem Treiber, wie er arbeiten soll.
			 Argument :
				   >= 0 : Nummer der Zeile die bertragen werden soll
				   -1   : Fehler beim Erffnen ( Gert defekt, )
				   -2   : Fehler beim bertragen (Busy oder Strung)
				   -3   : Soll Graphik erzeugt werden ? 0 : ja  1: nein
			 Rckgabe :
                   0 : Fortsetzung der bertragung (noch mal versuchen)
                   1 : Abrruch der bertragung
                   2 : Neustart der bertragung (nur wenn Status < 0)
             Wenn die Adresse dieser Funktion dem Treiber nicht eingetragen
             ist (NIL), bricht er bei Erffnungsfehler ab, sonst arbeitet er
             weiter. (Printer Busy)

Alle Funktionen mssen FAR sein!  Sie mssen das jeweilige Datensegment
dieser Funktionen kennen. Darum lassen Sie sie am besten in dieser Unit.
}


interface

uses
    params;


var
   monitortreiber ,            { Defaulttreiber wird nach installuserdriver }
   monitormode    : integer;   { nicht mehr gefunden }

{$IFDEF HPGLPLOTTER}
   plottermode    ,
   plottertreiber : integer;     { Treibernummer fr initgraph }
{$ENDIF}

{$IFDEF LASERDRUCKER}
   lasermode      ,
   lasertreiber   : integer;     { Treibernummer fr initgraph }
{$ENDIF}

{$IFDEF NADELDRUCKER}
   nadelmode      ,
   nadeltreiber   : integer;     { Treibernummer fr initgraph }
{$ENDIF}

{$IFDEF DESKJETDRUCKER}
   deskjetmode      ,
   deskjettreiber   : integer;     { Treibernummer fr initgraph }
{$ENDIF}

{$IFDEF PAINTJETDRUCKER}
   PAINTJETmode      ,
   PAINTJETtreiber   : integer;     { Treibernummer fr initgraph }
{$ENDIF}

{$IFDEF DXFDRUCKER}
   DXFmode      ,
   DXFtreiber   : integer;     { Treibernummer fr initgraph }
{$ENDIF}

function TreiberName(driver : integer) : string;

const
     myfill : array[1..16] of word = (          { Beispiel fr 16*16 Bit }
                                     $8000,     { Wenn Sie die Adresse die- }
                                     $4000,     { ses records in }
                                     $2000,     { Treiber_konfiguration. }
                                     $1000,     { userfill eintragen }
                                     $0800,
                                     $0400,
                                     $0200,
				     $0100,
                                     $0080,
                                     $0040,
                                     $0080,
                                     $0100,
                                     $0200,
				     $0400,
                                     $0800,
                                     $F000
                                     );

     Treiber_konfiguration : BGI_Konfiguration =
        (
        umgebung : (
            errormessages : TRUE;                      { zum debuggen }
            warnings      : TRUE;                      { zum debuggen }
            dateiname     : 'BGI.DAT';  { fr Mode 8  }
                          { Rest wird von dieser Unit beim Start initialisiert }
            control       : NIL;
            control_ds    : 0;
			myalloc       : NIL;
            mfree         : NIL;
	    free_ds       : 0;
	    Selectordelta : 0;
            tmp_path      : ''
            );
       plotter      : NIL;
       laserjet     : NIL;
       nadeldrucker : NIL;
       deskjet_c    : NIL;
       PAINTJET     : NIL;
       DXF          : NIL;
       reserve1     : NIL;
       reserve2     : NIL;
       reserve3     : NIL;
       userfill     : NIL   { NIL : normales SetFillPattern  }
{      userfill     : @myfill;  { sonst Zeiger auf 16 Worte, die das Bitmuster }
                            { fr USER_FILL Zeilenweise mit 16 Bit definieren }
       );

{$IFDEF NADELDRUCKER}
const            { Werte fr Treiber_konfiguration.nadeldrucker^.printermode }
  EPS_240     = 0;   { 8 Nadelmodi, vertikale Auflsung immer 72 DPI }
  EPS_120Y    = 1;   { so gut wie alle Nadeldrucker }
  EPS_120L    = 2;
  EPS_60      = 3;
  EPS_240_216 = 4;
  EPS_80      = 5;
  EPS_72      = 6;
  EPS_90      = 7;
  EPS_144     = 8;

  EPS_60_180  =  9;   { 24 Nadelmodi }
  EPS_120_180 = 10;   { so gut wie alle Nadeldrucker }
  EPS_90_180  = 11;
  EPS_180_180 = 12;
  EPS_360_180 = 13;
  NEC_360_360 = 14;   { nur NEC P6/7 }
  EPS_360_360 = 15;   { Epson   }

{$ENDIF}

implementation

uses
    crt,
    dos,
  {$IFDEF DPMI}
    WinApi,
  {$ENDIF}
    graph;

const
  {$IFDEF VER70}
      {$IFDEF DPMI} { Protected Mode Version 7.0}
     plottername  = 'PHPGL';
     lasername    = 'PLASER';
     nadelname    = 'PNADEL';
     deskjetname  = 'PDJ500C';
     PAINTJETname = 'PPJXL';
     DXFname      = 'PDXF';
      {$ELSE} { REALMODE Version 7.0}
     plottername  = 'RHPGL';
     lasername    = 'RLASER';
     nadelname    = 'RNADEL';
     deskjetname  = 'RDJ500C';
     PAINTJETname = 'RPJXL';
     DXFname      = 'RDXF';
     RESTHEAP     = 4096;          { RESTHEAP mu noch fr Interrupts}
                                    { von Turbovision bleiben }
      {$ENDIF}
  {$ELSE} { REALMODE vor Version 7.0}
     plottername  = 'HPGL';
     lasername    = 'LASER';
     nadelname    = 'NADEL';
     deskjetname  = 'DESKJETC';
     PAINTJETname = 'PJXL';
     DXFname      = 'DXF';
     RESTHEAP     = 4096;           { RESTHEAP mu noch fr Interrupts}
                                    { von Turbovision bleiben }
     SelectorInc  = $1000;          { wird aber nur in Version 7 bentigt }
                                    { und ist dort eine globale System-Variable }
  {$ENDIF}

type
    wordpointer = ^word;

var

{$IFDEF ANY_DRUCKER}
  {$IFDEF DPMI}     { Speicher wird am Stck mit GlobalAllocPtr angefordert}
	MemHandle       : array[0..10] of THandle;
	MemPtr          : array[0..10] of pointer;
  {$ELSE}           { Real Mode Speicher wird mit GetMem angefordert}
	Blockzahl       : word;                  { Anzahl der allozierten Blcke }
	memptr          : array[1..10] of ^byte;  { Zeiger auf diese Blcke       }
	memsize         : array[1..10] of word;   { Gren dieser Blcke          }
  {$ENDIF}
{$ENDIF}


  benutzte_Vektornummer : integer;
  AltIntVektor          : pointer;    { Interruptvektor vor initialisierung der Unit}
  oldexitproc           : pointer;    { alte Exitprocedur }
{$IFnDEF DPMI}
  Umleitung             : IntServiceRec;        { einfach statische Daten }
{$ENDIF}
  UmleitungPtr          : ^IntServiceRec;       { Zeiger auf ISR }

{$F+}

{$IFDEF HPGLPLOTTER}
   {$IFDEF PLOTTER_EINBINDEN}
   procedure _HPGL_driver; external;
      {$IFDEF VER70}
          {$IFDEF DPMI} { Protected Mode Version 7.0}
          {$L p_phpgl.obj}
          {$ELSE} { REALMODE Version 7.0}
          {$L p_rhpgl.obj}
          {$ENDIF}
      {$ELSE} { REALMODE vor Version 7.0}
      {$L p_hpgl.obj}
      {$ENDIF}
   {$ENDIF}
{$ENDIF}

{$IFDEF LASERDRUCKER}
   {$IFDEF LASER_EINBINDEN}
   procedure _LASER_driver; external;
      {$IFDEF VER70}
          {$IFDEF DPMI} { Protected Mode Version 7.0}
          {$L p_plaser.obj}
          {$ELSE} { REALMODE Version 7.0}
          {$L p_rlaser.obj}
          {$ENDIF}
      {$ELSE} { REALMODE vor Version 7.0}
      {$L p_laser.obj}
      {$ENDIF}
   {$ENDIF}
{$ENDIF}

{$IFDEF NADELDRUCKER}
   {$IFDEF NADEL_EINBINDEN}
   procedure _NADEL_driver; external;
      {$IFDEF VER70}
          {$IFDEF DPMI} { Protected Mode Version 7.0}
          {$L p_pnadel.obj}
          {$ELSE} { REALMODE Version 7.0}
          {$L p_rnadel.obj}
          {$ENDIF}
      {$ELSE} { REALMODE vor Version 7.0}
      {$L p_nadel.obj}
      {$ENDIF}
   {$ENDIF}
{$ENDIF}

{$IFDEF DESKJETDRUCKER}
   {$IFDEF DESKJET_EINBINDEN}
   procedure _DESKJETC_driver; external;
      {$IFDEF VER70}
          {$IFDEF DPMI} { Protected Mode Version 7.0}
          {$L p_pdj500.obj}
          {$ELSE} { REALMODE Version 7.0}
          {$L p_rdj500.obj}
          {$ENDIF}
      {$ELSE} { REALMODE vor Version 7.0}
      {$L p_deskjt.obj}
      {$ENDIF}
   {$ENDIF}
{$ENDIF}

{$IFDEF PAINTJETDRUCKER}
   {$IFDEF PAINTJET_EINBINDEN}
   procedure _PAINTJET_driver; external;
      {$IFDEF VER70}
          {$IFDEF DPMI} { Protected Mode Version 7.0}
          {$L p_ppjxl.obj}
          {$ELSE} { REALMODE Version 7.0}
          {$L p_rpjxl.obj}
          {$ENDIF}
      {$ELSE} { REALMODE vor Version 7.0}
      {$L p_pjxl.obj}
      {$ENDIF}
   {$ENDIF}
{$ENDIF}

{$IFDEF DXFDRUCKER}
   {$IFDEF DXF_EINBINDEN}
   procedure _DXF_driver; external;
      {$IFDEF VER70}
          {$IFDEF DPMI} { Protected Mode Version 7.0}
          {$L p_ppjxl.obj}
          {$ELSE} { REALMODE Version 7.0}
          {$L p_rpjxl.obj}
          {$ENDIF}
      {$ELSE} { REALMODE vor Version 7.0}
      {$L p_pjxl.obj}
      {$ENDIF}
   {$ENDIF}
{$ENDIF}






{$IFDEF ANY_DRUCKER}
{$IFnDEF DPMI}      { zuerst realmode Version}

   function errorhandler(s : word) : integer;  far;{Fehlerbehandlung von getmem  }
   begin
       errorhandler := 1;   { Fehler fhrt nicht zu Abbruch,    }
                            { sondern GetMem liefert NIL zurck }
   end;

   function lpointer(x : pointer) : longint;  { Adresse als longzahl }
   begin
   lpointer := longint(seg(x^)) * 16 + ofs(x^);
   end;


   function bgi_alloc(var start : word) : word; far;
                     { Rckgabe : Gre in Paragraphen }
                     { start ist der 1. Paragraph      }
   var
      theorie  : longint;
      alterror : pointer;
      i        : word;

   begin
   alterror := HeapError;        { Fehlerbehandlung ohne Abbruch installieren }
   HeapError := @errorhandler;
   theorie := maxavail - RESTHEAP; { Wieviel Speicher gibt es ? }
                                    { RESTHEAP mu noch fr Interrupts}
                                    { von Turbovision bleiben }
   i := 0;                       { noch keine Speicher reserviert }
   while (theorie > 16) do       { ganze Paragraphen }
	  begin
	  inc(i);                           { nchster Block }
	  if theorie >= $FFF0 then          { maximale Blockgre in Turbo Pascal }
		 memsize[i] := $FFF0
      else
         memsize[i] := theorie;
      getmem(memptr[i],memsize[i]);     { Speicher anfordern }
      if memptr[i] = nil then           { Allokation nicht erfolgreich ? }
         begin
         dec(i);                        { Block wird nicht gezhlt }
         theorie := 0;                  { Schleifenabbruch         }
         end
      else                              { Allokation erfolgreich }
		 begin                          { auf Zusammenhang prfen }
         dec(theorie,memsize[i]);       { Restspeicher ermitteln }
         if i > 1 then                  { den 1. Block natrlich nicht }
            begin
            if lpointer(memptr[i]) <> (lpointer(memptr[i-1]) + memsize[i-1]) then
              begin                          { Lcke zum vorherigen Block : }
              freemem(memptr[i],memsize[i]); { und wieder freigegeben   }
              dec(i);                        { Block wird nicht gezhlt }
              theorie := 0;                  { Schleifenabbruch         }
              end;
            end;
         end;                           { Allokation erfolgreich }
      end;  { while theorie }

   Blockzahl := i;                      { merken fr myfree }
   if i = 0 then                        { Kein Speicher ?  }
      bgi_alloc := 0                      { Funktionswert 0  }
   else
      begin                             { oder doch Erfolg :}
      start := seg(memptr[1]^);         {Funktionswert = Startparagraph }
	  inc(start,(ofs(memptr[1]^) +15) div 16);  { start aufrunden mit offset }
      bgi_alloc := (lpointer(memptr[i]) + memsize[i]) div 16 - start;
      end;
   HeapError := alterror;
   end;

   procedure myfree; far;    { gibt den Speicher wieder frei }
                          { mu auch aufgerufen werden koennen, wenn }
                          { bgi_alloc nicht erfolgreich war ! }
   var
      i : word;
   begin
   for i := 1 to Blockzahl do
       freemem(memptr[i],memsize[i]); { Speicher wieder freigegeben   }
   end;

{$ELSE}  { DPMI Version }

   const
		stack_count : word = 0; { Zaehler der Calls von bgi_alloc }
                { bgi_alloc wird je nach Treiber und Mode bis zu 6 mal auf-}
                { gerufen. Beim letzten Aufruf (fr die Bit-Image Daten) }
                { darf auch weniger Speicher reserviert werden. Dann wird }
                { das Bild in Bndern erzeugt und bertragen (dauert lnger)}

   function bgi_alloc( var Memory : pointer; idealsize : longint)
			: longint;
   far;
		 { Input Pointer auf Daten, Wunschgre in Byte }
		 { Rckgabe : Gre in Byte }
   var
	maxmem : LongInt;
   begin
	maxmem   := GlobalCompact(idealsize);     { mglichst alles }
                                                  { bereitstellen }
	if (idealsize) < maxmem then              { aber nicht mehr als}
		maxmem := idealsize;              { erforderlich }
	MemHandle[stack_count]	:= GlobalAlloc(GMEM_FIXED, maxmem);     { reservieren }
	MemPtr[stack_count]	:= GlobalLock(MemHandle[stack_count]);  { festnageln }
	Memory                  := MemPtr[stack_count];                 { mitteilen }
	bgi_alloc               := GlobalSize(MemHandle[stack_count]);	{ Gre ermitteln }
	inc(stack_count);
   end;

   procedure myfree; far;    { gibt den Speicher wieder frei }
   begin
   if stack_count = 0 then
      exit;
   while stack_count >0 do
      begin
      dec(stack_count);
      if MemPtr[stack_count] = NIL then
         continue;
      if GlobalUnlock(MemHandle[stack_count]) = false then
         begin
         MemHandle[stack_count] := GlobalFree(MemHandle[stack_count]);
         MemPtr[stack_count] := NIL;
         end
      else
         begin
         Writeln('Speicher konnte von "myfree" nicht freigegeben werden!');
         Halt(4);
         end;
      end;
   end;

{$ENDIF}

function BGIControl(Status : integer) : word; far;
{ wird von den Drucker-Treibern whrend der Ausgabe oft aufgerufen }
{ Argument : Status }
	  { >= 0 : Nummer der Zeile die bertragen werden soll }
	  { -1   : Fehler beim Erffnen }
	  { -2   : Fehler beim bertragen (Busy oder Strung) }
	  { -3   : Soll Graphik erzeugt werden ? 0 : ja  1: nein
{ Rckgabe : }
      { 0 : Fortsetzung der bertragung }
      { 1 : Abbruch der bertragung }
      { 2 : Neustart der bertragung (nur wenn Status < 0) }

var
   c : char;
begin
if Status >= 0 then           { kein Fehler : Status = Zeilennummer }
   begin
   write(#13,Status:4);       { den Anwender unterhalten }
                              { Bemerkung : Der Treiber schreibt auch }
                              { die Grenzzeilen des aktuellen Bandes auf }
                              { den Monitor. Dies knnen Sie mit  }
                              { Treiber_konfiguration.warnings unterbinden }

   if keypressed then         { den Anwender beachten }
      begin
      writeln('Ausgabe in vollem Gange');
      writeln('Was ist zu tun ?');
      writeln(' 0 : Weitermachen');
      writeln(' 1 : Aufhren');
      while keypressed do
            c := readkey;                   { Puffer leeren }
      repeat
         c := readkey;                      { Entscheidung abholen }
      until (c = '0') or (c = '1') ;
      BGIControl := ord(c) - ord('0');      { Entscheidung auswerten }
      end
   else                                     { keine Intervention : }
      BGIControl := 0;                      { weitermachen }
   exit;                                    { zurck zum BGI-Treiber }
   end;
if Status = -1 then                         { Fehler beim ffnen }
   begin
   writeln('Ausgabe nicht bereit (Disk voll, Printer Offline, ...) !');
   writeln('Was ist zu tun ?');
   writeln(' 0 : Drucker ist eingeschaltet, nochmal versuchen ');
   writeln(' 1 : Aufhren');
   while keypressed do
		 c := readkey;                      { Puffer leeren }
   repeat
	  c := readkey;                         { Entscheidung abholen }
   until (c = '0') or (c = '1') ;
   BGIControl := ord(c) - ord('0');         { Entscheidung auswerten }
   exit;
   end;
if Status = -3 then                         { Soll graphik erzeugt werden ?}
   begin
   BGIControl := 0;						 { ja ! }
{   BGIControl := 1;						 { nein! }
   exit;
   end;
										 { Rest : Status < -1 }
gotoxy(6,wherey);
write('Printer BUSY');                   { melden }
if keypressed then                       { Eingriff gefordert ? }
   begin
   writeln('Ausgabe gestrt oder Drucker beschftigt !');
   writeln('Was ist zu tun ?');
   writeln(' 0 : Drucker ist beschftigt, weiter versuchen');
   writeln(' 1 : Aufhren');
   writeln(' 2 : Daten noch mal von vorn bertragen');
   while keypressed do
         c := readkey;                   { Puffer leeren }
   repeat
      c := readkey;                      { Entscheidung abholen }
   until (c >= '0') and (c <= '2') ;
   BGIControl := ord(c) - ord('0');      { Entscheidung auswerten }
   end
else
   BGIControl := 0;        { Weitermachen }
end;

{$ENDIF}

const
{$IFDEF HPGLPLOTTER}
       HP7475_A3 : hpgl_rec = (
           reconfig    : 1;         { 1: Treiber benutzt diese Werte   }
           stiftzahl   : 7;         { Stifte im Karussel +  "kein stift" }
           speedmax    : 381;       { Defaultspeed [mm/s] }
           speed       : (100,100,100,100,100,100,100,100, { der Farbstifte }
                          100,100,100,100,100,100,100,100, { in % }
                          100,100,100,100,100,100,100,100, {  100 = default }
                          100,100,100,100,100,100,100,100
                         );
           dicke       :    { der Stifte [Plottereinheiten],  12 = 0.3mm  }
                         (12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12
                         );
           strichweite : 3;  { gestrichelten Linien pro Pattern-Bit }
                             {in Stiftdicken }
           size        : (x:16158;y:11040); { Ausdehnung in Pixeln          }
           filehandle  : 0;     { wird vom Treiber gesetzt. }
                                { Fr Plotterbefehle mittels INT $40) }
           rotate      : FALSE; { Landscape                 }
           formfeed    : FALSE; { Plotter kann und soll Papier auswerfen ?  }
           lastschnitt : 0;     { fr Schnittstellle = 9    }
           initstr     : #27'(;IN;SC;PU0,0;'; { Plotter Reset, kein Stift }
           exitstr     : ''    { leer }
           );

       HP7475_A4 : hpgl_rec = (
           reconfig    : 1;         { 1: Treiber benutzt diese Werte   }
           stiftzahl   : 7;         { Stifte im Karussel +  "kein stift" }
           speedmax    : 381;       { Defaultspeed [mm/s] }
           speed       : (100,100,100,100,100,100,100,100, { der Farbstifte }
                          100,100,100,100,100,100,100,100, { in % }
                          100,100,100,100,100,100,100,100, {  100 = default }
                          100,100,100,100,100,100,100,100
                         );
           dicke       :    { der Stifte [Plottereinheiten],  12 = 0.3mm  }
                         (12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12
                         );
           strichweite : 3;  { gestrichelten Linien pro Pattern-Bit }
                             {in Stiftdicken }
           size        : (x:11040;y: 7721); { Ausdehnung in Pixeln         }
           filehandle  : 0;     { wird vom Treiber gesetzt. }
                                { Fr Plotterbefehle mittels INT $40) }
           rotate      : FALSE; { Landscape                 }
           formfeed    : FALSE; { Plotter kann und soll Papier auswerfen ? }
           lastschnitt : 0;     { fr Schnittstellle = 9    }
           initstr     : #27'(;IN;SC;PU0,0;'; { Plotter Reset, kein Stift }
           exitstr     : ''     { leer }
           );

       HPLaserjet_A4 : hpgl_rec = (
           reconfig    : 1;         { 1: Treiber benutzt diese Werte   }
           stiftzahl   : 7;         { Stifte im Karussel +  "kein stift" }
           speedmax    : 381;       { Defaultspeed [mm/s] }
           speed       : (100,100,100,100,100,100,100,100, { der Farbstifte }
                          100,100,100,100,100,100,100,100, { in % }
                          100,100,100,100,100,100,100,100, {  100 = default }
                          100,100,100,100,100,100,100,100
                         );
           dicke       :    { der Stifte [Plottereinheiten],  12 = 0.3mm  }
                         (12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12
                         );
           strichweite : 3;  { gestrichelten Linien pro Pattern-Bit }
                             {in Stiftdicken }
           size        : (x:7721;y: 11040); { Ausdehnung in Pixeln                 }
           filehandle  : 0;     { wird vom Treiber gesetzt. }
                                { Fr Plotterbefehle mittels INT $40) }
           rotate      : FALSE; { Landscape                 }
           formfeed    : FALSE; { Plotter kann und soll Papier auswerfen ?         }
           lastschnitt : 0;     { fr Schnittstellle = 9    }
           initstr     : #27'%0B'#27'(;IN;SC;PU0,0;'; { HPGL-Modus an, Plotter Reset, kein Stift }
           exitstr     : #27'%0A'#12 { PCL-Modus wieder an, Formfeed }
           );

       HP7550_A3 : hpgl_rec = (
           reconfig    : 1;         { 1: Treiber benutzt diese Werte   }
           stiftzahl   : 9;         { Stifte im Karussel +  "kein stift" }
           speedmax    : 381;       { Defaultspeed [mm/s] }
           speed       : (100,100,100,100,100,100,100,100, { der Farbstifte }
                          100,100,100,100,100,100,100,100, { in % }
                          100,100,100,100,100,100,100,100, {  100 = default }
                          100,100,100,100,100,100,100,100
                         );
           dicke       :    { der Stifte [Plottereinheiten],  12 = 0.3mm  }
                         (12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12
                         );
           strichweite : 3;  { gestrichelten Linien pro Pattern-Bit }
                             {in Stiftdicken }
           size        : (x:15970;y:10870); { Ausdehnung in Pixeln           }
           filehandle  : 0;     { wird vom Treiber gesetzt. }
                                { Fr Plotterbefehle mittels INT $40) }
           rotate      : FALSE; { Landscape                 }
           formfeed    : TRUE;  { Plotter kann und soll Papier auswerfen ?   }
           lastschnitt : 0;     { fr Schnittstellle = 9    }
           initstr     : #27'(;IN;SC;PU0,0;'; { Plotter Reset, kein Stift }
           exitstr     : ''     { leer }
           );

       HP7550_A4 : hpgl_rec = (
           reconfig    : 1;         { 1: Treiber benutzt diese Werte   }
           stiftzahl   : 9;         { Stifte im Karussel +  "kein stift" }
           speedmax    : 381;       { Defaultspeed [mm/s] }
           speed       : (100,100,100,100,100,100,100,100, { der Farbstifte }
                          100,100,100,100,100,100,100,100, { in % }
                          100,100,100,100,100,100,100,100, {  100 = default }
                          100,100,100,100,100,100,100,100
                         );
           dicke       :    { der Stifte [Plottereinheiten],  12 = 0.3mm  }
                         (12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12,
                          12,12,12,12,12,12,12,12
                         );
           strichweite : 3;  { gestrichelten Linien pro Pattern-Bit }
                             {in Stiftdicken }
           size        : (x:10870;y: 7600); { Ausdehnung in Pixeln         }
           filehandle  : 0;     { wird vom Treiber gesetzt. }
                                { Fr Plotterbefehle mittels INT $40) }
           rotate      : FALSE; { Landscape                 }
           formfeed    : TRUE;  { Plotter kann und soll Papier auswerfen ? }
           lastschnitt : 0;     { fr Schnittstellle = 9    }
           initstr     : #27'(;IN;SC;PU0,0;'; { Plotter Reset, kein Stift }
           exitstr     : ''     { leer }
           );
{$ENDIF}

{$IFDEF LASERDRUCKER}
       AUFLOESUNG = 1;   {Druckerpixel/logischem Punkt    Bereich: 1..4  }
       laserkonfig : laser_rec = (
           reconfig    : 1;        { 1: Treiber liest Werte aus Struct   }
           stiftzahl   : 2;        { Stiftzahl des Druckers (0..n-1).     }
           dicke       : (  { in Dots Druckereinheiten, 12 = 1mm bei 300 dpi }
                         1,1,1,1,3,3,3,3,
                         3,3,3,3,3,3,3,3,
                         3,3,3,3,3,3,3,3,
             3,3,3,3,3,3,3,3
                         );
           strichweite : 6;     { der gestrichelten Linien pro Pattern-Bit }
           size        : (x:2335 div AUFLOESUNG;
                          y:3300 div AUFLOESUNG
                          );    { Ausdehnung in Pixeln bei Portrait }
           rotate      : FALSE; { Portrait }
           formfeed    : TRUE;  { (J/N) Seite ausdrucken ?  }
           resolution  : AUFLOESUNG;        { 1,2,3 oder 4 Pixel / Punkt }
           compress    : FALSE; { Komprimiermethode 2 ab Laserjet III }
           lastschnitt : 0;      { fr Schnittstellle = 9   }
           file_append : FALSE; { True : File wird nicht berschrieben }
     initstr     : #27'*p0X'#27'*p0Y'  { Cursor nach Links oben }
           );
{$ENDIF}


{$IFDEF NADELDRUCKER}
       nadelkonfig : nadel_rec = (
     reconfig    : 1;         { 1: Treiber liest Werte aus Struct      }
           stiftzahl   : 2;       { Stiftzahl im Karussel  (0..n-1).     }
           dicke       : (  { in Dots Druckereinheiten, 12 = 1mm bei 300 dpi }
                      1,1,1,1,1,1,1,1,
                      1,1,1,1,1,1,1,1,
                      1,1,1,1,1,1,1,1,
                      1,1,1,1,1,1,1,1
                      );    { in Dots Druckereinheiten 12 = 1mm bei 300 dpi }
           strichweite : 6;     { der gestrichelten Linien pro Pattern-Bit  }
           size        : (x:0;y:0);{ Nadel nimmt eigene Werte }
           rotate      : FALSE;     { Portrait }
           formfeed    : TRUE;  { (J/N) Seite ausdrucken ?  }
           printermode : EPS_240;       { EPS_240 .. NEC_360_360    }
           defaultbackground : 15;       { wei nur fr colormode }
           endezeichen : 6;     { 0: CR 1: LF 2: CR/LF  +4 fr Zeilenende immer }
           lastschnitt : 0;      { fr Schnittstellle = 9   }
           file_append : FALSE; { True : File wird nicht berschrieben }
	   initstr     : #27'U1'       { Spezielle Einstellungen     }
			{ z.B. Unidirektionaler Druck fr High Quality }
        );
{$ENDIF}

{$IFDEF DESKJETDRUCKER}
    DESKJET_AUFLOESUNG = 1;   {Druckerpixel/logischem Punkt    Bereich: 1..4  }
    deskjetkonfig : deskjet_rec = (
     reconfig    : 1;        { 1: Treiber liest Werte aus Struct       }
     stiftzahl   : 16;        { Stiftzahl des Druckers (0..n-1).     }
     dicke       : (  { in Dots Druckereinheiten, 12 = 1mm bei 300 dpi }
             1,1,1,1,3,3,3,3,
             3,3,3,3,3,3,3,3,
             3,3,3,3,3,3,3,3,
             3,3,3,3,3,3,3,3
             );
     strichweite : 6;       { der gestrichelten Linien pro Pattern-Bit}
     size        : (x:2400 div DESKJET_AUFLOESUNG;
              y:3100 div DESKJET_AUFLOESUNG   {3150 im Monomodus mglich}
              );    { Ausdehnung in Pixeln bei Portrait }
     rotate      : FALSE;   { Portrait }
     formfeed    : TRUE;    { (J/N) Seite ausdrucken ?  }
     resolution  : DESKJET_AUFLOESUNG;      { 1,2,3 oder 4 Pixel / Punkt }
     printermode : 128; { 0 fr Mono, 128 fr Color }
     defaultbackground : 15;       { wei nur fr colormode }
     lastschnitt : 0;     { fr Schnittstellle = 9  }
     file_append : FALSE;   { True : File wird nicht berschrieben }
     quality     : 2;       { 0: Keypad Einstellung 1: Draft 2: High }
     depletion   : 1;       { Ausdnnung 0: keine 1: normal, 2 stark }
     shingling   : 2;        { Mehrphasendruck 0: nein 1: 2 Phasen 2: 4 Phasen }
     Initstring  : ''        {  zur freien Benutzung 50 chars }
     );
{$ENDIF}

{$IFDEF PAINTJETDRUCKER}
    PAINTJET_AUFLOESUNG = 1;   {Druckerpixel/logischem Punkt    Bereich: 1..2  }
    PAINTJETkonfig : paintjet_rec = (
     reconfig    : 1;        { 1: Treiber liest Werte aus Struct       }
     stiftzahl   : 16;        { Stiftzahl des Druckers (0..n-1).     }
     dicke       : (  { in Dots Druckereinheiten, 12 = 1mm bei 300 dpi }
             1,1,1,1,3,3,3,3,
             3,3,3,3,3,3,3,3,
             3,3,3,3,3,3,3,3,
             3,3,3,3,3,3,3,3
             );
     strichweite : 3;       { der gestrichelten Linien pro Pattern-Bit}
     size        : (x:1440 div PAINTJET_AUFLOESUNG;    {A4}
              y:2055 div PAINTJET_AUFLOESUNG           {A4}
              );    { Ausdehnung in Pixeln bei Portrait }
     rotate      : FALSE;   { Portrait }
     formfeed    : TRUE;    { (J/N) Seite ausdrucken ?  }
     resolution  : PAINTJET_AUFLOESUNG;      { 1 oder 2 Pixel / Punkt }
     printermode : 128; { 0 fr Mono, 128 fr Color }
     defaultbackground : 15;       { wei nur fr colormode }
     lastschnitt : 0;     { fr Schnittstellle = 9  }
     file_append : FALSE;   { True : File wird nicht berschrieben }
     shingling   : 2        { Mehrphasendruck 0: nein 1: 2 Phasen 2: 4 Phasen }
     );
{$ENDIF}

{$IFDEF DXFDRUCKER}
    DXFkonfig : DXF_rec = (
     reconfig    : 1;        { 1: Treiber liest Werte aus Struct       }
     stiftzahl   : 8;        { Stiftzahl des Druckers (0..n-1).     }
     dicke       : (  { in units der resolution  }
             1,2,3,4,5,3,3,3,
             3,3,3,3,3,3,3,3,
             3,3,3,3,3,3,3,3,
             3,3,3,3,3,3,3,3
             );
     strichweite : 3;       { der gestrichelten Linien pro Pattern-Bit}
     size        : (x:2100;
                    y:2900);    { DIN A4 Ausdehnung 1/10 mm }
     resolution  : -1;      { 10 erpotenz der Pixel mm }
     textwinkel  : 90;   { Winkel SetTextStyle( x,VertDir, y)  normal }
     textstyle   : 'txt'
     );
{$ENDIF}

function get_schnittstelle(var mode: integer; geraet,defaultdatei : string) : boolean;
var
   c : char;
begin
writeln('Whlen Sie die Schnittstelle fr den ',geraet,' : ');
writeln('  0  Standarddatei "',defaultdatei,'" im Aktuellen Verzeichnis');
writeln('  1  COM1:');
writeln('  2  COM2:');
writeln('  3  COM3:');
writeln('  4  COM4:');
writeln('  5  LPT1:');
writeln('  6  LPT2:');
writeln('  7  LPT3:');
writeln('  8  Datei mit frei whlbarem Namen');
writeln('  9  ',geraet,' wird nicht bentigt.');
writeln;
write('Drcken Sie eine Taste aus 0..9 ');
mode := -1;
repeat
c := readkey;
if c <= '9' then
   mode := ord(c) - ord('0');
until mode >= 0;
writeln;
if mode = 9 then
   get_schnittstelle := false
else
   get_schnittstelle := true;
end;


const
{$IFDEF VER50}
graph_fehler = 5;
{$DEFINE NUR12}
{$ENDIF}

{$IFDEF VER55}
graph_fehler = 5;
{$DEFINE NUR12}
{$ENDIF}

{$IFDEF VER60}
graph_fehler = 0;  { Version 6.0 arbeitet korrekt}
                   { aber nicht registerbgidriver}
{$ENDIF}
{$IFDEF VER70}
graph_fehler = 0;  { Version 7.0 arbeitet korrekt}
                   { registerbgidriver hab ich nicht untersucht }
{$ENDIF}

function VectorIstBrauchbar(IntVektor : pointer ) : boolean;
begin
{$IFNDEF DPMI}
if (word(IntVektor^) = $CF58) or (IntVektor = NIL) then
   VectorIstBrauchbar := true { keine Interrupt Routine installiert }
else
   VectorIstBrauchbar := false; { Interrupt Routine vorhanden }
{$ELSE}
VectorIstBrauchbar := true; { es gibt sowieso keinen verwaisten Interrupt- }
                            { vektor. Aber die Umlenkung funktioniert  }
                            { sogar mit INT21 (kostet nur Zeit). }
{$ENDIF}
end;


procedure SucheIntvektor;
var
  weitersuchen  : boolean;    { nach freiem Interruptvektor }

begin
weitersuchen := true;
benutzte_Vektornummer      := $60;
while weitersuchen do
   begin
   getintvec(benutzte_Vektornummer,AltIntVektor);
   weitersuchen := not VectorIstBrauchbar(AltIntVektor);
   if weitersuchen then
      begin
      inc(benutzte_Vektornummer);
      if benutzte_Vektornummer > $FF then   { alle Ints durchprobiert  }
         begin                              { kann eigentlich nicht ... }
         writeln('Kein Interrupt mehr fr BGI-Treiber frei !');
         halt(4);
         end;
      end;
   end;
end;

procedure allocexit; far;
    begin
    exitproc := oldexitproc;   { alte exitprozedur restaurieren }
    setintvec(benutzte_Vektornummer,AltIntVektor);  { alten Vektor restaurieren }
    {$IFDEF DPMI}
    if GlobalFreePtr(UmleitungPtr) <> 0 then
       begin
       writeln('Intvektor Speicher nicht mehr frei zu geben !?');
       { writeln('Warum haben Sie denn die SIMM's angeltet?');}
       end;
    {$ENDIF}
    end;



procedure ErzeugeIntServiceRoutine;
var
   test : word;                 { dummy }
begin
{$IFDEF DPMI}
    { Speicher fr ISR reservieren }
UmleitungPtr := GlobalAllocPtr(gmem_NoDiscard+gmem_NoCompact, sizeof(UmleitungPtr^));
{$ELSE}
UmleitungPtr := @Umleitung;    { erzeugt einen far Pointer fr SetIntVec}
{$ENDIF}

{ISR "assemblieren" }
with UmleitungPtr^ do
    begin
    jumpbefehl   := $EA;            { jump far segment offset }
    sprungziel   := AltIntVektor;   { zur original ISR }
    kennung      := kenncode;       { fr BGI-Treiber  }
    data         := @Treiber_konfiguration; { Pointer auf Konfiguration }
    end;
{$IFDEF DPMI}
    { im Protected Mode mu der Code ber einen Codeselector adressiert werden}
    test := PrestoChangoSelector(seg(UmleitungPtr^),seg(UmleitungPtr^));
{$ENDIF}
    SetIntVec(benutzte_Vektornummer,UmleitungPtr); { und installieren }
    oldexitproc := exitproc;          { bisherige exitprozedur merken      }
    exitproc    := @allocexit;        { sorgt fuer Restaurierung der ISR   }
                                      { und der bisherigen Exitprozedur    }
end;

procedure InitDriver (
           var treiber ,                { Aufrufparameter fr initgraph }
               mode    : integer;       { Aufrufparameter fr initgraph }
           BGI_Name    ,                { Name der BGI-Datei }
           geraet      ,                { Klartext Name des Ausgabegertes}
           Ofile       : string;        { Standard Ausgabefile des Treibers }
           einbinden   : boolean;       { ja/nein}
           Objtreiber  : pointer        { falls ja : Zeiger auf angelinkten
                                        Treiber }
           );
begin

   if get_schnittstelle(mode,geraet,Ofile) then   { Treiber wird gebraucht }
      begin
      treiber := graph_fehler + installuserdriver (BGI_Name,NIL);
      if einbinden then
          begin
          if registerbgidriver(Objtreiber) < 0 then
             begin
             writeln('RegisterBGIDriver von ',BGI_Name,' ist fehlgeschlagen');
             halt(0);
             end;
          end;
      end
   else
      begin                            { Treiber wird nicht gebraucht }
      treiber := monitortreiber;       { Zur Sicherheit Ausgabe auf Monitor }
      mode    := monitormode;          { falls er doch gewhlt wird.}
      end;
   {$IFDEF NUR12}
   if treiber > 12 then
      begin writeln('Maximal 2 fremde Treiber bei Pascal 5.0'); halt; end;
   {$ENDIF}
   if treiber < 0 then
       begin
       writeln( BGI_Name,' kann nicht mehr installiert werden.');
       writeln('Vermutlich ist die Tabelle voll.');
       writeln('Entfernen Sie einen der Treiber aus der Datei "Inventar.inc".');
       writeln('Oder whlen Sie einen der Treiber nicht aus.');
       halt(0);
       end;
end;

procedure KonfiguriereDieTreiber;
begin
    with Treiber_konfiguration.umgebung do
         begin
{$IFDEF ANY_DRUCKER}
         control       := @BGIControl;
         control_ds    := DSeg;
         myalloc       := @bgi_alloc;
         mfree         := @myfree;
	 free_ds       := DSeg;
	 Selectordelta := SelectorInc;
{$ENDIF}
         end;

{$IFDEF HPGLPLOTTER}
{      plotter := @HPLaserjet_A4; fuer Laserjet mit HPGL-Emulation }
Treiber_konfiguration.plotter := @HP7475_A4;
InitDriver (
           plottertreiber,
           plottermode,
           plottername        ,
           'Plotter',
           'HPGL.PLT',
    {$IFDEF PLOTTER_EINBINDEN}
           true,
           @_HPGL_driver
    {$ELSE}
           false,
           NIL
    {$ENDIF}
           );
{$ENDIF}

{$IFDEF LASERDRUCKER}
Treiber_konfiguration.laserjet     := @laserkonfig;
InitDriver (
           lasertreiber,
           lasermode,
           lasername        ,
           'Laserdrucker',
           'LASER.PRN',
    {$IFDEF LASER_EINBINDEN}
           true,
           @_LASER_driver
    {$ELSE}
           false,
           NIL
    {$ENDIF}
           );
{$ENDIF}

{$IFDEF NADELDRUCKER}
Treiber_konfiguration.nadeldrucker := @nadelkonfig;
InitDriver (
           NADELtreiber,
           NADELmode,
           NADELname        ,
           'NADELdrucker',
           'NADEL.PRN',
    {$IFDEF NADEL_EINBINDEN}
           true,
           @_NADEL_driver
    {$ELSE}
           false,
           NIL
    {$ENDIF}
           );
{$ENDIF}

{$IFDEF DESKJETDRUCKER}
Treiber_konfiguration.deskjet_c := @deskjetkonfig;
InitDriver (
           DESKJETtreiber,
           DESKJETmode,
           DESKJETname,
           'DESKJET 500 C',
           'DESKJETC.PRN',
    {$IFDEF DESKJET_EINBINDEN}
           true,
           @_DESKJETC_driver
    {$ELSE}
           false,
           NIL
    {$ENDIF}
           );
{$ENDIF}

{$IFDEF PAINTJETDRUCKER}
Treiber_konfiguration.paintjet := @PAINTJETkonfig;
InitDriver (
           paintjettreiber,
           paintjetmode,
           paintjetname        ,
           'Paintjet XL',
           'PAINTJET.PRN',
    {$IFDEF PAINTJET_EINBINDEN}
           true,
           @_paintjet_driver
    {$ELSE}
           false,
           NIL
    {$ENDIF}
           );
{$ENDIF}

{$IFDEF DXFDRUCKER}
Treiber_konfiguration.DXF := @DXFkonfig;
InitDriver (
           DXFtreiber,
           DXFmode,
           DXFname        ,
           'DXF',
           'BGI.DXF',
    {$IFDEF DXF_EINBINDEN}
           true,
           @_DXF_driver
    {$ELSE}
           false,
           NIL
    {$ENDIF}
           );
{$ENDIF}
end;

function TreiberName(driver : integer) : string;
begin
if driver = monitortreiber then
   begin
   TreiberName := GetDriverName;
   exit;
   end;
{$IFDEF HPGLPLOTTER}
if driver = plottertreiber then
   begin
   TreiberName := plottername;
   exit;
   end;
{$ENDIF}
{$IFDEF LASERDRUCKER}
if driver = lasertreiber then
   begin
   TreiberName := lasername;
   exit;
   end;
{$ENDIF}
{$IFDEF NADELDRUCKER}
if driver = nadeltreiber then
   begin
   TreiberName := nadelname;
   exit;
   end;
{$ENDIF}
{$IFDEF DESKJETDRUCKER}
if driver = deskjettreiber then
   begin
   TreiberName := deskjetname;
   exit;
   end;
{$ENDIF}
{$IFDEF PAINTJETDRUCKER}
if driver = PAINTJETtreiber then
   begin
   TreiberName := PAINTJETname;
   exit;
   end;
{$ENDIF}
{$IFDEF DXFDRUCKER}
if driver = DXFtreiber then
   begin
   TreiberName := DXFname;
   exit;
   end;
{$ENDIF}
   TreiberName := 'unknown driver';
end;



begin {initialisierung der unit }

{ Monitor ermitteln solange DetectGraph noch funktioniert }
DetectGraph(monitortreiber,monitormode);

SucheIntvektor;      { Freien Interruptvektor suchen  }

{ Code fr die Interruptreoutine erzeugen und installieren }
ErzeugeIntServiceRoutine;

{XYtreiber  , XYmode ... zuweisen, und die Treiber Installieren}
KonfiguriereDieTreiber;

end.
