{
Filename auswahl.PAS

Interaktive Auswahl eines der BGI-Treiber fr die Testprogramme

(C) Raimund Nisius
    Goethepark  13
    10627  Berlin

Der Compiler mu die Dateien alloc.pas und params.pas bersetzen knnen.
}

unit auswahl;

interface
var
   treibertyp,                   { Diese Variablen werden von dieser Unit }
   treibermode : integer;        { interaktiv bestimmt }

procedure waehle_treiber;        { Ausgabegert bestimmen }

implementation

uses crt,
     alloc;

{$I inventar.inc}    { Welche Treiber stehen zur Auswahl }

function inchar(s:string) : char; { liefert einen der Buchstaben }
var                               { aus dem String s zurck}
   c : char;
begin
repeat
   c := readkey;
until pos(c,s) > 0;
inchar := c;
end;

{$IFDEF NADELDRUCKER}
const Nadelnamen : array[0..15] of string =
(
' A  Epson 240 * 72',
' B  Epson 120 * 72 schnell',
' C  Epson 120 * 72 schn',
' D  Epson 60  * 72',
' E  Epson 240 * 216',
' F  Epson 80  * 72',
' G  Epson 72  * 72',
' H  Epson 90  * 72',
' I  Epson 144 * 72',
' J  Epson 60  * 180',
' K  Epson 120 * 180',
' L  Epson 90  * 180',
' M  Epson 180 * 180',
' N  Epson 360 * 180',
' O  NEC   360 * 360',
' P  Epson 360 * 360'
);

procedure Nadeldrucker_waehlen;
var
   i             : integer;
   choice        : char;
   erlaubtstring : string;


begin
clrscr;
erlaubtstring := 'ABCDEFGHIJKLMNOPabcdefghijklmnop';

for I := 0 to 15 do
   writeln(Nadelnamen[i]);
writeln(' A .. I sind Modi fr 9-Nadler');
writeln(' F .. I sind nicht auf jedem Drucker verfgbar');
writeln(' J .. P sind Modi fr 24-Nadler');
writeln;
writeln('Bitte whlen Sie einen Druckermodus aus.');
choice := inchar(erlaubtstring);
choice := upcase(choice);
Treiber_konfiguration.nadeldrucker^.printermode := ord(choice) - ord('A');
writeln;
write('Farbdrucker ? (j/n)');
writeln('');
choice := inchar('JjNn');
choice := upcase(choice);
if choice = 'J' then
   begin
   inc(Treiber_konfiguration.nadeldrucker^.printermode,$80);
   Treiber_konfiguration.nadeldrucker^.stiftzahl := 16;
   end
else
   Treiber_konfiguration.nadeldrucker^.stiftzahl := 2;
end;
{$ENDIF}


procedure waehle_treiber;        { Ausgabegert bestimmen }
var
   erlaubtstring : string;
   choice        : char;

begin
erlaubtstring := '1';                   { Monitor immer}

{$IFDEF HPGLPLOTTER}
erlaubtstring := erlaubtstring + '2';
{$ENDIF}

{$IFDEF LASERDRUCKER}
erlaubtstring := erlaubtstring + '3';
{$ENDIF}

{$IFDEF NADELDRUCKER}
erlaubtstring := erlaubtstring + '4';
{$ENDIF}

{$IFDEF DESKJETDRUCKER}
erlaubtstring := erlaubtstring + '5';
{$ENDIF}

{$IFDEF PAINTJETDRUCKER}
erlaubtstring := erlaubtstring + '6';
{$ENDIF}

{$IFDEF DXFDRUCKER}
erlaubtstring := erlaubtstring + '7';
{$ENDIF}


clrscr;
writeln('             Auswahl der Graphikausgabe     ');
writeln;
writeln('Copyright an den Treibern fr Plotter und Drucker bei');
writeln('      Raimund Nisius');
writeln('      SoftwareEntwicklung');
writeln('      Goethepark 13');
writeln('      10627 Berlin');
writeln('      Tel./FAX  312 50 74 ');
writeln;
writeln;
writeln('Wo soll die folgende Graphik erzeugt werden ?');
writeln;
writeln('   1  Monitor  mit dem Default-Monitortreiber');
{$IFDEF HPGLPLOTTER}
   writeln('   2  HPGL-Plotter  ber die schon gewhlte Schnittstelle');
{$ENDIF}
{$IFDEF LASERDRUCKER}
   writeln('   3  LASER-Drucker ber die schon gewhlte Schnittstelle');
{$ENDIF}
{$IFDEF NADELDRUCKER}
   writeln('   4  NADEL-Drucker ber die schon gewhlte Schnittstelle');
{$ENDIF}
{$IFDEF DESKJETDRUCKER}
   writeln('   5  HP-DeskJet 500C ber die schon gewhlte Schnittstelle');
{$ENDIF}
{$IFDEF PAINTJETDRUCKER}
   writeln('   6  HP-PAINTJET XL ber die schon gewhlte Schnittstelle');
{$ENDIF}

{$IFDEF DXFDRUCKER}
   writeln('   7  DXF File ');
{$ENDIF}

writeln;
writeln('Whlen Sie bitte durch Drcken der entsprechenden Taste !');
choice := inchar(erlaubtstring);
case choice of
   '1' : begin
         treibertyp  := monitortreiber;
         treibermode := monitormode
         end;
{$IFDEF HPGLPLOTTER}
   '2' : begin
         treibertyp  := plottertreiber;
         treibermode := plottermode
         end;
{$ENDIF}
{$IFDEF LASERDRUCKER}
   '3' : begin
         treibertyp  := lasertreiber;
         treibermode := lasermode
         end;
{$ENDIF}
{$IFDEF NADELDRUCKER}
   '4' : begin
         treibertyp  := nadeltreiber;
         treibermode := nadelmode;
         Nadeldrucker_waehlen;
         end;
{$ENDIF}
{$IFDEF DESKJETDRUCKER}
   '5' : begin
         treibertyp  := deskjettreiber;
         treibermode := deskjetmode;
         end;
{$ENDIF}
{$IFDEF PAINTJETDRUCKER}
   '6' : begin
         treibertyp  := PAINTJETtreiber;
         treibermode := PAINTJETmode;
         end;
{$ENDIF}
{$IFDEF DXFDRUCKER}
   '7' : begin
         treibertyp  := DXFtreiber;
         treibermode := DXFmode;
         end;
{$ENDIF}
   end;
end; { waehle_treiber }

end.
