unit params;
{
File PARAMS.PAS

Typen zur Konfigurierung der BGI-Treiber

(C)opyright
       Raimund Nisius
       Goethepark  13
       10627  Berlin
       Dezember 1991
Als rechtmiger Besitzer eines BGI-Treibers von mir drfen sie
diesen Quellcode benutzen und nach Ihrem Bedarf verndern.
Die Datentypen mssen natrlich gleich bleiben.

Stand August 1993

}

interface

type
  stiftarr = array[0..31] of integer;  { Max. 32 Paletteneintrge }
  pointtype = record x,y : integer; end; {erspart uses graph; }


type
    kenntyp = array[1..8] of char;
const
    kenncode : kenntyp = ('N','i','s','i','u','s',#255,#0);  { Mu bleiben }
type
    IntServiceRec = record              { springt zum Original Interrupt }
                                        { Rest ist toter Briefkasten fr }
                                        { BGI-Treiber                    }
                      jumpbefehl : byte;     { OpCode "jmp"              }
                      sprungziel : pointer;  { Original Vektor           }
					  alignbyte	 : byte;	 { fuer word alignment }
					  kennung    : kenntyp;  {'NISIUS'                   }
                      data       : pointer   { Pointer auf Konfiguration }
                    end;

    allgemein_rec = record
                  { Folgende Elemente haben Bedeutung fr alle Treiber }
        errormessages : boolean;    { (on/off)      }
        warnings      : boolean;    { (on/off)      }
        dateiname     : string[79]; { fr Mode 8    }
                  { Folgende Elemente haben Bedeutung fr die Druckertreiber }
        control       : pointer;    { Steuerung der Datenbertragung  }
        control_ds    : word;       { Datensegment von control        }
        myalloc       : pointer;    { allocmem im Hauptprogramm       }
	mfree         : pointer;    { freemem im Hauptprogramm        }
	free_ds       : word;       { Datensegment im Hauptprogramm   }
	Selectordelta : word;		{ eben diese Variable }
	tmp_path      : string[79]; { kompletter Pfad fr temporre   }
                                    { Datei: Laufwerk am Anfang und   }
                                    { '\' am Ende, oder '' z.B. 'D:\' }
    end;  { allgemein_rec }

    hpgl_rec = record
       reconfig    : word;      { 0: Treiber setzt hier Defaultwerte   }
                                { 1: Treiber liest Werte aus Struct    }
       stiftzahl   : word;      { Stiftzahl im Karussel  (0..n-1).     }
       speedmax    : word;      { das 10-fache der Defaultspeed [cm/s] }
       speed       : stiftarr;  { der Farbstifte in %    100 = default }
       dicke       : stiftarr;  { in Dots Plottereinheiten 12 = 0.3mm  }
       strichweite : word;      { der gestrichelten Linien pro Pattern-Bit}
       size        : pointtype; { Ausdehnung in Pixeln                 }
       filehandle  : word;      { falls Sie Plotterbefehle geben wollen (mit INT $40) }
       rotate      : boolean;   { Landscape ?               }
       formfeed    : boolean;   { Plotter kann und soll Papier auswerfen ? }
       lastschnitt : byte;      { fr Schnittstellle = 9    }
       initstr     : string[50];{ Spezielle Einstellungen   }
                                { des Benutzers (z.B. Plotter-Reset) }
       exitstr     : string[50];{ Spezielle Einstellungen   }
                                { des Benutzers (z.B. Drucker in PCL_Mode zurck) }
  end; { hpgl_rec }

  laser_rec = record
       reconfig    : word;      { 0: Treiber setzt hier Defaultwerte   }
                                { 1: Treiber liest Werte aus Struct    }
       stiftzahl   : word;      { Stiftzahl im Karussel  (0..n-1).     }
       dicke       : stiftarr;  { in Dots Druckereinheiten 12 = 1mm bei 300 dpi }
       strichweite : word;      { der gestrichelten Linien pro Pattern-Bit}
       size        : pointtype; { Ausdehnung in Pixeln                 }
       rotate      : boolean;   { Landscape ?               }
       formfeed    : boolean;   { (J/N) Seite ausdrucken ?  }
       resolution  : byte;      { 1,2,3 oder 4 Pixel / Punkt }
       compress    : boolean;   { Komprimiermethode 2 ab Laserjet III }
       lastschnitt : byte;      { fr Schnittstellle = 9    }
       file_append : boolean;   { True : File wird nicht berschrieben }
       initstr     : string[51];{ Spezielle Einstellungen   }
                                { des Benutzers (z.B. Emulation) }
  end; {laser_rec}

  nadel_rec = record
       reconfig    : word;      { 0: Treiber setzt hier Defaultwerte   }
                                { 1: Treiber liest Werte aus Struct    }
       stiftzahl   : word;       { Stiftzahl im Karussel  (0..n-1).     }
       dicke       : stiftarr;  { in Dots Druckereinheiten 12 = 1mm bei 300 dpi }
       strichweite : word;      { der gestrichelten Linien pro Pattern-Bit      }
       size        : pointtype; { Ausdehnung in Pixeln                 }
       rotate      : boolean;   { Landscape ?               }
       formfeed    : boolean;   { (J/N) Seite ausdrucken ?  }
       printermode : byte;      { EPS_240 .. NEC_360_360    }
       defaultbackground : byte;{ nur fr colormode (0..15), 15 = wei }
       endezeichen : byte;      { 0: CR 1: LF 2: CR/LF  +4 fr Zeilenende immer }
       lastschnitt : byte;      { fr Schnittstellle = 9    }
       file_append : boolean;   { True : File wird nicht berschrieben }
       initstr     : string[51];{ Spezielle Einstellungen   }
                                { des Benutzers (z.B. Emulation) }
  end; {nadel_rec}

  deskjet_rec = record
       reconfig    : word;      { 0: Treiber setzt hier Defaultwerte   }
                                { 1: Treiber liest Werte aus Struct    }
       stiftzahl   : word;      { Stiftzahl im Karussel  (0..n-1).     }
       dicke       : stiftarr;  { in Dots Druckereinheiten 12 = 1mm bei 300 dpi }
       strichweite : word;      { der gestrichelten Linien pro Pattern-Bit }
       size        : pointtype; { Ausdehnung in Pixeln                 }
       rotate      : boolean;   { Landscape ?               }
       formfeed    : boolean;   { (J/N) Seite ausdrucken ?  }
       resolution  : byte;      { 1,2,3 oder 4 Pixel / Punkt }
       printermode : byte;      { 0 : monochrom 128 : Color }
       defaultbackground : byte;{ nur fr colormode (0..15), 15 = wei }
       lastschnitt : byte;      { fr Schnittstellle = 9    }
       file_append : boolean;   { True : File wird nicht berschrieben }
       quality     : byte;      { 0: Keypad Einstellung 1: Draft 2: High }
       depletion   : byte;      { Ausdnnung 0: keine 1: normal, 2 stark }
       shingling   : byte;      { Mehrphasendruck 0: nein 1: 2 Phasen 2: 4 Phasen }
       Initstring  : string[51] { Spezielle Einstellungen   }
  end; {deskjet_rec}


  paintjet_rec = record
       reconfig    : word;      { 0: Treiber setzt hier Defaultwerte   }
                                { 1: Treiber liest Werte aus Struct    }
       stiftzahl   : word;      { Stiftzahl im Karussel  (0..n-1).     }
       dicke       : stiftarr;  { in Dots Druckereinheiten 12 = 1mm bei 300 dpi }
       strichweite : word;      { der gestrichelten Linien pro Pattern-Bit }
       size        : pointtype; { Ausdehnung in Pixeln                 }
                                { Format        x     y}
                                { US Letter/A   1472  1931 }
                                { US Ledger/B   1920  2990 }
                                { A4            1440  2055 }
                                { A3            1984  2906 }
       rotate      : boolean;   { Landscape ?               }
       formfeed    : boolean;   { (J/N) Seite ausdrucken ?  }
       resolution  : byte;      { 1,2,3 oder 4 Pixel / Punkt }
       printermode : byte;      { 0 : monochrom 128 : Color }
       defaultbackground : byte;{ nur fr colormode (0..15), 15 = wei }
       lastschnitt : byte;      { fr Schnittstellle = 9    }
       file_append : boolean;   { True : File wird nicht berschrieben }
       shingling   : byte;      { Mehrphasendruck 0: nein 1: ja}
       initstr     : string[51] { Spezielle Einstellungen   }
  end; {paintjet_rec}

  DXF_rec = record
       reconfig    : word;      { 0: Treiber setzt hier Defaultwerte   }
                                { 1: Treiber liest Werte aus Struct    }
       stiftzahl   : word;      { Stiftzahl im Karussel  (0..n-1).     }
       dicke       : stiftarr;  { in units der resolution  }
       strichweite : word;      { der gestrichelten Linien pro Pattern-Bit }
       size        : pointtype; {Ausdehnung in mm * 10 hoch resolution  }
       resolution  : integer;   { 1,2,3 oder 4 Pixel / Punkt }
       textwinkel  : integer;   { Winkel SetTextStyle( x,VertDir, y) erlaubt
                                { andere Winkel als 90 }
       textstyle    : string[51] { Spezielle Einstellungen   }
  end; {DXF_rec}

    HPGL_Konfig_ptr = ^hpgl_rec;


    BGI_Konfiguration = record
       umgebung     : allgemein_rec;
       plotter      : HPGL_Konfig_ptr;
       laserjet     : ^laser_rec;
       nadeldrucker : ^nadel_rec;
       deskjet_c    : ^deskjet_rec;
       paintjet     : ^paintjet_rec;
       DXF           : ^DXF_rec;
       reserve1     : pointer;
       reserve2     : pointer;
       reserve3     : pointer;
       userfill     : pointer;  { NIL : normales SetFillPattern  }
                                { sonst Zeiger auf 16 Worte, die das }
                                { Bitmuster fr USER_FILL Zeilenweise }
                                { mit 16 Bit definieren               }
    end;   { BGI_Konfiguration }

implementation
{ reine Typdeklaration, kein Code }
end.

