// See Termy.c for an example of using these functions.
/*
	  COM1 is handled via INT 0xC (IRQ 4) and COM2 through COM8 are
	  handled via INT 0xB (IRQ 3). The base port addresses for COM1
	  through COM8 are 0x3f8, 0x2f8, 0x3220, 0x3228, 0x4220, 0x4228,
	  0x5220, and 0x5228. DON'T FORGET TO CLOSE YOUR PORTS!
*/
////
//  Can be used with AS_close(), AS_getmcr(), and AS_setmcr() functions.
////
#define MCR_DTR  1  // Turns DTR on.
#define MCR_RTS  2  // Turns RTS on.
#define MCR_OUT1 4  // Makes modem inactive.
#define MCR_LOOP 16 // Puts modem into "local echo" mode.

// PARITY TYPES
#define PAR_NONE  0
#define PAR_ODD   1
#define PAR_EVEN  3
#define PAR_MARK  5
#define PAR_SPACE 7

#define AS_icount ( p) (( p)->icount) // input buffer peek
#define AS_ocount ( p) (( p)->ocount) // output ""    ""
///////////////////////////////////////////////////////////////////////////
// This is the ASYNC block.
///////////////////////////////////////////////////////////////////////////
typedef struct
 {
  unsigned      base ;      /* base address of async port                     */
  unsigned char *ibuf ;     /* points to buffer for incomming data            */
  unsigned char *ibufend ;  /* points 1 byte past end of input buffer         */
  unsigned char *ibufhead ; /* next available byte in input buffer            */
  unsigned char *ibuftail ; /* next byte to be read from input buffer         */
  unsigned      icount ;    /* number of characters in the buffer             */
  unsigned char *obuf ;     /* points to buffer for outgoing data             */
  unsigned char *obufend ;  /* points 1 byte past end of output buffer        */
  unsigned char *obufhead ; /* next available unsigned char in output buffer  */
  unsigned char *obuftail ; /* next byte to be put into output buffer         */
  unsigned      ocount ;    /* number of characters in the output buffer      */
  unsigned      xon ;       /* either 0 or the % at which to send an XON  */
  unsigned      xoff ;      /* either 0 or the % at which to send an XOFF */
  unsigned char lookx ;     /* TRUE iff we must recognize xon/xoff            */
  unsigned char sentxoff ;  /* TRUE iff an XOFF has been sent.                */
  unsigned char recvxoff ;  /* TRUE iff we received an XOFF.                  */
 } ASYNC ;

/////////////////////////////////////////////////////
//            Prototypes and SOME docs             //
/////////////////////////////////////////////////////

// The int based functions return -1 if unsuccessfull,
// 0 (or an appropriate count) if all was cool.

// turn on break signal for count 18's of a second.
int AS_break ( ASYNC *p, int count) ;

// close port, restore ints, free memory, etc.
// value of fc may be any combination of the bits of
// MCR_DTR and MCR_RTS to leave the DTR and/or RTS
// signals active after port is closed. fc=0 for total closure.
ASYNC *AS_close ( ASYNC *p, int fc) ;

// get char from port. -1 means nothing there.
int AS_getc ( ASYNC *p) ;

// get string from port. up to n-1 chars, t is 18's of second timeout.
char *AS_gets ( char *s, int n, ASYNC *p, int t) ;

// get line/modem control and status register values.
int AS_getlcr ( ASYNC *p) ;
int AS_getlsr ( ASYNC *p) ;
int AS_getmcr ( ASYNC *p) ;
int AS_getmsr ( ASYNC *p) ;

// purge input buffer.
int AS_iflush ( ASYNC *p) ;

// purge output buffer.
int AS_oflush ( ASYNC *p) ;

// open a port.
ASYNC *AS_open ( int port, int baud, int par, int dbits,
		 int sbits, int ibufsize, int obufsize) ;

// change params of OPEN port.
int AS_params ( ASYNC *p, int baud, int par, int dbits, int sbits) ;

// return the com port associated with this async structure, 1 - 8.
int AS_portno ( ASYNC *p) ;

// send char c to port.
int AS_putc ( int c, ASYNC *p) ;

// send null term'd string to port.
int AS_puts ( char *s, ASYNC *p) ;

// set line/modem control and status registers.
void AS_setlcr ( ASYNC *p, int newval) ;
void AS_setmcr ( ASYNC *p, int newval) ;

// enable xon/xoff, xon = % empty, xoff = % full (lo-hi water marks.)
int  AS_setxonoff ( ASYNC *p, int xon, int xoff) ;

// wait for string s. t is 18's of second timeout, mode = 0 for exact match, 1 for no case checking.
int AS_waitfor ( ASYNC *port, char *s, int t, int mode) ;
