type

  messages = (noteoff, noteon, polyat, ctrlchange, progchange, chanat,
                pitchwheel,
              sysex, quarter, songpos, songsel, tune, eox, undefsc,
              clock, startc, continue, stopc, actsens, mreset, undefrt,
              sxfrag, none);

  messageset = set of noteoff..none;

  midifcntype = function: integer;

const

  channelset:  messageset = [noteoff..pitchwheel];
  syscomset:   messageset = [sysex..undefsc];
  realtimeset: messageset = [clock..undefrt];

  msglen:  array [messages] of integer =
             (3, 3, 3, 3, 2, 2, 3,
              2, 2, 3, 2, 1, 1, 0,
              1, 1, 1, 1, 1, 1, 0,
              0, 0);

  chmsgs:  array [$8..$e] of messages =
             (noteoff, noteon, polyat, ctrlchange, progchange, chanat,
              pitchwheel);

  sysmsgs: array [0..15] of messages =
             (sysex, quarter, songpos, songsel, undefsc, undefsc,
             tune, eox, clock, undefrt, startc, continue, stopc, undefrt,
             actsens, mreset);

  endex = $f7;

  msgvalues: array [messages] of byte =
               ($80, $90, $a0, $b0, $c0, $d0, $e0,
                $f0, $f1, $f2, $f3, $f6, $f7, $f4, $f8,
                $fa, $fb, $fc, $fe, $ff, $f9, $00, $00);
