typedef unsigned char  byte;
typedef unsigned int  word;
typedef char  channels[15];

typedef enum {  noteoff, noteon, polyat, ctrlchange, progchange, chanat,
                 pitchwheel,
                sysex, quarter, songpos, songsel, tune, eox, undefsc,
		clock, startc, cont, stopc, actsens, mreset, undefrt,
                sxfrag, none } messages;

typedef int (far pascal *ftype1) (int a);
typedef void (far pascal *ftype2) (int a, int b);
typedef long (far pascal *ftype3) ();
typedef char (far pascal *ftype4) (int a);
typedef void (far pascal *ftype5) (int a, int far *b);
typedef void (far pascal *ftype6) (int dev, messages far *msg, byte far *chan,
				   byte far *data1, byte far *data2);
typedef void (far pascal *ftype7) (int a);
typedef void (far pascal *ftype8) (int dev, messages msg, byte chan,
				   byte data1, byte data2);


#define NULL 0

#define chan_map  0
#define chan_ena  1
#define chan_xpos 2

#if !defined(LOCAL)

extern char MidiDriverLoaded;
extern int MID;

extern ftype2 midiPutByte;
extern ftype4 midiInputReady;
extern ftype5 midiGetByte;
extern ftype1 midiClearInput;
extern ftype3 msTimer;
extern ftype6 midiGetMessage;
extern ftype7 midiResend;
extern ftype8 midiPutMessage;

#endif

char midiInit();
int midiDevName(int dev, char *devname, char *devdesc);
void midiPutBuffer(int dev, char far *buf, unsigned int len);
void midiPutBuffer1(int dev, char *buf, unsigned int len);
word midiGetBuffer(int dev, char *buf, word max);
void midiReset(int dev);
void midiRemove();
void mfPause();
void mfContinue();
void mfPopup();
void mfRewind();
byte mfPlay(char *name);
void mfSongStat(char *playing, char *done, long *position,
		byte *songcount, byte *cursong);
void mfFileStat(byte *stat, char *name);
byte mfLoad(char *name);
void mfQuiet();
void mfPopEnable(char stat);
void mfVolume(int adjust);
void mfTimeMode(byte mode);
void mfGetChan(int datatype, channels *chan);
void mfSetChan(int datatype, channels *chan);
void mfSetPos(long time);
void mfSkipSong(byte n);
void mfLoopMode(byte n);

#if !defined(LOCAL)

static int msglen[23]  =
	   { 3, 3, 3, 3, 2, 2, 3,
	   2, 2, 3, 2, 1, 1, 0,
	   1, 1, 1, 1, 1, 1, 0,
	   0, 0 };

static char msgvalues[23] =
	    { 0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0,
	      0xf0, 0xf1, 0xf2, 0xf3, 0xf6, 0xf7, 0xf4, 0xf8,
	      0xfa, 0xfb, 0xfc, 0xfe, 0xff, 0xf9, 0x00, 0x00 };

#endif

