@echo off
REM -------------------------------------------------------------------
REM Batchfile to do the model/trace/model loop.
REM Moray will search this file for a line containing the program name
REM (which I can't write here, since it would be replaced) and replaces
REM it with a call to the scene you were editing.
REM -------------------------------------------------------------------

REM Set the environment variable, so that Moray knows it was called from 
REM here and can support the RENDER button
set MORAY=YES

:ModelIt
REM Change disk and directory to your modeller directory
c:
cd \modeller

REM Call Moray to design or edit the scene. Moray will edit this line
REM during the cycle. You can place any commandline parameter between
REM the EXE name and the scene name.
MORAY.EXE MRYSTART.MDL

REM Check whether a render was requested (if so errorlevel is set to 16)
if errorlevel 16 goto RenderIt
if errorlevel 1 goto Error
goto End

REM User asked Moray for a render, so change to the POV Scene directory 
REM and call the GO.BAT that was created. You may need to edit these lines
REM to reflect your directory structure
:RenderIt
c:
cd \povray2\scenes
call go.bat

REM After rendering go back to Moray for further design.
goto ModelIt

REM MORAY exited with an error condition
:Error
echo.
echo MORAY returned an error. Leaving the Editing/Rendering loop.
echo.
:End

REM Clear the environment variable.
set MORAY=
