// ===================================================================
// distrib.h
//	Declares functions used to implement the adaptive
//	supersampling scheme for ray distribution.
//	It's hard to unify the code for different types of
//	ray (primary, secondary and shadow), but common pieces 
//	of code have been collected here.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================

// Returns the distance from p to the nearest point in arr.
float MinDist(const Vector3D& p, const Vector3D *arr, int n);

// Return nonzero if the contrast given by the min and max doesn't meet
// the tolerance given (i.e., returns nonzero if more rays are needed).
int MoreRays(const RGBColor& min, const RGBColor& max, const RGBColor& tol);
