// ===================================================================
// geo.cpp
//	Limited OFF file support for OORT.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================

#include "oort.h"

void
FatalError(const char *msg)
{
	cerr << msg << '\n';
	exit(1);
}

Aggregate *
ReadGEOFile(char *filename, Surface *clr)
{
    int totverts, numverts, numpolys, somethin;
    int i, j;
    float x, y, z;
    Vector3D *arr;
    Aggregate *ret = new Aggregate;
    ifstream geofile;
    char tempstr[256];

    geofile.open(filename, ios::nocreate);
	if (! geofile) {
		sprintf(tempstr, "Could not open %s", filename);
		FatalError(tempstr);
    }
    geofile >> totverts >> numpolys >> somethin;
    arr = new Vector3D[totverts];
    if (! arr) {
		sprintf(tempstr, "Out of memory while reading %s", filename);
		FatalError(tempstr);
    }
    for (i = 0; i < totverts; i++) {
	geofile >> x >> y >> z;
	if (! geofile) {
	    sprintf(tempstr, "Encountered error reading %s", filename);
	    FatalError(tempstr);
	}
	arr[i] = Vector3D(x, y, z);
    }
    for (i = 0; i < numpolys; i++) {
	Vector3D *temparr;

	geofile >> numverts;
	if (! geofile) {
	    sprintf(tempstr, "Encountered error reading %s", filename);
	    FatalError(tempstr);
	}
	temparr = new Vector3D[numverts];
	if (! temparr) {
	    sprintf(tempstr, "Out of memory while reading %s", filename);
	    FatalError(tempstr);
	}
	for (j = 0; j < numverts; j++) {
	    int tempinx;
	    geofile >> tempinx;
	    if (! geofile) {
		sprintf(tempstr, "Encountered error reading %s", filename);
		FatalError(tempstr);
	    }
	    temparr[j] = arr[tempinx-1];
	}
	ret->AddObject(Polygon(numverts, temparr, clr));
	delete temparr;
    }
    delete arr;
    geofile.close();
    return ret;
}

