// ===================================================================
// vector.cpp
//	Vector3D support routines for OORT.
//
//	     The Object-Oriented Ray Tracer (OORT)
//            Copyright (C) 1993 by Nicholas Wilt.
//
// This software product may be freely copied and distributed in
// unmodified form but may not be sold.  A nominal distribution
// fee may be charged for media and handling by freeware and
// shareware distributors.  The software product may not be
// included in whole or in part into any commercial package
// without the express written consent of the author.
// 
// This software product is provided as is without warranty of
// any kind, express or implied, including but not limited to
// the implied warranties of merchantability and fitness for a
// particular purpose.  The author assumes no liability for any
// alleged or actual damages arising from the use of this
// software.  The author is under no obligation to provide 
// service, corrections or upgrades to the software.
//
// ------------------------------------------------------------
//
// Please contact me with questions, comments, suggestions or
// other input about OORT.  My Compuserve account number is
// [75210,2455] (Internet sites can reach me at 
// 75210.2455@compuserve.com).
//					--Nicholas Wilt
// ===================================================================

#include <iostream.h>
#include <math.h>
#include <stdio.h>
#include "matrix.h"
#include "vector.h"

// Overload << operator for C++-style output
ostream&
operator<< (const ostream& s, const Vector3D& A)
{
    return s << "(" << A.x << ", " << A.y << ", " << A.z << ")";
}

// Given min a vector to minimize and a candidate vector, replace
// elements of min whose corresponding elements in Candidate are
// smaller.  This function is used for finding objects' bounds,
// among other things.
void
Minimize(Vector3D& min, const Vector3D& Candidate)
{
    if (Candidate.x < min.x)
	min.x = Candidate.x;
    if (Candidate.y < min.y)
	min.y = Candidate.y;
    if (Candidate.z < min.z)
	min.z = Candidate.z;
}

// Given min a vector to minimize and a candidate vector, replace
// elements of min whose corresponding elements in Candidate are
// larger.  This function is used for finding objects' bounds,
// among other things.
void
Maximize(Vector3D& max, const Vector3D& Candidate)
{
    if (Candidate.x > max.x)
	max.x = Candidate.x;
    if (Candidate.y > max.y)
	max.y = Candidate.y;
    if (Candidate.z > max.z)
	max.z = Candidate.z;
}

// Project the vector onto the YZ, XZ, or XY plane depending on which.
// which	Coordinate plane to project onto
// 0		YZ
// 1		XZ
// 2		XY
// This function is used by the polygon intersection code.

void
Vector3D::ExtractVerts(float *px, float *py, int which) const
{
    switch (which) {
	case 0:
	    *px = y;
	    *py = z;
	    break;
	case 1:
	    *px = x;
	    *py = z;
	    break;
	case 2:
	    *px = x;
	    *py = y;
	    break;
    }
}

