// colorbox.h: Header file for colorbox
// Copyright (C) 1991 by Nicholas Wilt.  All rights reserved.

struct ColorVector {
  unsigned char r, g, b;
};

class ColorBoxNode;

class ColorBox {
private:
  ColorVector min, max;
  long volume;
  long num_members;
  Histogram *hist;
public:
  long repr, repg, repb;
  long avg_by;
  int inx;

  void CountMembers();
  void Shrink();
public:
  ColorBox();
  ColorBox(ColorVector& NewMin, ColorVector& NewMax, Histogram *NewHist);
  int Split(ColorBox **new1, ColorBox **new2);
  int IsInside(int x, int y, int z);

  friend int comp_cboxes(void *a, void *b);
  friend void findreps(int y, unsigned char *r, unsigned char *g, unsigned char *b, int width);
  friend void mapreps(int y, unsigned char *r, unsigned char *g, unsigned char *b, int width);
  friend ColorBoxNode *Quantize(Histogram& hist, int num_clrs);
  friend LocalSearch *FindAverages();
  friend void mapreps(int y, unsigned char *r, unsigned char *g, unsigned char *b, int width);
  friend void FindWhichBox(Histogram& hist);
  friend void FindCheckList(Histogram& hist);
  friend void SetPalette();
};

struct ColorBoxNode {
  ColorBox *box;
  ColorBoxNode *next;
};
