// heap.h: Header file for Heap class in OORT.
// Copyright (C) 1991 by Nicholas Wilt.  All rights reserved.

class Heap {
private:
  void **elms;			// Array of elements in heap
  int n;			// Number of elements in heap
  int maxsize;			// Max. # elements in heap
  int (*comp)(void *, void *);	// Comparison function to use

  void SiftUp();		// Private functions to fix
  void SiftDown();		// heap property

public:
  Heap(int (*ComparisonFunction)(void *, void *));
  ~Heap();
  void Insert(void *);
  void *ExtractMin();
  int N();
};
