#include <iostream.h>
#include <stdlib.h>
#include "hist.h"

Histogram::Histogram(int Dimension)
{
  int i, j, k;

  dim = Dimension;
  hist = new long**[dim];
  if (! hist) {
    cerr << "Out of memory allocating histogram\n";
    exit(1);
  }
  for (i = 0; i < dim; i++) {
    hist[i] = new long*[dim];
    if (! hist[i]) {
      cerr << "Out of memory allocating histogram\n";
      exit(1);
    }
  }
  for (i = 0; i < dim; i++)
    for (j = 0; j < dim; j++) {
      hist[i][j] = new long[dim];
      if (! hist[i][j]) {
	cerr << "Out of memory allocating histogram\n";
	exit(1);
      }
    }
  for (i = 0; i < dim; i++)
    for (j = 0; j < dim; j++)
      for (k = 0; k < dim; k++)
	hist[i][j][k] = 0L;
}

Histogram::~Histogram()
{
  int i, j;

  for (i = 0; i < dim; i++) {
    for (j = 0; j < dim; j++)
      delete hist[i][j];
    delete hist[i];
  }
  delete hist;
}
