DECLARE FUNCTION getword$ ()
DECLARE FUNCTION getasp$ (parfile$)
DECLARE SUB ernote (warning$)
DECLARE FUNCTION getfile$ (ext$)
DECLARE SUB cframe (snum!)              ' Change frames in a step
DECLARE SUB showst (ststep)             ' Show steps/frames - adj total
DECLARE SUB drawsc ()                   ' Redraw whole screen - calls showst
DECLARE SUB drawbox (x1!, y1!, x2!, y2!, title$) ' Draw a box w/ title
DECLARE FUNCTION readfile$ ()           ' Read the input file
CLS
DIM SHARED maxsteps
maxsteps = 255
DIM SHARED xmin(maxsteps) AS DOUBLE, xmax(maxsteps) AS DOUBLE
DIM SHARED ymin(maxsteps) AS DOUBLE, ymax(maxsteps) AS DOUBLE
DIM SHARED frames(maxsteps) AS INTEGER, maxiter(maxsteps) AS DOUBLE
DIM SHARED sname(maxsteps) AS STRING
DIM SHARED comm$, mapfil$, type$
DIM SHARED ststep, ero, enstep
ON ERROR GOTO ehandle
ststep = 1
comm$ = COMMAND$
IF comm$ <> "" THEN parfil$ = readfile$         ' If command line, load file
CALL drawsc                                     ' Draw the screen
rot$ = "none"                                   'Set default rotation
LOCATE 6, 17: COLOR 15, 1                       'and write to screen
PRINT rot$
rots = 1                                        'Set default rotation speed
LOCATE 6, 32: COLOR 15, 1                       'and write to screen
PRINT rots
aspect$ = "normal"
LOCATE 9, 48: COLOR 15, 1
PRINT aspect$;

LOCATE 25, 1: COLOR 15, 0
PRINT SPACE$(63);

getkey:                                         'Start of MAIN LOOP
DO
        key$ = INKEY$
LOOP UNTIL key$ <> ""                           ' Wait for keystroke
IF LEN(key$) > 1 THEN                           ' Look for extended key-code
        key$ = RIGHT$(key$, 1)
        IF key$ = CHR$(59) THEN junk$ = readfile$' F1 - read input file
        IF key$ = CHR$(60) THEN                 ' F2 - change start step
                LOCATE 3, 17: COLOR 15, 0: PRINT SPACE$(13)
                LOCATE 3, 17: COLOR 15, 1: INPUT ; "", ststep
                CALL drawsc
        END IF
        IF key$ = CHR$(61) THEN                 ' F3 - Change end step
                LOCATE 3, 32: COLOR 15, 0: PRINT SPACE$(14)
                LOCATE 3, 32: COLOR 15, 1: INPUT ; "", enstep
                CALL drawsc
        END IF
        IF key$ = CHR$(62) THEN CALL cframe(1)  ' F4 - Change frame/steps
        IF key$ = CHR$(63) THEN                 ' F5 - Change MAP file
                mapfil$ = getfile$("map")
                LOCATE 6, 3: COLOR 15, 0
                PRINT SPACE$(12)
                LOCATE 6, 3: COLOR 15, 1
                PRINT mapfil$
        END IF
        IF key$ = CHR$(64) THEN                 ' F6 - Change rotation type
                IF rot$ = "none" THEN newrot$ = "normal"
                IF rot$ = "normal" THEN newrot$ = "smart"
                IF rot$ = "smart" THEN newrot$ = "none"
                rot$ = newrot$
                LOCATE 6, 17: COLOR 15, 0
                PRINT SPACE$(6)
                LOCATE 6, 17: COLOR 15, 1
                PRINT rot$
        END IF
        IF (key$ = CHR$(65)) OR (key$ = CHR$(66)) THEN  ' F7,F8 Change speed
                IF key$ = CHR$(65) THEN
                        rots = rots - 1
                        IF rots < 1 THEN rots = 1
                        ELSE
                        rots = rots + 1
                        END IF
                LOCATE 6, 32: COLOR 15, 0
                PRINT SPACE$(12);
                LOCATE 6, 32: COLOR 15, 1
                PRINT rots;
        END IF
        IF key$ = CHR$(67) THEN                 ' F9 Change Aspect
                aspect$ = getasp$("aspect.par")
                aspect$ = LCASE$(aspect$)
                LOCATE 9, 48: COLOR 15, 0
                PRINT SPACE$(15);
                LOCATE 9, 48: COLOR 15, 1
                PRINT aspect$;
        END IF
        IF key$ = CHR$(68) THEN                 ' F10 Shell to DOS
                SCREEN , , 1, 1
                SHELL
                SCREEN , , 0, 0
        END IF

END IF

IF key$ = CHR$(13) THEN                         ' C/R - Begin
        FOR stp = ststep TO enstep - 1
                IF frames(stp) < 1 THEN CALL cframe(stp)
        NEXT stp                                ' Check for 'empty' steps
        GOSUB begin    ' ENTER - BEGIN!         ' Write file....
END IF

IF key$ = CHR$(27) THEN                         ' ESC - Abort!
        ero = 0
        OPEN "internal.scr" FOR INPUT AS #1     ' Delete internal.scr
        IF ero = 0 THEN
                CLOSE #1
                KILL "internal.scr"
        END IF
        CLS
        CLOSE
        END
END IF
GOTO getkey

ehandle:                                        ' Set flag if there's error
ero = ero + 1
RESUME NEXT

begin:
LOCATE 25, 1: COLOR 15, 1
OPEN "addit.bat" FOR OUTPUT AS #2       ' Re-Write addit.bat
cmdln$ = "fractint @aspect.par/" + aspect$ + " @respfile.par map=%1"
cmdln$ = cmdln$ + " type=" + type$
PRINT #2, cmdln$
CLOSE #2                                ' Close addit.bat

OPEN "internal.scr" FOR OUTPUT AS #2            'Open file
PRINT #2, mapfil$                               'Write mapfilename
SELECT CASE rot$                                'Write rotation type
        CASE "none"
                PRINT #2, "N"                   'none=N
        CASE "normal"
                PRINT #2, "R"                   'normal=R (regular)
        CASE "smart"
                PRINT #2, "S"                   'smart=S
END SELECT
PRINT #2, rots
PRINT #2, enstep - ststep + 1                   'Write total frames
FOR stp = ststep TO enstep                      'Write each step to file
        PRINT #2, USING "##.#################"; xmin(stp);
        PRINT #2, ",";
        PRINT #2, USING "##.#################"; ymin(stp)
        PRINT #2, USING "##.#################"; xmax(stp);
        PRINT #2, ",";
        PRINT #2, USING "##.#################"; ymax(stp)
        PRINT #2, frames(stp)
        PRINT #2, maxiter(stp)
NEXT stp
CLS : CLOSE : END                               'On to newfilm.exe....

SUB cframe (snum)                               ' Snum - default step#
stp = snum
LOCATE 25, 1: COLOR 15, 1                       ' Give instructions
PRINT "Use arrow keys to change values, press ENTER when finished";
DO                                              ' Loop until ESC
        LOCATE stp + 1, 74: COLOR 12, 1         ' Highlight current frame
        IF frames(stp) = 0 THEN
                PRINT "      ";
                ELSE
                PRINT frames(stp);
        END IF
        DO
                key$ = INKEY$
        LOOP UNTIL key$ <> ""                   ' Loop until keystroke
        LOCATE stp + 1, 74: COLOR 12, 0
        IF frames(stp) = 0 THEN
                PRINT "      ";
                ELSE
                PRINT frames(stp);
        END IF                                  ' Un-highlight current frame
        IF LEN(key$) > 1 THEN                   ' Check for extended key-code
                key$ = RIGHT$(key$, 1)
                IF key$ = CHR$(75) THEN         ' Left-arrow, decrement value
                        frames(stp) = frames(stp) - 1
                        IF frames(stp) < 1 THEN frames(stp) = 1
                END IF
                                                ' Right arrow, increment value
                IF key$ = CHR$(77) THEN frames(stp) = frames(stp) + 1
                IF key$ = CHR$(72) THEN         ' Up arrow, previous step
                        stp = stp - 1
                        IF stp < 1 THEN stp = 1
                END IF
                                                ' Down arrow, next step
                IF (key$ = CHR$(80)) AND (frames(stp + 1) <> 0) THEN
                        stp = stp + 1
                END IF
        END IF
LOOP UNTIL (key$ = CHR$(27)) OR (key$ = CHR$(13))' Loop until ESC.
LOCATE 25, 1: COLOR 15, 0
PRINT SPACE$(64);                               ' Remove instructions
END SUB

SUB drawbox (x1, y1, x2, y2, title$)
IF x1 > x2 THEN temp = x1: x1 = x2: x2 = temp
IF y1 > y2 THEN temp = y1: y1 = y2: y2 = temp   'Reverse 1 and 2 if 1>2
LOCATE y1, x1
FOR a = 1 TO LEN(title$)                        'Find first word
        IF fs = 0 THEN
                IF MID$(title$, a, 1) = " " THEN fs = a
        END IF
NEXT a
fs = fs - 1                                     'Is first word all caps?
IF LEFT$(title$, fs) <> UCASE$(LEFT$(title$, fs)) THEN fs = 0
COLOR 15, 2
PRINT CHR$(218);                                'Draw upper left
FOR a = 1 TO x2 - x1 - 1                        'Draw top and title
  IF (MID$(title$, a, 1) = " ") OR (MID$(title$, a, 1) = "") THEN
     PRINT CHR$(196);
  ELSE
     IF a <= fs THEN COLOR 4, 2                 'If it's caps, make it RED
     PRINT MID$(title$, a, 1);
     COLOR 15, 2
  END IF
NEXT a
PRINT CHR$(191);                                'Draw upper right
IF y1 + 1 < y2 THEN                             'Draw sides
        FOR a = y1 + 1 TO y2 - 1
                LOCATE a, x1
                PRINT CHR$(179);                'Left
                LOCATE a, x2
                PRINT CHR$(179);                'Right
        NEXT a
END IF
LOCATE y2, x1
PRINT CHR$(192);                                'Draw lower left
FOR a = 1 TO x2 - x1 - 1                        'Draw bottom
  PRINT CHR$(196);
NEXT a
PRINT CHR$(217);                                'Draw lower right
END SUB

SUB drawsc                                      ' Draw whole screen
COLOR 0, 4: LOCATE 1, 2
PRINT " FILMER V1.0 ";
COLOR 0, 7
PRINT "  FREEWARE BY JULIAN HAIGHT AND DAVID MANSFIELD  "
CALL drawbox(2, 2, 15, 4, "F1 .PAR File")       ' Draw boxes
CALL drawbox(16, 2, 30, 4, "F2 Start step")
CALL drawbox(31, 2, 46, 4, "F3 End step")
CALL drawbox(47, 2, 63, 4, "F4 Edit Frames >>")
CALL drawbox(2, 5, 15, 7, "F5 .MAP File")
CALL drawbox(16, 5, 30, 7, "F6 Rotation")
CALL drawbox(31, 5, 46, 7, CHR$(17) + "F7 speed")
CALL drawbox(47, 5, 63, 7, "Total Frames")
CALL drawbox(47, 20, 63, 21, "ENTER Begin!")
CALL drawbox(47, 23, 63, 24, "ESC Exit")
CALL drawbox(47, 8, 63, 10, "F9 Aspect")
CALL drawbox(47, 17, 63, 18, "F10 Shell->DOS")
COLOR 15, 2
LOCATE 3, 48: PRINT ">>>>>>>>>>>>>>>";          ' Fill the F4 box
COLOR 15, 1
LOCATE 3, 17: PRINT ststep                      ' Fill in values
LOCATE 3, 32: PRINT enstep
COLOR 4, 2: LOCATE 5, 42                       'Cludge to make F8 bold
PRINT "F8" + CHR$(16);
CALL showst(ststep)            ' Draw steps/frames
END SUB

SUB ernote (warning$)
LOCATE 25, 1: COLOR 0, 4
PRINT warning$ + "[more]";
a$ = INPUT$(1)
LOCATE 25, 1: COLOR 15, 0
PRINT SPACE$(64);
END SUB

FUNCTION getasp$ (parfile$)
ero = 0
OPEN parfile$ FOR INPUT AS #1
IF ero > 0 THEN CALL ernote("Can't find " + parfile$)
REDIM asparr$(100)
casp = 1
DO
        temp$ = INPUT$(1, #1)
        IF temp$ = "{" THEN
                DO
                        temp$ = INPUT$(1, #1)
                LOOP UNTIL temp$ = "}" OR EOF(1)
                temp$ = INPUT$(1, #1)
                casp = casp + 1
        END IF
        IF (ASC(temp$) > 32) AND (ASC(temp$) < 127) THEN
                asparr$(casp) = asparr$(casp) + temp$
        END IF
LOOP UNTIL EOF(1)
CLOSE #1
COLOR 11, 0
casp = 0
vpos = 8
hpos = 1
DO
        casp = casp + 1
        LOCATE vpos, hpos
        PRINT LEFT$(asparr$(casp), 8);
        vpos = vpos + 1
        IF vpos = 25 THEN vpos = 8: hpos = hpos + 9
        IF hpos > 37 THEN tomany = 1
LOOP UNTIL (asparr$(casp + 1) = "") OR (tomany = 1)
LOCATE 25, 1: COLOR 15, 1
INPUT ; "Which do you want to use"; aspect$
LOCATE 25, 1: COLOR 15, 0
PRINT SPACE$(64);
COLOR 0, 0
casp = 0
vpos = 8
hpos = 1
DO
        casp = casp + 1
        LOCATE vpos, hpos
        PRINT LEFT$(asparr$(casp), 8);
        vpos = vpos + 1
        IF vpos = 25 THEN vpos = 8: hpos = hpos + 9
        IF hpos > 37 THEN tomany = 1
LOOP UNTIL (asparr$(casp + 1) = "") OR (tomany = 1)
COLOR 15, 0
getasp$ = aspect$
END FUNCTION

FUNCTION getfile$ (ext$)                        'Gets user input - filename
vpos = 8
hpos = 1
COLOR 11, 0
ero = 0
LOCATE 1, 1
SHELL "dir *." + ext$ + " /b>" + ext$ + ".txt"   'Create .tmp file for DIR
OPEN ext$ + ".txt" FOR INPUT AS #1
IF ero = 1 THEN CALL ernote("Error opening " + ext$ + ".txt")
ero = 0
DO                                              'Display all files
        INPUT #1, temp$
        LOCATE vpos, hpos
        PRINT LEFT$(temp$, LEN(temp$) - 4);
        vpos = vpos + 1
        IF vpos = 25 THEN vpos = 8: hpos = hpos + 9
        IF hpos > 37 THEN tomany = 1
LOOP UNTIL (EOF(1)) OR (tomany = 1)
CLOSE
KILL ext$ + ".txt"                              'Kill temp file
LOCATE 25, 1: COLOR 15, 1
PRINT "Which ." + ext$ + "?";                   'Ask user for name of file
INPUT ; "", fil$
LOCATE 25, 1: COLOR 15, 0
PRINT SPACE$(63);                               'Clear last line
COLOR 15, 0
FOR vpos = 8 TO 24                              'Clear list
        LOCATE vpos, 1
        PRINT SPACE$(46);
NEXT vpos
ero = 0
OPEN fil$ FOR INPUT AS #1                       'Check if file exists
IF ero = 1 THEN
        OPEN fil$ + "." + ext$ FOR INPUT AS #1  'Check for file+ext.
        IF ero = 2 THEN
                CALL ernote("Could not open " + fil$ + " or " + fil$ + "." + ext$)
                fil$ = ""
                ero = 0
        END IF
        fil$ = fil$ + "." + ext$                'Add extension
END IF
fil$ = LCASE$(fil$)                             'Make lower case
CLOSE #1
getfile$ = fil$                                 'Return value
END FUNCTION

FUNCTION getword$
sf$ = ""
DO
  sf$ = sf$ + here$
  here$ = INPUT$(1, #1)
LOOP UNTIL (here$ = " ") OR (here$ = CHR$(13))
getword$ = sf$
END FUNCTION

FUNCTION readfile$
IF comm$ = "" THEN
        parfil$ = getfile$("par")
        ELSE
        parfil$ = LCASE$(comm$)
        ero = 0
        OPEN parfil$ FOR INPUT AS #1                       'Check if file exists
        IF ero = 1 THEN
                OPEN parfil$ + ".par" FOR INPUT AS #1      'Check for file+ext.
                IF ero = 2 THEN
                        CALL ernote("Could not open " + parfil$ + " or " + parfil$ + ".par")
                        parfil$ = ""
                        ero = 0
                END IF
                parfil$ = parfil$ + ".par"                 'Add extension
        END IF
        comm$ = ""
END IF
CLOSE #1
FOR temp = 1 TO LEN(parfil$)
        IF MID$(parfil$, temp, 1) = "." THEN period = temp
NEXT temp
IF period > 0 THEN
        file$ = LEFT$(parfil$, period - 1)
ELSE
        file$ = parfil$
END IF
mapfil$ = file$ + ".map"
ero = 0
OPEN mapfil$ FOR INPUT AS #2
IF ero = 1 THEN mapfil$ = "default.map"
CLOSE #2

LOCATE 6, 3: COLOR 15, 0
PRINT SPACE$(12)
LOCATE 6, 3: COLOR 15, 1
PRINT mapfil$


OPEN parfil$ FOR INPUT AS #1                    'Open input file
LOCATE 3, 3: COLOR 15, 0
PRINT SPACE$(12)
LOCATE 3, 3: COLOR 15, 1
PRINT parfil$

FOR stp = 1 TO maxsteps                         'Reset all variables
        xmin(stp) = 0: xmax(stp) = 0
        ymin(stp) = 0: ymax(stp) = 0
        frames(stp) = 0: maxiter(stp) = 0
        sname(stp) = ""
NEXT stp
stp = 0
DO                                              'Main loop, read each step
  stp = stp + 1
  find$ = "{"                                   'Look for {
  done = 0
  current$ = ""
  total$ = ""
  DO
    a$ = INPUT$(1, #1)
    total$ = total$ + a$
    current$ = RIGHT$(current$, LEN(find$) - 1) + a$
    IF UCASE$(current$) = find$ THEN done = 1
    IF (find$ = "MAXITER=") AND (a$ = "}") THEN done = 1: fucked = 1
  LOOP UNTIL (EOF(1)) OR (done = 1)             'Loop until eof or found
  IF EOF(1) THEN find$ = "NF"
  IF find$ = "NF" THEN GOTO fileend             'If eof quit sub
  REM DO WHILE ASC(LEFT$(total$, 1)) < 33
    REM total$ = RIGHT$(total$, LEN(total$) - 1)
  REM LOOP
  tt = 0                                        'Look back to name of step
  DO
        tt = tt + 1
        temp$ = RIGHT$(total$, tt)
        IF (ASC(LEFT$(temp$, 1)) < 32) THEN     'Found it by c/r
                sname(stp) = MID$(temp$, 2, 8)
                temp$ = ""
        END IF
        IF (tt > LEN(total$)) THEN              'Found it by length of total$
                sname(stp) = MID$(temp$, 1, 8)
                temp$ = ""
        END IF
  LOOP UNTIL temp$ = ""                         'Found it!
  a$ = INPUT$(3, #1)                            'Look forward again
  IF a$ = " ; " THEN INPUT #1, a$               'This means we have a name
  frames(stp - 1) = VAL(a$)
  IF (frames(stp - 1) = 0) AND (stp > 1) THEN   'No frames# - set to -1
        frames(stp - 1) = -1
  END IF
  find$ = "type="                               'Look for 'type'
  GOSUB find
  type$ = getword$
  find$ = "corners="                            'Look for 'corners'
  GOSUB find
  GOSUB getnum                                  'Get all four corners
  xmin(stp) = sofar#
  GOSUB getnum
  xmax(stp) = sofar#
  GOSUB getnum
  ymin(stp) = sofar#
  GOSUB getnum
  ymax(stp) = sofar#
  find$ = "maxiter="                            'Get maxiter
  GOSUB find
  GOSUB getnum
  maxiter(stp) = sofar#
fileend:
LOOP UNTIL find$ = "NF" OR EOF(1)               'Found EOF - file read complete
enstep = stp - 1                                'Set total steps
CLOSE
GOTO subend
 
 

getnum:
IF fucked = 1 THEN sofar# = 250: GOTO fucked
sf$ = ""
DO
  here$ = INPUT$(1, #1)
  IF here$ = "\" THEN
    LINE INPUT #1, junk$
    DO
      here$ = INPUT$(1, #1)
    LOOP UNTIL (ASC(here$) >= ASC("0")) AND (ASC(here$) <= ASC("9")) OR (here$ = "-") OR (here$ = "+") OR (here$ = ".")
  END IF
  sf$ = sf$ + here$
  LOOP UNTIL (here$ = "/") OR (here$ = " ") OR (here$ = STR$(13))
sf$ = LEFT$(sf$, LEN(sf$) - 1)
sf$ = STR$(VAL(sf$))
sofar# = VAL(sf$)
fucked:
fucked = 0
RETURN

find:
find$ = UCASE$(find$)
done = 0
current$ = ""
DO
  a$ = INPUT$(1, #1)
  current$ = RIGHT$(current$, LEN(find$) - 1) + a$
  IF UCASE$(current$) = find$ THEN done = 1
  IF (find$ = "MAXITER=") AND (a$ = "}") THEN done = 1: fucked = 1
LOOP UNTIL (EOF(1)) OR (done = 1)
IF EOF(1) THEN find$ = "NF"
RETURN
GOTO subend

subend:
CALL drawsc
readfile$ = parfil$
END FUNCTION

SUB showst (ststep)      'Show steps/frames with highlighting current
LOCATE 1, 65: COLOR 5, 0                                'Top of table
PRINT "S#"
LOCATE 1, 68: COLOR 14, 0
PRINT "SName";
LOCATE 1, 75: COLOR 12, 0
PRINT "Frames";
FOR stp = 1 TO 24                                       'Draw only what'l fit
  IF (stp < ststep) OR (stp >= enstep + 1) THEN           'Set highlight
        LOCATE stp + 1, 64: COLOR 5, 0
        ELSE
        LOCATE stp + 1, 64: COLOR 5, 1
  END IF
  PRINT USING "###"; stp;                               'Absolute step#
  LOCATE stp + 1, 67: COLOR 14, 0
  IF sname(stp) = "" THEN                               'Print step name
        PRINT SPACE$(8);
        ELSE
        PRINT sname(stp);
  END IF
  LOCATE stp + 1, 74: COLOR 12, 0
  IF frames(stp) = 0 THEN                               'Print # of frames
        PRINT "      ";                                 'if not 0
        ELSE
        PRINT frames(stp);
  END IF
NEXT stp                                                'AND loop!
FOR stp = ststep TO enstep - 1                          'count total frames
        total = total + frames(stp)
NEXT stp
LOCATE 6, 48: COLOR 15, 0
PRINT SPACE$(12);                                       'Write total to screen
LOCATE 6, 48: COLOR 15, 1
PRINT total;
END SUB

