//lRegen_FileHeading
//lRegen_FileHeading

     /********************************************************************
      *
      *   Source File:  toolbars.c                                        
      *   Author:       Miles Dempsey / Ray                               
      *   Module:       Source for toolbars application                   
      *   Program Desc: ToolBars Example                                                                
      *   Date:         Fri Nov 12 18:15:17 1993                          
      *
      ********************************************************************/

#include "toolbars.h"

//lRegen_Variables

BOOL  bHiPrintPos = TRUE;
BOOL  bLoPrintPos = FALSE; 

BOOL  bWriteTop = FALSE;
BOOL  bWriteBottom = FALSE;
BOOL  bWriteRight = FALSE;
BOOL  bWriteLeft = FALSE;

//lRegen_Variables

LRESULT CALLBACK __export MainWndProc(HWND, UINT, WPARAM, LPARAM);
VIEW     hViewMainView;

#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance,      // Application Instance Handle
                   HINSTANCE hPrevInstance,  // Previous Instance Handle
                   LPSTR  lpszCmdLine,       // Pointer to Command Line
                   int    nCmdShow)          // Show Window Option
{
   //lRegen_BeginFunction
   //lRegen_BeginFunction

   MSG      msg;
   HWND     hWndMain;

   HMODULE hBorLibrary;


   hInst = hInstance;

   lstrcpy(szAppName, "toolbars");
   hBorLibrary = LoadLibrary("bwcc.dll");

   if((UINT)hBorLibrary <= 32)
      MessageBox(NULL, "Unable to load Borland Controls",
                "System Error", MB_OK | MB_ICONHAND);

   //lRegen_InitMain
   //lRegen_InitMain

   if(!(hViewMainView = vwCreateView(hInst,
                   MAKEINTRESOURCE(onewin),
                   NULL,
                   (VIEWPROC)MainWndProc,
                   NULL)))
   {
         //lRegen_Create
         //lRegen_Create
        return FALSE;
   }
   vwSetViewIcon(hViewMainView, (LoadIcon(hInstance, "pgex")));
   vwSetFieldVar(hViewMainView, IDC_PVSTRING1, szHiString);
   vwSetFieldVar(hViewMainView, IDC_PVSTRING2, szLoString);
   //lRegen_MainWnd
   nCmdShow = SW_SHOWMAXIMIZED;
   //lRegen_MainWnd
   hWndMain = vwGetViewWindow(hViewMainView);
   vwSetViewToolBar(hWndMain, MAKEINTRESOURCE(TopToolbar), fnTopToolbarWndProc, TB_TOP);
   vwSetViewToolBar(hWndMain, MAKEINTRESOURCE(StatusLine), fnStatusLineWndProc, TB_BOTTOM);
   vwSetStatusLineId(hWndMain, IDC_STATUS1);
   vwSetViewToolBar(hWndMain, MAKEINTRESOURCE(LeftToolbar), fnLeftToolbarWndProc, TB_LEFT);
   vwSetViewToolBar(hWndMain, MAKEINTRESOURCE(RightToolbar), fnRightToolbarWndProc, TB_RIGHT);

   if(!(hWndMain = vwShowView(hViewMainView)))
      return FALSE;

   //lRegen_MainEnd
   //lRegen_MainEnd

   while(GetMessage(&msg, NULL, 0, 0))
          {
             TranslateMessage(&msg);
             DispatchMessage(&msg);
          }

   if((UINT)hBorLibrary > 32)
      FreeLibrary(hBorLibrary);

   //lRegen_AppTerm
   //lRegen_AppTerm
   return msg.wParam;
}

LRESULT CALLBACK __export MainWndProc(HWND hWnd, UINT wMessage, WPARAM wParam, LPARAM lParam)
{
GETVIEW;

   //lRegen_WindowProcVariables
   //lRegen_WindowProcVariables

   switch(wMessage)
   {
      //lRegen_WndProc
      //lRegen_WndProc

      case WM_INITDIALOG :
         //Regen_WM_INITDIALOG
	vwSetViewDefColors(View,rgbBLACK,rgbRED,rgbBLACK,rgbRED);
	//vwPaintField(View,IDC_PVSTRING1);
	//vwPaintField(View,IDC_PVSTRING2);
	lstrcpy(szHiString," ");
	lstrcpy(szLoString," ");
  	vwDoAppToScr(View,IDC_PVSTRING1);
  	vwDoAppToScr(View,IDC_PVSTRING2);
         //Regen_WM_INITDIALOG
         return TRUE;

      case WM_COMMAND :
         if(!LOWORD(lParam))
         {                             // Process Menu Commands
         }
         else
         {
            //Regen_CustomCommand
            //Regen_CustomCommand

            switch(wParam)
            {
               case IDC_PVSTRING1 :
                  //Regen_IDC_PVSTRING1
                  //Regen_IDC_PVSTRING1
                  break; 

               case IDC_PVSTRING2 :
                  //Regen_IDC_PVSTRING2
                  //Regen_IDC_PVSTRING2
                  break; 

            }
         }
         break;

      case WM_SIZE :
         //lRegen_WM_Size
         //lRegen_WM_Size
         vwSizeToolBars(hWnd);
         return 0;

      case WM_DESTROY :

         //lRegen_WM_DESTROY
         //lRegen_WM_DESTROY

         PostQuitMessage(0);
         break;

      default :
         return DefViewProc(hWnd, wMessage, wParam, lParam);
   }
   return DefViewProc(hWnd, wMessage, wParam, lParam);
}

//Regen_CustomCode
//Regen_CustomCode
