
//lRegen_FileHeading
//lRegen_FileHeading


     /********************************************************************
      *
      *   Source File:  toolbars.cpp                                      
      *   Author:       Miles Dempsey / Ray                               
      *   Module:       C++ Source file for toolbars application          
      *   Program Desc: ToolBars Example                                                                
      *   Date:         Fri Sep 24 12:15:59 1993                          
      *
      ********************************************************************/

#include "toolbars.h"

//Regen_toolbars_Vars
//Regen_toolbars_Vars

// Define application class derived from TApplication
class Ttoolbars : public TApplication
{
public:
  Ttoolbars(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
    virtual void InitMainWindow();
    //Regen_AppClass
    //Regen_AppClass
};

// Declare TMainWindow, a PVDialog descendant
class TMainWindow : public PVDialog 
{
public:
   TMainWindow(PTWindowsObject AParent, LPSTR ATitle);
   virtual void WMSize(RTMessage Msg) = [WM_FIRST + WM_SIZE];
   virtual void SetupWindow();
   //lRegen_MainClass
   //lRegen_MainClass

protected:
   virtual void GetWindowClass(WNDCLASS _FAR & AWndClass);
   virtual LPSTR GetClassName();
   char         szHiString[80 + 1];
   char         szLoString[80 + 1];

protected:
};


/****************************************************
 * TMainWindow implementations: 
 ****************************************************/

#pragma argsused
// Define TMainWindow, a TWindow constructor
TMainWindow::TMainWindow(PTWindowsObject AParent, LPSTR ATitle)
                         : PVDialog(AParent, ATitle)
{
   //lRegen_MainConstructor
   //lRegen_MainConstructor
   SetFieldVar(IDC_PVSTRING1, szHiString);
   SetFieldVar(IDC_PVSTRING2, szLoString);
   //Regen_MainEnd
   //Regen_MainEnd

}

void TMainWindow::SetupWindow()
{
   PVDialog::SetupWindow();
   vwSetViewIcon(hView, LoadIcon(GetModule()->hInstance, "pgex"));
   PTWindowsObject PTWndObj;
   if((PTWndObj = GetModule()->MakeWindow(
      new PVTopToolbarDlg(this, (LPSTR)MAKEINTRESOURCE(TopToolbar)))) != NULL)
   {
      vwSetToolBarView(HWindow, vwGetView(PTWndObj->HWindow), TB_TOP);
   }
   if((PTWndObj = GetModule()->MakeWindow(
      new PVStatusLineDlg(this, (LPSTR)MAKEINTRESOURCE(StatusLine)))) != NULL)
   {
      vwSetToolBarView(HWindow, vwGetView(PTWndObj->HWindow), TB_BOTTOM);
      vwSetStatusLineId(HWindow, IDC_STATUS1);
   }
   if((PTWndObj = GetModule()->MakeWindow(
      new PVLeftToolbarDlg(this, (LPSTR)MAKEINTRESOURCE(LeftToolbar)))) != NULL)
   {
      vwSetToolBarView(HWindow, vwGetView(PTWndObj->HWindow), TB_LEFT);
   }
   if((PTWndObj = GetModule()->MakeWindow(
      new PVRightToolbarDlg(this, (LPSTR)MAKEINTRESOURCE(RightToolbar)))) != NULL)
   {
      vwSetToolBarView(HWindow, vwGetView(PTWndObj->HWindow), TB_RIGHT);
   }
   lstrcpy(szHiString, "");
   lstrcpy(szLoString, "");
   //Regen_Setup
   //Regen_Setup

}

LPSTR TMainWindow::GetClassName()
{
   return "MainWindow";
}

void TMainWindow::GetWindowClass(WNDCLASS _FAR & AWndClass)
{
   PVDialog::GetWindowClass(AWndClass);
   AWndClass.hbrBackground = CreateSolidBrush(0xFFFFFF);
   AWndClass.lpszMenuName = (LPSTR)"toolbars";
   //Regen_ClassInfo
   //Regen_ClassInfo

}

#pragma argsused
void TMainWindow::WMSize(RTMessage Msg)
{
   vwSizeToolBars(HWindow);
   //Regen_WM_Size
   //Regen_WM_Size
};



/***************************************************
 * TtoolbarsApp method implementations:
 ***************************************************/

// Construct the Ttoolbars's MainWindow of type TMainWindow
void Ttoolbars::InitMainWindow()
{
   MainWindow = new TMainWindow(NULL, (LPSTR)MAKEINTRESOURCE(onewin));
   //lRegen_MainCreate
   //lRegen_MainCreate
}

// Main program
int PASCAL WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,
                   int nCmdShow)
{
   HINSTANCE hWinCtl;
   HINSTANCE hBorLibrary;

   hBorLibrary = LoadLibrary("bwcc.dll");

   if((UINT)hBorLibrary <= 32)
      MessageBox(NULL, "Unable to load Borland Controls", "System Error", MB_OK | MB_ICONHAND);

   hWinCtl = LoadLibrary("winctl.dll");

   if((UINT)hWinCtl <= 32)
      MessageBox(NULL, "Unable to load WinControl Library", "System Error", MB_OK | MB_ICONHAND);

   //lRegen_Init
   //lRegen_Init

   Ttoolbars Apptoolbars ("Toolbars Example", hInstance, hPrevInstance,
      lpCmdLine, nCmdShow);

   Apptoolbars.Run();

   if((UINT)hBorLibrary > 32)
      FreeLibrary(hBorLibrary);

   if((UINT)hWinCtl > 32)
      FreeLibrary(hWinCtl);

   //lRegen_CleanUp
   //lRegen_CleanUp

   return Apptoolbars.Status;
}

//Regen_CustomCode
//Regen_CustomCode
