//lRegen_FileHeading
//lRegen_FileHeading

     /********************************************************************
      *
      *   Source File:  TopToolb.c                                        
      *   Author:       Miles Dempsey / Ray                               
      *   Module:       Source for toolbars application                   
      *   Program Desc: ToolBars Example                                                                
      *   Date:         Fri Nov 12 18:15:08 1993                          
      *
      ********************************************************************/

#include "toolbars.h"


//lRegen_Variables

#include "dos.h"
#include "stdio.h"
#include "memory.h"

char * szShowTime (void);

extern HWND  hWndHelpLine;

extern bHiPrintPos;
extern bLoPrintPos;

extern BOOL  bWriteTop;
extern BOOL  bWriteBottom;
extern BOOL  bWriteRight;
extern BOOL  bWriteLeft;

//lRegen_Variables

char szcdOpenFilePath[80];
char szcdOpenFileTitle[40];
OPENFILENAME ofcdOpen;
static char szcdOpenFilter[] = {
   "All Files\0"
   "*.*\0"
   "Document Files\0"
   "*.doc\0"
   "Text Files\0"
   "*.txt\0"
   "\0"
};
char szcdSaveFilePath[80];
char szcdSaveFileTitle[40];
OPENFILENAME ofcdSave;
static char szcdSaveFilter[] = {
   "All Files\0"
   "*.*\0"
   "Document Files\0"
   "*.doc\0"
   "Text Files\0"
   "*.txt\0"
   "\0"
};
PRINTDLG pd;
VIEW     hViewTopToolbar;
HWND     hWndTopToolbar;
LRESULT CALLBACK __export fnTopToolbarWndProc(HWND hWnd, UINT wMessage, WPARAM wParam, LPARAM lParam)
{
   GETVIEW;
   //lRegen_WindowProcVariables
   //lRegen_WindowProcVariables

   switch(wMessage)
   {
      //lRegen_WndProc
      //lRegen_WndProc

      case WM_INITDIALOG :
         vwSetFieldVar(View, IDC_CLIPBOARD, szClipboard);
         vwSetFieldVar(View, IDC_TIME, szTime);
         //Regen_WM_INITDIALOG


         // set a timer called '1234' to track the time ever second

         SetTimer (hWnd, 1234, 1000, NULL);


         // copy hello world into the clipboard variable to start the app
         // then update the field on the screen with the value

         lstrcpy (szClipboard, "Hello World");
         vwDoAppToScr (View, IDC_CLIPBOARD);

         lstrcpy (szTime, szShowTime() );
         vwDoAppToScr (View, IDC_TIME);

         //Regen_WM_INITDIALOG
         return TRUE;

      case WM_MOUSEMOVE :
         //Regen_WM_MOUSEMOVE

         // Write a message to the status line once while mousing.
         // When the mouse rolls over another toolbar, the flag will be reset
	 // This will help avoid flicker

         if ( hWndHelpLine )
         {
           if ( !bWriteTop )
           {
             SetWindowText (hWndHelpLine, "The mouse is over the Top Toolbar");
             bWriteTop = TRUE;

             bWriteBottom = FALSE;
             bWriteRight = FALSE;
             bWriteLeft = FALSE;
           }
         }

         //Regen_WM_MOUSEMOVE
         break;

      case WM_TIMER :
         //Regen_WM_TIMER

         switch ( wParam )
         {
           case 1234 :

             // every second, call the function showtime at the bottom.
             // this function will return the time in a string.
             // it can then be painted onto the string field identified
             // by IDC_TIME on the top toolbar

             lstrcpy (szTime, szShowTime() );
             vwDoAppToScr (View, IDC_TIME);
             break;
         }

         //Regen_WM_TIMER
         break;

      case WM_COMMAND :
         switch(wParam)
         {
            case ID_FILE_OPEN :
               if(HIWORD(lParam) == BN_CLICKED)
               {
               //lRegen_Start_ID_FILE_OPEN
               //lRegen_Start_ID_FILE_OPEN
               szcdOpenFilePath[0] = '\0';
               ofcdOpen.lStructSize = sizeof(OPENFILENAME);
               ofcdOpen.hwndOwner = hWnd;
               ofcdOpen.lpstrFilter = szcdOpenFilter;
               ofcdOpen.lpstrCustomFilter = (LPSTR)NULL;
               ofcdOpen.nMaxCustFilter = 0L;
               ofcdOpen.nFilterIndex = 0;
               ofcdOpen.lpstrFile= szcdOpenFilePath;
               ofcdOpen.nMaxFile = 256;
               ofcdOpen.lpstrFileTitle = szcdOpenFileTitle;
               ofcdOpen.nMaxFileTitle = sizeof(szcdOpenFileTitle);
               ofcdOpen.lpstrInitialDir = NULL;
               ofcdOpen.lpstrTitle = (LPSTR)"Open File Dialog";
               ofcdOpen.Flags = 0;
               ofcdOpen.nFileOffset = 0;
               ofcdOpen.nFileExtension = 0;
               ofcdOpen.lpstrDefExt = NULL;
               GetOpenFileName(&ofcdOpen);
               //Regen_End_ID_FILE_OPEN
               //Regen_End_ID_FILE_OPEN
               }
               return(TRUE);

            case ID_FILE_SAVE :
               if(HIWORD(lParam) == BN_CLICKED)
               {
               //lRegen_Start_ID_FILE_SAVE
               //lRegen_Start_ID_FILE_SAVE
               szcdSaveFilePath[0] = '\0';
               ofcdSave.lStructSize = sizeof(OPENFILENAME);
               ofcdSave.hwndOwner = hWnd;
               ofcdSave.lpstrFilter = szcdSaveFilter;
               ofcdSave.lpstrCustomFilter = (LPSTR)NULL;
               ofcdSave.nMaxCustFilter = 0L;
               ofcdSave.nFilterIndex = 0;
               ofcdSave.lpstrFile = szcdSaveFilePath;
               ofcdSave.nMaxFile = 256;
               ofcdSave.lpstrFileTitle = szcdSaveFileTitle;
               ofcdSave.nMaxFileTitle = sizeof(szcdSaveFileTitle);
               ofcdSave.lpstrInitialDir = NULL;
               ofcdSave.lpstrTitle = (LPSTR)"Save File Dialog";
               ofcdSave.Flags = 0;
               ofcdSave.nFileOffset = 0;
               ofcdSave.nFileExtension = 0;
               ofcdSave.lpstrDefExt = (LPSTR)"*.*";
               GetSaveFileName(&ofcdSave);
               //Regen_End_ID_FILE_SAVE
               //Regen_End_ID_FILE_SAVE
               }
               return(TRUE);

            case IDC_ABOUT :
               if(HIWORD(lParam) == BN_CLICKED)
               {
               //lRegen_Start_IDC_ABOUT
               //lRegen_Start_IDC_ABOUT
               if(fnAboutBox(hWnd, 0, NULL))
               {
               }
               //Regen_End_IDC_ABOUT
               //Regen_End_IDC_ABOUT
               }
               return(TRUE);

            case ID_FILE_PRINT :
               if(HIWORD(lParam) == BN_CLICKED)
               {
               //lRegen_Start_ID_FILE_PRINT
               //lRegen_Start_ID_FILE_PRINT
               memset(&pd, 0, sizeof(PRINTDLG));
               pd.lStructSize = sizeof(PRINTDLG);
               pd.hwndOwner = hWnd;
               pd.Flags = 0;
               pd.nFromPage = 0;
               pd.nToPage   = 0;
               pd.nCopies   = 0;
               PrintDlg(&pd);
               //Regen_End_ID_FILE_PRINT
               //Regen_End_ID_FILE_PRINT
               }
               return(TRUE);

            case ID_FILE_NEW :
               //Regen_ID_FILE_NEW
               //Regen_ID_FILE_NEW
               break; 

            case ID_EDIT_CUT :
               //Regen_ID_EDIT_CUT
	       lstrcpy(szClipboard," ");
	       lstrcpy(szHiString," ");
	       lstrcpy(szLoString," ");
	       vwDoAppToScr(View,IDC_CLIPBOARD);
	       vwUpdateScreen(vwGetView(GetParent(hWnd)));
               //Regen_ID_EDIT_CUT
               break; 

            case ID_EDIT_COPY :
               //Regen_ID_EDIT_COPY


               // get the data from the clipboard edit field and copy it
               // to the clipboard

               vwDoScrToApp (View, IDC_CLIPBOARD);

               vwClipboardCopyText (hWnd, szClipboard, sizeof(szClipboard));


               //Regen_ID_EDIT_COPY
               break; 

            case ID_EDIT_PASTE :
               //Regen_ID_EDIT_PASTE
	       fnPutText(hWnd);
               //Regen_ID_EDIT_PASTE
               break; 

            case IDC_CLIPBOARD :
               //Regen_IDC_CLIPBOARD
               //Regen_IDC_CLIPBOARD
               break; 

            case IDC_COPY_LABEL :
               //Regen_IDC_COPY_LABEL
               //Regen_IDC_COPY_LABEL
               break; 

            case IDC_TIME :
               //Regen_IDC_TIME
               //Regen_IDC_TIME
               break; 

            //lRegen_CustomCommand
            //lRegen_CustomCommand
            }
            break;

   }
   return DefViewProc(hWnd, wMessage, wParam, lParam);
}

//Regen_CustomCode

char * szShowTime (void)

{
   static struct dostime_t   PPSTime;
   static char   szBuffer[20];

   _dos_gettime (&PPSTime);
   if (PPSTime.hour == 0)
     wsprintf (szBuffer, " %d:%02d:%02d AM", 12, PPSTime.minute, PPSTime.second);
   else if (PPSTime.hour > 0 && PPSTime.hour < 12)
     wsprintf (szBuffer, " %d:%02d:%02d AM", PPSTime.hour, PPSTime.minute, PPSTime.second);
   else if (PPSTime.hour == 12)
     wsprintf (szBuffer, " %d:%02d:%02d PM", 12, PPSTime.minute, PPSTime.second);
   else if (PPSTime.hour > 12)
     wsprintf (szBuffer, " %d:%02d:%02d PM", PPSTime.hour-12, PPSTime.minute, PPSTime.second);

//   return ( "10:12 PM" );
   return ( szBuffer );
}


void fnPutText(HWND hWnd) {


  if (bHiPrintPos) {
    lstrcpy(szLoString," ");
    lstrcpy(szHiString,szClipboard);
  }
  if (bLoPrintPos) {
    lstrcpy(szHiString," ");
    lstrcpy(szLoString,szClipboard);
  }
  vwUpdateScreen(vwGetView(GetParent(hWnd)));
  //vwPaintField(vwGetView(GetParent(hWnd)),IDC_PVSTRING1);
  //vwPaintField(vwGetView(GetParent(hWnd)),IDC_PVSTRING2);
}





//Regen_CustomCode
