/*
Name      ZAPCHK
Author    BF GAVIN
Format    Standard .EXE file format.
Intent    Patch CHKDSK.EXE v6.2 to not display SCANDISK hype message.

Model     SMALL
Compiler  Borland C v3.1, all warnings enabled.

Usage     No command line parms.
08DEC93   Release date

Needs     CHKDSK.EXE in the current path.
          Must use PKLITE -x to unpack CHKDSK.EXE first.

Remark    Unique signature code is at: 0x3A38

Method    Calls to SCANDISK advertising message are NOP'd out.
          Carry flag for CHKDSK /F hard coded to NC (yes).

*/

#include <conio.h>;                             // clrscr prototype
#include <stdio.h>;                             // printf prototype
#include <stdlib.h>;                            // exit   prototype
#include <string.h>;                            // cmpstr prototype


FILE
  *f;                                          // file handle

unsigned long int
  FilePos,
  PatchAddr = 0x3A38L;                          // patch offset in CHKDSK.EXE

unsigned int
  ErrLvl,                                       // errorlevel exit code
  Idx,                                          // string compare index
  OK;                                           // signature compare flag

unsigned char
  buffer [17],                                  // disk read buffer

  OldValue [17] = {
                  0xE8, 0xF9, 0x04,             // Call CHKDSK /F message
                  0x72, 0x09,                   // Jc   37D6 - skip chkdsk
                  0xE8, 0xF6, 0x03,             // ChkDsk program calls
                  0xE8, 0x10, 0x04,             //   ..
                  0xE8, 0x14, 0x04,             //   ..
                  0xE8, 0xCE, 0x04              // Call SCANDISK hype message
                  },

  NewValue [17] = {
                  0x90, 0x90, 0x90,             // NOP  the message call
                  0x90, 0xF8,                   // CLC  always return 'YES'
                  0xE8, 0xF6, 0x03,             // ChkDsk program calls
                  0xE8, 0x10, 0x04,
                  0xE8, 0x14, 0x04,
                  0x90, 0x90, 0x90              // NOP  the message call
                  };

void main()
  {
  clrscr();                                     // clear the screen
  printf ("Patch file courtesy Online Reference\n");

  if ((f = fopen("CHKDSK.EXE","r+b")) == NULL)  // open for binary r/w mode
     {
     printf ("Unable to open CHKDSK.EXE for read/write access\n\n");
     exit(1);                                   // exit with ERRORLEVEL set
     }

  fseek (f,PatchAddr,SEEK_SET);                 // seek to CHKDSK patch area
  fread (buffer,17,sizeof(char),f);             // read it

  ErrLvl = 0;                                   // set initial exit code
  OK = 0;                                       // Non-Zero is miscompare
  for (Idx=0;Idx<17;Idx++)                      // signature non-compare?
      if (OldValue[Idx] != buffer[Idx])         // y: complain and quit
         OK++;                                  // increment flag to non-zero

  if (OK == 0)                                  // file match signature?
     {                                          // y: ok to patch the file
     fseek (f,PatchAddr,SEEK_SET);              // seek back to patch address
     fwrite (NewValue,17,sizeof(char),f);       // write patch data to CHKDSK.EXE
     printf("CHKDSK.EXE v6.2 is patched.\n");   // display success message
     printf("The SCANDISK advertising messages will no longer display.\n");
     }
  else
     {
     printf ("Signature verify failed.  Unable to patch CHKDSK.EXE\n");
     ErrLvl++;                                  // set errorlevel 1
     }

  fclose(f);                                    // close CHKDSK.EXE file
  printf ("\n");                                // trailing CRLF
  exit (ErrLvl);                                // return errorlevel 0 or 1
  }
