// File    : BLDRSC.CPP
// Author  : Eric Woodruff
// Updated : Thu 03/10/94 19:57:52
// Note    : Copyright 1993-94, Eric Woodruff, All Rights Reserved
// Compiler: Borland C++ 3.1/4.0
//
// This file contains the standard resource file builder.
// Modify or add the necessary items and compile.
//

#define RSC_FILENAME    "MSGTST.RSC"      // File to create.

#define WriteResource(a,b,c) \
    cout << c << endl; \
    a = b(); \
    if( a == 0 ) \
    { \
        strcpy(endString, RSC_FILENAME ": Creation failure\n"); \
        TObject::destroy(rsc); \
        exit(1); \
    } \
    rsc->put(a,c); \
    TObject::destroy(a)

#define WriteObject(a,c) \
    cout << c << endl; \
    if(a == 0) \
    { \
        strcpy(endString, RSC_FILENAME ": Creation failure\n"); \
        TObject::destroy(rsc); \
        exit(1); \
    } \
    rsc->put(a,c); \
    TObject::destroy(a)

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define Uses_TApplication
#define Uses_TButton
#define Uses_TCheckBoxes
#define Uses_TColorDialog
#define Uses_TColorGroup
#define Uses_TColorItem
#define Uses_TDialog
#define Uses_TInputLine
#define Uses_TKeys
#define Uses_TLabel
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TProgram
#define Uses_TRadioButtons
#define Uses_TRect
#define Uses_TResourceFile
#define Uses_TSItem
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TSubMenu
#define Uses_TView
#define Uses_TVCOLR             // Use this if you modified the TV.H file.
#define Uses_fpstream
#include <tv.h>

#if !defined(cpDefSize)
// Use this if you chose not to modify the Turbo Vision files.
#include <tvcolr.h>
#endif

#include <msginpbx.h>

#include "link.h"
#include "msgtst.h"

// ============================================================================
TDialog *Colors(void);
TMenuBar *initMenuBar(void);
TStatusLine *initStatusLine(void);

TDialog *makeTextDialog(void);
TDialog *makeParamDialog(void);

// ============================================================================

fpstream *s;
TResourceFile* rsc;
char endString[255] = "";

// ============================================================================

void exitfunc(void)
{
   cout << endl << endString << endl;
}

#pragma exit exitfunc 31

void main(void)
{
    TDialog *dlg;
    TMenuBar *menuBar;
    TStatusLine *statusLine;

    // Return code variable used by the message/input box builder.
    short RetCode;

    cout << "Creating " RSC_FILENAME << endl;

    // Construct stream and resource.
    s = new fpstream (RSC_FILENAME, ios::trunc | ios::binary);
    rsc = new TResourceFile(s);

    // Create all of the necessary dialogs for the application.
//    dlg = makeMsgDialog("About", 1, mdNoButtons, ECode,
//        mdXTime | mdInfoColor, 4,
//        "\003Message Box Demo - "    // \003 = Center lines.
//        "Version 1.00\n"             // \n = Start new line.
//        "\003by Eric Woodruff\n\n"   // \n\n = Make a blank line.
//        "\003CIS ID: 72134,1150");
//    WriteObject(dlg, "AboutBox");

    WriteResource(dlg, Colors, "ColorDlg");

    WriteResource(dlg, makeTextDialog, "TextDialog");
    WriteResource(dlg, makeParamDialog, "ParamDialog");

    // Create a message dialog box for writing to the stream.  Note that you
    // cannot pass variable parameters to the message lines in the main
    // application when restoring a message or input box from a stream, but
    // you can when you create it.  Here, the #defined resource filename
    // goes into creating a constant string for the message dialog box.
    dlg = makeMsgDialog("Message Box from a resource file", 2, mdOKOnly,
                        RetCode, mdTimeBeep, 10, mdShortBeep, mdMedPitch,
                        "Had a beep and will close in 10 seconds",
                        "Read from resource file %s", RSC_FILENAME);

    WriteObject(dlg, "StrmMsgBox");

    // It is important that when you create an input box this way, you
    // insure that the message length and optional history id are accurate!
    dlg = makeMsgDialog("Input Box from a resource file", 1, mdYesNoCancel,
                        RetCode, mdTimeBeepHis, 10, mdMediumBeep, mdHighPitch,
                        TEST_STR_SIZE, HISTORY_ID,
                        "This had a beep, will close in 10 seconds, and"
                        " has an input line with history.  The data will"
                        " show up in TestString if <Yes> is selected.");

    WriteObject(dlg, "StrmInpBox");

    // Create the menus and status line.
    WriteResource(menuBar, initMenuBar, "MenuBar");
    WriteResource(statusLine, initStatusLine, "StatusLine");

    TObject::destroy(rsc);
    strcpy(endString, RSC_FILENAME " creation completed.");
}

// ============================================================================
TDialog *Colors(void)
{
    TColorGroup &group1 =
        *new TColorGroup("Desktop") +
            *new TColorItem("Background",        1)+

        *new TColorGroup("Menus") +
            *new TColorItem("Normal text",       2)+
            *new TColorItem("Disabled text",     3)+
            *new TColorItem("Shortcut key",      4)+
            *new TColorItem("Selection bar",     5)+
            *new TColorItem("Selected disabled", 6)+
            *new TColorItem("Shortcut selected", 7);

    TColorGroup &group2 =
        *new TColorGroup("Blue Window") +
            *new TColorItem("Frame inactive",    8)+
            *new TColorItem("Frame active",      9)+
            *new TColorItem("Frame icons",      10)+
            *new TColorItem("Scrollbar page",   11)+
            *new TColorItem("Scrollbar icons",  12)+
            *new TColorItem("Normal text",      13)+
            *new TColorItem("Selected text",    14)+

        *new TColorGroup("Cyan Window") +
            *new TColorItem("Frame inactive",  16)+
            *new TColorItem("Frame active",    17)+
            *new TColorItem("Frame icons",     18)+
            *new TColorItem("Scrollbar page",  19)+
            *new TColorItem("Scrollbar icons", 20)+
            *new TColorItem("Normal text",     21)+
            *new TColorItem("Selected text",   22)+

        *new TColorGroup("Gray Window") +
            *new TColorItem("Frame inactive",  24)+
            *new TColorItem("Frame active",    25)+
            *new TColorItem("Frame icons",     26)+
            *new TColorItem("Scrollbar page",  27)+
            *new TColorItem("Scrollbar icons", 28)+
            *new TColorItem("Normal text",     29)+
            *new TColorItem("Selected text",   30) +

        *new TColorGroup("Dialog Box") +
            *new TColorItem("Frame inactive",   32)+
            *new TColorItem("Frame active",     33)+
            *new TColorItem("Frame icons",      34)+
            *new TColorItem("Scrollbar page",   35)+
            *new TColorItem("Scrollbar icons",  36);

    TColorGroup &group3 =
        // The last four Dialog Text colors can be set, but are only
        // accessible when using the alternate mapColor() routine.
        // from TVCOLR.ZIP.
        *new TColorGroup("Dialog Text") +
            *new TColorItem("Normal",       37)+
            *new TColorItem("Information",  cCTxtInfoColor)+    // Extended
            *new TColorItem("Notification", cCTxtNotifyColor)+  // Extended
            *new TColorItem("Warning",      cCTxtWarnColor)+    // Extended
            *new TColorItem("Error",        cCTxtErrorColor)+   // Extended

        // Selected Shortcut is only applicable if you made the
        // changes described in COLUPDT.DOC in TVCOLR.ZIP.
        *new TColorGroup("Dialog Label") +
            *new TColorItem("Normal",            38)+
            *new TColorItem("Selected",          39)+
            *new TColorItem("Shortcut key",      40)+
#ifdef MODIFIED_TV_COLORS
            *new TColorItem("Selected shortcut", 66)+   // Added
#endif

        // Default and Selected Shortcut are only applicable if you made
        // the changes described in COLUPDT.DOC in TVCOLR.ZIP
        *new TColorGroup("Dialog Button") +
            *new TColorItem("Normal",            41)+
            *new TColorItem("Default",           42)+
            *new TColorItem("Selected",          43)+
            *new TColorItem("Disabled",          44)+
            *new TColorItem("Shortcut key",      45)+
#ifdef MODIFIED_TV_COLORS
            *new TColorItem("Default shortcut",  64)+   // Added
            *new TColorItem("Selected shortcut", 65)+   // Added
#endif
            *new TColorItem("Shadow",            46)+

        *new TColorGroup("Dialog Cluster") +
            *new TColorItem("Normal",    47)+
            *new TColorItem("Selected",  48)+
            *new TColorItem("Shortcut",  49);

    TColorGroup &group4 =
        *new TColorGroup("Dialog Input") +
            *new TColorItem("Input normal",      50)+
            *new TColorItem("Input selected",    51)+
            *new TColorItem("Input arrow",       52)+
            *new TColorItem("History button",    53)+
            *new TColorItem("History sides",     54)+
            *new TColorItem("History scrollbar", 55)+
            *new TColorItem("History icons",     56)+

        *new TColorGroup("Dialog List") +
            *new TColorItem("Normal item",       57)+
            *new TColorItem("Focused item",      58)+
            *new TColorItem("Selected item",     59)+
            *new TColorItem("Divider",           60)+
            *new TColorItem("Information pane",  61)+

#ifdef MODIFIED_TV_COLORS
        *new TColorGroup("Help Window") +
            *new TColorItem("Frame inactive",   67)+
            *new TColorItem("Frame active",     68)+
            *new TColorItem("Frame icons",      69)+
            *new TColorItem("Scrollbar page",   70)+
            *new TColorItem("Scrollbar icons",  71)+
            *new TColorItem("Normal text",      72)+
            *new TColorItem("Keyword",          73)+
            *new TColorItem("Selected keyword", 74);
#else
        *new TColorGroup("Help Window") +
            *new TColorItem("Frame inactive",   64)+
            *new TColorItem("Frame active",     65)+
            *new TColorItem("Frame icons",      66)+
            *new TColorItem("Scrollbar page",   67)+
            *new TColorItem("Scrollbar icons",  68)+
            *new TColorItem("Normal text",      69)+
            *new TColorItem("Keyword",          70)+
            *new TColorItem("Selected keyword", 71);
#endif

    TColorGroup &group5 = group1 + group2 + group3 + group4;

    // See the notes in handleEvent() about the proper usage of TColorDialog.
    TColorDialog *c = new TColorDialog((TPalette*)0, &group5);

    return c;
}

TMenuBar *initMenuBar(void)
{
    TSubMenu& MiscMenu = *new TSubMenu( "~\xF0~", 0) +
        *new TMenuItem( "~A~bout...", cmAbout, kbNoKey)+
        *new TMenuItem( "~R~epaint desktop", cmRepaint, kbNoKey) +
            newLine() +
        *new TMenuItem( "~D~OS shell", cmDOSshell, kbNoKey) +
        *new TMenuItem( "~Q~uit", cmQuit, kbAltX, hcNoContext, "Alt+X" );

    TSubMenu& FileMenu = *new TSubMenu("~M~essage/Input Boxes", 0) +
        *new TMenuItem("~B~utton Menu", cmButtonMenu, kbF2, hcNoContext, "F2")+
        *new TMenuItem("~C~hange Text", cmChgText, kbF3, hcNoContext, "F3")+
        *new TMenuItem("~T~est Message Box", cmTestMsgBox, kbF4, hcNoContext, "F4")+
        *new TMenuItem("T~e~st Input Box", cmTestInpBox, kbF5, hcNoContext, "F5")+
        *new TMenuItem("M~s~gBox on Stream", cmStrmMsgBox, kbF6, hcNoContext, "F6")+
        *new TMenuItem("~I~npBox on Stream", cmStrmInpBox, kbF7, hcNoContext, "F7")+
        *new TMenuItem("~F~ormatted Message Test", cmFormatTest, kbF8, hcNoContext, "F8");

    TSubMenu& WindowMenu = *new TSubMenu( "~W~indows", 0) +
//        *new TMenuItem( "~S~ize/Move", cmResize, kbCtrlF5, hcNoContext, "Ctrl+F5" ) +
//        *new TMenuItem( "~Z~oom", cmZoom, kbF5, hcNoContext, "F5" ) +
//        *new TMenuItem( "C~a~scade", cmCascade, kbNoKey) +
//        *new TMenuItem( "~T~ile", cmTile, kbNoKey) +
//        *new TMenuItem( "Ne~x~t", cmNext, kbF6, hcNoContext, "F6" ) +
//        *new TMenuItem( "~P~revious", cmPrev, kbShiftF6, hcNoContext, "Shift+F6" ) +
//        *new TMenuItem( "~C~lose", cmClose, kbAltF3, hcNoContext, "Alt+F3" ) +
//        *new TMenuItem( "Clos~e~ all", cmCloseTileable, kbNoKey) +
//            newLine() +
        *new TMenuItem( "To~g~gle Screen Size", cmScreenSize, kbNoKey) +
        *new TMenuItem( "~U~ser screen", cmUserScreen, kbAltF5, hcNoContext, "Alt+F5");

    TSubMenu& OptionsMenu = *new TSubMenu("~O~ptions", 0) +
        *new TMenuItem( "~C~olors...", cmColors, kbNoKey ) +
        *new TMenuItem( "C~h~ange palettes", cmChangePalettes, kbNoKey ) +
            newLine() +
        *new TMenuItem( "~L~oad configuration...", cmLoadCfg, kbNoKey) +
        *new TMenuItem( "~S~ave configuration...", cmSaveCfg, kbNoKey);

    return new TMenuBar(TRect(0, 0, 80, 1), MiscMenu + FileMenu +
        WindowMenu + OptionsMenu);
}

TStatusLine *initStatusLine(void)
{
    return new TStatusLine( TRect(0, 24, 80, 25),
      *new TStatusDef( 0, 0xFFFF ) +
        *new TStatusItem( NULL, kbF10, cmMenu ) +
        *new TStatusItem( "~Alt+X~ Exit", kbAltX, cmQuit ) +
        *new TStatusItem( "~F2~ Button Menu", kbF2, cmButtonMenu));
}

// The following two dialog boxes are used for the sole purpose of putting
// the Message Box/Input Box library through its paces.  These are in no way
// required for using the library or functions themselves.
TDialog *makeTextDialog(void)
{
    TDialog* dlg = new TDialog(TRect(0,0,80,23), "Set Dialog Texts");
    if(!dlg)
        return 0;

    dlg->options |= ofCentered;

    TInputLine *i = new TInputLine(TRect(12,2,43,3), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(2,2,11,3), "Line #1:", i));

    i = new TInputLine(TRect(12,3,43,4), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(2,3,11,4), "Line #2:", i));

    i = new TInputLine(TRect(12,4,43,5), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(2,4,11,5), "Line #3:", i));

    i = new TInputLine(TRect(12,5,43,6), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(2,5,11,6), "Line #4:", i));

    i = new TInputLine(TRect(12,6,43,7), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(2,6,11,7), "Line #5:", i));

    i = new TInputLine(TRect(12,7,43,8), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(2,7,11,8), "Line #6:", i));

    i = new TInputLine(TRect(12,8,43,9), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(2,8,11,9), "Line #7:", i));

    i = new TInputLine(TRect(12,9,43,10), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(2,9,11,10), "Line #8:", i));

    i = new TInputLine(TRect(12,10,43,11), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(2,10,11,11), "Line #9:", i));

    i = new TInputLine(TRect(12,11,43,12), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(1,11,11,12), "Line #10:", i));

    i = new TInputLine(TRect(12,12,43,13), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(1,12,11,13), "Line #11:", i));

    i = new TInputLine(TRect(12,13,43,14), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(1,13,11,14), "Line #12:", i));

    i = new TInputLine(TRect(12,14,43,15), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(1,14,11,15), "Line #13:", i));

    i = new TInputLine(TRect(12,15,43,16), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(1,15,11,16), "Line #14:", i));

    i = new TInputLine(TRect(12,16,43,17), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(1,16,11,17), "Line #15:", i));

    i = new TInputLine(TRect(12,17,43,18), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(1,17,11,18), "Line #16:", i));

    i = new TInputLine(TRect(57,2,78,3), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(45,2,56,3), "Button #1:", i));

    i = new TInputLine(TRect(57,3,78,4), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(45,3,56,4), "Button #2:", i));

    i = new TInputLine(TRect(57,4,78,5), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(45,4,56,5), "Button #3:", i));

    i = new TInputLine(TRect(57,5,78,6), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(45,5,56,6), "Button #4:", i));

    i = new TInputLine(TRect(57,6,78,7), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(45,6,56,7), "Button #5:", i));

    i = new TInputLine(TRect(57,7,78,8), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(45,7,56,8), "Button #6:", i));

    i = new TInputLine(TRect(57,8,78,9), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(45,8,56,9), "Button #7:", i));

    i = new TInputLine(TRect(57,9,78,10), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(45,9,56,10), "Button #8:", i));

    i = new TInputLine(TRect(57,10,78,11), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(45,10,56,11), "Button #9:", i));

    i = new TInputLine(TRect(57,11,78,12), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(44,11,56,12), "Button #10:", i));

    i = new TInputLine(TRect(57,12,78,13), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(44,12,56,13), "Button #11:", i));

    i = new TInputLine(TRect(57,13,78,14), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(44,13,56,14), "Button #12:", i));

    i = new TInputLine(TRect(57,14,78,15), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(44,14,56,15), "Button #13:", i));

    i = new TInputLine(TRect(57,15,78,16), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(44,15,56,16), "Button #14:", i));

    i = new TInputLine(TRect(57,16,78,17), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(44,16,56,17), "Button #15:", i));

    i = new TInputLine(TRect(2,20,43,21), TEXT_SIZE);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(1,19,43,20), "Message Dialog Title:", i));

    TButton *b = new TButton(TRect(46,19,58,21), "O~K~", cmOK, bfDefault);
    dlg->insert(b);

    b = new TButton(TRect(62,19,74,21), "Cancel", cmCancel, bfNormal);
    dlg->insert(b);

    dlg->selectNext(False);
    return dlg;
}

TDialog *makeParamDialog(void)
{
    TDialog* dlg = new TDialog(TRect(0,0,80,23), "Test Parameters");
    if(!dlg)
        return 0;

    dlg->options |= ofCentered;

    TRadioButtons *r = new TRadioButtons(TRect(2,3,16,20),
      new TSItem("No Text",
      new TSItem("1 Line",
      new TSItem("2 Lines",
      new TSItem("3 Lines",
      new TSItem("4 Lines",
      new TSItem("5 Lines",
      new TSItem("6 Lines",
      new TSItem("7 Lines",
      new TSItem("8 Lines",
      new TSItem("9 Lines",
      new TSItem("10 Lines",
      new TSItem("11 Lines",
      new TSItem("12 Lines",
      new TSItem("13 Lines",
      new TSItem("14 Lines",
      new TSItem("15 Lines",
      new TSItem("16 Lines", 0))))))))))))))))));
    dlg->insert(r);

    r = new TRadioButtons(TRect(20,1,45,22),
      new TSItem("No Buttons",
      new TSItem("OK Only",
      new TSItem("Cancel Only",
      new TSItem("OK and Cancel",
      new TSItem("Yes and No",
      new TSItem("Yes, No, and Cancel",
      new TSItem("1 Button",
      new TSItem("2 Buttons",
      new TSItem("3 Buttons",
      new TSItem("4 Buttons",
      new TSItem("5 Buttons",
      new TSItem("6 Buttons",
      new TSItem("7 Buttons",
      new TSItem("8 Buttons",
      new TSItem("9 Buttons",
      new TSItem("10 Buttons",
      new TSItem("11 Buttons",
      new TSItem("12 Buttons",
      new TSItem("13 Buttons",
      new TSItem("14 Buttons",
      new TSItem("15 Buttons", 0))))))))))))))))))))));
    dlg->insert(r);

    TCheckBoxes *x = new TCheckBoxes(TRect(49,1,75,4),
      new TSItem("Will explode/implode",
      new TSItem("Has a History Button",
      new TSItem("Input is a password", 0))));
    dlg->insert(x);

    TRadioButtons *y = new TRadioButtons(TRect(49,5,77,10),
      new TSItem("Use normal color",
      new TSItem("Use information color",
      new TSItem("Use notification color",
      new TSItem("Use warning color",
      new TSItem("Use error color", 0))))));
    dlg->insert(y);

    TInputLine *i = new TInputLine(TRect(69,11,76,12), 3);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(47,11,68,12), "Max Input Line Size:", i));

    i = new TInputLine(TRect(69,12,76,13), 5);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(46,12,68,13), "Time Limit (seconds):", i));

    i = new TInputLine(TRect(69,13,76,14), 5);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(48,13,68,14), "Beep (1/4 seconds):", i));

    i = new TInputLine(TRect(69,14,76,15), 5);
    dlg->insert(i);
    dlg->insert(new TLabel(TRect(56,14,68,15), "Beep Pitch:", i));

    TButton *b = new TButton(TRect(56,17,70,19), "O~K~", cmOK, bfDefault);
    dlg->insert(b);

    b = new TButton(TRect(56,20,70,22), "~S~top", cmCancel, bfNormal);
    dlg->insert(b);

    dlg->selectNext(False);
    return dlg;
}
