// File    : MAPCOLOR.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Tue 02/08/94 10:27:43
// Note    : Hereby declared public domain
// Compiler: Borland C++ 3.1/4.0
//
// NOTICE:
// All Borland International copyrights remain in effect as this is
// only a replacement function and an extension to the normal Turbo Vision
// code.  I make no claim of ownership or copyright to this code.
// Although the basic concept is derived from Turbo Vision's mapColor(),
// this code is entirely of my own creation.
//

#define Uses_TView
#define Uses_TGroup
#define Uses_TVCOLR     // Get size of default palette (cpDefSize).
#include <tv.h>

#if !defined(cpDefSize)
// Use this if you choose not to modify the Turbo Vision files.
#include <tvcolr.h>
#endif

// ****************************************************************************
// Provide proper mapping for the extended colors.  If an extended color is
// referenced, the attribute is retrieved directly from the main application
// palette instead of mapping it onto any subsequent owning views.
uchar TView::mapColor(uchar color)
{
    TPalette *p;
    TView *cur;

    for(cur = this; cur ; cur = cur->owner)
    {
        p = &cur->getPalette();
        if(p->data[0])
        {
            // It's an error to try and exceed the palette length.
            if(color > p->data[0])
                return errorAttr;         // Mistake. Return error color.

            if(p->data[color] > cpDefSize && cur->owner)
            {
                color = p->data[color];    // Get index.

                while(cur->owner)          // Move to base palette.
                    cur = cur->owner;

                // Retrieve color from base application palette.
                p = &cur->getPalette();
                color = p->data[color];
                break;
            }

            color = p->data[color];    // Map onto owner.
        }
    }

    return color;
}
