// Program : MSGTST.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Thu 03/10/94 19:57:52
// Note    : Copyright 1993-94, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 3.1/4.0
//
// This is the test program header file.
//

#define TEXT_SIZE       101
#define TEST_STR_SIZE    46
#define HISTORY_ID       12     // This is shared between the dynamic and
                                // resource file input boxes.

// These are data structures for the demo and test program.
struct TextRecord
{
    char Lines[16][TEXT_SIZE];
    char Buttons[15][TEXT_SIZE];
    char Title[TEXT_SIZE];
};

struct ParamRecord
{
    ushort LineCount;
    ushort ButtonCount;
    ushort Options;
    ushort Color;
    char   LineLen[3];
    char   MaxTime[5];
    char   BeepTime[5];
    char   Pitch[5];
};

// Test function to put the functions through their paces.
TDialog *makeTestDialog(void);

// Exit code values.
#define EXIT_NOERR      0
#define EXIT_RSCERR     1
#define EXIT_SYNTAX     2
#define EXIT_SWERR      3

const int
    cmAbout         = 100,      // Standard event values.
    cmRepaint       = 101,
    cmDOSshell      = 102,
    cmColors        = 103,
    cmChangePalettes = 104,
    cmLoadCfg       = 105,
    cmSaveCfg       = 106,
//    cmCloseTileable = 107,
    cmScreenSize    = 108,
    cmUserScreen    = 109,

    cmTestMsgBox = 110,         // Other command values.
    cmChgText    = 111,
    cmFormatTest = 112,
    cmButtonMenu = 113,
    cmQuitMenu   = 114,
    cmTestInpBox = 115,
    cmStrmMsgBox = 116,
    cmStrmInpBox = 117;

// ***************************************************************************

//class far THeapView;

class TDemoApp : public TApplication
{
//private:
//    THeapView *heap;
//
public:
    TDemoApp();
    static TMenuBar *initMenuBar( TRect r );
    static TStatusLine *initStatusLine( TRect r );
    static TDeskTop *initDeskTop(TRect r);

    virtual void initScreen();                  // Sets correct palette.
    virtual void idle(void);
    virtual void handleEvent(TEvent& Event);
    virtual void outOfMemory(void);
    virtual TPalette& getPalette() const;

    void loadConfig(Boolean UseFileSetting);
    void saveConfig(void);

    void FormatTest(void);
};

// A couple of useful functions.
ushort execDialog(TDialog *d, void *data);
//Boolean isTileable(TView *p, void *);
