// File    : TVCOLR.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Tue 02/08/94 20:54:28
// Note    : Hereby declared public domain
// Compiler: Borland C++ 3.1/4.0
//
// Easy extensions to the colors for Turbo Vision applications.
// Complete documentation for this method can be found by downloading
// TVCOLR.ZIP from the BCPPDOS forum of CompuServe.
//
// This copy contains fewer comments on how to add extended colors so
// that you can get an uncluttered view of how it works.
// See TVCOLR.HDC for a fully commented view of how it works.
//
// NOTE: If you modify this file, modify TVCOLR.HDC accordingly!!
//

#if !defined( __TVCOLR_H )
#define __TVCOLR_H

#if !defined(cpColor)
#define  Uses_TProgram
#include <tv.h>             // Get the standard colors defined.
#endif

#if !defined(cHelpColor)
class far fpstream;
#include <helpbase.h>       // Get the help colors defined.
#endif

// An alternate color palette attributes map.
// I have added two colors to TButton and one color to TLabel for when those
// objects are selected that the default Turbo Vision doesn't have.  If the
// definition MODIFIED_TV_COLORS appears in APP.H, then those three extra
// colors will be defined here.

#if defined(MODIFIED_TV_COLORS)

#define cpAltColor \
    "\x07\x70\x76\x74\x17\x08\x1B\x07\x03\x0B\x70\x70\x07\x70" \
    "\x00\x37\x3F\x3A\x13\x13\x3F\x1F\x00\x70\x7F\x7A\x13\x13" \
    "\x70\x7F\x00\x70\x7F\x7A\x13\x13\x70\x70\x6F\x7E\x1B\x1F" \
    "\x6F\x10\x1E\x70\x30\x3F\x3E\x1B\x4F\x1A\x20\x70\x07\x70" \
    "\x30\x1B\x3E\x31\x13\x00\x00\x1D\x6E\x6E"

#else

#define cpAltColor \
    "\x07\x70\x76\x74\x17\x08\x1B\x07\x03\x0B\x70\x70\x07\x70" \
    "\x00\x37\x3F\x3A\x13\x13\x3F\x1F\x00\x70\x7F\x7A\x13\x13" \
    "\x70\x7F\x00\x70\x7F\x7A\x13\x13\x70\x70\x6F\x7E\x1B\x1F" \
    "\x6F\x10\x1E\x70\x30\x3F\x3E\x1B\x4F\x1A\x20\x70\x07\x70" \
    "\x30\x1B\x3E\x31\x13\x00\x00"

#endif

// An Alternate Color help window attribute map.
#define cAltHelpColor "\x67\x6F\x6E\x76\x76\x6F\x6E\x1E"

// Define any other palette names and the total number of available palettes.
// For additional palettes, start numbering them at 3.  They must come
// after the regular color, black and white, and monochrome sets because
// apColor, apBlackWhite, and apMonochrome are defined as 0 through 2.
#define apAltColor         3        // Alternate color palette.

#define apTotalPalettes    4        // Color, B&W, Monochrome, Alt. Color.

// Define the default extended color sets (regular colors + help colors).
//
// If the default TV colors have not been modified as described in
// COLUPDT.DOC, some padding is added so that the indices below come out
// the same regardless of this optional change.
//
#if defined(MODIFIED_TV_COLORS)

#define cpDefAltColor       cpAltColor cAltHelpColor
#define cpDefColor          cpColor cHelpColor
#define cpDefBlackWhite     cpBlackWhite cHelpBlackWhite
#define cpDefMonochrome     cpMonochrome cHelpMonochrome

#else

#define cpDefAltColor       cpAltColor cAltHelpColor "\x07\x07\x07"
#define cpDefColor          cpColor cHelpColor "\x07\x07\x07"
#define cpDefBlackWhite     cpBlackWhite cHelpBlackWhite "\x07\x07\x07"
#define cpDefMonochrome     cpMonochrome cHelpMonochrome "\x07\x07\x07"

#endif

// Define the default size.  Doesn't matter which one we use because they are
// all the same size.
#define cpDefSize           sizeof(cpDefColor) - 1  // Less 1 for the NULL!

// ****************************************************************************
// ^^^^^^     NOTHING ABOVE THIS POINT WILL EVER CHANGE AND MUST NOT     ^^^^^^
//                     (Unless you add more color palettes)
// ****************************************************************************
//
// Extended color definitions:
//
// 1. TColorText additional color attributes.
//
#define cpColorTextAltColor   "\x1B\x1F\x4F\x4E"    // Alt color palette
#define cpColorTextColor      "\x1B\x1F\x4F\x4E"    // Color palette
#define cpColorTextBlackWhite "\x70\x7F\x07\x0F"    // B&W palette
#define cpColorTextMonochrome "\x70\x01\x0F\x0F"    // Monochrome palette

// 2. Define the indices into the extended application palettes.
//
#define cCTxtInfoColor      cpDefSize + 1       // Information color
#define cCTxtNotifyColor    cpDefSize + 2       // Notification color
#define cCTxtWarnColor      cpDefSize + 3       // Warning color
#define cCTxtErrorColor     cpDefSize + 4       // Error color

// ****************************************************************************
// vvvvvv       Additional extended color definitions will go here       vvvvvv
// ****************************************************************************
// TMsgViewWindow and TMsgListViewer

#define cpMsgDlgAltColor   "\x48\x4E\x4F\x74\x74\x4F\x6E\x4E"
#define cpMsgDlgColor      "\x48\x4E\x4F\x74\x74\x4F\x6E\x4E"
#define cpMsgDlgBlackWhite "\x78\x7F\x7F\x70\x70\x70\x07\x7F"
#define cpMsgDlgMonochrome "\x70\x70\x0F\x0F\x0F\x70\x0F\x01"

#define cMsgFramePassive    cCTxtErrorColor + 1   // Frame passive
#define cMsgFrameActive     cCTxtErrorColor + 2   // Frame active
#define cMsgFrameIcon       cCTxtErrorColor + 3   // Frame icons
#define cMsgSBPage          cCTxtErrorColor + 4   // Scrollbar page
#define cMsgSBCtrl          cCTxtErrorColor + 5   // Scrollbar controls
#define cMsgNText           cCTxtErrorColor + 6   // Normal text
#define cMsgSText           cCTxtErrorColor + 7   // Selected/Focused text
#define cMsgSelected        cCTxtErrorColor + 8   // Selected (inactive) text

// TVMIndicator
#define cpIndAltColor      "\x60\x7F"
#define cpIndColor         "\x30\x7F"
#define cpIndBlackWhite    "\x70\x70"
#define cpIndMonochrome    "\x70\x70"

#define cIndEditWin        cMsgSelected + 1       // For Edit Windows
#define cIndMemoFld        cMsgSelected + 2       // For Memo Fields

// ****************************************************************************
// ^^^^^^       ALWAYS ADD ANY NEW DEFINITIONS JUST ABOVE THIS LINE      ^^^^^^
// ****************************************************************************
//
// 3. Define the full extended color sets.
//    NOTE: THESE DEFINES SHOULD ALWAYS BE HERE AT THE BOTTOM AND NOWHERE ELSE!
// ****************************************************************************

#define cpExtAltColor       cpDefAltColor cpColorTextAltColor \
                            cpMsgDlgAltColor cpIndAltColor

#define cpExtColor          cpDefColor cpColorTextColor cpMsgDlgColor \
                            cpIndColor

#define cpExtBlackWhite     cpDefBlackWhite cpColorTextBlackWhite \
                            cpMsgDlgBlackWhite cpIndBlackWhite

#define cpExtMonochrome     cpDefMonochrome cpColorTextMonochrome \
                            cpMsgDlgMonochrome cpIndMonochrome

#endif // __TVCOLR_H
