/*
 * MIDIMOD.H - Amiga Module to MIDI file converter header
 * Turbo C 2.0
 *
 * Author: Andrew Scott (Adrenalin Software)
 *
 * Date: 14/3/1993 ver 0.1
 */

/* File buffer size.. increase for better performance */
#define BUFFSIZE 512

/* Max line length in text files */
#define MAXSTRING 128

/* MIDI drum channel - 1 */
#define DRUMCHANN 9

/* MIDI instrument file */
#define DEF_INSFILE "midimod.ins"

/* MOD sample to MIDI instrument map */
#define DEF_MAPFILE "midimod.map"

typedef char *string;

typedef struct bstruct {
	FILE *f;                   /* File to read/write to */
	unsigned char b[BUFFSIZE]; /* Holds buffer data */
	unsigned int o, r;         /* Offset in buffer, Bytes actually read */
} bfile[1];

struct bpos {
	struct bstruct d; /* file data */
	unsigned long p;  /* file position */
};

typedef struct _X3 {
	char n[23];         /* Sample name */
	unsigned int l;     /* Number of ticks in length (4000 per second) */
	unsigned char v, m; /* Volume of sample, Midi instrument */
	signed char c;      /* Midi channel */
	int t[3];           /* Transposition amounts */
} samp;

typedef struct _X4 {
	unsigned char n; /* Number of samples */
	samp s[31];      /* Sample information */
} samps[1];

string _IF[] = {
  "Please enter the filename for the",
	"",
	"",
	NULL
};

string _CNVE[] = {
	"Conversion Error:",
	"",
	"Both the MIDI and MOD files must be defined",
	"before conversion can take place.",
	NULL
};

string _MODE[] = {
	"Amiga Module Error:",
	"",
	"The MOD file you have chosen cannot be",
	"understood by this program.",
	NULL
};

string _NOFIL[] = {
	"File Error:",
	"",
	"Cannot locate the file",
	"",
	NULL
};

string _MODM[] = {
	"Amiga Module Error:",
	"",
	"There has been no MOD file defined yet, so",
	"no samples have been loaded.",
	NULL
};

string _OOME[] = {
	"Out Of Memory Error:",
	"",
	"For some reason, all of the available memory",
	"has been allocated, and this program cannot",
	"continue.",
	NULL
};

string _OUTE[] = {
	"Warning:",
	"",
	"You have chosen a file which already exists.",
	"Proceeding will overwrite this file. Press ",
	"the letter 'Y' if this is ok.",
	NULL
};

string _TMC[] = {
	"Instrument Error:",
	"",
	"You have selected too many different instruments.",
	"There is a maximum of 16 different instruments, ",
	"including 1 drum instrument. Please change your ",
	"selection.",
	NULL
};

string _NOSAV[] = {
	"File Access Error:",
	"",
	"The file " DEF_MAPFILE " cannot be replaced with",
	"an updated version. Any changes to the instrument-maps",
	"cannot be performed. Please exit from the program and",
	"set up the necessary access permissions on this file if",
	"you wish to use this command.",
	NULL
};

string _ABOUT[] = {
	"MIDIMOD ver 0.1 (c) Andrew Scott (Adrenalin Software) '93",
	"",
	"MIDIMOD is a utility that aids in the conversion of .MOD",
	"files (Amiga Sound/Noise/Protracker files) to MIDI files",
	"(General MIDI format 1 files). Many effects are converted",
	"but some cannot due to the differences between the two",
	"formats. A log of instrument-maps can be kept and updated",
	"to allow MIDIMOD to automatically allocate instruments &",
	"transpositions to known samples.",
	"",
	"Note: Some editting may be necessary after conversion due",
	"to the lack of information stored in the .MOD file. Also,",
	"MIDI players without tempo-track interpretting may not",
	"play the converted MIDI file properly.",
	NULL
};

string _TRAQ[] = {
	"Please enter a transposition value",
	"for the sample you have just selected,",
	"eg. '-12' for a bass guitar sample,",
	"'0,3,7' for a minor chord, or '0,4,7'",
	"for a major chord are usual.",
	"",
	NULL
};

string _TRANE[] = {
	"Transposition Error:",
	"",
	"You cannot set transposition values outside",
	"the range -128 to 127. Much smaller values",
	"are usual anyway. Your transposition is being",
	"reset back to 0.",
	NULL
};

string _TRANWRN[] = {
	"Transposition Warning:",
	"",
	"You have set transposition values for a percussion",
	"instrument. This is not a good idea unless you know",
	"what you are doing - effectively changing the",
	"percussion instrument! The rest of the program can't",
	"report correct information if you do this. Chords",
	"are also not really possible for percussion. You",
	"would be sensible to change the values to 0.",
	NULL
};

string _CNVPOS[] = {
	"Please wait..",
	"Currently converting",
	"sample    ",
	NULL
};
