/* archive.c */

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "archive.h"
#include "rw_io.h"
#include "lzw4w.h"
#include "display.h"
#include "about.h"
#include "dir_io.h"
#include "databox.h"
#include "ascii.h"
#include "sayerror.h"

/*
** PostMainHandle() is required only for the
** Shareware version of LZW4W.
*/

#if __cplusplus
extern "C" void FAR PASCAL PostMainHandle(HWND);
#else
extern void FAR PASCAL PostMainHandle(HWND);
#endif

static FARPROC lpProcAbout;
static FARPROC lpProcDataBox;

static HANDLE ghInstance;

static char FileSpec[MAXEDITTEXT];
static char FileName[15];
static char ArchiveName[MAXEDITTEXT];
static char ExtractName[MAXEDITTEXT];
static char Temp[MAXEDITTEXT];
static char CRLF[3] = {CR,LF,'\0'};

int FAR PASCAL Dummy(char Byte)
{
 return(1);
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
          LPSTR lpCmdLine, int nCmdShow)
{
 MSG Message;
 HWND hWnd;
 WNDCLASS WndClass;

 ghInstance = hInstance;

 if(!hPrevInstance)
   {
    WndClass.cbClsExtra = 0;
    WndClass.cbWndExtra = 0;
    WndClass.hbrBackground = GetStockObject(WHITE_BRUSH);
    WndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
    /*WndClass.hIcon = LoadIcon(NULL, IDI_APPLICATION);*/
    WndClass.hIcon = LoadIcon(hInstance, "ArchiveIcon");
    WndClass.hInstance = hInstance;
    WndClass.lpfnWndProc = WndProc;
    WndClass.lpszClassName = "ARCHIVE";
    WndClass.lpszMenuName = "ArchiveMenu";
    WndClass.style = CS_HREDRAW | CS_VREDRAW;
    RegisterClass(&WndClass);
  }

 hWnd = CreateWindow("ARCHIVE", "ARCHIVE", WS_OVERLAPPEDWINDOW,
           CW_USEDEFAULT,  CW_USEDEFAULT,
           8*NCOLS,        12*NROWS+48,
           NULL,           NULL,
           hInstance,      NULL);
 /* show time ! */
 ShowWindow(hWnd, nCmdShow);
 while( GetMessage(&Message,NULL,0,0))
   {TranslateMessage(&Message);
    DispatchMessage(&Message);
   }
 return Message.wParam;
}

static CheckError(HWND hWnd,int Code)
{if(Code<0)
  {SayError(hWnd,Code);
   return FALSE;
  }
 else return TRUE;
}

static void CopyNameOnly(LPSTR Dest,LPSTR Source)
{int i = 0;
 char c;
 while(1)
   {c = (char) *Source++;
    if((c==':')||(c=='\\')) i = 0;
    else if(c=='.') break;
    else Dest[i++] = c;
   }
 Dest[i] = '\0';
}

/* get filename from archive file */

static int FetchFilename(LPSTR Ptr)
{int i, k;
 char c;
 /* skip past any leading 0's */
 for(k=0;k<5;k++)
   {i = Reader();
    if(i==-1)
      {ReaderClose();
       return FALSE;
      }
    c = (char)i;
    if(c!='\0') break;
   }
 Ptr[0] = c;
 /* get remainder of name */
 for(k=1;k<15;k++)
   {i = Reader();
    c = (char)i;
    Ptr[k] = c;
    if(c=='\0') break;
    if( (i==-1) || (c<'!') || (c>'z') )
      {DisplayText("Unexpected end of list!\r\n");
       Ptr[k+1] = '\0';
       wsprintf(Temp,"%s [%xH]\r\n",Ptr,c);
       DisplayText(Temp);
       return FALSE;
      }
   }
 return TRUE;
}

/********** WndProc ************/


long FAR PASCAL WndProc(HWND hWnd, UINT iMessage, WPARAM wParam, LPARAM lParam)
{int i, k;
 int Code;
 char c;
 HDC hDC;
 HPEN hPen;
 PAINTSTRUCT ps;
 int Flag;
 switch(iMessage)
   {
    case WM_PAINT:
      hDC = BeginPaint(hWnd, &ps);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      DisplayPaint(hDC,&ps);
      EndPaint(hWnd,&ps);
      break;

    case WM_COMMAND:
      switch(wParam)
         {case MSG_ABOUT:
            DialogBox(ghInstance,"AboutBox",hWnd,lpProcAbout);
            break;

          case MSG_COMPRESS:

            if(!CheckError(hWnd,InitLZW(14))) break;
            /* get archive spec */
            SetDlgInfoString("Enter archive filename");
            if(!DialogBox(ghInstance,"DataBox",hWnd,lpProcDataBox)) break;
            lstrcpy(ArchiveName,GetDlgTextPtr());
            AnsiUpper(ArchiveName);
            if(!WriterOpen(ArchiveName))
               {MessageBox(hWnd,ArchiveName,"Cannot open",MB_ICONEXCLAMATION);
                break;
               }
            /* get input file specs */
            SetDlgInfoString("Enter file(s) to archive");
            if(!DialogBox(ghInstance,"DataBox",hWnd,lpProcDataBox))break;
            lstrcpy(FileSpec,GetDlgTextPtr());
            /* compress each file in turn */
            for(i=0;;i++)
              {/* get next filename */
               if(i==0) Flag = FindFirst(FileSpec,FileName);
               else Flag = FindNext(FileName);
               /* skip archive file itself */
               AnsiUpper(FileName);
               if(lstrcmp(FileName,ArchiveName)==0) continue;
               /* compress this file */
               if(Flag)
                 {/* write filename to output file */
                  Writer('\0');
                  for(k=0;k<strlen(FileName);k++) Writer(FileName[k]);
                  Writer('\0');
                  /* open input file */
                  if(ReaderOpen(FileName)) DisplayText(FileName);
                  else
                    {MessageBox(hWnd,FileName,"Cannot open",MB_ICONEXCLAMATION);
                     break;
                    }
                 }
               else break;
               /* compress this file */
               if(!CheckError(hWnd,Compress(Reader,Writer))) break;
               ReaderClose();
               DisplayText(" OK\r\n");
              }
            WriterClose();
            DisplayText("<DONE>\r\n");
            if(!CheckError(hWnd,TermLZW())) break;
            break;

          case MSG_EXPAND:

            if(!CheckError(hWnd,InitLZW(14))) break;
            /* get archive spec */
            SetDlgInfoString("Enter archive filename");
            if(!DialogBox(ghInstance,"DataBox",hWnd,lpProcDataBox)) break;
            lstrcpy(ArchiveName,GetDlgTextPtr());
            AnsiUpper(ArchiveName);
            if(!ReaderOpen(ArchiveName))
               {MessageBox(hWnd,ArchiveName,"Cannot open",MB_ICONEXCLAMATION);
                break;
               }
            /* expand each file in turn */
            while(TRUE)
              {/* get filename */
               if(!FetchFilename(FileName)) break;
               DisplayText(FileName);
               if(!WriterOpen(FileName))
                 {MessageBox(hWnd,FileName,"Cannot open",MB_ICONEXCLAMATION);
                  break;
                 }
               /* expand this file */
               if(!CheckError(hWnd,Expand(Reader,Writer))) break;
               WriterClose();
               DisplayText(" OK\r\n");
              }
            DisplayText("<DONE>\r\n");
            if(!CheckError(hWnd,TermLZW())) break;
            break;

          case MSG_LIST:

            if(!CheckError(hWnd,InitLZW(14))) break;
            /* get archive spec */
            SetDlgInfoString("Enter archive filename");
            if(!DialogBox(ghInstance,"DataBox",hWnd,lpProcDataBox)) break;
            lstrcpy(ArchiveName,GetDlgTextPtr());
            AnsiUpper(ArchiveName);
            if(!ReaderOpen(ArchiveName))
               {MessageBox(hWnd,ArchiveName,"Cannot open",MB_ICONEXCLAMATION);
                break;
               }
            /* list each file in turn */
            while(TRUE)
              {/* get filename */
               if(!FetchFilename(FileName)) break;
               DisplayText(FileName);
               if(!CheckError(hWnd,Expand(Reader,Dummy))) break;
               DisplayText(CRLF);
              }
            DisplayText("<DONE>\r\n");
            if(!CheckError(hWnd,TermLZW())) break;
            break;

          case MSG_EXTRACT:

            if(!CheckError(hWnd,InitLZW(14))) break;
            /* get archive spec */
            SetDlgInfoString("Enter archive filename");
            if(!DialogBox(ghInstance,"DataBox",hWnd,lpProcDataBox)) break;
            lstrcpy(ArchiveName,GetDlgTextPtr());
            AnsiUpper(ArchiveName);
            if(!ReaderOpen(ArchiveName))
               {MessageBox(hWnd,ArchiveName,"Cannot open",MB_ICONEXCLAMATION);
                break;
               }
            /* get file name (for extract) */
            SetDlgInfoString("Enter filename to extract");
            if(!DialogBox(ghInstance,"DataBox",hWnd,lpProcDataBox)) break;
            lstrcpy(ExtractName,GetDlgTextPtr());
            AnsiUpper(ExtractName);
            /* examine each file in turn */
            while(TRUE)
              {/* get filename */
               if(!FetchFilename(FileName)) break;
               DisplayText(FileName);
               /* is this the file to extract ? */
               if(lstrcmp(ExtractName,FileName)==0)
                 {/* found file to extract */
                  if(!WriterOpen(FileName))
                    {MessageBox(hWnd,FileName,"Cannot open",MB_ICONEXCLAMATION);
                     break;
                    }
                  /* expand this file */
                  if(!CheckError(hWnd,Expand(Reader,Writer))) break;
                  ReaderClose();
                  WriterClose();
                  DisplayText(" OK\r\n");
                  break;
                 }
               else
                 {/* skip this file */
                  if(!CheckError(hWnd,Expand(Reader,Dummy))) break;
                  DisplayText(" skipping\r\n");
                 }
              }
            DisplayText("<DONE>\r\n");
            if(!CheckError(hWnd,TermLZW())) break;
            break;

          case MSG_EXIT:

            PostQuitMessage(0);
            break;
         }
      break;

    case WM_CREATE:

      /* create AboutDlgProc() thunk */
      lpProcAbout = MakeProcInstance((FARPROC)AboutDlgProc,ghInstance);
      /* create DataBoxDlgProc() thunk */
      lpProcDataBox = MakeProcInstance((FARPROC)DataBoxDlgProc,ghInstance);
      /* initialize window display */
      DisplayInit(hWnd);
      /*
      ** You must call PostMainHandle() before attemping to call LZW.
      ** This is required only for the Shareware version of LZW4W.
      */
      PostMainHandle(hWnd);
      if(!CheckError(hWnd,InitLZW(14)))
        {PostQuitMessage(0);
         break;
        }
      TermLZW();
      break;

    case WM_DESTROY:

      PostQuitMessage(0);
      break;

    default:

      return( DefWindowProc(hWnd,iMessage,wParam,lParam) );
   }
 return(NULL);
}