/* runlzw.c */

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "runlzw.h"
#include "rw_io.h"
#include "lzw4w.h"
#include "display.h"
#include "databox.h"
#include "about.h"
#include "sayerror.h"

/*
** PostMainHandle() is required only for the
** Shareware version of LZW4W.
*/

#if __cplusplus
extern "C" void FAR PASCAL PostMainHandle(HWND);
#else
extern void FAR PASCAL PostMainHandle(HWND);
#endif

static FARPROC lpProcDataBox;
static FARPROC lpProcAbout;
static HANDLE  ghInstance;

static char InputFile[MAXEDITTEXT];
static char OutputFile[MAXEDITTEXT];
static char FileName[15];

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
          LPSTR lpszCmdParam, int nCmdShow)
{
 MSG Message;
 HWND hWnd;
 WNDCLASS WndClass;

 ghInstance = hInstance;

 if(!hPrevInstance)
   {
    WndClass.cbClsExtra = 0;
    WndClass.cbWndExtra = 0;
    WndClass.hbrBackground = GetStockObject(WHITE_BRUSH);
    WndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
    WndClass.hIcon = LoadIcon(hInstance, "LZWIcon");
    WndClass.hInstance = hInstance;
    WndClass.lpfnWndProc = WndProc;
    WndClass.lpszClassName = "RUNLZW";
    WndClass.lpszMenuName = "LZWMenu";
    WndClass.style = CS_HREDRAW | CS_VREDRAW;
    RegisterClass(&WndClass);
  }

 hWnd = CreateWindow("RUNLZW",  "RUNLZW", WS_OVERLAPPEDWINDOW,
          CW_USEDEFAULT, CW_USEDEFAULT,
          8*NCOLS,       12*NROWS+48,
          NULL,          NULL,
          hInstance,     NULL);
 /* show time ! */
 ShowWindow(hWnd, nCmdShow);
 while( GetMessage(&Message,NULL,0,0))
   {TranslateMessage(&Message);
    DispatchMessage(&Message);
   }
 return Message.wParam;
}


static CheckError(HWND hWnd,int Code)
{if(Code<0)
  {SayError(hWnd,Code);
   return FALSE;
  }
 else return TRUE;
}

static void CopyNameOnly(LPSTR Dest,LPSTR Source)
{int i = 0;
 char c;
 while(1)
   {c = (char) *Source++;
    if((c==':')||(c=='\\')) i = 0;
    else if(c=='.') break;
    else Dest[i++] = c;
   }
 Dest[i] = '\0';
}

/*
** Prompts user for input & output file names
** and opens the Reader & Writer
*/

static int GetFileNames(HWND hWnd,LPSTR InputPrompt,LPSTR OutputPrompt)
{/* get input file name */
 SetDlgInfoString(InputPrompt);
 if(!DialogBox(ghInstance,"DataBox",hWnd,lpProcDataBox)) return FALSE;
 lstrcpy(InputFile,GetDlgTextPtr());
 AnsiUpper(InputFile);
 if(!ReaderOpen(InputFile))
   {MessageBox(hWnd,InputFile,"Cannot open",MB_ICONEXCLAMATION);
    return FALSE;
   }
 /* get output file name */
 SetDlgInfoString(OutputPrompt);
 if(!DialogBox(ghInstance,"DataBox",hWnd,lpProcDataBox)) return FALSE;
 lstrcpy(OutputFile,GetDlgTextPtr());
 AnsiUpper(OutputFile);
 if(!WriterOpen(OutputFile))
   {MessageBox(hWnd,OutputFile,"Cannot open",MB_ICONEXCLAMATION);
    return FALSE;
   }
 /* display base part of filename */
 CopyNameOnly(FileName,InputFile);
 DisplayText(FileName);
 return TRUE;
}

/********** WndProc ************/

long FAR PASCAL WndProc(HWND hWnd, UINT iMessage, WPARAM wParam, LPARAM lParam)
{int i;
 int Code;
 HDC hDC;
 HPEN hPen;
 PAINTSTRUCT ps;
 float X, Y;
 float V;
 POINT Point;
 switch(iMessage)
   {
    case WM_PAINT:

      hDC = BeginPaint(hWnd, &ps);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      DisplayPaint(hDC,&ps);
      EndPaint(hWnd,&ps);
      break;

    case WM_COMMAND:

      switch(wParam)
         {case MSG_ABOUT:
            DialogBox(ghInstance,"AboutBox",hWnd,lpProcAbout);
            break;

          case MSG_COMPRESS:

            if(!GetFileNames(hWnd,"Enter file to compress",
                                  "Name of compressed file")) break;
            /* compress */
            if(!CheckError(hWnd,InitLZW(14))) break;
            if(!CheckError(hWnd,Compress(Reader,Writer))) break;
            if(!CheckError(hWnd,TermLZW())) break;
            ReaderClose();
            WriterClose();
            DisplayText(" OK\r\n");
            break;

          case MSG_EXPAND:

            if(!GetFileNames(hWnd,"Enter file to expand",
                                  "Name of expanded file")) break;
            if(!CheckError(hWnd,InitLZW(14))) break;
            if(!CheckError(hWnd,Expand(Reader,Writer))) break;
            if(!CheckError(hWnd,TermLZW())) break;
            ReaderClose();
            WriterClose();
            DisplayText(" OK\r\n");
            break;

          case MSG_EXIT:

            PostQuitMessage(0);
            break;
         }
      break;

    case WM_CREATE:

      /* create AboutDlgProc() thunk */
      lpProcAbout = MakeProcInstance((FARPROC)AboutDlgProc,ghInstance);
      /* create DataBoxDlgProc() thunk */
      lpProcDataBox = MakeProcInstance((FARPROC)DataBoxDlgProc,ghInstance);
      /* initialize window display */
      DisplayInit(hWnd);
      /*
      ** You must call PostMainHandle() before attemping to call LZW.
      ** This is required only for the Shareware version of LZW4W.
      */
      PostMainHandle(hWnd);
      if(!CheckError(hWnd,InitLZW(14)))
        {PostQuitMessage(0);
         break;
        }
      TermLZW();
      break;

    case WM_DESTROY:

      PostQuitMessage(0);
      break;

    default:

      return( DefWindowProc(hWnd,iMessage,wParam,lParam) );
   }
 return(NULL);
}