/*   RW_IO.C
**
**   Reader/Writer Buffered I/O
**
**   Reader() and Writer() are called directly by the LZW4C.ASM code.
**   They should never be called by your application code.
**
**   The other functions are never called by the LZW4C.ASM code, but are
*    called only by your application routines.
**
**   Note that only a Reader() and Writer() function is required by the
**   LZW4C.ASM code. This means that you have complete control over data
**   coming into and out of the compression/expansion code. Instead of
**   reading or writing to disk, you can just as easily read/write to a
**   buffer, serial port, etc. You just have to write the Reader() and
**   Writer() code.
*/

#include <windows.h>
#include <stdio.h>
#include "rw_io.h"
#include "display.h"

#define BUFFER_SIZE 2048

typedef struct IOstruct
{char Buffer[BUFFER_SIZE];
 int  Left;      /* leftmost byte in Buffer */
 int  Right;     /* rightmost byte in buffer */
 long Count;     /* # times Reader/Writer called */
 HANDLE Handle;
 OFSTRUCT ofs;
} IOstruct;

static HWND hTheWnd = 0;
static IOstruct InpControl;
static IOstruct OutControl;
static int X = 1;
static int Y = 15;

int FAR PASCAL ReaderOpen(LPSTR Ptr)
{int Code;
 /* open input file */
 InpControl.Left = 0;
 InpControl.Right = 0;
 InpControl.Count = 0;
 Code = OpenFile(Ptr,&InpControl.ofs,OF_READ);
 if(Code==-1) return(FALSE);
 InpControl.Handle = (HANDLE)Code;
 return(TRUE);
}

int FAR PASCAL Reader(void)
{char Byte;
 if(InpControl.Left==InpControl.Right)
    {/* read next buffer */
     InpControl.Left = 0;
     InpControl.Right = _lread(InpControl.Handle,&InpControl.Buffer,BUFFER_SIZE);
     if(InpControl.Right<=0) return(EOF);
    }
 /* return next byte */
 Byte = InpControl.Buffer[InpControl.Left++];
 InpControl.Count++;
 return(0x00ff&Byte);
}

long FAR PASCAL ReaderCount(void)
{/* return bytes read */
 return(InpControl.Count);
}

void FAR PASCAL ReaderClose(void)
{/* close input file */
 _lclose(InpControl.Handle);
}

int FAR PASCAL WriterOpen(LPSTR Ptr)
{int Code;
 /* open output file */
 OutControl.Left = 0;
 OutControl.Right = 0;
 OutControl.Count = 0;
 Code = OpenFile(Ptr,&OutControl.ofs,OF_CREATE);
 if(Code==-1) return(FALSE);
 OutControl.Handle = (HANDLE)Code;
 return(TRUE);
}

int FAR PASCAL Writer(char Byte)
{int Code;
 HDC hDC;
 OutControl.Count++;
 if((OutControl.Count&0x0fff)==0) DisplayText(".");
 OutControl.Buffer[OutControl.Right++] = Byte;
 if(OutControl.Right==BUFFER_SIZE)
    {/* read next buffer */
     Code = _lwrite(OutControl.Handle,&OutControl.Buffer,OutControl.Right);
     OutControl.Right = 0;
    }
 return(Code);
}

long FAR PASCAL WriterCount(void)
{/* return bytes written */
 return(OutControl.Count);
}

void FAR PASCAL WriterClose(void)
{/* flush buffer to disk */
 _lwrite(OutControl.Handle,&OutControl.Buffer[OutControl.Left],OutControl.Right-OutControl.Left);
 /* close output file */
 _lclose(OutControl.Handle);
}