/* sayerror.c */

#include <windows.h>
#include <stdio.h>
#include "LZW4W.H"
#include "SAYERROR.H"

static char Text[25];

void SayError(HWND hWnd,int Code)
{switch(Code)
  {case EXPANSION_ERROR:
     MessageBox(hWnd,
               "Can only expand a previously compressed file",
               "Expansion Error",
               MB_ICONEXCLAMATION);
     break;
   case CANNOT_ALLOCATE:
     MessageBox(hWnd,
                "Could not allocate sufficient memory",
                "Allocation Error",
                MB_ICONEXCLAMATION);
     break;
   case INTERNAL_ERROR:
     MessageBox(hWnd,
                "LZW4W object code modified !",
                "Internal Error",
                MB_ICONEXCLAMATION);
     break;
   case NOT_INITIALIZED:
     MessageBox(hWnd,
                "Must call InitLZW first",
               "Not Initialized Error",
                MB_ICONEXCLAMATION);
     break;
   case BAD_BITCODE:
     MessageBox(hWnd,
                "Must be 12, 13, or 14",
                "Bit Code Error",
                MB_ICONEXCLAMATION);
     break;
   default:
     wsprintf(Text,"%d [%xH]",Code,Code);
     MessageBox(hWnd,
                Text,
                "Unknown Error",
                MB_ICONEXCLAMATION);
     break;
  }
}