// "COMMANCHE"

// INCLUDES

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "template.h"
#include "comsim.h"
#include "vx.h"
#include "timer.h"
#include "keyscan.h"


// GLOBAL VARS

byte *dataseg1,*data_ptr;
char sincurve1[256],sincurve2[256];
byte farmap=0;
float maxh;
int lookheredown=233;


// kbd
void interrupt newkbdhandler(...);
void interrupt (*oldkbdhandler)(...);
byte *keypressed;
keyscan_C kbd;

// screen
vx_C vx;

// timer
timer_C timer;


// FUNCTIONS

// SETCOLORS

void setcolors(void)
{
  int qw=0;
  for (int plan=0; plan<4; plan++)
  for (int teller=0; teller<64; teller++)
        {
    float r,g,b;
    switch(plan)
    {
      case 0:   r=teller/2;
                g=(3*teller)/4;
                b=teller/5;
                break;
      case 1:   r=(teller*7)/7;
                g=(teller*7)/8;
                b=(teller*22)/32;
                break;
      case 2:   r=teller/4;
                g=teller/4;
                b=teller;
                break;
      case 3:   r=g=b=(teller*4)/5;
                break;
    }
    vx.setrgb(teller+64*plan,r,g,b);
  }
}

// MAKEVRAM

void makevram()
{
  vx.blockfill(0,10,0);
  vx.blockfill(10,65535,0);
  vx.setoffset(8192);
  for (float teller=0; teller<256; teller++)
  {
    float val2,val=sin(teller*3.14159265/128);
    sincurve1[teller]=val*127;
    sincurve2[teller]=val*val*val*127;
        }
  for (int ha=0; ha<32; ha++)
  {
    float haz=1.05-4.0*ha/125.0;
    fit ((float)0,haz,(float)1);
    for (int plan=0; plan<4; plan++)
      for (int teller=0; teller<256; teller++)
      {
        int base=64*(teller/64);
        int color=teller&63;
        if (color==10)
        {
          base=128;
          color=20+teller/26;
        }
        color+=random(RANDOM);
        fit(0,color,63);
        vx.writepixel(ha*256+teller,plan,haz*(color/1.5+21)+base);
      }
  }
#define BIG 40
  for (int c=0; c<80; c++)
  {
    int vin=BIG*(c/BIG);
    int sm=c%BIG;
    if (sm&1)
      sm=BIG-1-sm/2;
    else
      sm=sm/2;
    int no=vin+sm;
    data_ptr[c+ORDER]=no;
  }
}

// MAKEMAPLINE

void makemapline(byte qteller)
{
        static int magic1=0;
        static int slide=0;
        slide++;
        magic1++;
        static int bigfac=0;
        float last;
        last=0;
        static int flow;
        static byte no1=random(256),no2=random(256),no3=random(256),
                                no4=random(256),no5=random(256),no6=random(256);

        no3=no5+87;
        no4=49+no6;
        no1+=1;
        no2+=2;
        no5+=2;
        no6+=3;
        int adresse=qteller+MAPDATA;
        for (int teller=0; teller<MAPX; teller++)
        {
                int temp=sincurve1[no1]+sincurve2[no2]+
                         sincurve1[no3]+sincurve2[no4];
                int sgn=1;
    if (temp<0)
      temp*=-1;
    temp>>=1;
    word temp2=temp*bigfac;
    temp2>>=10;

    no3+=10;
    no4-=6;

    if (temp2>ICE)
      temp2+=192;
    if (temp2<=LAKE)
      temp2=10+64*random(4);
    else
    if (temp2<BEACH)
      temp2+=64;
    data_ptr[adresse]=temp2;
    adresse+=MAPY;
				}
  flow++;
  if (bigfac || (!lookheredown))
    bigfac=max(50,bigfac+1);
  if (bigfac>255)
    bigfac=255;
}

// MAKELOOKUP

void makelookup(void)
{
  float v,s;
  for (int y=0; y<MAPY/4; y++)
  for (int z=0; z<64; z++)
  {
                v=atan(4.0*y/(HEIGHT-z));
    v-=DOWNVIEW;
    s=sin(v);
    int hei=CENTER+WIDTH*s;
    if (hei<0)
      hei=0;
    data_ptr[256*z+192+y]=hei;
  }
}

// MAKEMAPDATA

void makemapdata(void)
{
  for (int teller=0; teller<MAPY; teller++)
    makemapline(teller);
}

// MAKEXFAC

void makexfac()
{
  for (int teller=0; teller<80; teller++)
  {
    float real=teller*MAPX/80.0;
    int xdiff=LENS*(real-MAPX/2);
    float temp=(float)xdiff/MAPY;
    if (temp<0)
      temp++;
    temp*=256;
    byte itemp=(temp+0.5);
    data_ptr[XFAC+teller]=itemp;
  }
}

// MAKEORIGMAX

void makeorigmax(void)
{
  for (int teller=0; teller<160; teller++)
    data_ptr[ORIGMAX+teller]=0;
}



// SHOWMAP

void showmap(void)
{
  for (int x=0; x<MAPX; x++)
  for (int y=0; y<MAPY; y++)
  {
    vx.writepixel(x/4+80*y,x&3,data_ptr[(long)MAPDATA+(long)256*x+y]);
  }
}

// DRAW

void draw(word vrampos,byte down)
{
  vrampos+=233*80;
  asm push ds
  asm pusha
  int localfarmap=farmap;
  byte br0k,maxy;
  word xcount=0;

  asm mov dx,GC_INDEX
  asm mov ax,BIT_MASK
  asm out dx,ax

  asm mov dx,SC_INDEX+1
  asm mov al,0x0f
  asm out dx,al

  asm mov ax,0xa000
  asm mov es,ax

  asm xor dl,dl
	asm lds si,data_ptr           // ds=seg data_ptr

nextrow:
  asm mov dx,xcount
  asm mov br0k,dh
  asm mov si,dx
  asm mov di,dx

  asm add di,vrampos
  asm mov bx,localfarmap
  asm add bx,MAPDATA+256*(MAPX/2)
                                // bx=bmp-pos
  asm mov cl,[si+XFAC]          // cl=pluss
  asm mov ah,down
  asm mov maxy,ah
        asm mov dl,192
countup:

        asm mov al,[bx]
        asm mov dh,al
        asm and dh,63
        asm xchg dx,di
        asm mov ah,[di]
        asm xchg dx,di

        asm cmp ah,maxy
        asm jbe nothingnew
  asm mov dh,ah
  asm sub dh,maxy
  asm mov maxy,ah
#if HAZE
  asm mov ah,dl
  asm and ah,63
  asm shr ah,HAZE
#else
  asm xor ah,ah
#endif
  asm mov si,ax
#if FUZZY
moveup:
  asm mov al,[es:si]
  asm xor si,FUZZY
#else
  asm mov al,[es:si]
  moveup:
#endif
  asm mov [es:di],al
  asm sub di,80
  asm dec dh
  asm jnz moveup

nothingnew:
  asm inc bl
  asm add br0k,cl
  asm adc bh,0
  asm dec bh
  asm inc dl
  asm jnz countup

  asm mov dh,maxy
  asm mov si,xcount
  asm sub dh,[si+LASTTOP]
  asm add [si+LASTTOP],dh
  asm cmp dh,210
  asm jb lower
  asm mov dl,[es:-1]
clearup:
  asm mov [es:di],dl
  asm sub di,80
  asm inc dh
  asm jnz clearup
lower:
// OK! NOW TO THE RIGHT SIDE: //
  asm add xcount,40
nextrow2:
  asm mov dx,xcount
  asm mov br0k,dh
  asm mov si,dx
  asm mov di,dx

  asm add di,vrampos
  asm mov bx,localfarmap
  asm add bx,MAPDATA+256*(MAPX/2)
        asm mov cl,[si+XFAC]
        asm mov ah,down
        asm mov maxy,ah
        asm mov dl,192
countup2:
        asm mov al,[bx]
        asm mov dh,al
        asm and dh,63
        asm xchg dx,di
        asm mov ah,[di]
        asm xchg dx,di

  asm cmp ah,maxy
  asm jbe nothingnew2
  asm mov dh,ah
  asm sub dh,maxy
  asm mov maxy,ah
#if HAZE
  asm mov ah,dl
  asm and ah,63
  asm shr ah,HAZE
#else
  asm xor ah,ah
#endif
  asm mov si,ax
#if FUZZY
moveup2:
  asm mov al,[es:si]
  asm xor si,FUZZY
#else
  asm mov al,[es:si]
moveup2:
#endif
  asm mov [es:di],al
  asm sub di,80
  asm dec dh
  asm jnz moveup2

nothingnew2:
  asm inc bl
  asm add br0k,cl
  asm adc bh,0
  asm inc dl
  asm jnz countup2
  asm mov dh,maxy
        asm mov si,xcount
  asm sub dh,[si+LASTTOP]
  asm add [si+LASTTOP],dh
  asm cmp dh,215
  asm jb lower2
  asm mov dl,[es:-1]
clearup2:
  asm mov [es:di],dl
  asm sub di,80
  asm inc dh
  asm jnz clearup2

lower2:

  asm sub xcount,39
  asm cmp xcount,40
  asm je row79done
  asm jmp nextrow
row79done:

  asm mov dx,GC_INDEX+1
  asm mov al,0xff
  asm out dx,al

  asm mov  dx,SC_INDEX
        asm mov  al,MAP_MASK
  asm out  dx,al
  asm inc  dx

  asm popa
  asm pop ds
}

// MEMBLIT

void memblit(word from, word to)
{
  asm push ds
  asm cld
  asm lds ax,data_ptr
  asm mov ax,ds
  asm mov es,ax
  asm mov si,from
  asm mov di,to
#ifdef USE32
  asm mov cx,20
  asm rep movsd
#else
  asm mov cx,40
  asm rep movsw
#endif
  asm pop ds
}

// COMSIM

float comsim(void)
{
  float fps;
  dataseg1=new byte[DATAEND+32];
				data_ptr=(byte *)((long)dataseg1+65532l);
  for (word teller=0; teller<DATAEND; teller++)
    data_ptr[teller]=0;

  makevram();
  setcolors();
  makelookup();
  makemapdata();
  makexfac();
  makeorigmax();
        long lastscroll,start,stop,msek,count=0;
  word apos=8192,oldlast=LASTTOP+80;
  int speed=SPEED;
  for (int wind=0; wind<00; wind++)
  {
    makemapline(farmap);
    farmap=(farmap+speed)&255;
  }
  lastscroll=start=timer.readtimer();
  byte down=233,bailout=0,timeroll=0;
  long herenow,gone,timestamp[3];
  timestamp[0]=timestamp[1]=timestamp[2]=start;
  do
  {
    lookheredown=down;
    apos+=19200-256;
								if (apos==-512)
      apos=8192;
    memblit(oldlast,LASTTOP);
		draw(apos,down);
    memblit(LASTTOP,oldlast);
		long now=timer.readtimer();
    do
    {
      herenow=timer.readtimer();
                        gone=timer.elapsed(timestamp[timeroll],herenow);
    } while (gone<42);
    timestamp[timeroll++]=herenow;
    if (timeroll==3)
      timeroll=0;
    vx.setoffset(apos);
    if (timer.elapsed(lastscroll,now)>6)
    {
      lastscroll=now;
      if (bailout)
                        {
        for (word o=80+LASTTOP; o<320+LASTTOP; o++)
          data_ptr[o]+=2;
        down+=1;
      }
      else
        down-=!!down;
    }
    oldlast+=80;
    if (oldlast==LASTTOP+320)
      oldlast=LASTTOP+80;
    makemapline(farmap);
    farmap=(farmap+speed)&255;
    count++;
    if (keypressed[57] && !(count&7))
      speed*=-1;
    if (keypressed[1])
      bailout=1;
  } while (down<234);
  stop=timer.readtimer();
  msek=timer.elapsed(start,stop);
  delete dataseg1;
  return (1.0*count/(msek/1000.0));
}

main()
{
        float fps;

        fps = comsim();

				_AX = 0x03;
				VGAINT;

        printf( "fps = %lf\n", fps );

}
