// PART A - "COMMANCHE"

#ifndef _COMSIM_H
#define _COMSIM_H

// INCLUDES

#include "def.h"

// DEFINITIONS

#define HISPEED 	4
#define FUZZY   	0
#define RANDOM    0
#define HAZE    	1
#define LENS		2.0

#define HEIGHT 		66//70 	// fly-h0yde
#define DOWNVIEW 	0.7//0.7 	// radianer hellning paa kameraet
#define CENTER 		25//50
#define WIDTH 		230//210
#define SPEED		1

#define ICE		38
#define BEACH		19
#define LAKE		10


#define MAPX 	128
#define MAPY	256
#define MAPZ	64

#define LOOKUP	0
#define MAPDATA 16384
#define XFAC 	49152
#define ORIGMAX	49472
#define LASTTOP 49712
#define ORDER   49632
#define DATAEND 50032	// oppdateres ogsaa i 'comsim.asm'!

// DECLARATIONS

float comsim(void);

#endif

/*

Layout, 'data': (forutsetter MAPX=128, MAPY=256, MAPZ=64)

0	LOOKUP	16383   Lookup: skjerm-ypos=[BX], bh=h0yde, bl=lengde
			(ikke def. for bl=0)
16384	MAPDATA	49152	H0yde/farge-data (0-5=h0yde, 6-7=farge)
			h0yde=[BX], bh=64+mapx, bl=mapy
					 =MAPDATA+256*x+y;
49152	XFAC   	49471   x-faktor, ved forflytning mot h0yre i map-dataene.
			Paa venstre side av skjermen skal det i tillegg
			trekkes fra 1. Dette er dobbelt saa mye som
			n0dvendig, i tilfelle x-res blir 160 istedet for
			80. Faktisk enda verre, ettersom jeg pr0ver med
			byte istedet for word
49472	ORIGMAX	49631	Tabell: max-y i utgangspunktet (for evt. cockpit
			senere)
49632	LASTTOP 49791   Forrige maxh0yde

49792   ORDER   49871   Rekkef0lge hvordan linjene skal tegnes opp

49872 DATAEND

*/