#define STRICT
#include <windows.h>
#include <string.h>
#include <commdlg.h>
#include "toolbar.rc"

#define DKGRAY_PEN      RGB(128, 128, 128)
#define IB_SPACE        -1
#define ICONBORDER      4
#define TOOLBARBORDER   4

typedef struct ICONBUTTON_STRUCT {
	int    idBtn;
	HICON  hIcon;
	HWND   hWndBtn;
} ICONBUTTON, *LPICONBUTTON;

HWND            ToolBar(HWND, LPICONBUTTON, LPINT);
BOOL            InitApplication(HINSTANCE);
BOOL            InitInstance(HINSTANCE, int);
LONG FAR PASCAL MainWndProc(HWND, UINT, WPARAM, LPARAM);
LONG FAR PASCAL ToolBarWndProc(HWND, UINT, WPARAM, LPARAM);
LONG FAR PASCAL HelloWndProc(HWND, UINT, WPARAM, LPARAM);
BOOL FAR PASCAL DlgAbout(HWND, UINT, WPARAM, LPARAM);


HANDLE        hInst;
char          szAppName[] = "ToolBar";
char          szTitle[]   = "ToolBar";
HWND          hWndMainWin;
HWND          hWndToolBar;
HWND          hWndHello;
HWND          hWndToolBarOwner;
int           ToolBarHeight;
char          outtext[32];
ICONBUTTON    IconButtons[10];
LPICONBUTTON  lpIconBtn;

int PASCAL
WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
				LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;
	HANDLE hAccelTable;

	if (!hPrevInstance)
		if (!InitApplication(hInstance))
			return (FALSE);
	if (!InitInstance(hInstance, nCmdShow))
		return (FALSE);
	hAccelTable = LoadAccelerators (hInstance, szAppName);
	while (GetMessage(&msg, NULL, 0, 0))
		if (!TranslateAccelerator (msg.hwnd, hAccelTable, &msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	return (msg.wParam);
}


BOOL
InitApplication(HINSTANCE hInstance)
{
	WNDCLASS  wc;

	wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc   = (WNDPROC) MainWndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = LoadIcon(hInstance, "ToolBar");
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
	wc.lpszMenuName  = szAppName;
	wc.lpszClassName = "ToolBarDemo";
	if(!RegisterClass(&wc))
		return FALSE;
	wc.style         = (UINT) NULL;
	wc.lpfnWndProc   = (WNDPROC) HelloWndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = NULL;
	wc.hCursor       = NULL;
	wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = "Hello";
	if(!RegisterClass(&wc))
		return(FALSE);
	wc.style         = (UINT) NULL;
	wc.lpfnWndProc   = (WNDPROC) ToolBarWndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = NULL;
	wc.hCursor       = NULL;
	wc.hbrBackground = (HBRUSH) GetStockObject(LTGRAY_BRUSH);
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = "ToolBar";
	if( !RegisterClass(&wc))
		return( FALSE );
	return TRUE;
}

HWND
CreateToolBar(HWND hWndParent, LPINT lpToolBarHeight)
{
	int i;

	i = 0;
	IconButtons[i].idBtn     = CM_AMERICAN;
	IconButtons[i].hWndBtn   = NULL;
	IconButtons[i].hIcon     = LoadIcon(hInst, "AMERICAN");
	i++;
	IconButtons[i].idBtn     = CM_FRENCH;
	IconButtons[i].hWndBtn   = NULL;
	IconButtons[i].hIcon     = LoadIcon(hInst, "FRENCH");
	i++;
	IconButtons[i].idBtn     = CM_GERMAN;
	IconButtons[i].hWndBtn   = NULL;
	IconButtons[i].hIcon     = LoadIcon(hInst, "GERMAN");
	i++;
	IconButtons[i].idBtn     = CM_SPANISH;
	IconButtons[i].hWndBtn   = NULL;
	IconButtons[i].hIcon     = LoadIcon(hInst, "SPANISH");
	i++;
	IconButtons[i].idBtn     = CM_RUSSIAN;
	IconButtons[i].hWndBtn   = NULL;
	IconButtons[i].hIcon     = LoadIcon(hInst, "RUSSIAN");
	i++;
	IconButtons[i].idBtn     = IB_SPACE;
	IconButtons[i].hWndBtn   = NULL;
	IconButtons[i].hIcon     = 0;
	i++;
	IconButtons[i].idBtn     = CM_ABOUT;
	IconButtons[i].hWndBtn   = NULL;
	IconButtons[i].hIcon     = LoadIcon(hInst, "ABOUT");
	i++;
	IconButtons[i].idBtn     = 0;
	IconButtons[i].hWndBtn   = (HWND)  NULL;
	return(ToolBar(hWndParent, IconButtons, lpToolBarHeight));
}

BOOL
InitInstance(hInstance, nCmdShow)
HINSTANCE hInstance;
int    nCmdShow;
{
	strcpy(outtext, (char *) "Hi!");
	hInst = hInstance;
	hWndMainWin = CreateWindow("ToolBarDemo", szTitle, WS_OVERLAPPEDWINDOW,
															 CW_USEDEFAULT, CW_USEDEFAULT, 250, 250,
															 NULL, NULL, hInstance, NULL);
	if (!hWndMainWin)
		return (FALSE);
	ShowWindow(hWndMainWin,  nCmdShow);
	ShowWindow(hWndToolBar,  nCmdShow);
	ShowWindow(hWndHello,    nCmdShow);
	UpdateWindow(hWndMainWin);
	return TRUE;
}


LONG FAR PASCAL
MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	RECT        rct;

	switch (message) {
	case WM_CREATE :
		GetClientRect(hWnd, &rct);
		hWndToolBar = CreateToolBar(hWnd,   &ToolBarHeight);
		hWndHello   = CreateWindow("Hello", "Hello", WS_CHILD | WS_CLIPSIBLINGS,
															 0, rct.top + ToolBarHeight,
															 rct.right - rct.left,
															 rct.bottom - rct.top - ToolBarHeight,
															 hWnd, NULL, hInst, NULL);
		return TRUE;
	case WM_SIZE:
		GetClientRect(hWnd, &rct);
		SetWindowPos(hWndToolBar, (HWND) HWND_TOP,
								 0, 0,
								 rct.right - rct.left, ToolBarHeight,
								 SWP_NOMOVE);
		SetWindowPos(hWndHello,   (HWND) HWND_TOP,
								 0, 0,
								 rct.right - rct.left, (rct.bottom - rct.top) - ToolBarHeight,
								 SWP_NOMOVE);
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case CM_AMERICAN:
			strcpy(outtext, (char *) "Hi!");
			InvalidateRect(hWndHello, NULL, TRUE);
			return 0;
		case CM_FRENCH:
			strcpy(outtext, (char *) "Salut!");
			InvalidateRect(hWndHello, NULL, TRUE);
			return 0;
		case CM_GERMAN:
			strcpy(outtext, (char *) "Tschus!");
			InvalidateRect(hWndHello, NULL, TRUE);
			return 0;
		case CM_SPANISH:
			strcpy(outtext, (char *) "Hola!");
			InvalidateRect(hWndHello, NULL, TRUE);
			return 0;
		case CM_RUSSIAN:
			strcpy(outtext, (char *) "Priviet!");
			InvalidateRect(hWndHello, NULL, TRUE);
			return 0;
		case CM_ABOUT:
			DialogBox(hInst, (LPSTR) "AboutBox",  hWnd, DlgAbout);
			break;
		case CM_QUIT:
			PostQuitMessage(0);
			break;
		default:
		 return (DefWindowProc(hWnd, message, wParam, lParam));
	 }
	 break;
	 case WM_DESTROY:
		 DestroyWindow(hWndToolBar);
		 DestroyWindow(hWndHello);
		 PostQuitMessage(0);
		 return FALSE;
	 default:
		 return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return 0;
}

//-----------------------------------------------------------------------
// APPLICATION
//-----------------------------------------------------------------------

LONG FAR PASCAL
HelloWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps;
	HPEN        hPen, hOldPen;

	switch (message) {
	case WM_PAINT:
		BeginPaint(hWnd, &ps);
		hPen = CreatePen(PS_SOLID, 1, BLACK_PEN);
		hOldPen = SelectObject(ps.hdc, hPen);
		TextOut(ps.hdc, 80, 80, outtext, strlen(outtext));
		SelectObject(ps.hdc, hOldPen);
		DeleteObject(hPen);
		EndPaint(hWnd, &ps);
		return 0;
	default:
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}
}

//-----------------------------------------------------------------------
// ABOUT BOX
//-----------------------------------------------------------------------


BOOL FAR PASCAL
DlgAbout(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) {
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
			case IDOK:
				EndDialog(hDlg, TRUE);
				return TRUE;
		}
		break;
	}
	return (FALSE);
}

//-----------------------------------------------------------------------
// TOOLBAR
//-----------------------------------------------------------------------


HWND
ToolBar(HWND hWndParent, LPICONBUTTON lpIconButton, LPINT lpHeight)
{
	HWND         hWnd;
	int          x, Width, Height;
	LPICONBUTTON lpTIB;
	RECT         rect;

	lpIconBtn         = lpIconButton;
	hWndToolBarOwner  = hWndParent;
	Height    = 2 * ICONBORDER + 28;
	*lpHeight = 2 * TOOLBARBORDER + Height;
	GetClientRect(hWndParent, &rect);
	hWnd = CreateWindow("ToolBar", "ToolBar", WS_VISIBLE | WS_CHILD | WS_CLIPSIBLINGS,
											0, 0, rect.right - rect.left, *lpHeight,
											hWndToolBarOwner, (HMENU) NULL, (HINSTANCE) hInst, NULL);
	SetWindowPos(hWnd, (HWND) 1, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE );
	ShowWindow(hWnd, SW_SHOW);
	x          = ICONBORDER * 2;
	for (lpTIB = lpIconButton; lpTIB->idBtn != 0; lpTIB++) {
		if (lpTIB->idBtn == -1) {
			x += ((ICONBORDER * 4) / 3);
			continue;
		}
		Width = (4 * ICONBORDER) + 20;
		(lpTIB->hWndBtn) = CreateWindow("BUTTON", "",
																		WS_VISIBLE | BS_OWNERDRAW | WS_CHILD,
																		x, TOOLBARBORDER, Width, Height, hWnd,
																		(HMENU) lpTIB->idBtn, (HINSTANCE) hInst, NULL );
		x += Width + (ICONBORDER/2);
		ShowWindow(lpTIB->hWndBtn, SW_SHOW);
	}
	return(hWnd);
}

LONG FAR PASCAL
ToolBarWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	HPEN             hPen, hOldPen;
	HBRUSH           hBrush;
	RECT             rect;
	PAINTSTRUCT      ps;
	LPDRAWITEMSTRUCT lpdis;
	int              i;

	switch(message) {
		case WM_COMMAND:
			SendMessage(hWndToolBarOwner, message, wParam, lParam);
			return(FALSE);
		case WM_DRAWITEM:
		lpdis = (LPDRAWITEMSTRUCT) lParam;
			for (i=0;;i++) {
				if (lpIconBtn[i].idBtn == 0)
					return 0;
				if (lpIconBtn[i].idBtn == lpdis->CtlID)
					break;
			}
			lpdis->rcItem.right--;
			lpdis->rcItem.bottom--;
			hBrush = CreateSolidBrush(RGB(192, 192, 192));
			FillRect(lpdis->hDC, &lpdis->rcItem, hBrush);
			DeleteObject(hBrush);
			hOldPen = SelectObject(lpdis->hDC, GetStockObject(BLACK_PEN));
			MoveToEx(lpdis->hDC, lpdis->rcItem.left,  lpdis->rcItem.top, NULL);
			LineTo(lpdis->hDC,   lpdis->rcItem.right, lpdis->rcItem.top);
			LineTo(lpdis->hDC,   lpdis->rcItem.right, lpdis->rcItem.bottom);
			LineTo(lpdis->hDC,   lpdis->rcItem.left,  lpdis->rcItem.bottom);
			LineTo(lpdis->hDC,   lpdis->rcItem.left,  lpdis->rcItem.top);
			SelectObject(lpdis->hDC, hOldPen);
			lpdis->rcItem.left++;
			lpdis->rcItem.right--;
			lpdis->rcItem.top++;
			lpdis->rcItem.bottom--;
			if (lpdis->itemState & ODS_SELECTED) {
				hPen = CreatePen(PS_SOLID, 1, DKGRAY_PEN);
				hOldPen = SelectObject(lpdis->hDC, hPen);
				MoveToEx(lpdis->hDC, lpdis->rcItem.left,  lpdis->rcItem.bottom, NULL);
				LineTo(lpdis->hDC,   lpdis->rcItem.left,  lpdis->rcItem.top);
				LineTo(lpdis->hDC,   lpdis->rcItem.right, lpdis->rcItem.top);
				SelectObject(lpdis->hDC, hOldPen);
				DeleteObject(hPen);
				DrawIcon(lpdis->hDC, lpdis->rcItem.left+2, lpdis->rcItem.top+2, lpIconBtn[i].hIcon);
			} else {
				hOldPen = SelectObject(lpdis->hDC, GetStockObject(WHITE_PEN));
				MoveToEx(lpdis->hDC, lpdis->rcItem.left,  lpdis->rcItem.bottom, NULL);
				LineTo(lpdis->hDC,   lpdis->rcItem.left,  lpdis->rcItem.top);
				LineTo(lpdis->hDC,   lpdis->rcItem.right, lpdis->rcItem.top);
				SelectObject(lpdis->hDC, hOldPen);
				hPen = CreatePen(PS_SOLID, 1, DKGRAY_PEN);
				hOldPen = SelectObject(lpdis->hDC, hPen);
				MoveToEx(lpdis->hDC, lpdis->rcItem.left,  lpdis->rcItem.bottom, NULL);
				LineTo(lpdis->hDC,   lpdis->rcItem.right, lpdis->rcItem.bottom);
				LineTo(lpdis->hDC,   lpdis->rcItem.right, lpdis->rcItem.top);
				SelectObject(lpdis->hDC, hOldPen);
				DeleteObject(hPen);
				DrawIcon(lpdis->hDC, lpdis->rcItem.left+1, lpdis->rcItem.top+1, lpIconBtn[i].hIcon);
			}
			return 0;
		case WM_PAINT:
			BeginPaint(hWnd, &ps);
			GetClientRect(hWnd, &rect);
			hOldPen = SelectObject(ps.hdc, GetStockObject(WHITE_PEN));
			MoveToEx(ps.hdc, rect.left, rect.top, NULL);
			LineTo(ps.hdc, rect.right+1, rect.top);
			SelectObject(ps.hdc, hOldPen);
			hPen = CreatePen(PS_SOLID, 1, DKGRAY_PEN);
			hOldPen = SelectObject(ps.hdc, hPen);
			MoveToEx(ps.hdc, rect.left, rect.bottom-2, NULL);
			LineTo(ps.hdc, rect.right+1, rect.bottom-2);
			SelectObject(ps.hdc, hOldPen);
			DeleteObject(hPen);
			hPen    = CreatePen( PS_SOLID, 1, BLACK_PEN);
			hOldPen = SelectObject(ps.hdc, hPen);
			MoveToEx(ps.hdc, rect.left,    rect.bottom-1, NULL);
			LineTo(ps.hdc,   rect.right+1, rect.bottom-1);
			SelectObject(ps.hdc, hOldPen);
			DeleteObject(hPen);
			EndPaint(hWnd, &ps);
			return 0;
		default:
			return(DefWindowProc(hWnd, message, wParam, lParam));
	}
}


