 
   /**********************************************************************\
   *                                                                      *
   * Author:   Paul Lapsansky                                             *
   * Date:     03/03/94                                                   *
   *                                                                      *
   * File:     demo.c                                                     *
   *                                                                      *
   * Descrpt:  Demonstrates functions found in the SYSTEM INFO LIBRARY.   *
   *                                                                      *
   * Language: Borland C++ 2.0+                                           *
   *                                                                      *
   * Available on: All machines.                                          *
   *                                                                      *
   * Restrictions: None.                                                  *
   *                                                                      *
   \**********************************************************************/
 
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <alloc.h>
#include "sysinfo.h"

void hardware(void);
void memory(void);
void video(void);
void dos(void);
void mouse(void);
void shells(void);
void drives(void);
void network(void);

void main(void)
{
   int error;                            // error code
   int x,y;                              // x and y coordinates
   int num;                              // logical drive number
   int code;                             // ascii code
   int model,submodel,rev;               // model information
   int cpu,npu;                          // processor information
   int DMA3,s8259,realtime,keyint,       // feature byte information
       event,extbios,MCA;
   long ext,exta;                        // extended memory
   int ems,emsa;                         // EMS memory
   long xmsa,xmsb;                       // XMS memory
   int vram;                             // video card memory
   int major,minor,drvMaj,drvMin;        // version information              
   int A20,HMA;                          // XMS information
   int handles,segment;                  // EMS information
   int emm;                              // '386 EMM type
   int card;                             // video card type
   int buttons,type,irq;                 // mouse information
   int oem;                              // DOS OEM number
   int drdos;                            // DR-DOS version
   int mode;                             // Windows mode
   int dblspace,stacker,mscdex;          // installed flags
   int a,b;                              // floppy drive type
   int lastdrive;                        // available drives
   int removable,remote;                 // drive type
   int heads,cyl,sectors;                // hard-drive information
   int version,sub,conn,use,vol,peak;    // NetWare File Server Information
   int year,month,day,hour,min,sec,week; // login date and time

   long SecPerClus,FreeClus,BytesPerSec, // misc. drive space information
        TotalClus,ClusSize,FreeSpace,
        TotalSpace;

   char *drive;                          // drive letter
   char *pcdate;                         // system BIOS date
   char *server;                         // server name
   char *user;                           // user name

   _setcursortype(_NOCURSOR);            // turn off cursor

   /**********************************************************************\
   *                 Display Hardware Information Screen                  *
   \**********************************************************************/ 

   clrscr();                             // clear screen
   hardware();                           // draw hardware screen
   highvideo();                          // turn on high-intensity
   textattr(31);                         // white on blue

   getID(&model,&submodel,&rev);         // get model information
   pcdate=biosDate();                    // get BIOS date

   gotoxy(24,9);
   switch (model) {                      // display model type
     case 0xFF:
       switch (submodel) {
         case 0x46:
           cputs("Olivetti");
           break;
         default:
           cputs("IBM PC or compatible");
       }
       break;
     case 0xFE:
       switch (submodel) {
         case 0x43:
           cputs("Olivetti");
           break;
         default:
           cputs("IBM PC/XT or compatible");
       }
       break;
     case 0xFD:
       cputs("IBM PCjr");
       break;
     case 0xFC:
       switch (submodel) {
         case 0x02:
           cputs("IBM XT-286");
           break;
         case 0x04:
           cputs("PS/2");
           break;
         case 0x05:
           cputs("PS/2");
           break;
         case 0x06:
           cputs("IBM 7552");
           break;
         case 0x08:
           cputs("Epson");
           break;
         case 0x09:
           cputs("PS/2");
           break;
         case 0x0B:
           cputs("PS/1");
           break;
         case 0x20:
           cputs("Compaq");
           break;
         case 0x30:
           cputs("Epson");
           break;
         case 0x31:
           cputs("Epson");
           break;
         case 0x33:
           cputs("Epson");
           break;
         case 0x42:
           cputs("Olivetti");
           break;
         case 0x45:
           cputs("Olivetti");
           break;
         case 0x48:
           cputs("Olivetti");
           break;
         case 0x4F:
           cputs("Olivetti");
           break;
         case 0x50:
           cputs("Olivetti");
           break;
         case 0x51:
           cputs("Olivetti");
           break;
         case 0x52:
           cputs("Olivetti");
           break;
         case 0x94:
           cputs("Zenith 386");
           break;
         default:
           cputs("IBM AT or compatible");
       }
       break;
     case 0xFB:
       switch (submodel) {
         case 0x4C:
           cputs("Olivetti");
           break;
         default:
           cputs("IBM PC/XT or compatible");
       }
       break;
     case 0xFA:
       switch (submodel) {
         case 0x4E:
           cputs("Olivetti");
           break;
         default:
           cputs("PS/2");
       }
       break;
     case 0xF9:
       cputs("PC Convertible");
       break;
     case 0xF8:
       switch (submodel) {
         case 0x0E:
           cputs("PS/1");
           break;
         case 0x0F:
           cputs("PS/1");
           break;
         case 0x1F:
           cputs("PS/ValuePoint");
           break;
         case 0x30:
           cputs("PS/1");
           break;
         case 0x49:
           cputs("PS/ValuePoint");
           break;
         case 0x4A:
           cputs("PS/ValuePoint");
           break;
         case 0x4B:
           cputs("PS/ValuePoint");
           break;
         case 0x5E:
           cputs("IBM ThinkPad");
           break;
         case 0x61:
           cputs("Olivetti");
           break;
         case 0x62:
           cputs("Olivetti");
           break;
         default:
           cputs("PS/2");
       }
       break;
     case 0xE1:
       cputs("PS/2");
       break;
     case 0x9A:
       cputs("Compaq XT");
       break;
     case 0x30:
       cputs("Sperry PC");
       break;
     case 0x2D:
       cputs("Compaq Deskpro");
       break;
     default:
       cputs("Unknown model!");
   }

   gotoxy(24,10);                       
   cprintf("%02X %02X %02X",model,submodel,rev); // display model I.D.

   gotoxy(24,11);                        
   cputs(pcdate);                        // display BIOS date

   cpu=getCPU();                         // get processor type

   gotoxy(24,12);                        
   switch (cpu) {                        // display processor type
     case 1:
       cputs("NEC V20");
       break;
     case 2:
       cputs("8088");
       break;
     case 3:
       cputs("80186");
       break;
     case 4:
       cputs("80286");
       break;
     case 5:
       cputs("80386");
       break;
     case 6:
       cputs("80486");
   }

   npu=getNPU();                         // get math-coprocessor type

   gotoxy(24,13);                        
   switch (npu) {                        // display math co-processor type
     case 1:
       cputs("8087");
       break;
     case 2:
       cputs("80287");
       break;
     case 3:
       if(cpu==6)                        // '486DX co-processor returns 80387
         cputs("Internal");
       else
         cputs("80387");
       break;
     default:
       cputs("Not installed");
   }
   
   gotoxy(24,14);
   cprintf("%d",getCOM());               // display number of serial ports

   gotoxy(24,15);                        
   cprintf("%d",getLPT());               // display number of parallel ports

   gotoxy(24,16);                    
   if(chkEnhKeyb())                      // get keyboard type
     cputs("Enhanced Keyboard");
   else
     cputs("Standard Keyboard");

                                         // get feature byte information
   if(!getFeatures(&DMA3,&s8259,&realtime,&keyint,&event,&extbios,&MCA)) {
     textattr(28);                       // bright red on blue
     gotoxy(75,10);                       
     if(DMA3)                            // display if DMA3 used
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,11);
     if(s8259)                           // display if a slave 8259 available
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,12);                      
     if(realtime)                        // display if a realtime clock is avail
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,13);
     if(keyint)                          // display if keyboard intercept avail
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,14);                     
     if(event)                          // display if external event available
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,15);                     
     if(extbios)                        // display if extended BIOS available
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,16);                     
     if(MCA)                            // display if MCA bus
       cputs("yes");
     else
       cputs("no");
   }

   getch();                             // wait for keystroke
   textattr(15);                        // white on black
   clrscr();                            // clear screen
   
   /**********************************************************************\
   *                       Display Memory Screen                          *
   \**********************************************************************/ 

   memory();                            // draw memory screen      
   highvideo();                         // turn on high-intensity
   textattr(31);                        // white on blue

   gotoxy(32,8);                        
   cprintf("%dK",getRAM());             // display total conventional memory

   gotoxy(32,9);                        
   cprintf("%luK",farcoreleft()/1024);  // display free conventional memory

   if(cpu > 3) {                        // check for '286 or higher
     gotoxy(32,11);              
     ext=getExt();                      // get total extended memory
     cprintf("%ldK",ext);               // display total extended memory
     gotoxy(32,12);                  
     exta=getAvailExt();                // get available extended memory
     cprintf("%ldK",exta);              // display available extended memory
     if(chkXMS()) {                     // check for XMS driver 
       if(!getXMSa(&xmsa,&xmsb)) {      // get XMS memory
         gotoxy(32,14);                     
         cprintf("%ldK",xmsa);          // display available XMS memory
         gotoxy(32,15);
         cprintf("%ldK",xmsb);          // display largest XMS block
       }
   
       if(!getXMSv(&major,&minor,&drvMaj,&drvMin)) {  // get XMS version
         gotoxy(32,16);
         cprintf("%d.%02d",major,minor);   // display XMS version
         gotoxy(32,17);
         cprintf("%d.%02d",drvMaj,drvMin); // display XMS driver version
       }

       if(!getXMSi(&HMA,&A20)) {        // get XMS information
         textattr(28);                  // bright red on blue
         gotoxy(32,18);
         if(A20)                        // display if A20 enabled
           cputs("Enabled");
         else
           cputs("Not Enabled");
         gotoxy(32,19);
         if(HMA)                        // display if HMA available
           cputs("Available");
         else
           cputs("Not Available");
         textattr(31);                  // white on blue
       }
     }
   }

   if(chkEMS()) {                       // check for EMS memory
     if(!getEMS(&ems,&emsa)) {          // get EMS memory
       gotoxy(68,8);
       cprintf("%dK",ems*16);           // display total EMS memory
       gotoxy(68,9);
       cprintf("%dK",emsa*16);          // display available EMS memory
     }

     if(!getEMSv(&major,&minor)) {      // get EMS driver version
       gotoxy(68,10);
       cprintf("%d.%02d",major,minor);  // display EMS driver version
     }

     if(!getEMSi(&handles,&segment)) {  // get EMS information
       gotoxy(68,11);
       cprintf("%X",segment);           // display EMS page frame address
       gotoxy(68,12);
       cprintf("%d",handles);           // display handles used
     }
   }
   else {
     gotoxy(68,8);
     cputs("0K");                     // display total EMS memory
     gotoxy(68,9);
     cputs("0K");                     // display available EMS memory
   }

   if(cpu > 3) {                        // check for '286 or higher
     if(chkDPMI()) {                    // check for DPMI driver
       textattr(28);                    // bright red on blue
       gotoxy(68,14);
       cputs("yes");
       textattr(31);                    // white on blue
       if(!getDPMIv(&major,&minor)) {   // get DPMI version
         gotoxy(68,15);
         cprintf("%d.%02d",major,minor);// display DPMI version
       }
     }
     else {
       textattr(28);                    // bright red on blue
       gotoxy(68,14);
       cputs("no");
       textattr(31);                    // white on blue
     }
   }
   else {
     textattr(28);                    // bright red on blue
     gotoxy(68,14);
     cputs("no");
     textattr(31);                    // white on blue
   }

   emm = 0;                           // default to EMM not installed
   if(cpu > 4 && chkXMS()) {          // check for '386 or higher and XMS
     emm=getEMM();                    // get '386 Extended Memory Manager type
     gotoxy(35,21);
     switch (emm) {
       case 1:
         cputs("Quadtel QMAPS or Hewlett-Packard HPMM.SYS");
         break;
       case 2:
         cputs("Microsoft EMM386.EXE");
         break;
       case 3:
         cputs("Microsoft Windows 3.x WIN386.EXE");
         break;
       case 4:
         cputs("DR-DOS 6.0 EMM386.SYS");
         break;
       case 5:
         cputs("Qualitas 386MAX");
         break;
       case 6:
         cputs("V Communication's Memory Commander");
         break;
       case 7:
         cputs("Quarterdeck QEMM-386");
         break;
       case 8:
         cputs("Helix Netroom RM386");
         break;
       default:
         cputs("Unknown or 386 Memory Manager not installed!");
     }
   }

   if(emm > 0) {                        // check for extended memory manager
     if(chkVCPI()) {                    // check for VCPI driver
       textattr(28);                    // bright red on blue
       gotoxy(68,17);
       cputs("yes");
       textattr(31);                    // white on blue
       getVCPIv(&major,&minor);         // get VCPI version
       gotoxy(68,18);
       cprintf("%d.%02d",major,minor);  // display VCPI version
     }
     else {
       textattr(28);                    // bright red on blue
       gotoxy(68,17);
       cputs("no");
       textattr(31);                    // white on blue
     }
   }
   else {
     textattr(28);                      // bright red on blue
     gotoxy(68,17);
     cputs("no");
     textattr(31);                      // white on blue
   }

   getch();                             // wait for keystroke
   textattr(15);                        // white on black
   clrscr();                            // clear screen

   /**********************************************************************\
   *                   Display Video Information Screen                   *
   \**********************************************************************/ 

   video();                             // draw video screen
   highvideo();                         // turn on high-intensity
   textattr(31);                        // white on blue

   gotoxy(42,10);

   card=getVideo();                     // get video card type

   switch (card) {
     case 1:
       cputs("MDA - Monochrome Display Adapter");
       break;
     case 2:
       cputs("HGA - Hercules Graphics Adapter");
       break;
     case 3:
       cputs("CGA - Color Graphics Adapter");
       break;
     case 4:
       cputs("EGA - Enhanced Graphics Adapter");
       break;
     case 5:
       cputs("MCGA - Multi-Color Graphics Array");
       break;
     case 6:
       cputs("VGA - Video Graphics Array");
       break;
   }

   if(card > 4) {                       // check for EGA or higher
     gotoxy(42,11);
     if(getCRT())
       cputs("Monochrome");
     else
       cputs("Color");
   }

   if(card == 6) {                      // check for VGA
     if(getVESA(&major,&minor,&vram)) { // check for VESA support
       textattr(28);                    // bright red on blue
       gotoxy(42,14);
       cputs("yes");
       textattr(31);                    // white on blue
       gotoxy(42,15);
       cprintf("%d.%d",major,minor);    // display VESA version
       gotoxy(42,16);
       cprintf("%dK",vram);             // display Video RAM
     }
     else {
       textattr(28);                    // bright red on blue
       gotoxy(42,14);
       cputs("no");
       textattr(31);                    // white on blue
     }
   }
   else {
     textattr(28);                      // bright red on blue
     gotoxy(42,14);
     cputs("no");
     textattr(31);                      // white on blue
   }

   getch();                             // wait for keystroke
   textattr(15);                        // white on black
   clrscr();                            // clear screen

   /**********************************************************************\
   *                    Display DOS Information Screen                    *
   \**********************************************************************/ 

   dos();                               // draw DOS screen
   highvideo();                         // turn on high-intensity
   textattr(31);                        // white on blue

   getDosV(&major,&minor);              // get DOS version
   oem=getDosOem();                     // get DOS OEM number
   drdos=getDrDosV();                   // get DR-DOS type

   gotoxy(21,8);
   cprintf("%d.%02d",major,minor);      // display DOS version

   gotoxy(26,8);
   if(major==6 && !oem)                 // check for IBM DOS 6.1
     cputs("(IBM DOS 6.1)");

   if(drdos) {                          // check for DR-DOS
     switch (drdos) {
       case 0x01:
         cputs("(Multi-User DR-DOS)");
         break;
       case 0x60:
         cputs("(DOS Plus)");
         break;
       case 0x63:
         cputs("(DR-DOS 3.41)");
         break;
       case 0x64:
         cputs("(DR-DOS 3.42)");
         break;
       case 0x65:
         cputs("(DR-DOS 5.0)");
         break;
       case 0x67:
         cputs("(DR-DOS 6.0)");
         break;
       case 0x70:
         cputs("(PalmDOS)");
         break;
       case 0x71:
         cputs("(DR-DOS 6.0)");
         break;
       case 0x72:
         cputs("(Novell DOS 7.0)");
     }
   }

   if(get4DosV(&major,&minor))          // check for 4DOS
     cprintf("(4DOS %d.%02d)",major,minor);

   gotoxy(21,9);
   cprintf("%02Xh",oem);                // display OEM number
   if(!drdos) {
     gotoxy(26,9);
     switch (oem) {
       case 0x00:
         cputs("(PC-DOS)");
         break;
       case 0x01:
         cputs("(Compaq DOS)");
         break;
       case 0x04:
         cputs("(AT&T DOS)");
         break;
       case 0x05:
         cputs("(Zenith DOS)");
         break;
       case 0x06:
         cputs("(Hewlett-Packard DOS)");
         break;
       case 0x0D:
         cputs("(Packard-Bell DOS)");
         break;
       case 0x16:
         cputs("(DEC DOS)");
         break;
       case 0x23:
         cputs("(Olivetti DOS)");
         break;
       case 0x29:
         cputs("(Toshiba DOS)");
         break;
       case 0x4D:
         cputs("(Hewlett-Packard DOS)");
         break;
       case 0xFF:
         cputs("(MS-DOS)");
     }
   }

   textattr(28);                        // bright red on blue
   gotoxy(21,10);
   if(major > 4 || drdos > 0x65) {      // check for DOS 5.0+ or DR-DOS 6.0+
     if(chkDosHigh())                   // see if DOS is loaded in high memory
       cputs("High");
     else
       cputs("Low");
   }
   else
     cputs("Low");
 
   gotoxy(75,7);
   if(chkAnsi())                        // check for ANSI.SYS
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,8);
   if(chkAppend())                      // check for APPEND.EXE
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,9);
   if(chkAssign())                      // check for ASSIGN.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,10);
   if(chkDisplay())                     // check for DISPLAY.SYS
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,11);
   if(chkDoskey())                      // check for DOSKEY.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,12);
   if(chkDriver())                      // check for DRIVER.SYS
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,13);
   if(chkEGA())                         // check for EGA.SYS
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,14);
   if(chkGraftabl())                    // check for GRAFTBL.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,15);
   if(chkGraphics())                    // check for GRAPHICS.COM
     cputs("yes");
   else 
     cputs("no");
   gotoxy(75,16);
   if(chkKeyb())                        // check for KEYB.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,17);
   if(chkNlsfunc())                     // check for NLSFUNC.EXE
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,18);
   if(chkPrint())                       // check for PRINT.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,19);
   if(chkShare())                       // check for SHARE.EXE
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,20);
   if(chkShellb())                      // check for SHELLB.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,21);
   if(chkXMA2EMS())                     // check for XMA2EMS.SYS
     cputs("yes");
   else
     cputs("no");

   textattr(31);                        // white on blue

   getch();                             // wait for keystroke
   textattr(15);                        // white on black
   clrscr();                            // clear screen

   /**********************************************************************\
   *                   Display Mouse Information Screen                   *
   \**********************************************************************/ 

   mouse();                             // draw mouse screen       
   highvideo();                         // turn on high-intensity
   textattr(31);                        // white on blue

   buttons=chkMouse();                  // check for mouse and get buttons

   if(buttons) {
     textattr(28);                      // bright red on blue
     gotoxy(45,10);
     cputs("yes");
     textattr(31);                      // white on blue
     gotoxy(45,11);
     getMouseI(&type,&irq);             // get mouse information
     switch (type) {                    // display mouse type
       case 1:
         cputs("Bus Mouse");
         break;
       case 2:
         cputs("Serial Mouse");
         break;
       case 3:
         cputs("Inport Mouse");
         break;
       case 4:
         cputs("PS/2 Mouse");
         break;
       case 5:
         cputs("Hewlett-Packard Mouse");
         break;
     }
     getMouseV(&major,&minor);          // get mouse driver version
     gotoxy(45,12);
     cprintf("%d.%02d",major,minor);    // display mouse driver version
     gotoxy(45,13);
     cprintf("%d",buttons);             // display number of buttons
     gotoxy(45,14);
     if(type==4)                        // display mouse IRQ
       cputs("PS/2 Port");
     else
       cprintf("%d",irq);
   }
   else {
     textattr(28);                      // bright red on blue
     gotoxy(45,10);
     cputs("no");
     textattr(31);                      // white on blue
   }

   getch();                             // wait for keystroke
   textattr(15);                        // white on black
   clrscr();                            // clear screen

   /**********************************************************************\
   *                  Display Shell Information Screen                    *
   \**********************************************************************/ 

   shells();                            // draw shell screen
   highvideo();                         // turn on high-intensity
   textattr(28);                        // bright red on blue

   gotoxy(25,8);
   if(getWinV(&major,&minor,&mode)) {   // check for Windows
     cputs("yes");
     textattr(31);                      // white on blue
     gotoxy(25,9); 
     cprintf("%d.%02d",major,minor);    // display Windows version
     gotoxy(25,10);
     if(mode)                           // display Windows mode
       cputs("Enhanced");
     else
       cputs("Standard");
     textattr(28);                      // bright red on blue
   }
   else 
     cputs("no"); 

   gotoxy(25,12);
   if(getDESQv(&major,&minor)) {        // check for DESQview
     cputs("yes");
     textattr(31);                      // white on blue
     gotoxy(25,13);
     cprintf("%d.%02d",major,minor);    // display DESQview version
     textattr(28);                      // bright red on blue
   }
   else 
     cputs("no"); 

   gotoxy(25,15);
   if(DosShell())                       // check for Microsoft DOS Shell
     cputs("yes");
   else
     cputs("no");

   gotoxy(25,16);
   if(CPTask())                         // check for PCTools CPTask
     cputs("yes");
   else
     cputs("no");

   gotoxy(25,17);
   if(TaskMax())                        // check for DR-DOS TaskMax
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,8);
   if(SmartDrv())                       // check for Microsoft SmartDrv
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,9);
   if(PcCache())                        // check for PCTools PC-Cache
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,10);
   if(PcKwik())                         // check for PC-Kwik
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,11);
   if(Ncache())                         // check for Norton Ncache
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,12);
   if(HyperDisk())                      // check for HyperDisk 
     cputs("yes");
   else
     cputs("no");

   dblspace=DblSpace();                 // check for DoubleSpace
   gotoxy(73,14);                       
   if(dblspace)                         
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,15);
   if(Spaceman())                       // check for Spacemanager
     cputs("yes");
   else
     cputs("no");

   stacker=Stacker();                   // check for Stacker
   gotoxy(73,16);
   if(stacker)
     cputs("yes");                      
   else
     cputs("no");

   mscdex=MSCDEX(&major,&minor);        // check for CD-ROM extension
   gotoxy(73,18);
   if(mscdex) {                         
     cputs("yes");
     textattr(31);                      // white on blue
     gotoxy(73,19);
     cprintf("%d.%02d",major,minor);    // display MSCDEX version
   }
   else
     cputs("no");

   getch();                             // wait for keystroke
   textattr(15);                        // white on black
   clrscr();                            // clear screen

   /**********************************************************************\
   *                  Display Drives Information Screen                   *
   \**********************************************************************/ 

   drives();                            // draw drives screen
   highvideo();                         // turn on high-intensity
   textattr(31);                        // white on blue

   x=5;
   y=9;

   if(!getFlopType(&a,&b)) {            // get floppy drive type
     gotoxy(x,y);
     switch (a) {
       case 0:
         break;                 
       case 1:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 5 360K DD");
         y++;
         break;
       case 2:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 5 1.2M HD");
         y++;
         break;
       case 3:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 720K DD");
         y++;
         break;
       case 4:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 1.44M HD");
         y++;
         break;
       case 5:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 2.88M ED");
         y++;
     }
     gotoxy(x,y);
     switch (b) {
       case 0:
         break;
       case 1:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 5 360K DD");
         y++;
         break;
       case 2:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 5 1.2M HD");
         y++;
         break;
       case 3:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 720K DD");
         y++;
         break;
       case 4:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 1.44M HD");
         y++;
         break;
       case 5:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 2.88M ED");
         y++;
     }
   }

   num = 3;                                      // starting drive
   lastdrive = getAvailDrvs();                   // get lastdrive

drvinfo:
   
   while (num<=lastdrive && num<=26 && y<=21) {     
     code = num + 64;
     sprintf(drive,"%c",code);
     if(isCDROM(drive)) {                        // check for CD-ROM drive
       gotoxy(x,y);
       cprintf("%c:",code);
       gotoxy(x+8,y);
       cputs("CD-ROM Drive");
       y++;
       num++;
       continue;
       }
     if(dblspace) {                              // check for DblSpace drive
       if(isDblSpace(drive)) {
         gotoxy(x,y);
         cprintf("%c:",code);
         gotoxy(x+8,y);
         cputs("DblSpace Drive");
         if(!getDrvSpace(drive,&SecPerClus,&FreeClus,&BytesPerSec,&TotalClus)) {
           ClusSize=BytesPerSec * SecPerClus;          // calc. cluster size
           FreeSpace=(FreeClus * ClusSize) / 1024000;  // calc. available space
           TotalSpace=TotalClus * ClusSize / 1024000;  // calc. total space
           gotoxy(x+51,y);
           cprintf("%5ldM",FreeSpace);             // display available space
           gotoxy(x+66,y);
           cprintf("%5ldM",TotalSpace);            // display total space
         }
         y++;
         num++;
         continue;
       }
     }
     if(stacker) {                               // check for Stacker drive
       if(isStacker(drive)) {
         gotoxy(x,y);
         cprintf("%c:",code);
         gotoxy(x+8,y);
         cputs("Stacker Drive");
         if(!getDrvSpace(drive,&SecPerClus,&FreeClus,&BytesPerSec,&TotalClus)) {
           ClusSize=BytesPerSec * SecPerClus;          // calc. cluster size
           FreeSpace=(FreeClus * ClusSize) / 1024000;  // calc. available space
           TotalSpace=TotalClus * ClusSize / 1024000;  // calc. total space
           gotoxy(x+51,y);
           cprintf("%5ldM",FreeSpace);             // display available space
           gotoxy(x+66,y);
           cprintf("%5ldM",TotalSpace);            // display total space
         }  
         y++;
         num++;
         continue;
       }
     }
     if(!chkRemovable(drive,&removable)) {       // check for fixed disk
       if(removable) {
         gotoxy(x,y);
         cprintf("%c:",code);
         gotoxy(x+8,y);
         cputs("Fixed Disk");
         if(!getDrvSpace(drive,&SecPerClus,&FreeClus,&BytesPerSec,&TotalClus)) {
           ClusSize=BytesPerSec * SecPerClus;          // calc. cluster size
           FreeSpace=(FreeClus * ClusSize) / 1024000;  // calc. available space
           TotalSpace=TotalClus * ClusSize / 1024000;  // calc. total space
           gotoxy(x+51,y);
           cprintf("%5ldM",FreeSpace);             // display available space
           gotoxy(x+66,y);
           cprintf("%5ldM",TotalSpace);            // display total space
         }
         if(!getDrvInfo(drive,&cyl,&heads,&sectors)) { // get fixed disk info
           y++;
           gotoxy(x+10,y);
           cprintf("%d Heads, %d Cylinders, %d Sec/Track",heads,cyl,sectors);
         }
         y++;
         num++;
         continue;
       }
     else
       gotoxy(x,y);
       cprintf("%c:",code);
       gotoxy(x+8,y);
       cputs("Removable");
       y++;
       num++;
       continue;
     }
     if(!chkRemote(drive,&remote)) {             // check for network drive
       if(remote) {
         gotoxy(x,y);
         cprintf("%c:",code);
         gotoxy(x+8,y);
         cputs("Remote Drive");
         if(!getDrvSpace(drive,&SecPerClus,&FreeClus,&BytesPerSec,&TotalClus)) {
           ClusSize=BytesPerSec * SecPerClus;          // calc. cluster size
           FreeSpace=(FreeClus * ClusSize) / 1024000;  // calc. available space
           TotalSpace=TotalClus * ClusSize / 1024000;  // calc. total space
           gotoxy(x+51,y);
           cprintf("%5ldM",FreeSpace);             // display available space
           gotoxy(x+66,y);
           cprintf("%5ldM",TotalSpace);            // display total space
         }
         y++;
       }
     }
     num++;
   }
   
   getch();                                 // wait for keystroke

   if(num<=lastdrive && num<=26) {          // see if a second page is needed
     y = 9;                                 // reset y-axis
     textattr(15);                          // white on black
     clrscr();                              // clear screen
     drives();                              // draw new drives screen
     highvideo();                           // turn on high-intensity
     textattr(31);                          // white on blue
     goto drvinfo;                          // display remaining drive info
   }

   textattr(15);                        // white on black
   clrscr();                            // clear screen

   /**********************************************************************\
   *                  Display Network Information Screen                  *
   \**********************************************************************/ 

   network();                           // draw drives screen
   highvideo();                         // turn on high-intensity
   textattr(28);                        // bright red on blue

   gotoxy(25,8);
   if(chkIPX())                         // check for IPX
     cputs("yes");
   else
     cputs("no");
  
   gotoxy(25,10);
   if(Netbios())                        // check for Netbios
     cputs("yes");
   else
     cputs("no");

   gotoxy(25,12);
   if(NetShell(&major,&minor,&rev,&type)) {   // check for NetShell
     cputs("yes");
     textattr(31);                            // white on blue
     gotoxy(25,13);
     cprintf("%d.%02d.%02d",major,minor,rev); // display NetShell Version
     gotoxy(25,14);
     switch (type) {                          // display memory type
       case 0:
         cputs("Conventional Memory");
         break;
       case 1:
         cputs("Expanded Memory");
         break;
       case 2:
         cputs("Extended Memory");
     }
     server=getNetName(&version,&sub,&conn,&use,&vol,&peak); // get server info
     gotoxy(25,16);
     cputs(server);                     // display server name
     gotoxy(25,17);
     cprintf("%d.%02d",version,sub);    // display NetWare version
     gotoxy(75,8);
     cprintf("%d",conn);                // display number of connections
     gotoxy(75,9);
     cprintf("%d",use);                 // display connections in use
     gotoxy(75,10);
     cprintf("%d",peak);                // display peak connections used
     gotoxy(75,11);
     cprintf("%d",vol);                 // display number of volumes supported
     user=getUserName();                // get user name
     gotoxy(25,19);
     cputs(user);                       // display user name
     if(!getLoginTime(&year,&month,&day,&hour,&min,&sec,&week)) {
       gotoxy(25,20);
       cprintf("%02d-%02d-%d at %02d:%02d:%02d",month,day,year,hour,min,sec);
     }
   }
   else 
     cputs("no");
   
   getch();                             // wait for keystroke

   normvideo();                         // turn off high-intensity
   textattr(15);                        // white on black
   clrscr();                            // clear screen
   _setcursortype(_NORMALCURSOR);       // restore cursor
   exit(0);

}

void hardware(void)
{
   textattr(30); cputs("ͻ                            SYSINFO LIBRARY DEMO");
   cputs("                                                               Version 1.0                                  ");
   cputs("͹                                 Hardware                                                 ");
   cputs("                                                                                                                              ");
   cputs("                                                                                 BIOS Category     :                                       ");
   cputs("                    BIOS I.D.         :                    DMA Channel 3 used            :        BIOS Date         :                    2n");
   cputs("d 8259 installed            :        Processor         :                    Real Time Clock installed     :        Math Co-processor :     ");
   cputs("               Keyboard Int. (INT 15/AH=4F)  :        Serial Ports      :                    Wait for External Event       :        Paralle");
   cputs("l Ports    :                    Extended BIOS allocated       :        Keyboard Type     :                    Micro Channel Bus             :");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                      ");
   cputs("͹                        Press any key for next screen...                      ");
   cputs("ͼ");
}

void memory(void)
{
   textattr(30); cputs("ͻ                            SYSINFO LIBRARY DEMO");
   cputs("                                                               Version 1.0                                  ");
   cputs("͹                                  Memory                                                  ");
   cputs("                                                                                                                              ");
   cputs("   Total Conventional Memory :               Total EMS Memory    :               Free Conventional Memory  :               Free EMS Memory ");
   cputs("    :                                                         EMS Version         :               Total Extended Memory     :              ");
   cputs(" EMS Address Page    :               Free Extended Memory      :               Handles in Use      :                                       ");
   cputs("                                                      Available XMS Memory      :               DPMI Installed      :               Largest");
   cputs(" XMS Memory Block  :               DPMI Version        :               XMS Version               :                                           ");
   cputs("        XMS Driver                :               VCPI Installed      :               A20 Address Line          :               VCPI Versio");
   cputs("n        :               High Memory Area          :                                                                                       ");
   cputs("                                          '386 Extended Memory Manager :                                              ");
   cputs("͹                        Press any key for next screen...                      ");
   cputs("ͼ");
}

void video(void)
{
   textattr(30); cputs("ͻ                            SYSINFO LIBRARY DEMO");
   cputs("                                                               Version 1.0                                  ");
   cputs("͹                                   Video                                                  ");
   cputs("                                                                                                                              ");
   cputs("                                                                                                                                           ");
   cputs("                                 Video Adapter Type     :                                                      Display Type           :    ");
   cputs("                                                                                                                                           ");
   cputs("                                                                   VESA Support Installed :                                                ");
   cputs("      VESA Version           :                                                      Video Memory           :                                 ");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                      ");
   cputs("͹                        Press any key for next screen...                      ");
   cputs("ͼ");
}

void dos(void)
{
   textattr(30); cputs("ͻ                            SYSINFO LIBRARY DEMO");
   cputs("                                                               Version 1.0                                  ");
   cputs("͹                                    DOS                                                   ");
   cputs("                                                                                                 ANSI.SYS installed     :     ");
   cputs("   DOS Version    :                              APPEND.EXE installed   :        DOS OEM Number :                              ASSIGN.COM i");
   cputs("nstalled   :        DOS Loaded     :                              DISPLAY.SYS installed  :                                                 ");
   cputs("     DOSKEY.COM installed   :                                                      DRIVER.SYS installed   :                                ");
   cputs("                      EGA.SYS installed      :                                                      GRAFTABL.COM installed :               ");
   cputs("                                       GRAPHICS.COM installed :                                                      KEYB.COM installed     :");
   cputs("                                                      NLSFUNC.EXE installed  :                                                      PRINT.C");
   cputs("OM installed    :                                                      SHARE.EXE installed    :                                            ");
   cputs("          SHELLB.COM installed   :                                                      XMS2EMS.SYS installed  :      ");
   cputs("͹                        Press any key for next screen...                      ");
   cputs("ͼ");
}

void mouse(void)
{
   textattr(30); cputs("ͻ                            SYSINFO LIBRARY DEMO");
   cputs("                                                               Version 1.0                                  ");
   cputs("͹                                   Mouse                                                  ");
   cputs("                                                                                                                              ");
   cputs("                                                                                                                                           ");
   cputs("                                         Mouse Installed   :                                                           Mouse Type        : ");
   cputs("                                                          Driver Version    :                                                           Num");
   cputs("ber of Buttons :                                                           Mouse IRQ         :                                             ");
   cputs("                                                                                                                                             ");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                      ");
   cputs("͹                        Press any key for next screen...                      ");
   cputs("ͼ");
}

void shells(void)
{
   textattr(30); cputs("ͻ                            SYSINFO LIBRARY DEMO");
   cputs("                                                               Version 1.0                                  ");
   cputs("͹                         TSR's, Drivers and Shells                                        ");
   cputs("                                                                                                                ");
   cputs("   Windows Resident   :                        Smartdrv Installed     :          Windows Version    :                        PC-Cache Insta");
   cputs("lled     :          Windows Mode       :                        PC-Kwik Installed      :                                                   ");
   cputs("   Ncache Installed       :          DESQview Resident  :                        HyperDisk Installed    :          DESQview Version   :    ");
   cputs("                                                                                                  DoubleSpace Installed  :          DOS She");
   cputs("ll Resident :                        Spacemanager Installed :          CPTask Resident    :                        Stacker Installed      :  ");
   cputs("        Taskmax Resident   :                                                                                                      MSCDEX In");
   cputs("stalled       :                                                      MSCDEX Version         :                                              ");
   cputs("                                                                                                                      ");
   cputs("͹                        Press any key for next screen...                      ");
   cputs("ͼ");
}

void drives(void)
{
   textattr(30); cputs("ͻ                            SYSINFO LIBRARY DEMO");
   cputs("                                                               Version 1.0                                  ");
   cputs("͹                                  Drives                                                  ");
   cputs("                                                  Drive     Type                                     Free Space    Total Space");
   cputs("                                                                          ");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                                             ");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                                           ");
   cputs("                                                                                                                      ");
   cputs("͹                        Press any key for next screen...                      ");
   cputs("ͼ");
}

void network(void)
{
   textattr(30); cputs("ͻ                            SYSINFO LIBRARY DEMO");
   cputs("                                                               Version 1.0                                  ");
   cputs("͹                                  Network                                                 ");
   cputs("                                                                                                                              ");
   cputs("   IPX Installed      :                 Number of Connections Supported :                                             Number of Connections");
   cputs(" in Use    :        Netbios Installed  :                 Peak Connections Used           :                                             Maxi");
   cputs("mum Connected Volumes       :        Shell Installed    :                                                          Shell Version      :    ");
   cputs("                                                      Shell Located in   :                                                                 ");
   cputs("                                                                       Server Name        :                                                  ");
   cputs("        Netware Version    :                                                                                                               ");
   cputs("                         User Name          :                                                          Login Date & Time  :                ");
   cputs("                                                                                                                      ");
   cputs("͹                        Press any key for next screen...                      ");
   cputs("ͼ");
}

