/*************************************************************************
          
    tAngle Library 0.02
    Copyright (c) 1994 CSC Three
    Library of functions for tAngle type.


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada
    
    USAGE

        This is a library for PseudoAngles, integer approximations
        of angles.  They are MUCH faster than floating point (especially
        without a math coprocessor) and offer several advantages.  Such
        as:

            1. Sine() and Cosine() use tables for very fast results.
            2. You can add angles but they will always be in the
               range USHRT_MIN to USHRT_MAX (0 to 2pi) because of
               overflow.

        Pseudoangles go from 0 to USHRT_MAX, indicating angles from
        straight up going around clockwise.  When USHRT_MAX is
        2^16 then we have a resolution of 0.0055 degrees.

        The values returned by PseudoCosine() and PseudoSine(),
        the tFract part, gofrom SHRT_MIN to SHRT_MAX.
                
************************************************************************/

#include <assert.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>

#include "Angle.h"
#include "TrigTbl.h"

/* -----------------------------------------------------------------------

    tFract Cosine(const tAngle Angle)

    Calculates the PseudoAngle cosine of the given pseudoangle.

----------------------------------------------------------------------- */

tFract Cosine(const tAngle Angle)
{
    unsigned short AngleOffset = Angle % (16384);   // Offset in quadrant
    unsigned short Quadrant = Angle / (16384);
    if (Quadrant == 0)
        return(trigTable[(short)(((long)(16383-AngleOffset) * (TRIGTBL_SIZE-1)/16384))]);
    else if (Quadrant == 1)
        return(-trigTable[(short)(((long)AngleOffset * (TRIGTBL_SIZE-1)/16384))]);
    else if (Quadrant == 2)
        return(-trigTable[(short)(((long)(16383-AngleOffset) * (TRIGTBL_SIZE-1)/16384))]);
    else
        return(trigTable[(short)(((long)AngleOffset * (TRIGTBL_SIZE-1)/16384))]);
}

/* -----------------------------------------------------------------------

    tFract Sine(const tAngle Angle)

    Calculates the PseudoAngle cosine of the given pseudoangle.

----------------------------------------------------------------------- */

tFract Sine(const tAngle Angle)
{
    unsigned short Quadrant = Angle / (16384);
    unsigned short AngleOffset = Angle % (16384);
    if (Quadrant == 0)
        return(trigTable[(short)(((long)AngleOffset * (TRIGTBL_SIZE-1)/16384))]);
    else if (Quadrant == 1)
        return(trigTable[(short)(((long)(16383-AngleOffset) * (TRIGTBL_SIZE-1)/16384))]);
    else if (Quadrant == 2)
        return(-trigTable[(short)(((long)AngleOffset * (TRIGTBL_SIZE-1)/16384))]);
    else
        return(-trigTable[(short)(((long)(16383-AngleOffset) * (TRIGTBL_SIZE-1)/16384))]);
}
