/************************************************************************* 
          
    tAngle Library 0.02
    Copyright (c) 1994 CSC Three
    Library of functions for tAngle type.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

*************************************************************************/

#ifndef TANGLE_LIBRARY_H
#define TANGLE_LIBRARY_H

/* -----------------------------------------------------------------------
    tAngle - A PseudoAngle is an angle from USHRT_MIN to USHRT_MAX.  Add 
             them together, but because of overflow the result will still
             be in the range USHRT_MIN to USHRT_MAX.  Handy.
    tFract - The fractional portion returned by sine and cosine.  These
             values range from SHRT_MIN to SHRT_MAX, meaning -1 to
             1 respectively.
----------------------------------------------------------------------- */

typedef unsigned short tAngle;
typedef signed short   tFract;

/* -----------------------------------------------------------------------
    Prototypes
----------------------------------------------------------------------- */

tFract Cosine(const tAngle Angle);
tFract Sine(const tAngle Angle);

#endif // TANGLE_LIBRARY_H
