/********************************************

    File: BALLOON.CPP
    Author: Mike Lyons
    Contents: A ColorFont, balloon

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

--------------------------------------------------------------------------*/

// Include definition of NULL
#include <stdlib.h>

// Include our standard types
#include "basic.h"

// Include font definitions
#include "font.h"

// Character pixel data

// Block data for char # 33 (!),  4x12
unsigned char far balloonC33[] = {
  0, 31, 29,  0,
 31, 29, 27, 26,
 30, 27, 26, 25,
 29, 27, 26, 25,
 29, 27, 26, 24,
 27, 27, 26, 24,
  0, 26, 25,  0,
  0, 25, 24,  0,
  0,  0,  0,  0,
  0, 31, 29,  0,
 30, 27, 25, 25,
  0, 25, 24,  0
};

// Block data for char # 34 ("),  8x 6
unsigned char far balloonC34[] = {
  0, 31,  0,  0,  0,  0, 31,  0,
 31, 29, 26,  0,  0, 31, 29, 26,
 29, 26, 27,  0,  0, 29, 26, 25,
 27, 27, 24,  0,  0, 27, 25, 24,
  0, 27,  0,  0,  0,  0, 25,  0,
  0, 24,  0,  0,  0,  0, 24,  0
};

// Block data for char # 35 (#), 10x12
unsigned char far balloonC35[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 31, 31,  0,  0, 31, 30,  0,  0,
  0,  0, 29, 27,  0,  0, 29, 27,  0,  0,
 31, 30, 29, 26, 29, 30, 29, 27, 29, 30,
 27, 27, 26, 26, 25, 25, 27, 26, 25, 24,
  0,  0, 27, 26,  0,  0, 27, 26,  0,  0,
  0,  0, 27, 26,  0,  0, 27, 26,  0,  0,
  0,  0, 27, 26,  0,  0, 27, 26,  0,  0,
 31, 30, 27, 26, 29, 30, 27, 26, 29, 30,
 27, 27, 27, 26, 25, 25, 27, 26, 25, 24,
  0,  0, 27, 25,  0,  0, 27, 25,  0,  0,
  0,  0, 25, 24,  0,  0, 25, 24,  0,  0
};

// Block data for char # 36 ($),  7x12
unsigned char far balloonC36[] = {
  0,  0, 31, 30, 29,  0,  0,
  0,  0, 30, 29, 27,  0,  0,
  0, 31, 29, 27, 26, 27, 26,
 30, 29, 27, 26, 25, 25, 24,
 29, 27,  0, 26,  0,  0,  0,
 29, 27, 29, 26, 29, 27,  0,
  0, 27, 25, 26, 25, 27, 26,
  0,  0,  0, 26,  0, 27, 25,
 31, 30, 29, 26, 29, 27, 24,
 30, 27, 27, 26, 26, 24,  0,
  0,  0, 26, 26, 26,  0,  0,
  0,  0, 25, 25, 24,  0,  0
};

// Block data for char # 37 (%), 12x12
unsigned char far balloonC37[] = {
  0, 31, 30,  0,  0,  0,  0,  0,  0,  0, 31,  0,
 31, 29, 29, 25,  0,  0,  0,  0,  0, 31, 29, 24,
 29, 29, 27, 24,  0,  0,  0,  0, 31, 29, 24,  0,
  0, 25, 24,  0,  0,  0,  0, 30, 29, 24,  0,  0,
  0,  0,  0,  0,  0,  0, 30, 27, 24,  0,  0,  0,
  0,  0,  0,  0,  0, 30, 27, 24,  0,  0,  0,  0,
  0,  0,  0,  0, 30, 27, 24,  0,  0,  0,  0,  0,
  0,  0,  0, 29, 27, 25,  0,  0,  0,  0,  0,  0,
  0,  0, 29, 27, 25,  0,  0,  0,  0, 31, 30,  0,
  0, 29, 27, 25,  0,  0,  0,  0, 31, 29, 29, 25,
 29, 27, 25,  0,  0,  0,  0,  0, 29, 29, 27, 24,
  0, 25,  0,  0,  0,  0,  0,  0,  0, 25, 24,  0
};

// Block data for char # 38 (&), 10x12
unsigned char far balloonC38[] = {
  0,  0,  0,  0, 29, 29,  0,  0,  0,  0,
  0,  0,  0, 29, 29, 27, 27,  0,  0,  0,
  0,  0, 29, 27, 25,  0, 27, 25,  0,  0,
  0,  0, 29, 27, 25,  0, 27, 25,  0,  0,
  0,  0, 27, 27,  0,  0, 29, 25,  0,  0,
  0,  0,  0, 27, 26, 29, 27, 25,  0,  0,
  0,  0, 29, 29, 26, 26, 25,  0,  0,  0,
  0, 29, 29, 29, 27, 27, 27,  0, 29, 27,
  0, 29, 29,  0,  0, 25, 25, 27, 25,  0,
  0, 29, 27,  0,  0,  0, 26, 25, 25,  0,
  0, 29, 27, 27, 29, 29, 26, 25, 24, 24,
  0,  0,  0, 27, 25, 25, 24,  0,  0,  0
};

// Block data for char # 39 ('),  5x 6
unsigned char far balloonC39[] = {
  0,  0,  0, 31,  0,
  0,  0, 31, 29, 26,
  0,  0, 29, 26, 27,
  0,  0, 27, 27, 24,
  0, 29, 27, 24,  0,
 29, 24,  0,  0,  0
};

// Block data for char # 40 ((),  6x12
unsigned char far balloonC40[] = {
  0,  0,  0,  0, 29,  0,
  0,  0, 31, 29, 27, 24,
  0, 31, 29, 27, 25,  0,
  0, 29, 27, 25,  0,  0,
 29, 27, 27,  0,  0,  0,
 29, 27, 27,  0,  0,  0,
 27, 27, 27,  0,  0,  0,
 25, 27, 27,  0,  0,  0,
  0, 27, 27, 27,  0,  0,
  0, 25, 27, 27, 27,  0,
  0,  0, 25, 27, 27, 24,
  0,  0,  0,  0, 24,  0
};

// Block data for char # 41 ()),  6x12
unsigned char far balloonC41[] = {
  0, 29,  0,  0,  0,  0,
 31, 29, 29, 27,  0,  0,
  0, 29, 27, 27, 27,  0,
  0,  0, 27, 27, 27,  0,
  0,  0,  0, 29, 27, 27,
  0,  0,  0, 29, 27, 25,
  0,  0,  0, 29, 27, 25,
  0,  0,  0, 29, 27, 24,
  0,  0, 29, 27, 25,  0,
  0, 29, 29, 27, 24,  0,
 29, 29, 25, 24,  0,  0,
  0, 24,  0,  0,  0,  0
};

// Block data for char # 42 (*), 13x12
unsigned char far balloonC42[] = {
  0,  0,  0,  0,  0,  0, 30, 28,  0,  0,  0,  0,  0,
  0,  0, 31, 30,  0,  0, 28, 28,  0,  0, 30, 27,  0,
  0,  0, 30, 28, 28,  0, 28, 26,  0, 30, 27, 24,  0,
  0,  0,  0, 29, 28, 28, 28, 28, 27, 27, 24,  0,  0,
  0,  0,  0,  0, 28, 28, 28, 28, 27, 27,  0,  0,  0,
  0, 30, 30, 28, 28, 28, 27, 27, 27, 26, 26, 26, 24,
  0, 30, 28, 28, 28, 27, 27, 27, 26, 25, 25, 24, 24,
  0,  0,  0,  0, 27, 27, 27, 26, 25, 25,  0,  0,  0,
  0,  0,  0, 30, 27, 26, 26, 26, 25, 25, 25,  0,  0,
  0,  0, 30, 27, 24,  0, 26, 25,  0, 26, 25, 24,  0,
  0,  0, 30, 24,  0,  0, 26, 24,  0,  0, 24, 24,  0,
  0,  0,  0,  0,  0,  0, 24, 24,  0,  0,  0,  0,  0
};

// Block data for char # 43 (+),  8x10
unsigned char far balloonC43[] = {
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 31, 29,  0,  0,  0,
  0,  0,  0, 29, 28,  0,  0,  0,
  0,  0,  0, 28, 28,  0,  0,  0,
 30, 29, 28, 28, 27, 27, 27, 24,
 29, 28, 27, 27, 27, 27, 25, 23,
  0,  0,  0, 27, 27,  0,  0,  0,
  0,  0,  0, 27, 25,  0,  0,  0,
  0,  0,  0, 25, 23,  0,  0,  0
};

// Block data for char # 44 (,),  5x14
unsigned char far balloonC44[] = {
  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,
  0,  0,  0, 31,  0,
  0,  0, 31, 29, 26,
  0,  0, 29, 26, 27,
  0,  0, 27, 27, 24,
  0, 29, 27, 24,  0,
 29, 24,  0,  0,  0
};

// Block data for char # 45 (-),  8x 7
unsigned char far balloonC45[] = {
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
 30, 29, 28, 28, 28, 28, 27, 24,
 29, 28, 27, 27, 27, 25, 25, 23
};

// Block data for char # 46 (.),  3x12
unsigned char far balloonC46[] = {
  0,  0,  0,
  0,  0,  0,
  0,  0,  0,
  0,  0,  0,
  0,  0,  0,
  0,  0,  0,
  0,  0,  0,
  0,  0,  0,
  0, 31,  0,
 31, 29, 26,
 29, 26, 27,
  0, 26,  0
};

// Block data for char # 47 (/), 12x12
unsigned char far balloonC47[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 31,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 31, 29, 24,
  0,  0,  0,  0,  0,  0,  0,  0, 31, 29, 24,  0,
  0,  0,  0,  0,  0,  0,  0, 30, 29, 24,  0,  0,
  0,  0,  0,  0,  0,  0, 30, 27, 24,  0,  0,  0,
  0,  0,  0,  0,  0, 30, 27, 24,  0,  0,  0,  0,
  0,  0,  0,  0, 30, 27, 24,  0,  0,  0,  0,  0,
  0,  0,  0, 29, 27, 25,  0,  0,  0,  0,  0,  0,
  0,  0, 29, 27, 25,  0,  0,  0,  0,  0,  0,  0,
  0, 29, 27, 25,  0,  0,  0,  0,  0,  0,  0,  0,
 29, 27, 25,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 25,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
};

// Block data for char # 48 (0),  8x12
unsigned char far balloonC48[] = {
  0,  0,  0, 30, 29,  0,  0,  0,
  0, 31, 30, 29, 29, 29, 27,  0,
  0, 29, 29, 26, 26, 27, 27,  0,
 30, 29, 26,  0,  0, 27, 27, 26,
 30, 27, 26,  0, 29, 27, 27, 26,
 29, 27, 27, 29, 24, 27, 27, 26,
 29, 27, 27, 24,  0, 29, 27, 26,
 29, 27, 27,  0,  0, 29, 27, 25,
 27, 27, 26,  0,  0, 30, 27, 24,
  0, 27, 26, 29, 29, 27, 26,  0,
  0, 27, 27, 26, 26, 25, 25,  0,
  0,  0,  0, 26, 26,  0,  0,  0
};

// Block data for char # 49 (1),  7x12
unsigned char far balloonC49[] = {
  0,  0, 31, 29, 29,  0,  0,
  0, 30, 27, 27, 27,  0,  0,
 30, 29, 27, 27, 25,  0,  0,
 29, 29, 27, 27, 25,  0,  0,
  0,  0, 27, 27, 25,  0,  0,
  0,  0, 27, 27, 25,  0,  0,
  0,  0, 27, 26, 25,  0,  0,
  0,  0, 27, 26, 25,  0,  0,
  0,  0, 27, 26, 25,  0,  0,
  0,  0, 29, 26, 25,  0,  0,
 31, 30, 29, 29, 25, 27, 27,
 30, 29, 27, 27, 25, 25, 24
};

// Block data for char # 50 (2),  9x12
unsigned char far balloonC50[] = {
  0,  0, 30, 29, 29, 28, 28,  0,  0,
  0, 31, 29, 28, 28, 26, 26, 26,  0,
 30, 29, 28,  0,  0,  0, 30, 26, 26,
 29, 29, 26,  0,  0,  0, 29, 26, 25,
  0,  0,  0,  0,  0, 29, 29, 26, 25,
  0,  0,  0,  0, 29, 28, 28, 26, 23,
  0,  0, 30, 30, 28, 28, 25,  0,  0,
  0, 30, 28, 28, 26, 23,  0,  0,  0,
 30, 28, 28, 25,  0,  0,  0,  0,  0,
 30, 28, 26,  0,  0,  0,  0,  0,  0,
 30, 28, 26, 28, 28, 29, 29, 30, 31,
 29, 26, 26, 26, 25, 25, 25, 23, 23
};

// Block data for char # 51 (3),  9x12
unsigned char far balloonC51[] = {
  0,  0, 30, 29, 29, 28, 28,  0,  0,
  0, 31, 29, 28, 28, 26, 26, 26,  0,
 30, 29, 26,  0,  0,  0, 30, 26, 26,
 29, 26, 26,  0,  0,  0, 29, 26, 25,
  0,  0,  0,  0,  0,  0, 29, 26, 25,
  0,  0,  0,  0, 29, 28, 28, 26,  0,
  0,  0,  0,  0, 26, 26, 26, 26,  0,
  0,  0,  0,  0,  0,  0, 28, 26, 26,
 30, 30, 26,  0,  0,  0, 29, 26, 25,
 29, 26, 26,  0,  0,  0, 28, 26, 25,
  0, 26, 26, 28, 28, 29, 29, 25,  0,
  0,  0, 26, 26, 25, 25, 25,  0,  0
};

// Block data for char # 52 (4), 11x12
unsigned char far balloonC52[] = {
  0,  0,  0,  0,  0,  0, 30, 30, 30,  0,  0,
  0,  0,  0,  0,  0, 30, 28, 27, 27,  0,  0,
  0,  0,  0,  0, 30, 28, 28, 27, 26,  0,  0,
  0,  0,  0, 29, 28, 27, 27, 27, 26,  0,  0,
  0,  0, 29, 28, 28,  0, 29, 27, 26,  0,  0,
  0, 29, 28, 28,  0,  0, 29, 27, 26,  0,  0,
 28, 28, 28,  0,  0,  0, 29, 27, 26,  0,  0,
 28, 27, 27, 27, 29, 29, 29, 27, 27, 27, 25,
 27, 26, 26, 26, 26, 26, 27, 27, 27, 25, 24,
  0,  0,  0,  0,  0,  0, 27, 26, 25,  0,  0,
  0,  0,  0,  0,  0,  0, 26, 25, 25,  0,  0,
  0,  0,  0,  0,  0,  0, 26, 24, 24,  0,  0
};

// Block data for char # 53 (5),  9x12
unsigned char far balloonC53[] = {
 30, 29, 29, 29, 29, 29, 29, 27, 27,
 30, 29, 27, 27, 27, 27, 27, 27, 27,
 29, 27,  0,  0,  0,  0,  0,  0,  0,
 29, 27,  0,  0,  0,  0,  0,  0,  0,
 29, 27, 27, 29, 29, 29, 29,  0,  0,
 29, 27, 27, 27, 27, 27, 27, 27,  0,
 29, 25, 25,  0,  0,  0, 27, 27, 26,
  0,  0,  0,  0,  0,  0,  0, 29, 26,
 30, 29,  0,  0,  0,  0,  0, 29, 26,
 29, 29, 27,  0,  0,  0, 29, 29, 25,
  0, 27, 27, 29, 29, 29, 27, 26,  0,
  0,  0, 27, 26, 26, 26, 25,  0,  0
};

// Block data for char # 54 (6),  9x12
unsigned char far balloonC54[] = {
  0,  0, 29, 29, 29, 29, 27,  0,  0,
  0, 29, 27, 27, 27, 27, 27, 27, 27,
 30, 27, 27,  0,  0,  0,  0, 27, 25,
 30, 27,  0,  0,  0,  0,  0,  0,  0,
 30, 27, 27, 29, 29, 29, 29,  0,  0,
 29, 27, 27, 27, 27, 27, 27, 27,  0,
 29, 27, 25,  0,  0,  0, 27, 27, 26,
 29, 27,  0,  0,  0,  0,  0, 29, 26,
 29, 27,  0,  0,  0,  0,  0, 29, 26,
 29, 27, 26,  0,  0,  0, 29, 29, 25,
  0, 26, 27, 29, 29, 29, 27, 26,  0,
  0,  0, 27, 26, 26, 26, 25,  0,  0
};

// Block data for char # 55 (7),  9x12
unsigned char far balloonC55[] = {
 30, 29, 29, 29, 29, 28, 28, 27, 27,
 29, 28, 27, 27, 27, 27, 27, 27, 26,
  0,  0,  0,  0,  0,  0, 27, 26, 24,
  0,  0,  0,  0,  0, 30, 27, 26,  0,
  0,  0,  0,  0, 30, 29, 26,  0,  0,
  0,  0,  0,  0, 29, 26, 24,  0,  0,
  0,  0,  0, 30, 29, 27,  0,  0,  0,
  0,  0,  0, 30, 27, 27,  0,  0,  0,
  0,  0,  0, 29, 27, 26,  0,  0,  0,
  0,  0,  0, 29, 27, 26,  0,  0,  0,
  0,  0,  0, 29, 27, 26,  0,  0,  0,
  0,  0,  0, 27, 26, 24,  0,  0,  0
};

// Block data for char # 56 (8),  9x12
unsigned char far balloonC56[] = {
  0,  0, 29, 29, 29, 29, 27,  0,  0,
  0, 29, 27, 27, 27, 27, 27, 27,  0,
 30, 27, 27,  0,  0,  0, 27, 27, 25,
 30, 27, 25,  0,  0,  0, 29, 25, 25,
  0, 27, 27, 27, 29, 29, 29, 25,  0,
  0, 27, 27, 27, 27, 27, 27, 27,  0,
 29, 27, 25,  0,  0,  0, 27, 27, 26,
 29, 27,  0,  0,  0,  0,  0, 29, 26,
 29, 27,  0,  0,  0,  0,  0, 29, 26,
 29, 27, 26,  0,  0,  0, 29, 29, 25,
  0, 26, 27, 29, 29, 29, 27, 26,  0,
  0,  0, 27, 26, 26, 26, 25,  0,  0
};

// Block data for char # 57 (9),  9x12
unsigned char far balloonC57[] = {
  0,  0, 29, 29, 29, 29, 27,  0,  0,
  0, 29, 27, 27, 27, 27, 27, 27,  0,
 30, 27, 27,  0,  0,  0, 27, 27, 27,
 30, 27, 25,  0,  0,  0, 29, 27, 27,
  0, 27, 27, 27, 29, 29, 29, 27, 26,
  0, 27, 27, 27, 27, 27, 27, 27, 26,
  0,  0,  0,  0,  0,  0, 26, 27, 26,
  0,  0,  0,  0,  0,  0, 29, 26, 26,
 29, 29,  0,  0,  0,  0, 29, 26, 26,
 29, 27, 26,  0,  0,  0, 29, 26, 25,
  0, 26, 27, 29, 29, 29, 27, 26,  0,
  0,  0, 27, 26, 26, 26, 25,  0,  0
};

// Block data for char # 58 (:),  3x12
unsigned char far balloonC58[] = {
  0,  0,  0,
  0, 31,  0,
 31, 29, 26,
 29, 26, 27,
  0, 27,  0,
  0,  0,  0,
  0,  0,  0,
  0,  0,  0,
  0, 31,  0,
 31, 29, 26,
 29, 26, 27,
  0, 27,  0
};

// Block data for char # 59 (;),  5x14
unsigned char far balloonC59[] = {
  0,  0,  0,  0,  0,
  0,  0,  0, 31,  0,
  0,  0, 31, 29, 26,
  0,  0, 29, 26, 27,
  0,  0,  0, 24,  0,
  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,
  0,  0,  0, 31,  0,
  0,  0, 31, 29, 26,
  0,  0, 29, 26, 27,
  0,  0, 27, 27, 24,
  0, 29, 27, 24,  0,
 29, 24,  0,  0,  0
};

// Block data for char # 60 (<),  7x12
unsigned char far balloonC60[] = {
  0,  0,  0,  0,  0, 31,  0,
  0,  0,  0,  0, 31, 29, 24,
  0,  0,  0, 31, 29, 24,  0,
  0,  0, 30, 29, 24,  0,  0,
  0, 30, 27, 24,  0,  0,  0,
 30, 27, 24,  0,  0,  0,  0,
 30, 27, 25,  0,  0,  0,  0,
  0, 27, 27, 29,  0,  0,  0,
  0,  0, 25, 27, 29,  0,  0,
  0,  0,  0, 25, 27, 29,  0,
  0,  0,  0,  0, 25, 27, 29,
  0,  0,  0,  0,  0, 25,  0
};

// Block data for char # 61 (=),  8x 9
unsigned char far balloonC61[] = {
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
 30, 29, 28, 28, 28, 28, 27, 24,
 29, 28, 27, 27, 27, 25, 25, 23,
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
 30, 29, 28, 28, 28, 28, 27, 24,
 29, 28, 27, 27, 27, 25, 25, 23
};

// Block data for char # 62 (>),  7x12
unsigned char far balloonC62[] = {
  0, 31,  0,  0,  0,  0,  0,
 24, 29, 31,  0,  0,  0,  0,
  0, 24, 29, 31,  0,  0,  0,
  0,  0, 24, 29, 30,  0,  0,
  0,  0,  0, 24, 27, 30,  0,
  0,  0,  0,  0, 24, 27, 30,
  0,  0,  0,  0, 25, 27, 30,
  0,  0,  0, 29, 27, 27,  0,
  0,  0, 29, 27, 25,  0,  0,
  0, 29, 27, 25,  0,  0,  0,
 29, 27, 25,  0,  0,  0,  0,
  0, 25,  0,  0,  0,  0,  0
};

// Block data for char # 63 (?),  9x12
unsigned char far balloonC63[] = {
  0,  0, 29, 29, 29, 29, 27,  0,  0,
  0, 29, 27, 27, 27, 27, 27, 27,  0,
 30, 27, 27,  0,  0,  0, 27, 27, 25,
 30, 27, 25,  0,  0,  0, 29, 25, 25,
  0,  0,  0,  0,  0, 29, 27, 25,  0,
  0,  0,  0, 27, 29, 27, 27,  0,  0,
  0,  0,  0, 27, 27, 25,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 29,  0,  0,  0,  0,
  0,  0,  0, 29, 29, 27,  0,  0,  0,
  0,  0,  0, 29, 27, 25,  0,  0,  0,
  0,  0,  0,  0, 25,  0,  0,  0,  0
};

// Block data for char # 64 (@), 10x12
unsigned char far balloonC64[] = {
  0,  0,  0, 30, 29, 29, 29,  0,  0,  0,
  0, 31, 30, 29, 29, 29, 27, 27, 27,  0,
  0, 29, 29,  0,  0,  0,  0, 27, 27,  0,
 30, 29,  0,  0,  0,  0,  0,  0, 27, 26,
 30, 27,  0, 31, 30, 29, 27,  0, 27, 26,
 29, 27,  0, 30,  0,  0,  0,  0, 27, 26,
 29, 27,  0, 29,  0,  0,  0,  0, 27, 26,
 29, 27,  0, 29, 27, 27, 27,  0, 27, 26,
 27, 27,  0,  0,  0,  0,  0,  0, 27, 26,
  0, 27, 27,  0,  0,  0,  0, 27, 27,  0,
  0, 27, 27, 27, 27, 27, 27, 26, 26,  0,
  0,  0,  0, 26, 26, 26, 26,  0,  0,  0
};

// Block data for char # 65 (A), 13x12
unsigned char far balloonC65[] = {
  0,  0,  0,  0,  0, 30, 27, 27,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 29, 27, 27,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 30, 27, 27, 27, 27,  0,  0,  0,  0,
  0,  0,  0,  0, 29, 27,  0, 27, 27,  0,  0,  0,  0,
  0,  0,  0, 30, 27,  0,  0,  0, 27, 27,  0,  0,  0,
  0,  0,  0, 29, 27,  0,  0,  0, 29, 27,  0,  0,  0,
  0,  0, 30, 29, 27, 27, 29, 29, 27, 27, 27,  0,  0,
  0,  0, 29, 27, 27, 27, 27, 27, 27, 27, 27,  0,  0,
  0, 30, 27, 27,  0,  0,  0,  0,  0, 27, 27, 27,  0,
  0, 29, 27, 25,  0,  0,  0,  0,  0, 27, 27, 27,  0,
 30, 27, 27,  0,  0,  0,  0,  0,  0,  0, 27, 27, 25,
 29, 27, 25,  0,  0,  0,  0,  0,  0,  0, 27, 27, 25
};

// Block data for char # 66 (B),  9x12
unsigned char far balloonC66[] = {
 31, 30, 30, 30, 30, 28, 28,  0,  0,
 30, 28, 28, 25, 28, 27, 27, 27,  0,
 30, 28, 25,  0,  0, 27, 27, 27, 27,
 28, 28, 25,  0,  0,  0, 29, 27, 27,
 28, 27, 27,  0,  0, 29, 29, 27,  0,
 28, 27, 27, 27, 29, 29, 28,  0,  0,
 28, 28, 27, 25, 27, 27, 27,  0,  0,
 28, 28, 25,  0,  0, 25, 27, 27,  0,
 28, 28, 25,  0,  0,  0, 29, 27, 27,
 28, 28, 27,  0,  0, 29, 29, 27, 25,
 28, 27, 27, 27, 29, 27, 27, 25,  0,
 27, 27, 27, 27, 25, 25, 25,  0,  0
};

// Block data for char # 67 (C), 10x12
unsigned char far balloonC67[] = {
  0,  0,  0, 30, 29, 29, 29,  0,  0,  0,
  0, 31, 30, 29, 29, 29, 27, 27, 27,  0,
  0, 29, 29, 27, 25, 27, 27, 27, 27,  0,
 30, 29, 27, 25,  0,  0, 27, 27, 27, 26,
 30, 27, 25,  0,  0,  0,  0, 27, 27, 26,
 29, 27, 25,  0,  0,  0,  0,  0,  0,  0,
 29, 27, 27,  0,  0,  0,  0,  0,  0,  0,
 29, 27, 27,  0,  0,  0,  0, 27, 27, 26,
 27, 27, 27, 27,  0,  0, 27, 27, 27, 26,
  0, 27, 27, 27, 27, 27, 27, 27, 26,  0,
  0, 27, 27, 27, 27, 27, 27, 26, 25,  0,
  0,  0,  0, 26, 26, 25, 25,  0,  0,  0
};

// Block data for char # 68 (D),  9x12
unsigned char far balloonC68[] = {
 31, 30, 30, 30, 30, 28, 28,  0,  0,
 30, 28, 28, 25, 28, 27, 27, 27,  0,
 30, 28, 25,  0,  0, 27, 27, 27, 27,
 28, 28, 25,  0,  0,  0, 29, 27, 27,
 28, 27, 27,  0,  0,  0, 29, 27, 27,
 28, 27, 27,  0,  0,  0, 28, 27, 27,
 28, 28, 27,  0,  0,  0, 29, 27, 27,
 28, 28, 27,  0,  0,  0, 29, 27, 27,
 28, 28, 27,  0,  0,  0, 29, 27, 27,
 28, 28, 27,  0,  0, 29, 29, 27, 25,
 28, 27, 27, 27, 29, 27, 27, 25,  0,
 27, 27, 27, 27, 25, 25, 25,  0,  0
};

// Block data for char # 69 (E),  8x12
unsigned char far balloonC69[] = {
 31, 30, 30, 30, 30, 28, 28, 27,
 30, 28, 28, 25, 28, 27, 27, 27,
 30, 28, 25,  0,  0,  0,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,
 28, 27, 27,  0,  0,  0,  0,  0,
 28, 27, 27, 27, 29, 29, 28,  0,
 28, 28, 27, 25, 27, 27, 27,  0,
 28, 28, 25,  0,  0,  0,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,
 28, 28, 27,  0,  0,  0,  0,  0,
 28, 27, 27, 27, 27, 27, 27, 25,
 27, 27, 27, 27, 25, 25, 25, 25
};

// Block data for char # 70 (F),  8x12
unsigned char far balloonC70[] = {
 31, 30, 30, 30, 30, 28, 28, 27,
 30, 28, 28, 25, 28, 27, 27, 27,
 30, 28, 25,  0,  0,  0,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,
 28, 27, 27,  0,  0,  0,  0,  0,
 28, 27, 27, 27, 29, 29, 28,  0,
 28, 28, 27, 25, 27, 27, 27,  0,
 28, 28, 25,  0,  0,  0,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,
 28, 28, 27,  0,  0,  0,  0,  0,
 28, 27, 27,  0,  0,  0,  0,  0,
 27, 27, 27,  0,  0,  0,  0,  0
};

// Block data for char # 71 (G), 10x12
unsigned char far balloonC71[] = {
  0,  0,  0, 30, 29, 29, 29,  0,  0,  0,
  0, 31, 30, 29, 29, 29, 27, 27, 27,  0,
  0, 29, 29, 27, 25, 27, 27, 27, 27,  0,
 30, 29, 27, 25,  0,  0, 27, 27, 27, 26,
 30, 27, 25,  0,  0,  0,  0, 27, 27, 26,
 29, 27, 25,  0,  0,  0,  0,  0,  0,  0,
 29, 27, 27,  0,  0,  0,  0,  0,  0,  0,
 29, 27, 27,  0,  0, 30, 29, 29, 29, 26,
 27, 27, 27, 27,  0,  0, 29, 27, 27, 26,
  0, 27, 27, 27, 27, 27, 27, 27, 26, 25,
  0, 27, 27, 27, 27, 27, 27, 27, 26, 25,
  0,  0,  0, 26, 26, 25, 27,  0, 25, 25
};

// Block data for char # 72 (H), 10x12
unsigned char far balloonC72[] = {
 31, 30, 30,  0,  0,  0,  0, 31, 30, 30,
 30, 28, 28,  0,  0,  0,  0, 30, 28, 25,
 30, 28, 25,  0,  0,  0,  0, 30, 28, 25,
 28, 28, 25,  0,  0,  0,  0, 28, 28, 25,
 28, 27, 27,  0,  0,  0,  0, 28, 28, 25,
 28, 27, 27, 27, 29, 29, 28, 28, 28, 25,
 28, 28, 27, 25, 27, 27, 27, 28, 28, 25,
 28, 28, 25,  0,  0,  0,  0, 28, 28, 25,
 28, 28, 25,  0,  0,  0,  0, 28, 28, 25,
 28, 28, 27,  0,  0,  0,  0, 28, 28, 25,
 28, 27, 27,  0,  0,  0,  0, 28, 28, 25,
 27, 27, 27,  0,  0,  0,  0, 27, 25, 25
};

// Block data for char # 73 (I),  9x12
unsigned char far balloonC73[] = {
 31, 31, 31, 31, 30, 30, 30, 30, 30,
 30, 30, 30, 30, 28, 28, 28, 28, 28,
  0,  0,  0, 30, 28, 25,  0,  0,  0,
  0,  0,  0, 28, 28, 25,  0,  0,  0,
  0,  0,  0, 28, 27, 27,  0,  0,  0,
  0,  0,  0, 28, 27, 27,  0,  0,  0,
  0,  0,  0, 28, 28, 27,  0,  0,  0,
  0,  0,  0, 28, 28, 25,  0,  0,  0,
  0,  0,  0, 28, 28, 25,  0,  0,  0,
  0,  0,  0, 28, 28, 27,  0,  0,  0,
 28, 28, 28, 28, 27, 28, 28, 28, 28,
 28, 28, 28, 28, 27, 27, 28, 28, 28
};

// Block data for char # 74 (J), 11x12
unsigned char far balloonC74[] = {
  0,  0, 30, 30, 29, 29, 29, 27, 27, 27, 26,
  0,  0, 30, 29, 27, 27, 27, 27, 26, 26, 26,
  0,  0,  0,  0,  0, 27, 27, 26,  0,  0,  0,
  0,  0,  0,  0,  0, 27, 27, 26,  0,  0,  0,
  0,  0,  0,  0,  0, 27, 27, 26,  0,  0,  0,
  0,  0,  0,  0,  0, 27, 27, 26,  0,  0,  0,
 29, 27,  0,  0,  0, 29, 27, 26,  0,  0,  0,
 29, 27, 27,  0,  0, 29, 27, 25,  0,  0,  0,
 27, 27, 26,  0,  0, 30, 27, 24,  0,  0,  0,
  0, 27, 26, 29, 29, 27, 26,  0,  0,  0,  0,
  0, 27, 27, 26, 26, 25, 25,  0,  0,  0,  0,
  0,  0,  0, 26, 26,  0,  0,  0,  0,  0,  0
};

// Block data for char # 75 (K), 10x12
unsigned char far balloonC75[] = {
 31, 30, 30,  0,  0,  0,  0, 31, 30, 30,
 30, 28, 28,  0,  0,  0,  0, 30, 27, 27,
 30, 28, 25,  0,  0,  0, 30, 28, 27,  0,
 28, 28, 25,  0,  0, 30, 28, 27,  0,  0,
 28, 27, 27,  0, 30, 28, 27,  0,  0,  0,
 28, 27, 27, 27, 27, 27,  0,  0,  0,  0,
 28, 28, 27, 25, 27, 27,  0,  0,  0,  0,
 28, 28, 25,  0, 27, 27, 27,  0,  0,  0,
 28, 28, 25,  0,  0, 27, 27, 27,  0,  0,
 28, 28, 27,  0,  0,  0, 27, 27, 27,  0,
 28, 27, 27,  0,  0,  0,  0, 27, 27, 25,
 27, 27, 27,  0,  0,  0,  0, 25, 25, 25
};

// Block data for char # 76 (L),  9x12
unsigned char far balloonC76[] = {
 31, 30, 30,  0,  0,  0,  0,  0,  0,
 30, 28, 28,  0,  0,  0,  0,  0,  0,
 30, 28, 25,  0,  0,  0,  0,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,  0,
 28, 27, 27,  0,  0,  0,  0,  0,  0,
 28, 27, 27,  0,  0,  0,  0,  0,  0,
 28, 28, 27,  0,  0,  0,  0,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,  0,
 28, 28, 27,  0,  0,  0,  0,  0,  0,
 28, 27, 28, 28, 28, 28, 28, 28, 25,
 28, 27, 27, 28, 25, 25, 25, 25, 25
};

// Block data for char # 77 (M), 10x12
unsigned char far balloonC77[] = {
 31, 30, 30,  0,  0,  0,  0, 31, 30, 30,
 30, 28, 28, 28,  0,  0, 30, 30, 28, 25,
 30, 28, 25, 28, 28, 30, 28, 30, 28, 25,
 28, 28, 25, 25, 28, 28, 25, 28, 28, 25,
 28, 27, 27,  0, 25, 25,  0, 28, 28, 25,
 28, 27, 27,  0,  0,  0,  0, 28, 28, 25,
 28, 28, 27,  0,  0,  0,  0, 28, 28, 25,
 28, 28, 25,  0,  0,  0,  0, 28, 28, 25,
 28, 28, 25,  0,  0,  0,  0, 28, 28, 25,
 28, 28, 27,  0,  0,  0,  0, 28, 28, 25,
 28, 27, 27,  0,  0,  0,  0, 28, 28, 25,
 27, 27, 27,  0,  0,  0,  0, 27, 25, 25
};

// Block data for char # 78 (N), 10x12
unsigned char far balloonC78[] = {
 31, 30, 30,  0,  0,  0,  0, 31, 30, 30,
 30, 28, 28, 28,  0,  0,  0, 30, 28, 25,
 30, 28, 28, 28, 28,  0,  0, 30, 28, 25,
 28, 28, 28, 28, 28, 28,  0, 28, 28, 25,
 28, 27, 27, 28, 28, 28,  0, 28, 28, 25,
 28, 27, 27,  0, 28, 28,  0, 28, 28, 25,
 28, 28, 27,  0, 28, 28,  0, 28, 28, 25,
 28, 28, 25,  0, 28, 28, 28, 28, 28, 25,
 28, 28, 25,  0, 25, 28, 28, 28, 28, 25,
 28, 28, 27,  0,  0, 25, 28, 28, 28, 25,
 28, 27, 27,  0,  0,  0, 25, 28, 28, 25,
 27, 27, 27,  0,  0,  0,  0, 27, 25, 25
};

// Block data for char # 79 (O), 10x12
unsigned char far balloonC79[] = {
  0,  0,  0, 30, 29, 29, 29,  0,  0,  0,
  0, 31, 30, 29, 29, 29, 27, 27, 27,  0,
  0, 29, 29, 27, 25, 27, 27, 27, 27,  0,
 30, 29, 27, 25,  0,  0, 27, 27, 27, 26,
 30, 27, 25,  0,  0,  0,  0, 27, 27, 26,
 29, 27, 25,  0,  0,  0,  0, 27, 27, 25,
 29, 27, 27,  0,  0,  0,  0, 27, 27, 25,
 29, 27, 27,  0,  0,  0,  0, 27, 27, 25,
 27, 27, 27, 27,  0,  0, 27, 27, 27, 26,
  0, 27, 27, 27, 27, 27, 27, 27, 26,  0,
  0, 27, 27, 27, 27, 27, 27, 26, 25,  0,
  0,  0,  0, 26, 26, 25, 25,  0,  0,  0
};

// Block data for char # 80 (P),  9x12
unsigned char far balloonC80[] = {
 31, 30, 30, 30, 30, 28, 28, 27,  0,
 30, 28, 28, 25, 28, 27, 27, 27,  0,
 30, 28, 25,  0,  0,  0, 29, 27, 27,
 28, 28, 25,  0,  0,  0, 29, 27, 27,
 28, 27, 27,  0,  0,  0, 29, 27, 25,
 28, 27, 27, 27, 29, 29, 28, 25,  0,
 28, 28, 27, 25, 27, 27, 27, 25,  0,
 28, 28, 25,  0,  0,  0,  0,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,  0,
 28, 28, 27,  0,  0,  0,  0,  0,  0,
 28, 27, 27,  0,  0,  0,  0,  0,  0,
 27, 27, 27,  0,  0,  0,  0,  0,  0
};

// Block data for char # 81 (Q), 10x12
unsigned char far balloonC81[] = {
  0,  0,  0, 30, 29, 29, 29,  0,  0,  0,
  0, 31, 30, 29, 29, 29, 27, 27, 27,  0,
  0, 29, 29, 27, 25, 27, 27, 27, 27,  0,
 30, 29, 27, 25,  0,  0, 27, 27, 27, 26,
 30, 27, 25,  0,  0,  0,  0, 27, 27, 26,
 29, 27, 25,  0,  0,  0,  0, 27, 27, 25,
 29, 27, 27,  0,  0,  0,  0, 27, 27, 25,
 29, 27, 27,  0,  0, 31, 30, 27, 27, 25,
 27, 27, 27, 27,  0, 30, 27, 27, 27, 26,
  0, 27, 27, 27, 27, 27, 27, 27, 27,  0,
  0, 27, 27, 27, 27, 27, 27, 27, 27, 25,
  0,  0,  0, 26, 26, 25, 25,  0, 25, 25
};

// Block data for char # 82 (R),  9x12
unsigned char far balloonC82[] = {
 31, 30, 30, 30, 30, 28, 28, 27,  0,
 30, 28, 28, 25, 28, 27, 27, 27,  0,
 30, 28, 25,  0,  0,  0, 29, 27, 27,
 28, 28, 25,  0,  0,  0, 29, 27, 27,
 28, 27, 27,  0,  0,  0, 29, 27, 25,
 28, 27, 27, 27, 29, 29, 28, 25,  0,
 28, 28, 27, 27, 27, 27, 27, 25,  0,
 28, 28, 27, 27, 27, 27,  0,  0,  0,
 28, 28, 27,  0, 27, 27, 27,  0,  0,
 28, 28, 27,  0,  0, 27, 27, 27,  0,
 28, 27, 27,  0,  0,  0, 27, 27, 25,
 27, 27, 27,  0,  0,  0, 25, 25, 25
};

// Block data for char # 83 (S), 10x12
unsigned char far balloonC83[] = {
  0,  0, 30, 30, 30, 30, 30, 30,  0,  0,
  0, 30, 30, 30, 26, 26, 28, 28, 28, 28,
 30, 30, 30, 26,  0,  0,  0, 28, 28, 28,
 30, 28, 26,  0,  0,  0,  0,  0,  0, 28,
 30, 28, 28, 28,  0,  0,  0,  0,  0,  0,
  0, 28, 28, 28, 28, 28, 28, 28,  0,  0,
  0,  0, 28, 28, 28, 28, 28, 28, 28,  0,
  0,  0,  0,  0,  0,  0, 28, 28, 28, 25,
 30,  0,  0,  0,  0,  0,  0, 30, 28, 25,
 30, 28, 28,  0,  0,  0, 30, 28, 28, 25,
 28, 28, 28, 28, 30, 28, 28, 28, 25,  0,
  0,  0, 28, 28, 28, 28, 25, 25,  0,  0
};

// Block data for char # 84 (T),  9x12
unsigned char far balloonC84[] = {
 31, 31, 31, 31, 30, 30, 30, 30, 30,
 30, 30, 30, 30, 28, 28, 28, 28, 28,
  0,  0,  0, 30, 28, 25,  0,  0,  0,
  0,  0,  0, 28, 28, 25,  0,  0,  0,
  0,  0,  0, 28, 27, 27,  0,  0,  0,
  0,  0,  0, 28, 27, 27,  0,  0,  0,
  0,  0,  0, 28, 28, 27,  0,  0,  0,
  0,  0,  0, 28, 28, 25,  0,  0,  0,
  0,  0,  0, 28, 28, 25,  0,  0,  0,
  0,  0,  0, 28, 28, 27,  0,  0,  0,
  0,  0,  0, 28, 27, 28,  0,  0,  0,
  0,  0,  0, 28, 27, 27,  0,  0,  0
};

// Block data for char # 85 (U), 10x12
unsigned char far balloonC85[] = {
 30, 29, 27,  0,  0,  0,  0, 27, 27, 26,
 30, 29, 27,  0,  0,  0,  0, 27, 27, 26,
 30, 29, 27,  0,  0,  0,  0, 27, 27, 26,
 30, 29, 27,  0,  0,  0,  0, 27, 27, 26,
 30, 27, 25,  0,  0,  0,  0, 27, 27, 26,
 29, 27, 25,  0,  0,  0,  0, 27, 27, 25,
 29, 27, 27,  0,  0,  0,  0, 27, 27, 25,
 29, 27, 27,  0,  0,  0,  0, 27, 27, 25,
 27, 27, 27, 27,  0,  0, 27, 27, 27, 26,
  0, 27, 27, 27, 27, 27, 27, 27, 26,  0,
  0, 27, 27, 27, 27, 27, 27, 26, 25,  0,
  0,  0,  0, 26, 26, 25, 25,  0,  0,  0
};

// Block data for char # 86 (V), 13x12
unsigned char far balloonC86[] = {
 29, 27, 25,  0,  0,  0,  0,  0,  0,  0, 27, 27, 25,
 30, 27, 27,  0,  0,  0,  0,  0,  0,  0, 27, 27, 25,
  0, 29, 27, 25,  0,  0,  0,  0,  0, 27, 27, 27,  0,
  0, 30, 27, 27,  0,  0,  0,  0,  0, 27, 27, 27,  0,
  0,  0, 29, 27, 27,  0,  0,  0, 27, 27, 27,  0,  0,
  0,  0, 30, 29, 27,  0,  0,  0, 27, 27, 27,  0,  0,
  0,  0,  0, 29, 27, 27,  0, 27, 29, 27,  0,  0,  0,
  0,  0,  0, 30, 27, 27,  0, 27, 27, 27,  0,  0,  0,
  0,  0,  0,  0, 29, 27, 27, 27, 27,  0,  0,  0,  0,
  0,  0,  0,  0, 30, 27, 27, 27, 27,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 29, 27, 27,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 30, 27, 27,  0,  0,  0,  0,  0
};

// Block data for char # 87 (W), 10x12
unsigned char far balloonC87[] = {
 31, 31, 29,  0,  0,  0,  0, 31, 31, 27,
 29, 29, 27,  0,  0,  0,  0, 31, 29, 27,
 29, 29, 27,  0,  0,  0,  0, 29, 29, 25,
 29, 28, 27,  0,  0,  0,  0, 29, 27, 25,
 29, 28, 27,  0,  0,  0,  0, 29, 28, 25,
 29, 28, 27,  0,  0,  0,  0, 29, 28, 25,
 29, 27, 27,  0,  0,  0,  0, 29, 28, 25,
 29, 27, 27,  0, 30, 30,  0, 28, 28, 25,
 29, 28, 27, 30, 28, 28, 27, 28, 28, 25,
 28, 28, 27, 28, 28, 27, 28, 28, 28, 25,
 28, 28, 28, 28,  0,  0, 27, 28, 28, 25,
 28, 28, 28,  0,  0,  0,  0, 27, 27, 25
};

// Block data for char # 88 (X), 12x12
unsigned char far balloonC88[] = {
  0, 30,  0,  0,  0,  0,  0,  0,  0,  0, 31,  0,
 30, 29, 30,  0,  0,  0,  0,  0,  0, 31, 29, 24,
  0, 25, 27, 30,  0,  0,  0,  0, 31, 29, 24,  0,
  0,  0, 25, 27, 30,  0,  0, 30, 29, 24,  0,  0,
  0,  0,  0, 25, 27, 30, 30, 27, 24,  0,  0,  0,
  0,  0,  0,  0, 27, 30, 27, 24,  0,  0,  0,  0,
  0,  0,  0,  0, 30, 27, 29, 29,  0,  0,  0,  0,
  0,  0,  0, 29, 27, 25, 27, 27, 29,  0,  0,  0,
  0,  0, 29, 27, 25,  0,  0, 25, 27, 29,  0,  0,
  0, 29, 27, 25,  0,  0,  0,  0, 25, 27, 27,  0,
 29, 27, 25,  0,  0,  0,  0,  0,  0, 25, 24, 24,
  0, 25,  0,  0,  0,  0,  0,  0,  0,  0, 24,  0
};

// Block data for char # 89 (Y), 13x12
unsigned char far balloonC89[] = {
  0, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0, 31,  0,
 30, 29, 30,  0,  0,  0,  0,  0,  0,  0, 31, 29, 24,
  0, 25, 27, 30,  0,  0,  0,  0,  0, 31, 29, 24,  0,
  0,  0, 25, 27, 30,  0,  0,  0, 31, 29, 24,  0,  0,
  0,  0,  0, 25, 27, 30,  0, 31, 29, 24,  0,  0,  0,
  0,  0,  0,  0, 27, 27, 27, 29, 24,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 27, 27, 29,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 30, 27, 27,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 29, 27, 27,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 30, 27, 24,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 29, 27, 24,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 29, 24, 24,  0,  0,  0,  0,  0
};

// Block data for char # 90 (Z), 10x12
unsigned char far balloonC90[] = {
 31, 31, 31, 31, 30, 30, 30, 30, 30, 28,
 30, 30, 30, 30, 30, 30, 28, 28, 28, 28,
  0,  0,  0,  0,  0,  0,  0, 28, 28, 28,
  0,  0,  0,  0,  0,  0, 30, 30, 24,  0,
  0,  0,  0,  0,  0, 30, 28, 24,  0,  0,
  0,  0,  0,  0, 30, 28, 24,  0,  0,  0,
  0,  0,  0, 30, 28, 24,  0,  0,  0,  0,
  0,  0, 30, 28, 24,  0,  0,  0,  0,  0,
  0, 30, 28, 24,  0,  0,  0,  0,  0,  0,
 30, 30, 24,  0,  0,  0,  0,  0,  0,  0,
 30, 28, 28, 28, 27, 27, 27, 27, 27, 27,
 30, 28, 28, 28, 27, 27, 27, 27, 27, 24
};

// Block data for char # 91 ([),  7x12
unsigned char far balloonC91[] = {
 29, 29, 29, 27, 27, 27, 27,
 29, 29, 27, 25, 25, 25, 27,
 29, 27, 25,  0,  0,  0,  0,
 29, 27, 25,  0,  0,  0,  0,
 29, 27, 25,  0,  0,  0,  0,
 29, 27, 25,  0,  0,  0,  0,
 29, 27, 25,  0,  0,  0,  0,
 29, 27, 27,  0,  0,  0,  0,
 27, 27, 27,  0,  0,  0,  0,
 27, 27, 27,  0,  0,  0,  0,
 27, 27, 27, 27, 27, 27, 25,
 27, 25, 25, 25, 25, 25, 25
};

// Block data for char # 92 (\), 12x12
unsigned char far balloonC92[] = {
  0, 31,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 24, 29, 31,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 24, 29, 31,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 24, 29, 30,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 24, 27, 30,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 24, 27, 30,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 24, 27, 30,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 25, 27, 29,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 25, 27, 29,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 25, 27, 29,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 25, 27, 29,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 25,  0
};

// Block data for char # 93 (]),  7x12
unsigned char far balloonC93[] = {
 29, 29, 29, 29, 29, 29, 27,
 29, 27, 27, 27, 27, 27, 27,
  0,  0,  0,  0, 27, 27, 25,
  0,  0,  0,  0, 27, 27, 25,
  0,  0,  0,  0, 29, 27, 25,
  0,  0,  0,  0, 29, 27, 25,
  0,  0,  0,  0, 29, 27, 25,
  0,  0,  0,  0, 29, 27, 25,
  0,  0,  0,  0, 29, 27, 25,
  0,  0,  0,  0, 29, 27, 25,
 29, 29, 29, 29, 29, 27, 25,
 29, 27, 27, 25, 25, 25, 25
};

// Block data for char # 94 (^),  9x 6
unsigned char far balloonC94[] = {
  0,  0,  0,  0, 30,  0,  0,  0,  0,
  0,  0,  0, 30, 28, 28,  0,  0,  0,
  0,  0, 30, 28, 28, 28, 27,  0,  0,
  0, 30, 28, 26,  0, 27, 27, 27,  0,
 30, 28, 26,  0,  0,  0, 27, 26, 26,
  0, 26,  0,  0,  0,  0,  0, 26,  0
};

// Block data for char # 95 (_), 12x12
unsigned char far balloonC95[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 30, 29, 28, 28, 28, 28, 27, 27, 27, 27, 27, 24,
 29, 28, 27, 27, 27, 27, 27, 27, 27, 25, 25, 23
};

// Block data for char # 96 (`),  5x 6
unsigned char far balloonC96[] = {
  0, 31,  0,  0,  0,
 31, 29, 26,  0,  0,
 29, 26, 27,  0,  0,
 27, 27, 27,  0,  0,
  0, 27, 27, 27,  0,
  0,  0,  0, 24, 24
};

// Block data for char # 97 (a),  9x12
unsigned char far balloonC97[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 29, 29, 29, 29,  0, 25, 25,
  0, 29, 27, 27, 27, 27, 27, 27, 25,
 29, 25, 25,  0,  0,  0, 27, 27, 26,
 29, 25,  0,  0,  0,  0,  0, 29, 26,
 30, 25,  0,  0,  0,  0,  0, 29, 26,
 29, 29, 27,  0,  0,  0, 29, 29, 25,
  0, 27, 27, 29, 29, 29, 27, 26, 25,
  0,  0, 27, 26, 26, 26,  0, 25, 25
};

// Block data for char # 98 (b),  9x12
unsigned char far balloonC98[] = {
 31, 30, 30,  0,  0,  0,  0,  0,  0,
 30, 28, 28,  0,  0,  0,  0,  0,  0,
 30, 28, 25,  0,  0,  0,  0,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,  0,
 28, 27, 27, 29, 29, 29, 29,  0,  0,
 28, 29, 27, 27, 27, 27, 27, 27,  0,
 28, 28, 27,  0,  0,  0, 27, 27, 26,
 28, 28, 25,  0,  0,  0,  0, 29, 26,
 28, 28, 25,  0,  0,  0,  0, 29, 26,
 28, 29, 27,  0,  0,  0, 29, 29, 25,
 28, 27, 28, 29, 29, 29, 27, 26,  0,
 28, 27, 27, 26, 26, 26, 26,  0,  0
};

// Block data for char # 99 (c),  9x12
unsigned char far balloonC99[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 29, 29, 29, 29, 29,  0,  0,
  0, 29, 27, 27, 27, 27, 27, 27,  0,
 29, 25, 25,  0,  0,  0, 27, 27, 26,
 29, 25,  0,  0,  0,  0,  0,  0,  0,
 30, 25,  0,  0,  0,  0,  0,  0,  0,
 29, 29, 27,  0,  0,  0, 29, 29, 25,
  0, 27, 27, 29, 29, 29, 27, 26,  0,
  0,  0, 27, 26, 26, 26, 26,  0,  0
};

// Block data for char #100 (d),  9x12
unsigned char far balloonC100[] = {
  0,  0,  0,  0,  0,  0, 31, 30, 30,
  0,  0,  0,  0,  0,  0, 30, 28, 28,
  0,  0,  0,  0,  0,  0, 30, 28, 25,
  0,  0,  0,  0,  0,  0, 28, 28, 25,
  0,  0, 29, 29, 29, 29, 28, 27, 27,
  0, 29, 27, 27, 27, 27, 28, 27, 27,
 29, 25, 25,  0,  0,  0, 28, 28, 27,
 29, 25,  0,  0,  0,  0, 28, 28, 25,
 30, 25,  0,  0,  0,  0, 28, 28, 25,
 29, 29, 27,  0,  0,  0, 28, 28, 27,
  0, 27, 27, 29, 29, 29, 27, 27, 28,
  0,  0, 27, 26, 26, 26, 26, 27, 27
};

// Block data for char #101 (e),  9x12
unsigned char far balloonC101[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 29, 29, 29, 29, 29,  0,  0,
  0, 29, 27, 27, 27, 27, 27, 27,  0,
 29, 27, 27,  0,  0,  0, 27, 27, 26,
 29, 27,  0,  0, 27, 26, 26, 29,  0,
 30, 27, 27, 27, 26,  0,  0,  0,  0,
 29, 29, 27,  0,  0,  0,  0,  0,  0,
  0, 27, 27, 29, 29, 29, 27, 26,  0,
  0,  0, 27, 26, 26, 26, 26,  0,  0
};

// Block data for char #102 (f),  8x12
unsigned char far balloonC102[] = {
  0,  0,  0,  0, 30, 30, 28,  0,
  0,  0,  0, 30, 28, 28, 28, 28,
  0,  0, 30, 28, 28,  0, 28, 28,
  0,  0, 28, 28, 25,  0,  0,  0,
 30, 29, 28, 27, 27, 28, 27, 24,
 29, 28, 28, 27, 27, 25, 25, 23,
  0,  0, 28, 28, 27,  0,  0,  0,
  0,  0, 28, 28, 25,  0,  0,  0,
  0,  0, 28, 28, 25,  0,  0,  0,
  0,  0, 28, 28, 27,  0,  0,  0,
  0,  0, 28, 27, 28,  0,  0,  0,
  0,  0, 28, 27, 27,  0,  0,  0
};

// Block data for char #103 (g),  9x16
unsigned char far balloonC103[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 29, 29, 29, 29, 29,  0,  0,
  0, 29, 27, 27, 27, 27, 27, 27,  0,
 29, 25, 25,  0,  0,  0, 27, 27, 26,
 29, 25,  0,  0,  0,  0, 27, 27, 26,
 30, 25,  0,  0,  0,  0, 25, 27, 26,
 29, 29, 27,  0,  0,  0, 29, 27, 27,
  0, 27, 27, 29, 29, 29, 27, 27, 27,
  0,  0, 27, 26, 26, 26, 27, 27, 25,
  0,  0,  0,  0,  0,  0, 27, 27, 25,
 29, 27, 27,  0,  0,  0, 27, 25, 25,
 29, 27, 27, 27, 27, 27, 27, 25,  0,
  0,  0, 27, 27, 27, 25, 25,  0,  0
};

// Block data for char #104 (h), 10x12
unsigned char far balloonC104[] = {
 31, 30, 30,  0,  0,  0,  0,  0,  0,  0,
 30, 28, 28,  0,  0,  0,  0,  0,  0,  0,
 30, 28, 25,  0,  0,  0,  0,  0,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,  0,  0,
 28, 27, 27, 27, 29, 29, 28, 28,  0,  0,
 28, 27, 27, 27, 29, 29, 28, 28, 28,  0,
 28, 28, 27,  0,  0,  0, 28, 28, 28, 25,
 28, 28, 25,  0,  0,  0,  0, 28, 28, 25,
 28, 28, 25,  0,  0,  0,  0, 28, 28, 25,
 28, 28, 27,  0,  0,  0,  0, 28, 28, 25,
 28, 27, 27,  0,  0,  0,  0, 28, 28, 25,
 27, 27, 27,  0,  0,  0,  0, 27, 25, 25
};

// Block data for char #105 (i),  3x12
unsigned char far balloonC105[] = {
 31, 30, 30,
 30, 28, 28,
  0,  0,  0,
  0,  0,  0,
 28, 27, 27,
 28, 27, 27,
 28, 28, 27,
 28, 28, 25,
 28, 28, 25,
 28, 28, 27,
 28, 27, 28,
 28, 27, 27
};

// Block data for char #106 (j),  9x16
unsigned char far balloonC106[] = {
  0,  0,  0,  0,  0,  0, 31, 30, 30,
  0,  0,  0,  0,  0,  0, 30, 28, 28,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 29, 27, 27,
  0,  0,  0,  0,  0,  0, 27, 27, 27,
  0,  0,  0,  0,  0,  0, 27, 27, 27,
  0,  0,  0,  0,  0,  0, 27, 27, 27,
  0,  0,  0,  0,  0,  0, 27, 28, 27,
  0,  0,  0,  0,  0,  0, 27, 27, 27,
  0,  0,  0,  0,  0,  0, 27, 27, 27,
  0,  0,  0,  0,  0,  0, 27, 27, 25,
  0,  0,  0,  0,  0,  0, 27, 27, 25,
 29, 27, 27,  0,  0,  0, 27, 25, 25,
 29, 27, 27, 27, 27, 27, 27, 25,  0,
  0,  0, 27, 27, 27, 25, 25,  0,  0
};

// Block data for char #107 (k),  9x12
unsigned char far balloonC107[] = {
 31, 30, 30,  0,  0,  0,  0,  0,  0,
 30, 28, 28,  0,  0,  0,  0,  0,  0,
 30, 28, 28,  0,  0,  0,  0,  0,  0,
 30, 28, 27,  0,  0,  0,  0,  0,  0,
 28, 28, 27,  0,  0,  0, 30, 30, 30,
 28, 27, 27,  0, 30, 30, 27, 27, 25,
 28, 28, 27, 30, 27, 27, 25,  0,  0,
 28, 28, 27, 27, 25,  0,  0,  0,  0,
 28, 28, 27, 27, 27,  0,  0,  0,  0,
 28, 28, 27, 25, 27, 27, 27,  0,  0,
 28, 27, 28,  0, 25, 27, 27, 27, 27,
 28, 27, 27,  0,  0,  0, 25, 27, 25
};

// Block data for char #108 (l),  3x12
unsigned char far balloonC108[] = {
 31, 30, 30,
 30, 28, 28,
 30, 28, 28,
 30, 28, 27,
 28, 28, 27,
 28, 27, 27,
 28, 28, 27,
 28, 28, 25,
 28, 28, 25,
 28, 28, 27,
 28, 27, 28,
 28, 27, 27
};

// Block data for char #109 (m), 16x12
unsigned char far balloonC109[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 29, 29, 29, 29, 29,  0,  0,  0, 29, 29, 29, 29,  0,  0,
  0, 29, 27, 27, 27, 27, 27, 27, 29, 27, 27, 27, 27, 27, 27,  0,
 29, 25, 25,  0,  0,  0, 27, 27, 25, 25,  0,  0,  0, 27, 27, 26,
 29, 25,  0,  0,  0,  0,  0, 29, 26,  0,  0,  0,  0,  0, 29, 26,
 30, 27,  0,  0,  0,  0,  0, 29, 26,  0,  0,  0,  0,  0, 29, 26,
 29, 27,  0,  0,  0,  0,  0, 29, 25,  0,  0,  0,  0,  0, 29, 25,
 27, 27,  0,  0,  0,  0,  0, 27, 27,  0,  0,  0,  0,  0, 27, 27,
 27, 27,  0,  0,  0,  0,  0, 27, 27,  0,  0,  0,  0,  0, 27, 27
};

// Block data for char #110 (n),  9x12
unsigned char far balloonC110[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
 29, 29,  0, 29, 29, 29, 29,  0,  0,
 29, 29, 27, 27, 27, 27, 27, 27,  0,
 29, 27, 25,  0,  0,  0, 27, 27, 26,
 29, 27,  0,  0,  0,  0,  0, 29, 26,
 30, 27,  0,  0,  0,  0,  0, 29, 26,
 29, 27,  0,  0,  0,  0,  0, 29, 25,
 27, 27,  0,  0,  0,  0,  0, 27, 27,
 27, 27,  0,  0,  0,  0,  0, 27, 27
};

// Block data for char #111 (o),  9x12
unsigned char far balloonC111[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 29, 29, 29, 29, 29,  0,  0,
  0, 29, 27, 27, 27, 27, 27, 27,  0,
 29, 25, 25,  0,  0,  0, 27, 27, 26,
 29, 25,  0,  0,  0,  0,  0, 29, 26,
 30, 25,  0,  0,  0,  0,  0, 29, 26,
 29, 29, 27,  0,  0,  0, 29, 29, 25,
  0, 27, 27, 29, 29, 29, 27, 26,  0,
  0,  0, 27, 26, 26, 26, 26,  0,  0
};

// Block data for char #112 (p),  9x16
unsigned char far balloonC112[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
 31, 30, 30, 29, 29, 29, 29,  0,  0,
 30, 28, 28, 27, 27, 27, 27, 27,  0,
 30, 28, 28,  0,  0,  0, 27, 27, 26,
 30, 28, 27,  0,  0,  0,  0, 29, 26,
 28, 28, 27,  0,  0,  0,  0, 29, 26,
 28, 27, 27,  0,  0,  0, 29, 29, 25,
 28, 28, 27, 29, 29, 29, 27, 26,  0,
 28, 28, 25, 26, 26, 26, 26,  0,  0,
 28, 28, 25,  0,  0,  0,  0,  0,  0,
 28, 28, 27,  0,  0,  0,  0,  0,  0,
 28, 27, 28,  0,  0,  0,  0,  0,  0,
 28, 27, 27,  0,  0,  0,  0,  0,  0
};

// Block data for char #113 (q),  9x16
unsigned char far balloonC113[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 29, 29, 29, 29, 31, 30, 30,
  0, 29, 27, 27, 27, 27, 30, 28, 28,
 29, 25, 25,  0,  0,  0, 30, 28, 28,
 29, 25,  0,  0,  0,  0, 30, 28, 27,
 30, 25,  0,  0,  0,  0, 28, 28, 27,
 29, 29, 27,  0,  0,  0, 28, 27, 27,
  0, 27, 27, 29, 29, 29, 28, 28, 27,
  0,  0, 27, 26, 26, 26, 28, 28, 25,
  0,  0,  0,  0,  0,  0, 28, 28, 25,
  0,  0,  0,  0,  0,  0, 28, 28, 27,
  0,  0,  0,  0,  0,  0, 28, 27, 28,
  0,  0,  0,  0,  0,  0, 28, 27, 27
};

// Block data for char #114 (r),  6x12
unsigned char far balloonC114[] = {
  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,
 29, 29,  0, 29, 29, 29,
 29, 29, 27, 27, 27, 27,
 29, 27, 25,  0,  0,  0,
 29, 27,  0,  0,  0,  0,
 30, 27,  0,  0,  0,  0,
 29, 27,  0,  0,  0,  0,
 27, 27,  0,  0,  0,  0,
 27, 27,  0,  0,  0,  0
};

// Block data for char #115 (s),  9x12
unsigned char far balloonC115[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 29, 29, 29, 29, 29, 27,  0,
  0, 29, 27, 27, 27, 27, 27, 27, 27,
 29, 25, 25,  0,  0,  0,  0,  0,  0,
 29, 27, 27, 27, 27, 27, 27, 27, 26,
 30, 27, 27, 27, 27, 27, 27, 27, 26,
  0,  0,  0,  0,  0,  0, 29, 29, 25,
 27, 27, 27, 29, 29, 29, 27, 26,  0,
  0, 27, 27, 26, 26, 26, 26,  0,  0
};

// Block data for char #116 (t),  7x12
unsigned char far balloonC116[] = {
  0,  0, 31, 30, 30,  0,  0,
  0,  0, 30, 28, 28,  0,  0,
  0,  0, 30, 28, 28,  0,  0,
  0,  0, 28, 28, 25,  0,  0,
 30, 29, 28, 27, 27, 28, 25,
 29, 28, 28, 27, 27, 25, 25,
  0,  0, 28, 28, 27,  0,  0,
  0,  0, 28, 28, 25,  0,  0,
  0,  0, 28, 28, 25,  0,  0,
  0,  0, 28, 28, 27,  0,  0,
  0,  0, 28, 27, 28,  0,  0,
  0,  0, 28, 27, 27,  0,  0
};

// Block data for char #117 (u),  9x12
unsigned char far balloonC117[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
 30, 30,  0,  0,  0,  0,  0, 30, 30,
 30, 29,  0,  0,  0,  0,  0, 30, 27,
 30, 27,  0,  0,  0,  0,  0, 30, 27,
 29, 27,  0,  0,  0,  0,  0, 29, 27,
 30, 27,  0,  0,  0,  0,  0, 29, 27,
 29, 29, 27,  0,  0,  0, 29, 29, 27,
  0, 27, 27, 29, 29, 29, 27, 27, 24,
  0,  0, 27, 26, 26, 26,  0, 24, 24
};

// Block data for char #118 (v), 13x12
unsigned char far balloonC118[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0, 30,  0,
 30, 28, 28,  0,  0,  0,  0,  0,  0,  0, 30, 26, 26,
  0, 30, 28, 26,  0,  0,  0,  0,  0, 30, 26, 26,  0,
  0,  0, 30, 28, 26,  0,  0,  0, 28, 26, 26,  0,  0,
  0,  0,  0, 28, 28, 26,  0, 28, 27, 26,  0,  0,  0,
  0,  0,  0,  0, 28, 28, 28, 28, 26,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 26, 28, 26,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 26,  0,  0,  0,  0,  0,  0
};

// Block data for char #119 (w), 16x12
unsigned char far balloonC119[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 30, 29,  0,  0,  0,  0,  0, 30, 30,  0,  0,  0,  0,  0, 30, 30,
 29, 27,  0,  0,  0,  0,  0, 30, 27,  0,  0,  0,  0,  0, 30, 27,
 29, 27,  0,  0,  0,  0,  0, 30, 25,  0,  0,  0,  0,  0, 30, 25,
 27, 25,  0,  0,  0,  0,  0, 27, 25,  0,  0,  0,  0,  0, 27, 25,
 27, 25,  0,  0,  0,  0,  0, 27, 25,  0,  0,  0,  0,  0, 27, 25,
 27, 27, 27,  0,  0,  0, 25, 25, 25, 27,  0,  0,  0, 25, 25, 25,
  0, 27, 27, 27, 27, 27, 27, 25, 27, 27, 27, 27, 27, 27, 25,  0,
  0,  0, 29, 29, 29, 29,  0,  0,  0, 25, 25, 25, 25, 25,  0,  0
};

// Block data for char #120 (x),  8x12
unsigned char far balloonC120[] = {
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,
  0, 30,  0,  0,  0,  0, 30,  0,
 30, 28, 28,  0,  0, 30, 26, 26,
  0, 30, 28, 26, 30, 26, 26,  0,
  0,  0, 30, 28, 26, 26,  0,  0,
  0,  0, 28, 28, 28, 26,  0,  0,
  0, 28, 28, 26, 28, 28, 28,  0,
 26, 28, 26,  0,  0, 26, 28, 26,
  0, 26,  0,  0,  0,  0, 26,  0
};

// Block data for char #121 (y),  9x16
unsigned char far balloonC121[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
 30, 30,  0,  0,  0,  0,  0, 30, 30,
 30, 29,  0,  0,  0,  0,  0, 30, 27,
 30, 27,  0,  0,  0,  0,  0, 30, 27,
 29, 27,  0,  0,  0,  0,  0, 29, 27,
 30, 27,  0,  0,  0,  0,  0, 29, 27,
 29, 29, 27,  0,  0,  0, 29, 29, 27,
  0, 27, 27, 29, 29, 29, 27, 27, 24,
  0,  0, 27, 26, 26, 26, 27, 27, 25,
  0,  0,  0,  0,  0,  0, 27, 27, 25,
 29, 27, 27,  0,  0,  0, 27, 25, 25,
 29, 27, 27, 27, 27, 27, 27, 25,  0,
  0,  0, 27, 27, 27, 25, 25,  0,  0
};

// Block data for char #122 (z),  9x12
unsigned char far balloonC122[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,
 30, 30, 29, 29, 29, 29, 29, 27, 25,
 30, 29, 27, 27, 27, 27, 27, 27, 25,
  0,  0,  0,  0,  0,  0, 27, 27, 25,
  0,  0,  0, 29, 27, 27, 27, 25,  0,
  0, 29, 29, 27, 25, 25,  0,  0,  0,
 29, 29, 27,  0,  0,  0,  0,  0,  0,
 27, 27, 27, 29, 29, 29, 27, 26, 27,
 27, 27, 27, 26, 26, 26, 25, 25, 25
};

// Block data for char #123 ({),  6x12
unsigned char far balloonC123[] = {
  0,  0,  0,  0, 29,  0,
  0,  0, 31, 29, 27, 24,
  0, 31, 29, 27, 25,  0,
  0, 29, 27, 25,  0,  0,
  0,  0, 27, 25,  0,  0,
 29, 27, 27,  0,  0,  0,
 27, 27, 27,  0,  0,  0,
  0,  0, 27, 27,  0,  0,
  0, 27, 27, 27,  0,  0,
  0, 25, 27, 27, 27,  0,
  0,  0, 25, 27, 27, 24,
  0,  0,  0,  0, 24,  0
};

// Block data for char #124 (|),  3x12
unsigned char far balloonC124[] = {
 31, 30, 30,
 30, 28, 28,
 30, 28, 28,
 30, 28, 27,
 28, 28, 27,
  0,  0,  0,
  0,  0,  0,
 28, 28, 25,
 28, 28, 25,
 28, 28, 27,
 28, 27, 28,
 28, 27, 27
};

// Block data for char #125 (}),  6x12
unsigned char far balloonC125[] = {
  0, 29,  0,  0,  0,  0,
 31, 29, 29, 27,  0,  0,
  0, 29, 27, 27, 27,  0,
  0,  0, 27, 27, 27,  0,
  0,  0, 29, 27,  0,  0,
  0,  0,  0, 29, 27, 25,
  0,  0,  0, 29, 27, 25,
  0,  0, 29, 27,  0,  0,
  0,  0, 29, 27, 25,  0,
  0, 29, 29, 27, 24,  0,
 29, 29, 25, 24,  0,  0,
  0, 24,  0,  0,  0,  0
};

// Block data for char #126 (~),  8x 4
unsigned char far balloonC126[] = {
  0, 29, 28,  0,  0,  0,  0,  0,
 30, 28, 27, 28, 28,  0,  0, 24,
 29,  0,  0, 27, 27, 28, 27, 23,
  0,  0,  0,  0,  0, 25, 25,  0
};


struct tColorFontChar balloonCharArray[] = {
  // Character information: unsigned char XSize,
  //                        unsigned char YSize,
  //                        unsigned char far *Bytes

  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  4, 12, balloonC33},
  {  8,  6, balloonC34},
  { 10, 12, balloonC35},
  {  7, 12, balloonC36},
  { 12, 12, balloonC37},
  { 10, 12, balloonC38},
  {  5,  6, balloonC39},
  {  6, 12, balloonC40},
  {  6, 12, balloonC41},
  { 13, 12, balloonC42},
  {  8, 10, balloonC43},
  {  5, 14, balloonC44},
  {  8,  7, balloonC45},
  {  3, 12, balloonC46},
  { 12, 12, balloonC47},
  {  8, 12, balloonC48},
  {  7, 12, balloonC49},
  {  9, 12, balloonC50},
  {  9, 12, balloonC51},
  { 11, 12, balloonC52},
  {  9, 12, balloonC53},
  {  9, 12, balloonC54},
  {  9, 12, balloonC55},
  {  9, 12, balloonC56},
  {  9, 12, balloonC57},
  {  3, 12, balloonC58},
  {  5, 14, balloonC59},
  {  7, 12, balloonC60},
  {  8,  9, balloonC61},
  {  7, 12, balloonC62},
  {  9, 12, balloonC63},
  { 10, 12, balloonC64},
  { 13, 12, balloonC65},
  {  9, 12, balloonC66},
  { 10, 12, balloonC67},
  {  9, 12, balloonC68},
  {  8, 12, balloonC69},
  {  8, 12, balloonC70},
  { 10, 12, balloonC71},
  { 10, 12, balloonC72},
  {  9, 12, balloonC73},
  { 11, 12, balloonC74},
  { 10, 12, balloonC75},
  {  9, 12, balloonC76},
  { 10, 12, balloonC77},
  { 10, 12, balloonC78},
  { 10, 12, balloonC79},
  {  9, 12, balloonC80},
  { 10, 12, balloonC81},
  {  9, 12, balloonC82},
  { 10, 12, balloonC83},
  {  9, 12, balloonC84},
  { 10, 12, balloonC85},
  { 13, 12, balloonC86},
  { 10, 12, balloonC87},
  { 12, 12, balloonC88},
  { 13, 12, balloonC89},
  { 10, 12, balloonC90},
  {  7, 12, balloonC91},
  { 12, 12, balloonC92},
  {  7, 12, balloonC93},
  {  9,  6, balloonC94},
  { 12, 12, balloonC95},
  {  5,  6, balloonC96},
  {  9, 12, balloonC97},
  {  9, 12, balloonC98},
  {  9, 12, balloonC99},
  {  9, 12, balloonC100},
  {  9, 12, balloonC101},
  {  8, 12, balloonC102},
  {  9, 16, balloonC103},
  { 10, 12, balloonC104},
  {  3, 12, balloonC105},
  {  9, 16, balloonC106},
  {  9, 12, balloonC107},
  {  3, 12, balloonC108},
  { 16, 12, balloonC109},
  {  9, 12, balloonC110},
  {  9, 12, balloonC111},
  {  9, 16, balloonC112},
  {  9, 16, balloonC113},
  {  6, 12, balloonC114},
  {  9, 12, balloonC115},
  {  7, 12, balloonC116},
  {  9, 12, balloonC117},
  { 13, 12, balloonC118},
  { 16, 12, balloonC119},
  {  8, 12, balloonC120},
  {  9, 16, balloonC121},
  {  9, 12, balloonC122},
  {  6, 12, balloonC123},
  {  3, 12, balloonC124},
  {  6, 12, balloonC125},
  {  8,  4, balloonC126},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL},
  {  0,  0, NULL}
};


// Font Control Structure
struct tColorFont balloonFont = {

  // Global width and height information

   5,   // (unsigned int) Base height of font
  16,   // (unsigned int) Maximum height of font
   9,   // (unsigned int) Average width of font
  16,   // (unsigned int) Maximum width of font

  balloonCharArray
};

