/************************************************************************* 

    ThreeD Base Header 0.01
    Copyright (c) 1994 CSC Three
    Basic header to be included in everything.


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada
               
*************************************************************************/

#ifndef THREED_BASE_H
#define THREED_BASE_H

/* -----------------------------------------------------------------------
    Defines
----------------------------------------------------------------------- */

#define VERTICES_MAX 300            // World size
#define WALLS_MAX    300
#define SCREEN_SIZE_X 320           // Screen size
#define SCREEN_SIZE_Y 200
#define DefaultBackgroundColor DarkGrey

/* -----------------------------------------------------------------------
    Basic types
----------------------------------------------------------------------- */

// In C++ is true -1, 1, or !0?  To solve this a boolean type with
// known values was created.

enum tBool {False, True};

// A coordinate is a position.  The units for all coordinates is centimeters.

typedef long tCoord;

// A vertex/wall index is unique number assigned to each vertex/wall.

typedef unsigned short tVertexIndex;
typedef unsigned short tWallIndex;

// Walls may have textures to make them more realistic.  Textures
// from 1 to 255 (inclusive) are colors from the display pallete,
// everything else is a texture.

enum tTexture
    {
    transparent,
    SolidBlue,
    SolidGreen,
    SolidCyan,
    SolidRed,
    SolidMagenta,
    SolidBrown,
    SolidGrey,
    SolidDarkGrey,
    SolidLightBlue,
    SolidLightGreen,
    SolidSkyBlue,
    SolidBrightRed,
    SolidViolet,
    SolidYellow,
    SolidWhite,
    SolidBlack,
    stone1 = 256,
    brick1,
    starry,
    marblue1,
    brick2,
    wood1,
    wood2
    };

// A macro that returns the sign of an integer

#define sgn(x) (signed)((x)==0?0:((x)<0?-1:1))

// tColor type  (American spelling chosen for simplicity)

enum tColor {Black, Blue, Green, Cyan, Red, Magenta, Brown, Grey,
                         DarkGrey, LightBlue, LightGreen, SkyBlue,
                         BrightRed, Violet, Yellow, White};

// Define a handy between() macro

#define between(x,l,h) (((x)<=(h))&&((x)>=(l)))

// Define a handy swapInt() macro

#define swapInt(i1,i2) {register int zzzzj=(i1); (i1)=(i2); (i2)=zzzzj;}



#endif // THREED_BASE_H
