/*********************************************************************

    File: font.h
    Author: Mike Lyons
    Contents: Definition of font control structure

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

------------------------------------------------------------------ */

#ifndef _FONTHEADER
#define _FONTHEADER


// Definition of structure tracking individual character
struct tColorFontChar {
    unsigned char XSize;
    unsigned char YSize;
    unsigned char far *Bytes;
};


// Definition of font control structure
struct tColorFont {
    unsigned int BaseHeight;
    unsigned int MaxHeight;
    unsigned int AvgWidth;
    unsigned int MaxWidth;
    struct tColorFontChar *Ch;
};

#endif
