/*************************************************************************
    
    GrafDrvr 0.02                                             
    Copyright (c) 1994 CSC Three
    Low level graphics routines.

    This is a set of routines for dealing with low level graphics.
    It handles anything graphics oriented that doesn't fit into the
    tDisplay class.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada
        
*************************************************************************/

#include <assert.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h>

#include "Basic.h"
#include "GrafDrvr.h"

// Overview: Calculates the distance to the point x,y
// Returns:  Distance to point.
// Note:     Tried replacing with an integer square root
//           but it made no difference so I will be using
//           floating point square root because it is
//           more reliable and there is less maintenance.
tCoord DistanceToPoint(const tCoord x, const tCoord y)
{
    return((tCoord)sqrt((float)(x*x + y*y)));
}
