/*************************************************************************
          
    tMaze Class 0.02
    Copyright (c) 1994 CSC Three
    Three dimensional maze class.


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

*************************************************************************/

#include <assert.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>

#include "Maze.h"

/* -----------------------------------------------------------------------

    tVertexIndex tMaze::AddVertex(const tPoint Point)

    Adds the point given to the list of vertices and returns the
    vertex number.  The height and texture are taken from the
    defualt values.  The vertex number is what you use to connect
    walls.

----------------------------------------------------------------------- */

tVertexIndex tMaze::AddVertex(const tPoint Point)
{
    assert(VertexCount < VERTICES_MAX);
    Vertices[VertexCount] = Point;
    VertexCount++;
    return(VertexCount - 1);
}

/* -----------------------------------------------------------------------

    tVertexIndex tMaze::AddVertex(const tCoord x, const tCoord, y)

    Adds the point given to the list of vertices and returns the
    vertex number.  The height and texture are taken from the
    default values.  The vertex number is what you use to connect
    walls.  This form of the call creates the tPoint for you.

----------------------------------------------------------------------- */

tVertexIndex tMaze::AddVertex(const tCoord x, const tCoord y)
{
    tPoint Point(x, y);
    return(AddVertex(Point));
}

/* -----------------------------------------------------------------------

    tWallIndex tMaze::AddWall(const tVertexIndex a, const tVertexIndex b,
                              const tCoord Height, const tTexture Texture)

    Adds a wall (connection between vertices) to the maze.  It returns
    a unique number identifying the wall, specifically an index into
    the Walls[] array.

----------------------------------------------------------------------- */

tWallIndex tMaze::AddWall(const tVertexIndex a, const tVertexIndex b,
                          const tCoord Height, const tTexture Texture)
{
    assert(WallCount <= WALLS_MAX);
    tWall Wall;
    Wall.a = a;
    Wall.b = b;
    Wall.Height = Height;
    Wall.Texture = Texture;

    // Add wall and return index used

    Walls[WallCount] = Wall;
    WallCount++;
    return(WallCount - 1);
}

void tMaze::DissolveToView(void)
// Overview: Regenerates the display and dissolves it in.  Good for fading
//           out of a help screen or such.
// Effects:  Whatever was on the screen is overwritten.
{
    Display.FillScreen(DefaultBackgroundColor);
    Display.Display(Player);
    Display.DissolveToVideoMemory(0, 0, 0xFFF);
}

/* -----------------------------------------------------------------------

    void tMaze::DrawView(const tBool Force)

    Updates the display using the tDisplay class.  It clears the
    screen and such.  If Force is True then the display will be
    updated no matter what, otherwise it may not be updated if
    the view hasn't been changed.  This may be bypassed with
    DRAWVIEW_FORCE.

----------------------------------------------------------------------- */

void tMaze::DrawView(const tBool Force)
{
#ifndef DRAWVIEW_FORCE
    static tPoint Location;
    static tAngle ViewAngle;
    if ((Force == True) || (Player.SameView(Location, ViewAngle) == False))
        {
        Location = Player.Location;
        ViewAngle = Player.ViewAngle;
#else
    Force;          // Stop compiler complaint Force is never used
        {           // Balance parenthesis
#endif
        Display.FillScreen(DefaultBackgroundColor);
        Display.Display(Player);
#ifdef DRAWVIEW_SHOWHEIGHT
        char HeightStr[17];
        ltoa(Player.BounceHeight, HeightStr, 10);
        Display.SetTextColor(3);
        Display.GotoXY(0,15);
        Display.OutString("Bounce: ");
        Display.OutString(HeightStr);
#endif
        Display.Update();
        }

}

/* -----------------------------------------------------------------------

    char tMaze::MovePlayer(void)

    Moves the player according to any controllers that have changed.
    The value returned is any keypresses not handled internally.
    Please note that currently extended keycodes are not supported
    and that the keys returned are in LOWER CASE.

----------------------------------------------------------------------- */

char tMaze::MovePlayer(void)
{
    return(Player.Move());
}

/* -----------------------------------------------------------------------

    tVertexIndex tMaze::NumberVertices(void)

    Returns the number of vertices in the maze.

----------------------------------------------------------------------- */

tVertexIndex tMaze::NumberVertices(void)
{
    return(VertexCount);
}

/* -----------------------------------------------------------------------

    tWallIndex tMaze::NumberWalls(void)

    Returns the number of walls in the maze.

----------------------------------------------------------------------- */

tWallIndex tMaze::NumberWalls(void)
{
    return(WallCount);
}

/* -----------------------------------------------------------------------

    void tMaze::QueryPlayerPosition(tPoint &Location, tAngle &ViewAngle)

    Sets the given variables to the players current position.

----------------------------------------------------------------------- */

void tMaze::QueryPlayerPosition(tPoint &Location, tAngle &ViewAngle)
{
    Location = Player.Location;
    ViewAngle = Player.ViewAngle;
}

/* -----------------------------------------------------------------------

    tBool tMaze::SameView(const tPoint Location, const tAngle ViewAngle)

    Returns True if the view given is the same as the current view,
    or False otherwise.

----------------------------------------------------------------------- */

tBool tMaze::SameView(const tPoint Location, const tAngle ViewAngle)
{
    return(Player.SameView(Location, ViewAngle));
}

/* -----------------------------------------------------------------------

    void tMaze::SetMouse(const tBool MouseMode)

    True if you want to use the mouse, False if not.

----------------------------------------------------------------------- */

void tMaze::SetMouse(const tBool MouseMode)
{
    Player.SetMouse(MouseMode);
}

/* -----------------------------------------------------------------------

    void tMaze::SetPlayer(const tPoint Position, const tAngle ViewAngle)

    Moves the player around in the maze.

----------------------------------------------------------------------- */

void tMaze::SetPlayer(const tCoord x, const tCoord y, const tAngle ViewAngle)
{
    Player.Location.x  = x;
    Player.Location.y  = y;
    Player.ViewAngle = ViewAngle;
}

/* -----------------------------------------------------------------------

    tMaze::tMaze(void)
    
    Default constructor for the tMaze class.

----------------------------------------------------------------------- */

tMaze::tMaze(void)
{
    VertexCount = 0;
    WallCount   = 0;
}

/* -----------------------------------------------------------------------

    tMaze::~tMaze(void)
    
    Default destructor for the tMaze class.
    
----------------------------------------------------------------------- */

tMaze::~tMaze(void)
{
}

