/*************************************************************************
          
    tMaze Class 0.02
    Copyright (c) 1994 CSC Three
    Three dimensional maze class.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

*************************************************************************/

#ifndef TMAZE_H
#define TMAZE_H

#include "Player.h"
#include "Point.h"
#include "Wall.h"
#include "Display.h"

/* -----------------------------------------------------------------------
    Types
----------------------------------------------------------------------- */

struct tWallSortStruct {
    tWallIndex Order;
    tCoord Distance;
};

class tMaze
    {

    // tDisplay is friends with tMaze.
    public:
        friend tDisplay;

    // Constructors and destructors and general management
    public:
        tMaze(void);
        ~tMaze(void);
        tBool Load(const char *Filename);
        
    // List of vertices.  Arrays are the fastest here, although they
    // take up a little more memory.  A little?  Try insignificant.
    // The array needs to be public for now so Mike's tDisplay can
    // get at it.

    private:
        tVertexIndex VertexCount;
    public:
        tPoint Vertices[VERTICES_MAX];
        tPoint ViewVert[VERTICES_MAX];
        tVertexIndex AddVertex(const tPoint Point);
        tVertexIndex AddVertex(const tCoord x, const tCoord y);
        tVertexIndex NumberVertices(void);
        
    // List of walls
    private:
        tWallIndex WallCount;
    public:
        tWall Walls[WALLS_MAX];
        tWallIndex NumberWalls(void);
        tWallIndex AddWall(const tVertexIndex a, const tVertexIndex b,
                           const tCoord Height, const tTexture Texture);

    // Player controls view
    private:
        tPlayer Player;
    public:
        void SetPlayer(const tCoord x, const tCoord y, const tAngle ViewAngle);
        void SetMouse(const tBool MouseMode);
        char MovePlayer(void);
        void QueryPlayerPosition(tPoint &Location, tAngle &ViewAngle);
        tBool SameView(const tPoint Location, const tAngle ViewAngle);

    // Depth sorting
    public:
        tWallSortStruct WallSort[WALLS_MAX];

    // The display itself
    public:
        tDisplay Display;
        void DrawView(const tBool Force);
        void DissolveToView(void);

    };


#endif // TMAZE_H

