/*************************************************************************

    tPlayer Class 0.02
    Copyright (c) 1994 CSC Three
    tPlayer class for the 3D lab.

    The player StepAngle is the current cycle in the step.  It uses
    a circle, which is 0 to USRHT_MAX PseudoAngles, and the Sine()
    function for the cyclic effect.  A player that is halfway through
    a step would be at USRHT_MAX/2 pseudoangles (180 degrees).  Works
    quite elegantely.


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

*************************************************************************/

#include <assert.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <conio.h>
#include <limits.h>
#include <dos.h>
#include <math.h>

#include "Player.h"

/* -----------------------------------------------------------------------
    Globals
----------------------------------------------------------------------- */

const tCoord PlayerHeight       = 200;      // How tall player is in cm
const int    PlayerBounceHeight = 15;       // How much bounce when walks in cm
const int    PlayerStepLength   = 500;      // Size of player's step in cm

/* -----------------------------------------------------------------------

    void tPlayer::Move(void)

    Moves the player according the any change in the controllers.
    If a character from the keyboard is unknown it will be returned.
    Please note that currently extended keycodes are not supported
    and that the keys returned are in LOWER CASE.

----------------------------------------------------------------------- */

char tPlayer::Move(void)
{

    // Movement speed
    const tCoord MouseMoveIncrement  = 1;
#ifdef PLAYERMOVE_FASTMOUSE
    const tCoord MouseMoveScaler     = 1;       // Divide movement by this much
#else
    const tCoord MouseMoveScaler     = 2;
#endif
    const tAngle MouseAngleIncrement = 16;
    const tCoord KBMoveIncrement     = 50;
    const tAngle KBAngleIncrement    = 512;

    int mx, my, mb;         // Motion counters from mouse and button
    tCoord dx = 0, dy = 0;  // Change in position
    tCoord dt = 0;          // Change in movement (much faster than distance formula)
    tAngle da = 0;          // Change in view angle

    // Read mouse values if mouse is on
    if (MouseState == True)
        {
        _AX = 0xb;              // Read mickeys
        geninterrupt(0x33);
        mx  = _CX;
        my  = -_DX;
        _AX = 3;                // Read buttons
        geninterrupt(0x33);
        mb  = _BX;
        if (mx)
            if (!(mb & 2))      // Right button
                da -= MouseAngleIncrement*mx;
            else                // Strafing
                {
                dx -= (((long)MouseMoveIncrement*mx*Cosine((ViewAngle+(USHRT_MAX/4))))/SHRT_MAX);
                dy -= (((long)MouseMoveIncrement*mx*Sine((ViewAngle+(USHRT_MAX/4))))/SHRT_MAX);
                dt -= MouseMoveIncrement*my;
                }
        if (my)
            {
            dx += (((long)MouseMoveIncrement*my*Cosine(ViewAngle))/SHRT_MAX);
            dy += (((long)MouseMoveIncrement*my*Sine(ViewAngle))/SHRT_MAX);
            dt += MouseMoveIncrement*my;
            }
        if (mb & 1)             // Left button
            {
            dx += (((long)KBMoveIncrement*Cosine(ViewAngle))/SHRT_MAX);
            dy += (((long)KBMoveIncrement*Sine(ViewAngle))/SHRT_MAX);
            dt += KBMoveIncrement;
            }
        if (mb & 4)             // Middle button
            {
            dx -= (((long)KBMoveIncrement*Cosine(ViewAngle))/SHRT_MAX);
            dy -= (((long)KBMoveIncrement*Sine(ViewAngle))/SHRT_MAX);
            dt -= KBMoveIncrement;
            }
        }

    //  Scale mouse movement
    dx /= MouseMoveScaler;
    dy /= MouseMoveScaler;

    // Handle any keyboard input, exiting if none
    int c = 0;
    if (kbhit())
        c = tolower(getch());
    switch(c)
        {
        case 'j':  // Rotate left and right
            da += KBAngleIncrement;
            c = 0;
            break;
        case 'l':
            da -= KBAngleIncrement;
            c = 0;
            break;
        case 'i':  // Move forward
            dx += (((long)KBMoveIncrement*Cosine(ViewAngle))/SHRT_MAX);
            dy += (((long)KBMoveIncrement*Sine(ViewAngle))/SHRT_MAX);
            dt += KBMoveIncrement;
            c = 0;
            break;
        case 'k':   // Move backward
            dx += (((long)KBMoveIncrement*Cosine((ViewAngle+(USHRT_MAX/2))))/SHRT_MAX);
            dy += (((long)KBMoveIncrement*Sine((ViewAngle+(USHRT_MAX/2))))/SHRT_MAX);
            dt -= KBMoveIncrement;
            c = 0;
            break;
        case 'u':   // Strafe left
            dx -= (((long)KBMoveIncrement*Cosine((ViewAngle-(USHRT_MAX/4))))/SHRT_MAX);
            dy -= (((long)KBMoveIncrement*Sine((ViewAngle-(USHRT_MAX/4))))/SHRT_MAX);
            c = 0;
            break;
        case 'o':   // Strafe right
            dx -= (((long)KBMoveIncrement*Cosine((ViewAngle+(USHRT_MAX/4))))/SHRT_MAX);
            dy -= (((long)KBMoveIncrement*Sine((ViewAngle+(USHRT_MAX/4))))/SHRT_MAX);
            c = 0;
            break;
        default:
            break;
        }

    // Adjust height for bounce if position changed
    if (dx || dy)
        {
        StepAngle += (tAngle)(dt * (USHRT_MAX / PlayerStepLength));
        BounceHeight = Sine(StepAngle) / (SHRT_MAX / PlayerBounceHeight);
        }

    // Set changes
    Location.x += dx;
    Location.y += dy;
    ViewAngle  += da;
    return(c);
}

/* -----------------------------------------------------------------------

    tBool tPlayer::SameView(const tPoint Position, const tAngle Angle)

    Returns True if the view given is the same as the current view,
    or False otherwise.

----------------------------------------------------------------------- */

tBool tPlayer::SameView(const tPoint Position, const tAngle Angle)
{
    if ((Location.x == Position.x) &&
        (Location.y == Position.y) &&
        (ViewAngle  == Angle))
        return(True);
    return(False);
}

/* -----------------------------------------------------------------------

    void tPlayer::SetMouse(const tBool State)

    Turns the mouse on or off.  If the mouse is not present it
    won't be used.  If it is currently on and you tell it to turn
    it on the mouse driver will be reset.

----------------------------------------------------------------------- */

void tPlayer::SetMouse(const tBool State)
{
    MouseState = State;
    if (State == True)
        {
        _AX = 0;
        geninterrupt(0x33);
        if (_AX == 0)
            MouseState = False;
        }
}

/* -----------------------------------------------------------------------

    tPlayer::tPlayer(void)

    Default constructor for the tPlayer class.

----------------------------------------------------------------------- */

tPlayer::tPlayer(void)
{
    Location.x   = 0;
    Location.y   = 0;
    ViewAngle    = 0;
    ViewHeight   = PlayerHeight;
    BounceHeight = 0;
    StepAngle    = 0;
    Color        = Yellow;
    SetMouse(True);
}

/* -----------------------------------------------------------------------

    tPlayer::~tPlayer(void)

    Default destructor for the tPlayer class.

----------------------------------------------------------------------- */

tPlayer::~tPlayer(void)
{
}
