/*************************************************************************

    tPlayer Class 0.02
    Copyright (c) 1994 CSC Three
    tPlayer class for the 3D lab.


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

*************************************************************************/

#ifndef TPLAYER_H
#define TPLAYER_H

#include "point.h"
#include "angle.h"

/* -----------------------------------------------------------------------
    tPlayer Class Definition
----------------------------------------------------------------------- */

class tPlayer
    {

    // Constructors and destructors
    public:
        tPlayer(void);
        ~tPlayer(void);

    // Player location and view angle
    private:
        tAngle StepAngle;                   // Current cycle in step
    public:
        tPoint Location;                    // Location in map
        tAngle ViewAngle;                   // Angle of view
        tCoord ViewHeight;                  // Height from ground
        tCoord BounceHeight;                // Adjustment for bobbing
        tColor Color;                       // On-screen color, not skin

    // Movement and position
    public:
        tBool MouseState;
    public:
        char Move(void);
        tBool SameView(const tPoint Location, const tAngle ViewAngle);
        void SetMouse(const tBool State);
    };

#endif // TPLAYER_H
