/*************************************************************************
          
    tPoint Class 0.02
    Copyright (c) 1994 CSC Three
    Arbitrary coordinate point.
    
    USAGE
    
        The points are of type tCoord, which is signed long,
        slower but this means they can handy any coordinate at
        all.  They are signed to allow us to specify offsets.

        To assign a coordinate use Point.x = Newx and Point.y = Newy.
        This is simpler than using access methods.

        There are several operators to allow you to manipulate points
        easily.  They are: +, - , *, /, +=, and -=.


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

*************************************************************************/

#include <assert.h>
#include <ctype.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>

#include "Point.h"

/* -----------------------------------------------------------------------

    tPoint tPoint::operator +(const tPoint Point)

    Operator to allow you to go tPoint + tPoint for simplifying
    common operations.

----------------------------------------------------------------------- */

tPoint tPoint::operator +(const tPoint Point)
{
    return(tPoint(this->x + Point.x, this->y + Point.y));
}

/* -----------------------------------------------------------------------

    tPoint tPoint::operator -(const tPoint Point)

    Operator to allow you to go tPoint - tPoint for simplifying
    common operations.

----------------------------------------------------------------------- */

tPoint tPoint::operator -(const tPoint Point)
{
    return(tPoint(this->x - Point.x, this->y - Point.y));
}

/* -----------------------------------------------------------------------

    tPoint tPoint::operator *(const tPoint Point)

    Operator to allow you to go tPoint * tPoint for simplifying
    common operations.

----------------------------------------------------------------------- */

tPoint tPoint::operator *(const tPoint Point)
{
    return(tPoint(this->x * Point.x, this->y * Point.y));
}

/* -----------------------------------------------------------------------

    tPoint tPoint::operator /(const tPoint Point)

    Operator to allow you to go tPoint / tPoint for simplifying
    common operations.

----------------------------------------------------------------------- */

tPoint tPoint::operator /(const tPoint Point)
{
    return(tPoint(this->x / Point.x, this->y / Point.y));
}

/* -----------------------------------------------------------------------

    tPoint tPoint::operator +=(const tPoint Point)

    Operator to allow you to go tPoint += tPoint for simplifying
    common operations.

----------------------------------------------------------------------- */

tPoint tPoint::operator +=(const tPoint Point)
{
    return(tPoint(this->x += Point.x, this->y += Point.y));

}

/* -----------------------------------------------------------------------

    tPoint tPoint::operator -=(const tPoint Point)

    Operator to allow you to go tPoint -= tPoint for simplifying
    common operations.

----------------------------------------------------------------------- */

tPoint tPoint::operator -=(const tPoint Point)
{
    return(tPoint(this->x -= Point.x, this->y -= Point.y));
}

/* -----------------------------------------------------------------------

    tPoint::tPoint(void)

    Default constructor for the tPoint class.

----------------------------------------------------------------------- */

tPoint::tPoint(void)
{
    x = 0;
    y = 0;
}

/* -----------------------------------------------------------------------

    tPoint::tPoint(const tCoord NewX, const tCoord NewY)

    Default constructor that initalizes coordinates.

----------------------------------------------------------------------- */

tPoint::tPoint(const tCoord NewX, const tCoord NewY)
{
    x = NewX;
    y = NewY;
}

/* -----------------------------------------------------------------------

    tPoint::~tPoint(void)
    
    Default destructor for the tPoint class.                 
    
----------------------------------------------------------------------- */

tPoint::~tPoint(void)
{
}
