/*************************************************************************

    File:     texture.cpp
    Contents: Texture, color and palette information needed by tDisplay
    Author:   Mike Lyons


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

*************************************************************************/

// Get definitions for struct bitmap, struct texture etc.
#include "display.h"

// Set up an array to hold color data
unsigned char far marblue1Dat[] = {
     73, 72, 72, 73, 74, 74, 75, 74, 74, 74, 73, 73, 73, 73, 74, 74,
     73, 72, 74, 74, 74, 76, 75, 74, 73, 73, 73, 73, 73, 73, 73, 73,
     73, 73, 74, 76, 76, 75, 74, 73, 73, 74, 74, 74, 73, 73, 73, 73,
     73, 74, 76, 77, 75, 74, 74, 73, 74, 75, 75, 74, 74, 73, 73, 73,
     74, 75, 77, 76, 74, 73, 73, 73, 74, 75, 75, 74, 73, 73, 73, 74,
     74, 76, 75, 74, 73, 73, 74, 74, 76, 76, 74, 74, 73, 74, 74, 74,
     75, 75, 74, 73, 73, 74, 74, 73, 77, 77, 75, 74, 73, 74, 74, 75,
     75, 75, 74, 73, 73, 73, 74, 76, 76, 77, 75, 73, 73, 74, 75, 75,
     75, 74, 74, 73, 73, 74, 76, 77, 76, 74, 73, 73, 74, 74, 76, 76,
     74, 74, 74, 73, 73, 74, 75, 75, 74, 74, 73, 74, 74, 75, 76, 76,
     74, 73, 73, 73, 73, 74, 75, 75, 74, 73, 73, 74, 76, 76, 77, 75,
     74, 73, 73, 73, 73, 73, 74, 74, 73, 73, 73, 74, 76, 77, 76, 75,
     73, 72, 73, 73, 73, 73, 73, 73, 73, 74, 75, 75, 77, 76, 75, 74,
     72, 72, 72, 72, 73, 73, 73, 73, 74, 74, 76, 76, 76, 75, 74, 73,
     73, 73, 72, 73, 73, 73, 73, 74, 75, 76, 76, 76, 75, 73, 72, 72,
     74, 73, 73, 73, 73, 73, 74, 74, 75, 76, 74, 74, 73, 72, 73, 73
};


// Bitmap control structure for marblue1 texture
struct bitmap marblue1Bmp = {
    // Dimensions: LevEdit bitmaps are always 16x16
    16, 16,
    // Point to our color data
    marblue1Dat
};


// Bitmap data for brick1 texture
unsigned char far brick1Dat[]={
    252,252,252,251,251,250,250,249,252,252,252,251,251,250,250,249,
    252,251,251,250,250,250,250,247,252,251,251,250,250,250,250,247,
    250,250,250,250,250,250,249,247,250,250,250,250,250,250,249,247,
    247,247,247,247,247,247,247,247,247,247,247,247,247,247,247,247,
    250,250,250,249,252,252,252,251,251,250,250,249,252,252,252,251,
    250,251,251,247,252,251,251,250,250,250,250,247,252,251,251,250,
    250,251,251,247,251,250,250,250,250,250,251,247,251,251,250,250,
    247,247,247,247,247,247,247,247,247,247,247,247,247,247,247,247,
    252,252,252,251,251,250,250,249,252,252,252,251,251,250,250,249,
    252,251,251,251,251,251,251,247,252,251,251,251,251,251,251,247,
    251,251,251,251,251,251,251,247,251,251,251,251,251,251,251,247,
    247,247,247,247,247,247,247,247,247,247,247,247,247,247,247,247,
    251,250,250,249,252,252,252,251,251,250,250,249,252,252,252,251,
    251,251,251,247,252,251,251,251,251,251,251,247,252,251,251,251,
    251,251,251,247,251,251,251,251,251,251,251,247,251,251,251,251,
    247,247,247,247,247,247,247,247,247,247,247,247,247,247,247,247
};

// Bitmap control structure for brick1 texture
struct bitmap brick1Bmp = {
    // Dimensions: LevEdit bitmaps are always 16x16
    16, 16,
    // Color information follows
    brick1Dat
};

// Bitmap data for stone1 texture
unsigned char far stone1Dat[] = {
     31, 29, 29, 29, 27, 27, 27, 30, 29, 25, 27, 27, 27, 27, 27, 31,
     30, 29, 29, 27, 25, 27, 30, 29, 25, 27, 31, 31, 30, 27, 27, 29,
     29, 29, 27, 27, 27, 27, 26, 26, 27, 31, 30, 30, 29, 29, 27, 27,
     27, 25, 25, 31, 30, 30, 29, 26, 26, 27, 30, 29, 29, 28, 28, 27,
     27, 27, 31, 30, 29, 29, 29, 29, 29, 25, 27, 29, 28, 26, 26, 27,
     30, 27, 27, 30, 29, 29, 29, 27, 26, 25, 28, 28, 28, 26, 25, 31,
     28, 28, 27, 29, 28, 28, 27, 27, 26, 25, 27, 28, 26, 26, 25, 31,
     28, 25, 27, 29, 29, 27, 27, 26, 25, 27, 27, 27, 25, 25, 25, 27,
     28, 27, 27, 27, 27, 25, 25, 25, 25, 27, 31, 30, 27, 27, 27, 26,
     25, 27, 31, 31, 30, 29, 27, 27, 27, 31, 30, 30, 29, 28, 27, 27,
     27, 30, 30, 30, 30, 29, 29, 28, 27, 30, 29, 29, 28, 28, 27, 26,
     26, 27, 30, 29, 29, 29, 29, 28, 26, 29, 29, 28, 28, 27, 26, 26,
     26, 26, 27, 29, 29, 29, 28, 28, 26, 25, 27, 28, 28, 27, 26, 25,
     26, 27, 27, 27, 28, 28, 28, 26, 26, 25, 27, 27, 27, 26, 26, 25,
     27, 31, 30, 27, 26, 26, 25, 26, 25, 25, 27, 27, 26, 26, 25, 25,
     31, 30, 30, 30, 27, 27, 25, 25, 25, 27, 31, 27, 27, 25, 25, 27
};

// Bitmap control structure for stone1 texture
struct bitmap stone1Bmp = {
    // Dimensions: LevEdit bitmaps are always 16x16
    16, 16,
    // Point to our color data
    stone1Dat
};

// Bitmap data for starry texture
unsigned char far starryDat[] = {
    228,146,146,146,146,148,148,196,148,148,148,148,146,146,146,226,
    146,230,150,150,150,151,151,197,151,151,151,150,150,150,227,146,
    146,150,233,151,153,153,153,200,153,153,151,151,151,230,150,146,
    146,150,151,234,153,154,154,202,154,154,153,234,233,151,150,146,
    146,150,151,153,235,154,155,202,155,154,235,154,153,151,150,148,
    148,151,153,153,154,236,156,204,156,236,155,154,154,153,151,148,
    148,151,153,154,155,156,237,206,237,156,155,155,154,153,151,148,
    196,197,200,202,202,204,206,207,206,204,202,202,200,200,197,196,
    148,151,153,154,155,156,237,206,237,156,155,155,154,153,151,148,
    148,151,153,154,154,236,156,204,156,236,155,154,154,153,151,148,
    148,150,153,153,235,154,155,202,155,155,235,154,153,151,151,148,
    148,150,151,234,153,154,154,202,154,154,154,234,153,151,150,146,
    146,150,151,234,153,153,153,200,153,153,153,153,233,151,150,146,
    146,150,233,151,151,153,153,200,153,153,151,151,151,230,150,146,
    146,230,150,150,150,151,151,197,151,151,150,150,150,150,227,146,
    228,146,146,146,148,148,148,196,148,148,148,148,146,146,146,226
};

// Bitmap control structure for starry texture
struct bitmap starryBmp = {
    // Dimensions: LevEdit bitmaps are always 16x16
    16, 16,
    // Point to our color data
    starryDat
};

// Set up an array to hold color data
unsigned char far brick2Dat[] = {
  244,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
  244,252,252,252,252,252,252,252,252,252,252,252,252,251,251,251,
  244,252,252,252,252,252,252,252,251,251,251,250,250,249,249,249,
  244,252,252,251,251,251,251,251,251,251,250,250,249,249,249,248,
  244,252,252,251,251,251,251,251,250,250,249,249,249,249,248,247,
  244,252,252,251,251,250,250,250,250,249,249,249,249,248,248,247,
  244,252,251,251,250,250,249,249,249,249,248,248,247,247,247,247,
  244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,
  252,252,252,252,252,252,252,252,244,252,252,252,252,252,252,252,
  252,252,252,252,252,251,251,251,244,252,252,252,252,252,252,252,
  251,251,251,251,251,251,249,249,244,252,252,252,252,252,252,252,
  251,251,251,249,249,249,249,248,244,252,252,251,251,251,251,251,
  251,251,249,249,249,249,249,247,244,252,252,251,251,250,250,249,
  250,250,249,249,249,248,248,247,244,252,252,251,250,250,249,249,
  249,249,249,249,248,247,247,247,244,252,251,251,250,249,249,249,
  244,244,244,244,244,244,244,244,244,244,244,244,244,244,244,244
};

struct bitmap brick2Bmp = {
  // Dimensions: LevEdit bitmaps are always 16x16
  16, 16,
  // Point to our color data
  brick2Dat
};

// Set up an array to hold color data
unsigned char far wood2Dat[] = {
  117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
  118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,
  120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
  119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
  118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,
  117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
  116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
  113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
  117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
  118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,
  120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
  119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
  118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,
  117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
  116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
  113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113
};

struct bitmap wood2Bmp = {
  // Dimensions: LevEdit bitmaps are always 16x16
  16, 16,
  // Point to our color data
  wood2Dat
};

// Set up an array to hold color data
unsigned char far wood1Dat[] = {
  118,117,117,114,117,117,118,114,117,119,117,114,117,117,118,114,
  118,117,117,114,118,117,118,114,117,117,117,114,117,117,118,114,
  117,119,117,114,118,117,117,114,114,114,114,114,117,117,118,114,
  117,117,117,114,118,117,117,114,117,117,117,114,118,117,117,114,
  114,114,114,114,118,117,117,114,117,119,117,114,118,117,117,114,
  117,117,117,114,117,117,117,114,117,117,117,114,118,117,117,114,
  117,119,117,114,117,118,117,114,117,117,117,114,118,117,117,114,
  117,117,117,114,117,118,117,114,118,117,117,114,117,117,117,114,
  117,117,117,114,117,118,117,114,118,117,117,114,117,117,117,114,
  117,117,118,114,117,117,117,114,118,117,117,114,117,119,117,114,
  117,117,118,114,117,117,117,114,118,117,117,114,117,117,117,114,
  117,117,118,114,117,119,117,114,118,117,118,114,114,114,114,114,
  118,117,118,114,117,117,117,114,118,117,118,114,117,117,117,114,
  118,117,118,114,114,114,114,114,117,117,117,114,117,119,117,114,
  118,117,117,114,117,117,117,114,117,117,117,114,117,117,117,114,
  117,117,117,114,117,119,117,114,117,117,117,114,117,117,118,114
};

struct bitmap wood1Bmp = {
  // Dimensions: LevEdit bitmaps are always 16x16
  16, 16,
  // Point to our color data
  wood1Dat
};


// Texture control structure for stone1 texture
struct texture stone1Tx = {
    Grey,       // Default color
    True,       // Texture mapping on for this texture
    {
    16, 16,     // X and Y size (enclosed bitmap)
    stone1Dat,// (enclosed bitmap)
    },
    0,              // X offset
    0,              // Y offset
    False,      // FALSE meaning use tiling method for texture scaling
    256,            // X multiple
    256,            // Y multiple
    1024,       // X tiling
    1024        // Y tiling
};

// Texture control structure for brick1 texture
struct texture brick1Tx = {
    Red,            // Default color
    True,           // Texture mapping on for this texture
    {
    16, 16,     // X and Y size (enclosed bitmap)
    brick1Dat,// (enclosed bitmap)
    },
    0,              // X offset
    0,              // Y offset
    False,      // FALSE meaning use tiling method for texture scaling
    256,            // X multiple
    256,            // Y multiple
    512,        // X tiling
    512             // Y tiling
};

// Texture control structure for starry texture
struct texture starryTx = {
    Blue,       // Default color
    True,       // True=texture mapping on by default for this texture
    {
    16, 16,     // X and Y size (enclosed bitmap)
    starryDat,// (enclosed bitmap)
    },
    0,              // X offset
    0,              // Y offset
    False,      // FALSE meaning use tiling method for texture scaling
    256,            // X multiple
    256,            // Y multiple
    2048,       // X tiling
    2048        // Y tiling
};

// Texture control structure for marblue1 texture
struct texture marblue1Tx = {
    SkyBlue,    // Default color
    True,       //
    {
    16, 16,     // X and Y size (enclosed bitmap)
    marblue1Dat,// (enclosed bitmap)
    },
    0,              // X offset
    0,              // Y offset
    False,      // FALSE meaning use tiling method for texture scaling
    256,            // X multiple
    256,            // Y multiple
    512,        // X tiling
    512             // Y tiling
};

// Texture control structure for transparent or solid color textures
struct texture colorTx = {
    Blue,     // Default color
    False,    // Mapping=False, so use a solid color
    {
    0, 0,     // Indicates a solid color or transparent texture: no bitmap
    NULL,
    },
    0,
    0,
    False,
    0,
    0,
    0,
    0
};

// Texture control structure for brick2 texture
struct texture brick2Tx = {
    Red,            // Default color
    True,           // Texture mapping on for this texture
    {
    16, 16,     // X and Y size (enclosed bitmap)
    brick2Dat,// (enclosed bitmap)
    },
    0,              // X offset
    0,              // Y offset
    False,      // FALSE meaning use tiling method for texture scaling
    256,            // X multiple
    256,            // Y multiple
    512,        // X tiling
    512             // Y tiling
};

// Texture control structure for wood1 texture
struct texture wood1Tx = {
    Brown,          // Default color
    True,           // Texture mapping on for this texture
    {
    16, 16,     // X and Y size (enclosed bitmap)
    wood1Dat,// (enclosed bitmap)
    },
    0,              // X offset
    0,              // Y offset
    False,      // FALSE meaning use tiling method for texture scaling
    256,            // X multiple
    256,            // Y multiple
    512,        // X tiling
    512             // Y tiling
};

// Texture control structure for wood2 texture
struct texture wood2Tx = {
    Brown,          // Default color
    True,           // Texture mapping on for this texture
    {
    16, 16,     // X and Y size (enclosed bitmap)
    wood2Dat,// (enclosed bitmap)
    },
    0,              // X offset
    0,              // Y offset
    False,      // FALSE meaning use tiling method for texture scaling
    256,            // X multiple
    256,            // Y multiple
    512,        // X tiling
    512             // Y tiling
};


// Palette data for trippy palette
unsigned char far trippyPal[768] = {
     0, 0, 0, 0, 0,42, 0,42, 0, 0,42,42,42, 0, 0,42, 0,42,19,28,42,42,42,42,
    21,21,21,21,21,62,21,62,21, 0,63,63,62,21,21,62,21,62,62,62,21,62,62,62,
     0, 0, 0, 5, 5, 5, 8, 8, 8,11,11,11,14,14,14,17,17,17,20,20,20,24,24,24,
    28,28,28,32,32,32,36,36,36,40,40,40,44,44,44,49,49,49,55,55,55,62,62,62,
    17,11, 0,21,14, 0,25,18, 0,30,21, 0,34,25, 0,38,28, 0,42,32, 0,46,35, 0,
    50,39, 0,55,42, 0,59,46, 0,63,49, 0,63,52,16,63,56,32,63,60,47,63,63,63,
     0, 0, 0, 6, 0, 3,11, 0, 6,17, 0, 9,23, 0,12,29, 0,15,34, 0,19,40, 0,22,
    46, 0,25,52, 0,28,57, 0,31,63, 0,34,63,16,41,63,32,48,63,47,56,63,63,63,
     0, 0, 0, 0, 3, 6, 0, 6,11, 0,10,17, 0,13,23, 0,16,29, 0,19,34, 0,22,40,
     0,25,46, 0,29,52, 0,32,57, 0,35,63,15,42,63,30,48,63,46,55,63,61,62,63,
     0, 0, 0, 0, 6, 4, 0,11, 8, 0,17,12, 0,22,16, 0,28,20, 0,33,24, 0,39,28,
     0,44,32, 0,50,36, 0,55,40, 0,61,44,16,61,48,32,62,53,47,62,58,63,62,62,
     0, 0, 0, 5, 4, 2, 9, 7, 3,14,11, 5,19,14, 6,23,18, 8,28,21, 9,32,25,11,
    37,28,12,42,32,14,46,35,15,51,39,17,54,45,28,57,51,40,60,57,52,63,63,63,
     0, 0, 0, 4, 3, 0, 8, 6, 0,11, 8, 0,15,11, 0,19,14, 0,23,17, 0,27,20, 0,
    31,23, 0,34,25, 0,38,28, 0,42,31, 0,47,39,16,52,47,31,58,55,46,63,63,62,
     8, 5, 2,13,10, 6,18,14,11,23,19,15,28,24,20,33,29,24,37,33,29,42,38,33,
    47,43,38,52,48,42,57,52,47,62,57,51,62,58,54,62,60,56,63,61,59,63,62,62,
    12, 4, 0,17, 7, 0,21,10, 0,26,13, 0,31,16, 0,35,19, 0,40,21, 0,44,24, 0,
    49,27, 0,54,30, 0,58,33, 0,63,36, 0,63,42,13,63,47,26,63,52,40,63,58,53,
     6, 0, 5,11, 0,10,16, 0,16,22, 0,21,27, 0,26,32, 0,31,37, 0,37,42, 0,42,
    47, 0,47,53, 0,52,58, 0,58,63, 0,63,63,15,63,63,30,63,63,45,63,63,60,63,
     9, 9, 0,14,14, 0,19,19, 0,24,24, 0,29,29, 0,34,34, 0,38,38, 0,43,43, 0,
    48,48, 0,53,53, 0,58,58, 0,63,63, 0,63,63,15,63,63,30,63,63,45,63,63,60,
     0, 4, 4, 0, 9, 9, 0,15,15, 0,20,20, 0,25,25, 0,31,31, 0,36,36, 0,42,42,
     0,47,47, 0,52,52, 0,58,58, 0,63,63,15,63,63,30,63,63,45,63,63,60,63,63,
     0, 0, 8, 0, 0,13, 0, 0,18, 0, 0,23, 0, 0,28, 0, 0,33, 0, 0,38, 0, 0,43,
     0, 0,48, 0, 0,53, 0, 0,58, 0, 0,63,16,16,63,31,31,63,46,46,63,62,62,63,
     0, 6, 0, 0,11, 0, 0,16, 0, 0,22, 0, 0,27, 0, 0,32, 0, 0,37, 0, 0,42, 0,
     0,47, 0, 0,53, 0, 0,58, 0, 0,63, 0,16,63,16,31,63,31,46,63,46,62,63,62,
    11, 0, 0,16, 0, 0,20, 0, 0,25, 0, 0,30, 0, 0,35, 0, 0,39, 0, 0,44, 0, 0,
    49, 0, 0,54, 0, 0,58, 0, 0,63, 0, 0,63,15,15,63,30,30,63,46,46,63,61,61
};

