/*************************************************************************

    File:     texture.cpp
    Contents: Texture, color and palette information needed by tDisplay
    Author:   Mike Lyons


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Sheldon Young           (604)963-7067
    PO Box 2931             FidoNet:  Sheldon Young 1:359/197.1
    Prince George, BC       Internet: sheldon.young@datex.com
    V2N 4T7
    Canada

    Mike Lyons              (604)964-0725
    7833 Piedmont Crescent  FidoNet: Mike Lyons 1:359/262.1
    Prince George, BC       Internet: mike.lyons@datex.com
    V2N 3K8
    Canada

*************************************************************************/

#include "display.h"

// Point to the data
extern unsigned char far marblue1Dat[];
extern unsigned char far brick1Dat[];
extern unsigned char far stone1Dat[];
extern unsigned char far starryDat[];
extern unsigned char far brick2Dat[];
extern unsigned char far wood1Dat[];
extern unsigned char far wood2Dat[];

// Bitmap control structure for textures
extern struct bitmap marblue1Bmp;
extern struct bitmap brick1Bmp;
extern struct bitmap stone1Bmp;
extern struct bitmap starryBmp;
extern struct bitmap brick2Bmp;
extern struct bitmap wood1Bmp;
extern struct bitmap wood2Bmp;

// Texture handles
extern struct texture stone1Tx;
extern struct texture brick1Tx;
extern struct texture starryTx;
extern struct texture marblue1Tx;
extern struct texture brick2Tx;
extern struct texture wood1Tx;
extern struct texture wood2Tx;
extern struct texture colorTx;

// Palette data for trippy palette
extern unsigned char far trippyPal[768];

